/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfsc.api.busi.BusiTaskPayCancelInfoTimeOutService;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.ApplyPayInfoMapper;
import com.tydic.pfsc.dao.OrderInfoCancelHisMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.ApplyPayInfoPO;
import com.tydic.pfsc.dao.po.OrderInfoCancelHisPO;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.ApplyPayInfoQueryVO;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.umc.ability.DictionaryAbilityService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiTaskPayCancelInfoTimeOutService"})
public class BusiTaskPayCancelInfoTimeOutServiceImpl
implements BusiTaskPayCancelInfoTimeOutService {
    private static final Logger log = LoggerFactory.getLogger(BusiTaskPayCancelInfoTimeOutServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(BusiTaskPayCancelInfoTimeOutServiceImpl.class);
    @Autowired
    private DictionaryAbilityService dictionaryAbilityService;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private OrderInfoCancelHisMapper orderInfoCancelHisMapper;
    @Autowired
    private Environment prop;

    @PostMapping(value={"payCancelInfoTimeOut"})
    public PfscExtRspBaseBO payCancelInfoTimeOut() {
        int timeOutMinutes = this.initTimeOutMinutes();
        log.debug("\u540c\u6b65\u652f\u4ed8\u5355\u72b6\u6001\u4e3a\u5df2\u7ec8\u6b62-\u65f6\u95f4\u5dee\uff1a{}", (Object)timeOutMinutes);
        ApplyPayInfoQueryVO applyPayInfoQueryVO = new ApplyPayInfoQueryVO();
        applyPayInfoQueryVO.setPayStatus("07");
        applyPayInfoQueryVO.setApplyDate(new Date());
        applyPayInfoQueryVO.setTimeOutMinutes(timeOutMinutes);
        applyPayInfoQueryVO.setPayModeNotEq("2");
        List<ApplyPayInfoPO> outPayInitTimeOrderList = this.applyPayInfoMapper.findOutPayInitTimeOrderReform(applyPayInfoQueryVO);
        log.debug("\u540c\u6b65\u652f\u4ed8\u5355\u72b6\u6001\u4e3a\u5df2\u7ec8\u6b62-\u88ab\u540c\u6b65\u7684\u652f\u4ed8\u5355\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(outPayInitTimeOrderList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (outPayInitTimeOrderList != null && outPayInitTimeOrderList.size() > 0) {
            for (ApplyPayInfoPO app : outPayInitTimeOrderList) {
                ApplyPayInfoPO applyPayInfoS = new ApplyPayInfoPO();
                applyPayInfoS.setPayno(app.getPayno());
                applyPayInfoS.setPayStatus("08");
                this.applyPayInfoMapper.updatePayStatusByPayNo(applyPayInfoS);
                SaleOrderInfoVO saleOrderInfo = new SaleOrderInfoVO();
                saleOrderInfo.setPayno(app.getPayno());
                List<SaleOrderInfo> list = this.saleOrderInfoMapper.getList(saleOrderInfo);
                if (list == null || list.size() <= 0) continue;
                for (SaleOrderInfo sio : list) {
                    this.insertIntoHisByPaynoFromSaleOrderInfo(sio.getPayno(), sio.getOrderId(), sio.getInspectionId());
                    sio.setPayStatus("00");
                    if (!StringUtils.isBlank((CharSequence)sio.getOldPayType())) {
                        sio.setPayType(sio.getOldPayType());
                    }
                    this.saleOrderInfoMapper.updateByPrimaryKeySelectiveByOrderIdAndNoPayNo(sio);
                }
            }
        }
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        pfscExtRspBaseBO.setRespDesc("\u6210\u529f");
        pfscExtRspBaseBO.setRespCode("\u6210\u529f");
        return pfscExtRspBaseBO;
    }

    private int initTimeOutMinutes() {
        int timeout = 6;
        try {
            String timeOutMinutesStr = this.prop.getProperty("china.pay.time.out", "6");
            timeout = Integer.parseInt(timeOutMinutesStr);
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u5355\u72b6\u6001\u4e3a\u5df2\u7ec8\u6b62-\u8bfb\u53d6\u914d\u7f6e\u5c5e\u6027\u5931\u8d25\uff0cE:{}", (Throwable)e);
        }
        return timeout;
    }

    public PfscExtRspBaseBO payCancelInfoTimeOut_Old() {
        ApplyPayInfoPO applyPayInfo = new ApplyPayInfoPO();
        applyPayInfo.setPayStatus("07");
        applyPayInfo.setApplyDate(new Date());
        applyPayInfo.setPayMode("2");
        List<ApplyPayInfoPO> outPayInitTimeOrderList = this.applyPayInfoMapper.findOutPayInitTimeOrder(applyPayInfo);
        if (outPayInitTimeOrderList != null && outPayInitTimeOrderList.size() > 0) {
            for (ApplyPayInfoPO app : outPayInitTimeOrderList) {
                ApplyPayInfoPO applyPayInfoS = new ApplyPayInfoPO();
                applyPayInfoS.setPayno(app.getPayno());
                applyPayInfoS.setPayStatus("08");
                this.applyPayInfoMapper.updatePayStatusByPayNo(applyPayInfoS);
                SaleOrderInfoVO saleOrderInfo = new SaleOrderInfoVO();
                saleOrderInfo.setPayno(app.getPayno());
                List<SaleOrderInfo> list = this.saleOrderInfoMapper.getList(saleOrderInfo);
                if (list == null || list.size() <= 0) continue;
                for (SaleOrderInfo sio : list) {
                    this.insertIntoHisByPaynoFromSaleOrderInfo(sio.getPayno(), sio.getOrderId(), sio.getInspectionId());
                    sio.setPayStatus("00");
                    if (!StringUtils.isBlank((CharSequence)sio.getOldPayType())) {
                        sio.setPayType(sio.getOldPayType());
                    }
                    this.saleOrderInfoMapper.updateByPrimaryKeySelectiveByOrderIdAndNoPayNo(sio);
                }
            }
        }
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        pfscExtRspBaseBO.setRespDesc("\u6210\u529f");
        pfscExtRspBaseBO.setRespCode("\u6210\u529f");
        return pfscExtRspBaseBO;
    }

    private void insertIntoHisByPaynoFromSaleOrderInfo(String payno, Long orderId, Long inspectionId) {
        log.debug("\u7f13\u5b58\u5df2\u7ec8\u6b62\u7684\u652f\u4ed8\u5355\u5bf9\u5e94\u7684\u9a8c\u6536\u5355\u4fe1\u606f\uff1apayno={},orderId={},inspectionId={}", new Object[]{payno, orderId, inspectionId});
        if (StringUtils.isNotBlank((CharSequence)payno)) {
            OrderInfoCancelHisPO po = new OrderInfoCancelHisPO();
            po.setPayno(payno);
            po.setOrderId(orderId);
            po.setInspectionId(inspectionId);
            po.setStatusTag("03");
            po.setCreateTime(new Date());
            this.orderInfoCancelHisMapper.insertSelective(po);
        }
    }
}

