/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiInvoiceIssueAtourService;
import com.tydic.pfsc.api.busi.DzcsInvoiceReturnApplyRedInvoiceService;
import com.tydic.pfsc.api.busi.bo.BusiInvoiceIssueAtourReqBO;
import com.tydic.pfsc.api.busi.bo.DzcsInvoiceReturnApplyRedInvoiceReqBO;
import com.tydic.pfsc.api.busi.bo.DzcsInvoiceReturnApplyRedInvoiceRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.DBillApplySaleItemInfoMapper;
import com.tydic.pfsc.dao.DBillApplySaleOrderInfoMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.InvoiceReturnMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.DBillApplySaleItemInfoPO;
import com.tydic.pfsc.dao.po.DBillApplySaleOrderInfoPO;
import com.tydic.pfsc.dao.po.InvoiceReturn;
import com.tydic.pfsc.dao.po.InvoiceReturnDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfsc.dao.vo.InvoiceReturnVO;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.InvoiceReturnStatus;
import com.tydic.pfsc.enums.RedBlue;
import com.tydic.pfsc.enums.YesNo;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.external.atour.api.BillInfoUploadExternalService;
import com.tydic.pfsc.service.atom.BillSNService;
import com.tydic.pfsc.service.atom.EnumsService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.DzcsInvoiceReturnApplyRedInvoiceService"})
public class DzcsInvoiceReturnApplyRedInvoiceServiceImpl
implements DzcsInvoiceReturnApplyRedInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnApplyRedInvoiceServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private BillInfoUploadExternalService billInfoUploadExternalService;
    @Autowired
    private BusiInvoiceIssueAtourService busiInvoiceIssueAtourService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private DBillApplySaleOrderInfoMapper billApplySaleOrderInfoMapper;
    @Autowired
    private DBillApplySaleItemInfoMapper billApplySaleItemInfoMapper;

    @PostMapping(value={"invoiceReturn"})
    public DzcsInvoiceReturnApplyRedInvoiceRspBO invoiceReturn(@RequestBody DzcsInvoiceReturnApplyRedInvoiceReqBO reqBO) {
        String billNo;
        List billNos;
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ea2\u5b57\u5f00\u7968\u7533\u8bf7\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)(billNos = reqBO.getBillNos()))) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        InvoiceReturnVO invoiceReturnVO = new InvoiceReturnVO();
        invoiceReturnVO.setBillNos(billNos);
        List<InvoiceReturn> invoiceReturns = this.invoiceReturnMapper.selectListBy(invoiceReturnVO);
        for (InvoiceReturn invoiceReturn : invoiceReturns) {
            billNo = invoiceReturn.getBillNo();
            if (InvoiceReturnStatus.TO_RETURN.getCode().equals(invoiceReturn.getStatus())) continue;
            throw new PfscExtBusinessException("0001", "\u72b6\u6001\u5fc5\u987b\u662f\uff1a" + this.enumsService.getDescr(InvoiceReturnStatus.TO_RETURN));
        }
        for (InvoiceReturn invoiceReturn : invoiceReturns) {
            billNo = invoiceReturn.getBillNo();
            InvoiceReturnDetailVO vo = new InvoiceReturnDetailVO();
            vo.setBillNo(billNo);
            vo.setApplyNo2IsNull("1");
            List<InvoiceReturnDetail> details = this.invoiceReturnDetailMapper.selectList(vo);
            if (details.isEmpty()) continue;
            HashMap applyNo1Map = new HashMap();
            for (InvoiceReturnDetail invoiceReturnDetail : details) {
                if (applyNo1Map.containsKey(invoiceReturnDetail.getApplyNo1())) {
                    ((List)applyNo1Map.get(invoiceReturnDetail.getApplyNo1())).add(invoiceReturnDetail.getInvoiceNo1());
                    continue;
                }
                ArrayList<String> invoiceNo1s = new ArrayList<String>();
                invoiceNo1s.add(invoiceReturnDetail.getInvoiceNo1());
                applyNo1Map.put(invoiceReturnDetail.getApplyNo1(), invoiceNo1s);
            }
            for (Map.Entry entry : applyNo1Map.entrySet()) {
                String applyNo1 = (String)entry.getKey();
                List invoiceNo1s = (List)entry.getValue();
                SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
                saleInvoiceInfoVO.setApplyNo(applyNo1);
                saleInvoiceInfoVO.setInvoiceNoList(invoiceNo1s);
                List<SaleInvoiceInfo> invoices = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
                if (invoices.size() != invoiceNo1s.size()) {
                    throw new PfscExtBusinessException("0001", "\u539f\u53d1\u7968\u6570\u636e\u6709\u8bef");
                }
                BigDecimal amt = BigDecimal.ZERO;
                for (SaleInvoiceInfo invoice : invoices) {
                    amt = amt.add(invoice.getAmt());
                }
                BillApplyInfo billApplyInfo1 = this.billApplyInfoMapper.selectByPrimaryKey(applyNo1);
                String applyNo2 = this.getBillApplyNo();
                BillApplyInfo billApplyInfo2 = new BillApplyInfo();
                BeanUtils.copyProperties((Object)billApplyInfo1, (Object)billApplyInfo2);
                billApplyInfo2.setApplyNo(applyNo2);
                billApplyInfo2.setApplyDate(new Date());
                billApplyInfo2.setAmt(amt.negate());
                billApplyInfo2.setBillStatus(BillStatus.NO_APPLY.getCode());
                billApplyInfo2.setUserId(reqBO.getUserId());
                billApplyInfo2.setReturnBillNo(null);
                billApplyInfo2.setRedBlue(RedBlue.RED.getCode());
                billApplyInfo2.setUrgedInvoice(YesNo.NO.getCode());
                billApplyInfo2.setRemark(null);
                this.billApplyInfoMapper.insert(billApplyInfo2);
                InvoiceReturnDetailVO whereRecord = new InvoiceReturnDetailVO();
                whereRecord.setBillNo(billNo);
                whereRecord.setApplyNo1(applyNo1);
                InvoiceReturnDetailVO valueRecord = new InvoiceReturnDetailVO();
                valueRecord.setApplyNo2(applyNo2);
                this.invoiceReturnDetailMapper.updateBy(whereRecord, valueRecord);
                DBillApplySaleOrderInfoPO billApplySaleOrderInfoPo = new DBillApplySaleOrderInfoPO();
                billApplySaleOrderInfoPo.setApplyNo(applyNo1);
                List<DBillApplySaleOrderInfoPO> billApplySaleOrderInfoPoList = this.billApplySaleOrderInfoMapper.getList(billApplySaleOrderInfoPo);
                if (CollectionUtils.isEmpty(billApplySaleOrderInfoPoList)) {
                    throw new PfscExtBusinessException("18000", "\u672a\u67e5\u8be2\u5230\u539f\u5f00\u7968\u7533\u8bf7\u5355\u8ba2\u5355\u6570\u636e");
                }
                billApplySaleOrderInfoPoList.forEach(po -> po.setApplyNo(applyNo2));
                this.billApplySaleOrderInfoMapper.insertBatch(billApplySaleOrderInfoPoList);
                DBillApplySaleItemInfoPO billApplySaleItemInfoPo = new DBillApplySaleItemInfoPO();
                billApplySaleItemInfoPo.setApplyNo(applyNo1);
                List<DBillApplySaleItemInfoPO> billApplySaleItemInfoPoList = this.billApplySaleItemInfoMapper.getList(billApplySaleItemInfoPo);
                if (CollectionUtils.isEmpty(billApplySaleItemInfoPoList)) {
                    throw new PfscExtBusinessException("18000", "\u672a\u67e5\u8be2\u5230\u539f\u5f00\u7968\u7533\u8bf7\u5355\u8ba2\u5355\u660e\u7ec6\u6570\u636e");
                }
                billApplySaleItemInfoPoList.forEach(po -> po.setApplyNo(applyNo2));
                this.billApplySaleItemInfoMapper.insertBatch(billApplySaleItemInfoPoList);
                try {
                    BusiInvoiceIssueAtourReqBO atourReqBO = new BusiInvoiceIssueAtourReqBO();
                    ArrayList<String> applyNoList = new ArrayList<String>();
                    applyNoList.add(applyNo2);
                    atourReqBO.setApplyNoList(applyNoList);
                    atourReqBO.setApplyStatus(Integer.valueOf(2));
                    this.busiInvoiceIssueAtourService.invoiceIssue(atourReqBO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            invoiceReturn = new InvoiceReturn();
            invoiceReturn.setBillNo(billNo);
            invoiceReturn.setStatus(InvoiceReturnStatus.RETURNING.getCode());
            this.invoiceReturnMapper.updateByPrimaryKeySelective(invoiceReturn);
        }
        DzcsInvoiceReturnApplyRedInvoiceRspBO rspBO = new DzcsInvoiceReturnApplyRedInvoiceRspBO();
        return rspBO;
    }

    private String getBillApplyNo() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String dateL = Long.valueOf(df.format(new Date())).toString();
        String prefix = "KPSQ";
        String maxNum = this.billApplyInfoMapper.selectMaxPayNoNum(prefix + dateL);
        String num = "000001";
        if (maxNum != null && !"".equals(maxNum)) {
            num = String.format("%06d", Integer.parseInt(maxNum) + 1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(dateL).append(num);
        return sb.toString();
    }
}

