/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfsc.aop.annotation.FscDuplicateCommitLimit;
import com.tydic.pfsc.api.busi.BusiAuthInvoiceExistService;
import com.tydic.pfsc.api.busi.bo.PayPurchaseOrderInfoBO;
import com.tydic.pfsc.api.busi.vo.BillNotificationInfoVO;
import com.tydic.pfsc.api.busi.vo.BusiProcessInvoiceInOutVO;
import com.tydic.pfsc.api.comb.FscAddPayInvoiceInfoService;
import com.tydic.pfsc.api.comb.bo.FscAddPayInvoiceInfoReqBO;
import com.tydic.pfsc.api.comb.bo.FscAddPayInvoiceInfoRspBO;
import com.tydic.pfsc.api.comb.vo.FscInvoiceDetailVO;
import com.tydic.pfsc.api.comb.vo.FscInvoiceInfoVO;
import com.tydic.pfsc.api.deal.BusiBillNotificationService;
import com.tydic.pfsc.api.deal.BusiPayPurchaseOrderInfoListService;
import com.tydic.pfsc.api.deal.BusiUpdatePayPurchaseOrderInfoService;
import com.tydic.pfsc.api.deal.QueryPayInvoiceDetailService;
import com.tydic.pfsc.api.deal.QueryPayInvoiceService;
import com.tydic.pfsc.api.deal.bo.BusiPayInvoiceInfoReqBO;
import com.tydic.pfsc.api.deal.bo.BusiPayInvoiceInfoRspBO;
import com.tydic.pfsc.api.deal.bo.BusiPayPurchaseOrderInfoReqBO;
import com.tydic.pfsc.api.deal.bo.BusiPayPurchaseOrderInfoRspBO;
import com.tydic.pfsc.api.deal.bo.BusiUpdatePayPurchaseOrderInfoReqBO;
import com.tydic.pfsc.api.deal.bo.PayInvoiceDetailBO;
import com.tydic.pfsc.api.deal.bo.PayInvoiceInfoBO;
import com.tydic.pfsc.api.deal.bo.QueryPayInvoiceDetailReqBO;
import com.tydic.pfsc.api.deal.bo.QueryPayInvoiceDetailRspBO;
import com.tydic.pfsc.enums.NotificationInvoiceStatus;
import com.tydic.pfsc.enums.NotificationInvoiceStatusType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.comb.FscAddPayInvoiceInfoService"})
public class FscAddPayInvoiceInfoServiceImpl
implements FscAddPayInvoiceInfoService {
    private static final Logger log = LoggerFactory.getLogger(FscAddPayInvoiceInfoServiceImpl.class);
    @Autowired
    private BusiBillNotificationService busiBillNotificationService;
    @Autowired
    private QueryPayInvoiceService queryPayInvoiceService;
    @Autowired
    private QueryPayInvoiceDetailService queryPayInvoiceDetailService;
    @Autowired
    private BusiUpdatePayPurchaseOrderInfoService busiUpdatePayPurchaseOrderInfoService;
    @Autowired
    private BusiPayPurchaseOrderInfoListService busiPayPurchaseOrderInfoListService;
    @Autowired
    private BusiAuthInvoiceExistService busiAuthInvoiceExistService;

    @FscDuplicateCommitLimit(toast="\u6b63\u5728\u6dfb\u52a0\u53d1\u7968\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01")
    @PostMapping(value={"addPayInvoiceInfo"})
    public FscAddPayInvoiceInfoRspBO addPayInvoiceInfo(@RequestBody FscAddPayInvoiceInfoReqBO reqBO) {
        log.info("\u5f00\u7968\u901a\u77e5\u53d1\u7968\u586b\u5199\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        FscAddPayInvoiceInfoRspBO resp = new FscAddPayInvoiceInfoRspBO();
        if (reqBO.getNotificationNo() == null) {
            resp.setRespCode("0001");
            resp.setRespDesc("\u5fc5\u987b\u6307\u5b9a\u5f00\u7968\u901a\u77e5\u5355ID");
            return resp;
        }
        if (reqBO.getCompanyId() == null) {
            resp.setRespCode("0001");
            resp.setRespDesc("\u65e0\u6cd5\u786e\u5b9a\u4e13\u4e1a\u516c\u53f8");
            return resp;
        }
        if (reqBO.getSupplierNo() == null) {
            resp.setRespCode("0001");
            resp.setRespDesc("\u5fc5\u987b\u6307\u5b9a\u4f9b\u5e94\u5546ID");
            return resp;
        }
        BusiProcessInvoiceInOutVO busiProcessInvoiceInOutVO = new BusiProcessInvoiceInOutVO();
        busiProcessInvoiceInOutVO.setNotificationNo(reqBO.getNotificationNo());
        busiProcessInvoiceInOutVO.setCompanyId(reqBO.getCompanyId());
        BillNotificationInfoVO bill = this.busiBillNotificationService.selectByPrimaryAndCompany(busiProcessInvoiceInOutVO);
        if (bill == null) {
            log.info("\u53d1\u7968\u4fe1\u606f\u67e5\u8be2,\u5f00\u7968\u901a\u77e5\u5355\u4e0d\u5b58\u5728,\u901a\u77e5\u5355=" + reqBO.getNotificationNo() + ",companyID=" + reqBO.getCompanyId());
            resp.setRespCode("0001");
            resp.setRespDesc("\u5f00\u7968\u901a\u77e5\u5355" + reqBO.getNotificationNo() + "\u4e0d\u5b58\u5728");
            return resp;
        }
        if (!bill.getSupplierNo().equals(reqBO.getSupplierNo())) {
            log.info("\u53d1\u7968\u4fe1\u606f\u67e5\u8be2\u67e5\u8be2\u5904\u7406\u5931\u8d25,\u5f00\u7968\u901a\u77e5\u5355\u4e0d\u5c5e\u4e8e\u5f53\u524d\u4f9b\u5e94\u5546,\u901a\u77e5\u5355=" + reqBO.getNotificationNo() + ",supplierNo=" + reqBO.getSupplierNo());
            resp.setRespCode("0001");
            resp.setRespDesc("\u5f00\u7968\u901a\u77e5\u5355" + reqBO.getNotificationNo() + "\u4e0d\u5c5e\u4e8e\u5f53\u524d\u4f9b\u5e94\u5546!!!");
            return resp;
        }
        if (NotificationInvoiceStatus.SUBMITED.getCode().equals(bill.getInvoiceStatus())) {
            resp.setRespCode("18000");
            resp.setRespDesc("\u8be5\u5f00\u7968\u901a\u77e5\u53f7\u7684\u53d1\u7968\u5df2\u63d0\u4ea4\u8fc7\u4e86\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4");
            log.debug("\u8be5\u5f00\u7968\u901a\u77e5\u4e3a\u5f85\u5ba1\u6279\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u63d0\u4ea4\u3002bill:{}", (Object)JSON.toJSONString((Object)bill));
            return resp;
        }
        String invoiceStatus = bill.getInvoiceStatus();
        if (null != invoiceStatus && "03".equals(invoiceStatus)) {
            resp.setRespCode("0001");
            resp.setRespDesc("\u5f00\u7968\u901a\u77e5\u5355\u53f7\u7684\u53d1\u7968\u5df2\u6536\u7968,\u4e0d\u5141\u8bb8\u518d\u5904\u7406");
            return resp;
        }
        StringBuilder nullErrorMsg = new StringBuilder();
        if (null != reqBO.getInvoices() && reqBO.getInvoices().size() > 0) {
            log.error("\u6821\u9a8c\u53d1\u7968\u5f00\u59cb");
            for (int i = 0; i < reqBO.getInvoices().size(); ++i) {
                FscInvoiceInfoVO operatorInvoiceInfoVO = (FscInvoiceInfoVO)reqBO.getInvoices().get(i);
                if (null == operatorInvoiceInfoVO.getInvoiceNo() || "".equals(operatorInvoiceInfoVO.getInvoiceNo())) {
                    nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                }
                if (null == operatorInvoiceInfoVO.getInvoiceCode() || "".equals(operatorInvoiceInfoVO.getInvoiceCode())) {
                    nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                }
                if (null == operatorInvoiceInfoVO.getInvoiceDate()) {
                    nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                }
                if (null == operatorInvoiceInfoVO.getAmt()) {
                    nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u7968\u7a0e\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                }
                if (null == operatorInvoiceInfoVO.getNotTaxAmt()) {
                    nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                }
                if (null == operatorInvoiceInfoVO.getTaxAmt()) {
                    nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                }
                if (null == operatorInvoiceInfoVO.getTaxRate()) {
                    nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                } else if (operatorInvoiceInfoVO.getTaxRate().intValue() < 0 || operatorInvoiceInfoVO.getTaxRate().intValue() > 100) {
                    nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u7a0e\u7387\u975e\u6cd5,\u8303\u56f4\u5e94\u4e3a\u30100~100\u3011\u533a\u95f4\u7684\u6574\u6570\u3002");
                }
                if (!this.isNullOrEmpty(nullErrorMsg)) {
                    resp.setRespCode("0001");
                    resp.setRespDesc(nullErrorMsg.toString());
                    return resp;
                }
                log.error("\u6821\u9a8c\u53d1\u7968\u7ed3\u675f\u3002");
                List detailVoLs = operatorInvoiceInfoVO.getInvoiceDetails();
                if (null != detailVoLs && detailVoLs.size() > 0) {
                    log.error("\u6821\u9a8c\u53d1\u7968\u660e\u7ec6\u5f00\u59cb\u3002");
                    for (int j = 0; j < detailVoLs.size(); ++j) {
                        if (detailVoLs != null && ((FscInvoiceDetailVO)detailVoLs.get(j)).getInvoiceAmt() != null) continue;
                        resp.setRespCode("0001");
                        resp.setRespDesc("\u7b2c" + (i + 1) + "\u884c" + (j + 1) + "\u5217\u5f00\u7968\u91d1\u989d\u4e3a\u7a7a\u3002");
                        return resp;
                    }
                } else {
                    resp.setRespCode("0001");
                    resp.setRespDesc("\u7b2c" + (i + 1) + "\u884c \u8bf7\u5173\u8054\u5f00\u7968\u9a8c\u6536\u5355\u3002");
                    return resp;
                }
                log.error("\u6821\u9a8c\u53d1\u7968\u660e\u7ec6\u7ed3\u675f\u3002");
            }
        } else {
            resp.setRespCode("0001");
            resp.setRespDesc("\u672a\u53d1\u73b0\u5f00\u7968\u901a\u77e5\u5355\u53f7\u7684\u53d1\u7968\u6570\u636e");
            return resp;
        }
        BusiPayPurchaseOrderInfoReqBO busiPayPurchaseOrderInfoReqBO = new BusiPayPurchaseOrderInfoReqBO();
        busiPayPurchaseOrderInfoReqBO.setNotificationNo(reqBO.getNotificationNo());
        BusiPayPurchaseOrderInfoRspBO busiPayPurchaseOrderInfoRspBO = this.busiPayPurchaseOrderInfoListService.selectByNotificationNo(busiPayPurchaseOrderInfoReqBO);
        List payPurchaseOrderInfoBOArrayList = new ArrayList();
        if (null != busiPayPurchaseOrderInfoRspBO) {
            payPurchaseOrderInfoBOArrayList = busiPayPurchaseOrderInfoRspBO.getPayPurchaseOrderInfoBOS();
            log.info("\u5f00\u7968\u901a\u77e5\u5355-\u5173\u8054\u9a8c\u6536\u5355\u5217\u8868" + busiPayPurchaseOrderInfoRspBO.toString());
        }
        if (payPurchaseOrderInfoBOArrayList.size() == 0) {
            resp.setRespCode("0001");
            resp.setRespDesc("\u672a\u53d1\u73b0\u901a\u77e5\u5355\u76f8\u5173\u7684\u5546\u54c1\u660e\u7ec6");
            return resp;
        }
        log.info("\u5f00\u7968\u901a\u77e5\u5355-\u5f00\u59cb\u5904\u7406\u65b0\u589e\u53d1\u7968\u660e\u7ec6");
        ArrayList<PayInvoiceInfoBO> newInvoices = new ArrayList<PayInvoiceInfoBO>();
        ArrayList<PayInvoiceDetailBO> newIvDetails = new ArrayList<PayInvoiceDetailBO>();
        if (null != reqBO.getInvoices() && reqBO.getInvoices().size() > 0) {
            ArrayList sampsForUpdate = new ArrayList();
            HashSet payItemSeqSet = new HashSet();
            HashSet invoiceNoSet = new HashSet();
            BigDecimal amtTotal = BigDecimal.ZERO;
            HashMap<String, BigDecimal> inspectionMap = new HashMap<String, BigDecimal>();
            for (FscInvoiceInfoVO ivVo : reqBO.getInvoices()) {
                log.debug("\u5f00\u7968\u660e\u7ec6" + bill.getAddr() + bill.getBankName() + bill.getPhone() + bill.getTaxNo());
                PayInvoiceInfoBO iv = new PayInvoiceInfoBO();
                BeanUtils.copyProperties((Object)ivVo, (Object)iv);
                iv.setInvoiceType(bill.getInvoceType());
                iv.setAddress(bill.getAddr());
                iv.setBankName(bill.getBankName());
                iv.setPhone(bill.getPhone());
                iv.setTaxNo(bill.getTaxNo());
                iv.setBankAcNo(bill.getBankAccNo());
                iv.setAddress(ivVo.getAddress());
                iv.setBankAcNo(ivVo.getBankAcNo());
                iv.setAmt(ivVo.getAmt());
                iv.setNotTaxAmt(ivVo.getNotTaxAmt());
                iv.setTaxRate(ivVo.getTaxRate().divide(BigDecimal.valueOf(100L), 2, 1));
                iv.setInvoiceStatus("01");
                iv.setMailStatus("01");
                List detailVoLs = ivVo.getInvoiceDetails();
                BigDecimal amt = BigDecimal.ZERO;
                for (FscInvoiceDetailVO detailVo : detailVoLs) {
                    PayInvoiceDetailBO ivDetail = new PayInvoiceDetailBO();
                    BeanUtils.copyProperties((Object)detailVo, (Object)ivDetail);
                    ivDetail.setInvoiceNo(ivVo.getInvoiceNo());
                    ivDetail.setNotificationNo(ivVo.getNotificationNo());
                    newIvDetails.add(ivDetail);
                    if (ivDetail.getAmount() == null || BigDecimal.ZERO.compareTo(ivDetail.getAmount()) >= 0) {
                        resp.setRespCode("18001");
                        resp.setRespDesc(ivDetail.getItemName() + "\u7684\u9a8c\u6536\u91d1\u989d\u4e0d\u6b63\u786e(\u5fc5\u987b\u5927\u4e8e0)");
                        return resp;
                    }
                    if (ivDetail.getInvoiceAmt() == null || BigDecimal.ZERO.compareTo(ivDetail.getInvoiceAmt()) >= 0) {
                        resp.setRespCode("18001");
                        resp.setRespDesc(ivDetail.getItemName() + "\u7684\u5f00\u7968\u91d1\u989d\u4e0d\u6b63\u786e(\u5fc5\u987b\u5927\u4e8e0)");
                        return resp;
                    }
                    if (ivDetail.getInvoiceAmt().compareTo(ivDetail.getAmount()) > 0) {
                        resp.setRespCode("18001");
                        resp.setRespDesc("\u60a8\u586b\u5199\u7684\u5f00\u7968\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u9009\u62e9\u7684\u9a8c\u6536\u5355\u91d1\u989d");
                        return resp;
                    }
                    amt = amt.add(ivDetail.getInvoiceAmt());
                    ivDetail.setOrderCode(detailVo.getOrderCode());
                    ivDetail.setOrderId(detailVo.getOrderId());
                    ivDetail.setInspectionId(detailVo.getInspectionId());
                    ivDetail.setInvoiceDate(ivVo.getInvoiceDate());
                    ivDetail.setInvoiceCode(ivVo.getInvoiceCode());
                    String inspectionStr = detailVo.getInspectionId() + "-" + detailVo.getOrderId();
                    if (inspectionMap.containsKey(inspectionStr)) {
                        inspectionMap.put(inspectionStr, ((BigDecimal)inspectionMap.get(inspectionStr)).add(ivDetail.getInvoiceAmt()));
                    } else {
                        inspectionMap.put(inspectionStr, ivDetail.getInvoiceAmt());
                    }
                    log.error("\u586b\u5199\u53d1\u7968\uff1akey[" + inspectionStr + "] \u9a8c\u6536\u91d1\u989d" + inspectionMap.get(inspectionStr));
                }
                newInvoices.add(iv);
                amtTotal = amtTotal.add(amt);
                if (amt.compareTo(iv.getAmt()) == 0) continue;
                resp.setRespCode("18001");
                resp.setRespDesc("\u53d1\u7968[" + iv.getInvoiceNo() + "]\u53d1\u7968\u91d1\u989d" + iv.getAmt() + "\u4e0e\u5173\u8054\u9a8c\u6536\u5355\u6c47\u603b\u5408\u8ba1\u91d1\u989d" + amt + "\u4e0d\u5339\u914d");
                return resp;
            }
            if (null != inspectionMap && payPurchaseOrderInfoBOArrayList.size() == inspectionMap.size()) {
                log.error("\u586b\u5199\u53d1\u7968\uff1a\u901a\u77e5\u5355\u5173\u8054\u7684\u9a8c\u6536\u5355\u4e2a\u6570\uff1a" + payPurchaseOrderInfoBOArrayList.size() + " \u586b\u5199\u4e86\u53d1\u7968\u7684\u9a8c\u6536\u5355\u6570\u91cf" + inspectionMap.size());
                for (PayPurchaseOrderInfoBO purchaseOrderInfoBO : payPurchaseOrderInfoBOArrayList) {
                    log.error("\u586b\u5199\u53d1\u7968\uff1a\u60a8\u9009\u62e9\u7684\u9a8c\u6536\u5355\u53f7[" + purchaseOrderInfoBO.getInspectionCode() + "] \u9a8c\u6536\u91d1\u989d" + purchaseOrderInfoBO.getOrderAmt() + " \u9a8c\u6536\u5355\u5f00\u7968\u6c47\u603b\u91d1\u989d\uff1a" + inspectionMap.get(purchaseOrderInfoBO.getInspectionId() + "-" + purchaseOrderInfoBO.getOrderId()));
                    BigDecimal invoiceAmtTotal = (BigDecimal)inspectionMap.get(purchaseOrderInfoBO.getInspectionId() + "-" + purchaseOrderInfoBO.getOrderId());
                    if (null == invoiceAmtTotal || purchaseOrderInfoBO.getOrderAmt().compareTo(invoiceAmtTotal) >= 0) continue;
                    resp.setRespCode("0001");
                    resp.setRespDesc("\u60a8\u9009\u62e9\u7684\u9a8c\u6536\u5355\u53f7[" + purchaseOrderInfoBO.getInspectionCode() + "]\u586b\u5199\u7684\u5f00\u7968\u6c47\u603b\u91d1\u989d\u8d85\u51fa\u9a8c\u6536\u5355\u5141\u8bb8\u7684\u6700\u5927\u91d1\u989d");
                    return resp;
                }
            } else {
                resp.setRespCode("0001");
                resp.setRespDesc("\u6709\u9a8c\u6536\u5355\u672a\u5f55\u5165\u53d1\u7968\u4fe1\u606f\uff0c\u65e0\u6cd5\u63d0\u4ea4");
                return resp;
            }
            if (amtTotal.compareTo(bill.getAmt()) != 0) {
                resp.setRespCode("0001");
                resp.setRespDesc("\u53d1\u7968\u603b\u91d1\u989d\u4e0e\u5f00\u7968\u9a8c\u6536\u5355\u660e\u7ec6\u5408\u8ba1\u91d1\u989d\u4e0d\u5339\u914d,\u91d1\u989d\u8bf7\u586b\u5199\u4fdd\u75592\u4f4d\u5c0f\u6570\u540e\u7684\u503c");
                return resp;
            }
        } else {
            resp.setRespCode("0001");
            resp.setRespDesc("\u672a\u53d1\u73b0\u901a\u77e5\u5355\u76f8\u5173\u7684\u5546\u54c1\u660e\u7ec6");
            return resp;
        }
        this.clearOldInvoice(bill.getNotificationNo());
        QueryPayInvoiceDetailReqBO addreqBO = new QueryPayInvoiceDetailReqBO();
        addreqBO.setNewIvDetails(newIvDetails);
        QueryPayInvoiceDetailRspBO queryPayInvoiceDetailRspBO = this.queryPayInvoiceDetailService.insertByBatch(addreqBO);
        if (!"0000".equals(queryPayInvoiceDetailRspBO.getRespCode())) {
            resp.setRespCode(queryPayInvoiceDetailRspBO.getRespCode());
            resp.setRespDesc(queryPayInvoiceDetailRspBO.getRespDesc());
            return resp;
        }
        BusiPayInvoiceInfoReqBO newInvoicesBO = new BusiPayInvoiceInfoReqBO();
        newInvoicesBO.setNewIvDetails(newInvoices);
        BusiPayInvoiceInfoRspBO payInvoiceInfoRspBO = this.queryPayInvoiceService.batchInsert(newInvoicesBO);
        if (!"0000".equals(payInvoiceInfoRspBO.getRespCode())) {
            resp.setRespCode(payInvoiceInfoRspBO.getRespCode());
            resp.setRespDesc(payInvoiceInfoRspBO.getRespDesc());
            return resp;
        }
        BusiUpdatePayPurchaseOrderInfoReqBO busiUpdatePayPurchaseOrderInfoReqBO = new BusiUpdatePayPurchaseOrderInfoReqBO();
        busiUpdatePayPurchaseOrderInfoReqBO.setNotificationNo(reqBO.getNotificationNo());
        this.busiUpdatePayPurchaseOrderInfoService.updateInvoiceAmt(busiUpdatePayPurchaseOrderInfoReqBO);
        BillNotificationInfoVO vo = new BillNotificationInfoVO();
        vo.setInvoiceStatus(NotificationInvoiceStatusType.SUBMITED.getCode());
        vo.setNotificationNo(reqBO.getNotificationNo());
        this.busiBillNotificationService.updateByPrimaryKeySelective(vo);
        resp.setRespCode("0000");
        resp.setRespDesc("\u6210\u529f");
        return resp;
    }

    private void clearOldInvoice(String notificationNo) {
        BusiPayInvoiceInfoReqBO reqBO = new BusiPayInvoiceInfoReqBO();
        reqBO.setNotificationNo(notificationNo);
        List ls = new ArrayList();
        BusiPayInvoiceInfoRspBO busiPayInvoiceInfoRspBO = this.queryPayInvoiceService.selectByNotifyNo(reqBO);
        if (null != busiPayInvoiceInfoRspBO) {
            ls = busiPayInvoiceInfoRspBO.getPayInvoiceInfoBOs();
        }
        log.info("--\u901a\u77e5\u5355[" + notificationNo + "]\u6d89\u53ca\u7684\u9700\u6e05\u9664\u65e7\u53d1\u7968\u6570\u91cf=" + ls.size());
        for (PayInvoiceInfoBO iv : ls) {
            QueryPayInvoiceDetailReqBO ivs = new QueryPayInvoiceDetailReqBO();
            ivs.setPayInvoiceInfoBO(iv);
            this.queryPayInvoiceDetailService.deleteByInvoiceNo(ivs);
            BusiPayInvoiceInfoReqBO BusiPayInvoiceInfoReqBO2 = new BusiPayInvoiceInfoReqBO();
            BusiPayInvoiceInfoReqBO2.setPayInvoiceInfoBO(iv);
            this.queryPayInvoiceService.deleteByPrimaryKey(BusiPayInvoiceInfoReqBO2);
        }
    }

    private boolean isNullOrEmpty(Object str) {
        return str == null || "".equals(str.toString());
    }
}

