/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.utils;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    public static String httpPostData(String url, String data, String str) throws IOException {
        url = url + "?" + data;
        System.out.println(url);
        URL urlData = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)urlData.openConnection();
        conn.setRequestMethod("POST");
        InputStream is = urlData.openStream();
        return HttpUtils.convertStreamToString(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) {
        StringBuilder sb1 = new StringBuilder();
        byte[] bytes = new byte[4096];
        int size = 0;
        try {
            while ((size = is.read(bytes)) > 0) {
                String str = new String(bytes, 0, size, StandardCharsets.UTF_8);
                sb1.append(str);
            }
        }
        catch (IOException e) {
            logger.error("\u8f93\u5165\u6d41\u5904\u7406\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error("\u8f93\u5165\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
        }
        return sb1.toString();
    }

    public static String getResByPOST(String urlPath, String param) throws IOException {
        URL url = new URL(urlPath);
        HttpsURLConnection httpConn = (HttpsURLConnection)url.openConnection();
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        httpConn.setUseCaches(false);
        httpConn.setRequestMethod("POST");
        httpConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        httpConn.setRequestProperty("Connection", "Keep-Alive");
        httpConn.setRequestProperty("Charset", "UTF-8");
        DataOutputStream dos = new DataOutputStream(httpConn.getOutputStream());
        dos.writeBytes(param);
        dos.flush();
        dos.close();
        int resultCode = httpConn.getResponseCode();
        StringBuilder sb = new StringBuilder();
        String readLine = "";
        if (200 == resultCode) {
            BufferedReader responseReader = new BufferedReader(new InputStreamReader(httpConn.getInputStream(), StandardCharsets.UTF_8));
            while ((readLine = responseReader.readLine()) != null) {
                sb.append(readLine).append("\n");
            }
            responseReader.close();
            System.out.println(sb.toString());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(String url, String param) {
        PrintWriter out = null;
        BufferedReader in = null;
        StringBuilder result = new StringBuilder();
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(param);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001 POST \u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)ex);
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGet(String url, String param) {
        StringBuilder result = new StringBuilder();
        BufferedReader in = null;
        try {
            String line;
            String urlNameString = url + "?" + param;
            URL realUrl = new URL(urlNameString);
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.connect();
            Map<String, List<String>> map = connection.getHeaderFields();
            for (String key : map.keySet()) {
                System.out.println(key + "--->" + map.get(key));
            }
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001GET\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e2);
            }
        }
        return result.toString();
    }

    public static String getPostPingAn(String url, String param) throws IOException {
        String res = null;
        PostMethod postMethod = new PostMethod("http://127.0.0.1:7072");
        postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(param, "text/html", "GBK"));
        postMethod.setRequestHeader("Content-type", "text/xml; charset=GBK");
        HttpClient httpClient = new HttpClient();
        int resultint = httpClient.executeMethod((HttpMethod)postMethod);
        res = new String(postMethod.getResponseBody(), "GBK");
        System.out.println("http response:" + res);
        postMethod.releaseConnection();
        return res;
    }
}

