/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.controller.rest.dataexport;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.file.FileProcessing;
import com.tydic.pfsc.api.busi.BusiExportOutstockDetailInfoService;
import com.tydic.pfsc.api.busi.BusiGetYuanGuangAttachmentNameService;
import com.tydic.pfsc.api.busi.bo.BusiExportListOutstockInfoReqBO;
import com.tydic.pfsc.api.busi.bo.BusiExportOutstockDetailInfoRspBO;
import com.tydic.pfsc.api.busi.bo.BusiExportRowOutstockDetailInfoRspBO;
import com.tydic.pfsc.api.busi.bo.BusiGetYuanGuangAttachmentNameReqBO;
import com.tydic.pfsc.api.busi.bo.BusiGetYuanGuangAttachmentNameRspBO;
import com.tydic.pfsc.api.busi.vo.SaleInvoiceVO;
import com.tydic.pfsc.common.PDFShowPageFooterEvent;
import com.tydic.pfsc.controller.utils.FscFileUtils;
import com.tydic.pfsc.enums.YuanGuangBillType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class FscExportOutstockDetailInfoService {
    private static final Logger log = LoggerFactory.getLogger(FscExportOutstockDetailInfoService.class);
    @Autowired
    private BusiExportOutstockDetailInfoService busiExportOutstockDetailInfoService;
    @Autowired
    private BusiGetYuanGuangAttachmentNameService busiGetYuanGuangAttachmentNameService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportOutstockDetailInfoPDF(HttpServletResponse response, BusiExportListOutstockInfoReqBO reqBO) {
        log.debug("reqBO=" + reqBO);
        if (reqBO.getTotalNo() == null) {
            log.error("\u6c47\u603b\u5355\u53f7[totalNo]\u4e0d\u80fd\u4e3a\u7a7a\u3002reqBO=" + reqBO);
            this.failedMsg(response, "\u6c47\u603b\u5355\u53f7[totalNo]\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        Document document = new Document(PageSize.A4.rotate(), -60.0f, -60.0f, 15.0f, 40.0f);
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            log.error("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519\u3002reqBO=" + reqBO, (Throwable)e);
            this.failedMsg(response, "\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519");
            return;
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        Font footerFont = new Font(baseFont, 10.0f, 1);
        int COLUMNS = 6;
        response.setHeader("Content-Disposition", "attachment;filename=outstockPDF.pdf");
        response.setContentType("application/x-download");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)response.getOutputStream());
            PdfWriter.getInstance((Document)document, (OutputStream)baos);
            PDFShowPageFooterEvent event = new PDFShowPageFooterEvent(PageSize.A4.rotate(), footerFont, footerFont);
            writer.setPageEvent((PdfPageEvent)event);
        }
        catch (Exception e) {
            log.error("\u628apdf\u5199\u5230\u8f93\u51fa\u6d41\u51fa\u9519\u3002reqBO=" + reqBO, (Throwable)e);
            this.failedMsg(response, "\u628apdf\u5199\u5230\u8f93\u51fa\u6d41\u51fa\u9519");
            return;
        }
        document.open();
        BusiExportOutstockDetailInfoRspBO rspBO = null;
        try {
            rspBO = this.busiExportOutstockDetailInfoService.exportOutstockDetailInfo(reqBO);
            if (rspBO == null || !"0000".equals(rspBO.getRespCode())) {
                this.failedMsg(response, rspBO == null ? "\u67e5\u8be2\u51fa\u5e93\u6570\u636e\u5931\u8d25," : rspBO.getRespDesc());
                return;
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u65e0\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002reqBO=" + reqBO, (Throwable)e);
            this.failedMsg(response, "\u67e5\u8be2\u65e0\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        List rows = rspBO.getRows();
        PdfPTable titleTable1 = new PdfPTable(1);
        PdfPCell titleCell1 = new PdfPCell(new Phrase("\u7269\u8d44\u9500\u552e\u51fa\u5e93\u5355", titleFont));
        titleCell1.setColspan(1);
        titleCell1.setBorder(0);
        titleCell1.setFixedHeight(30.0f);
        titleCell1.setHorizontalAlignment(1);
        titleCell1.setVerticalAlignment(5);
        titleTable1.addCell(titleCell1);
        try {
            document.add((Element)titleTable1);
        }
        catch (DocumentException e) {
            log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO, (Throwable)e);
            this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
            return;
        }
        PdfPTable table1 = new PdfPTable(7);
        PdfPCell cell1 = new PdfPCell();
        cell1.setColspan(0);
        cell1.setBorder(0);
        cell1.setHorizontalAlignment(1);
        cell1.setVerticalAlignment(5);
        table1.addCell(cell1);
        cell1.setPhrase(new Phrase(rspBO.getCreateDate(), contentFont));
        cell1.setColspan(3);
        cell1.setHorizontalAlignment(0);
        table1.addCell(cell1);
        cell1.setPhrase(new Phrase("\u51fa\u5e93\u6c47\u603b\u5355\u53f7\uff1a" + reqBO.getTotalNo(), contentFont));
        cell1.setColspan(2);
        cell1.setHorizontalAlignment(0);
        table1.addCell(cell1);
        cell1.setPhrase(new Phrase("\u91d1\u989d\u5355\u4f4d\uff1a\u5143", contentFont));
        cell1.setColspan(2);
        cell1.setHorizontalAlignment(1);
        table1.addCell(cell1);
        try {
            document.add((Element)table1);
        }
        catch (DocumentException e) {
            log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO, (Throwable)e);
            this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
            return;
        }
        PdfPTable headTable = new PdfPTable(6);
        PdfPCell headCell = new PdfPCell(new Phrase("\u5e8f\u53f7", contentFont));
        headCell.setHorizontalAlignment(1);
        headCell.setVerticalAlignment(5);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u51fa\u5e93\u5355\u5355\u53f7", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u6210\u672c ", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u53d1\u7968", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u8d27\u6b3e", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u7a0e\u91d1", contentFont));
        headTable.addCell(headCell);
        try {
            document.add((Element)headTable);
        }
        catch (DocumentException e) {
            log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO, (Throwable)e);
            this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
            return;
        }
        int count = 1;
        for (BusiExportRowOutstockDetailInfoRspBO row : rows) {
            List saleInvoiceList = row.getSaleInvoiceList();
            int fixedHeight = saleInvoiceList.size() * 10;
            Float fixedHeightF = Float.valueOf(fixedHeight);
            PdfPTable detailTable = new PdfPTable(6);
            PdfPCell detailCell = new PdfPCell(new Phrase("" + count++, contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setVerticalAlignment(5);
            detailCell.setRowspan(saleInvoiceList.size());
            detailCell.setFixedHeight(fixedHeightF.floatValue());
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(row.getOutstockNo(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setRowspan(saleInvoiceList.size());
            detailCell.setFixedHeight(fixedHeightF.floatValue());
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(row.getAmt(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setRowspan(saleInvoiceList.size());
            detailCell.setFixedHeight(fixedHeightF.floatValue());
            detailTable.addCell(detailCell);
            for (SaleInvoiceVO saleInvoiceVO : saleInvoiceList) {
                detailCell.setPhrase(new Phrase(saleInvoiceVO.getInvoiceNo(), contentFont));
                detailCell.setHorizontalAlignment(1);
                detailCell.setRowspan(1);
                detailCell.setFixedHeight(10.0f);
                detailTable.addCell(detailCell);
                detailCell.setPhrase(new Phrase(saleInvoiceVO.getUntaxAmt(), contentFont));
                detailCell.setHorizontalAlignment(1);
                detailCell.setRowspan(1);
                detailCell.setFixedHeight(10.0f);
                detailTable.addCell(detailCell);
                detailCell.setPhrase(new Phrase(saleInvoiceVO.getTaxAmt(), contentFont));
                detailCell.setHorizontalAlignment(1);
                detailCell.setRowspan(1);
                detailCell.setFixedHeight(10.0f);
                detailTable.addCell(detailCell);
            }
            try {
                document.add((Element)detailTable);
            }
            catch (DocumentException e) {
                log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO, (Throwable)e);
                this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
                return;
            }
        }
        PdfPTable table2 = new PdfPTable(6);
        PdfPCell cell2 = new PdfPCell(new Phrase("\u6210\u672c\u5408\u8ba1", contentFont));
        cell2.setColspan(2);
        cell2.setHorizontalAlignment(1);
        cell2.setVerticalAlignment(5);
        table2.addCell(cell2);
        cell2.setPhrase(new Phrase(rspBO.getSum(), contentFont));
        cell2.setHorizontalAlignment(1);
        cell2.setColspan(1);
        table2.addCell(cell2);
        cell2.setPhrase(new Phrase("\u53d1\u7968\u5408\u8ba1", contentFont));
        cell2.setHorizontalAlignment(1);
        cell2.setColspan(1);
        table2.addCell(cell2);
        cell2.setPhrase(new Phrase(rspBO.getSumAmt(), contentFont));
        cell2.setColspan(2);
        cell2.setHorizontalAlignment(1);
        table2.addCell(cell2);
        try {
            document.add((Element)table2);
        }
        catch (DocumentException e) {
            log.error("pdf\u8ffd\u52a0table\u51fa\u9519\u3002reqBO=" + reqBO, (Throwable)e);
            this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
            return;
        }
        document.close();
        InputStream inputStream = null;
        try {
            inputStream = FscFileUtils.outputStreamToInputStream(baos);
            if (null != inputStream) {
                BusiGetYuanGuangAttachmentNameReqBO nameReqBO = new BusiGetYuanGuangAttachmentNameReqBO();
                nameReqBO.setBillTypeCode(YuanGuangBillType.OUTSTOCK_TOTAL_OUTBOUND.getCode());
                nameReqBO.setBillNo(reqBO.getTotalNo());
                nameReqBO.setCompanyId(rspBO.getOrgId());
                nameReqBO.setSuffixName(".pdf");
                BusiGetYuanGuangAttachmentNameRspBO nameRspBO = this.busiGetYuanGuangAttachmentNameService.query(nameReqBO);
                String newFileName = FileProcessing.uploadFileByInputStream((String)nameRspBO.getAttachmentName(), (InputStream)inputStream, (String)"", (String)"PAY", (boolean)false);
                if (StringUtils.hasText((String)newFileName)) {
                    log.debug("\u4e0a\u4f20\u6587\u4ef6" + nameRspBO.getAttachmentName() + "\u5230OSS\u6210\u529f");
                }
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25:" + e.getMessage());
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u8f93\u5165\u6d41\u51fa\u9519:" + e.getMessage());
                }
            }
        }
    }

    private void failedMsg(HttpServletResponse response, String msg) {
        response.setContentType("text/html;charset=utf-8");
        try {
            msg = String.format("<html><head><meta charset=\"utf-8\"><script language='javascript'>alert(\"%s\");window.history.back();</script></head><body><textarea>%s</textarea></body></html>", msg, msg);
            response.getWriter().print(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

