/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.controller.rest.dataexport;

import com.tydic.pfsc.api.busi.BusiExportInSummaryBillService;
import com.tydic.pfsc.api.busi.QueryEntryTotalInfoService;
import com.tydic.pfsc.api.busi.bo.BusiEntryTotalInfoRspBO;
import com.tydic.pfsc.api.busi.bo.BusiExportInSummaryBillRspBO;
import com.tydic.pfsc.api.busi.bo.InSummaryBO;
import com.tydic.pfsc.api.busi.bo.QueryEntryTotalInfoReqBO;
import com.tydic.pfsc.api.busi.vo.PayInvoiceInfoVO;
import com.tydic.pfsc.common.ExcelFile;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class FscExportInSummaryBillService {
    private static final Logger log = LoggerFactory.getLogger(FscExportInSummaryBillService.class);
    private String[] sheetNames = new String[]{"\u5165\u5e93\u6c47\u603b\u5355"};
    private String[][] ivDetailOutMap = new String[][]{{"applyNo", "B", "S"}, {"purchaseOrderCode", "C", "S"}, {"purchaseName", "D", "S"}, {"supplierName", "E", "S"}, {"invoiceTypeDescr", "F", "S"}, {"invoiceNo", "G", "S"}, {"notTaxAmt", "H", "S"}, {"taxRate", "I", "S"}, {"taxAmt", "J", "S"}, {"amt", "K", "S"}};
    @Autowired
    private QueryEntryTotalInfoService queryEntryTotalInfoService;
    @Autowired
    private BusiExportInSummaryBillService busiExportInSummaryBillService;

    public void exportInSummaryBill(HttpServletRequest request, HttpServletResponse response) {
        QueryEntryTotalInfoReqBO reqBo = this.initReqBO(request, response);
        List respList = null;
        try {
            log.debug("--\u8bfb\u53d6\u5165\u5e93\u6c47\u603b\u5355 \u6570\u636e\u5bfc\u51faExcel,reqBo=" + reqBo);
            BusiEntryTotalInfoRspBO notifiInvoiceList = this.queryEntryTotalInfoService.queryListPage(reqBo);
            if (null == notifiInvoiceList) {
                this.failedMsg(response, "\u83b7\u53d6\u5165\u5e93\u6c47\u603b\u5355 \u6570\u636e\u5931\u8d25");
                return;
            }
            respList = notifiInvoiceList.getRows();
            log.debug("Excel\u5165\u5e93\u6c47\u603b\u5355 \u5bfc\u51fa,\u8bfb\u53d6\u5165\u5e93\u6c47\u603b\u5355 \u8fd4\u56de,respList=" + respList);
        }
        catch (Exception e) {
            log.error("\u5165\u5e93\u6c47\u603b\u5355 \u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            this.failedMsg(response, "\u83b7\u53d6\u5165\u5e93\u6c47\u603b\u5355\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return;
        }
        List inSummaryBOList = null;
        BusiExportInSummaryBillRspBO busiExportInSummaryBillRspBO = null;
        try {
            busiExportInSummaryBillRspBO = this.busiExportInSummaryBillService.export(respList);
            inSummaryBOList = busiExportInSummaryBillRspBO.getRows();
            log.debug("Excel\u5165\u5e93\u6c47\u603b\u5355 \u5bfc\u51fa,\u8bfb\u53d6\u5165\u5e93\u6c47\u603b\u5355 \u8fd4\u56de,inSummaryBOList=" + inSummaryBOList);
        }
        catch (Exception e) {
            log.error("\u5165\u5e93\u6c47\u603b\u5355 \u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            this.failedMsg(response, "\u83b7\u53d6\u5165\u5e93\u6c47\u603b\u5355 \u5bfc\u51fa\u6570\u636e\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return;
        }
        ExcelFile excel = new ExcelFile();
        int sheetIdx = 0;
        Object[] cellFormat = new String[1];
        excel.createSheet(this.sheetNames[sheetIdx]);
        Object[] headerTitle = new String[]{"\u5e8f\u53f7", "\u6c47\u603b\u5355\u5355\u53f7", "\u8ba2\u5355\u7f16\u53f7", "\u91c7\u8d2d\u5355\u4f4d", "\u4f9b\u5e94\u5546", "\u53d1\u7968\u7c7b\u578b", "\u53d1\u7968\u53f7\u7801", "\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d", "\u7a0e\u7387", "\u7a0e\u989d", "\u4ef7\u7a0e\u5408\u8ba1"};
        cellFormat = new String[headerTitle.length];
        excel.setArrayValueByNames(cellFormat, ",C,,\u9ed1\u4f53:10", new String[0]);
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.addRow(sheetIdx, headerTitle, 16);
        excel.setArrayValueByNames(cellFormat, "S,CV,", new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K"});
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.setColumnsWidth(sheetIdx, new Integer[]{10, 25, 25, 25, 25, 30, 30, 20, 10, 20, 20});
        if (inSummaryBOList != null) {
            Object[] fieldsData = new String[headerTitle.length];
            int start = 1;
            for (int i = 0; i < inSummaryBOList.size(); ++i) {
                for (PayInvoiceInfoVO payInvoiceInfoVO : ((InSummaryBO)inSummaryBOList.get(i)).getPayInvoiceInfoVOs()) {
                    for (int j = 0; j < this.ivDetailOutMap.length; ++j) {
                        String fieldName = this.ivDetailOutMap[j][0];
                        String cellName = this.ivDetailOutMap[j][1];
                        int idx = ExcelFile.cellNameToIndex((String)cellName);
                        fieldsData[0] = i + 1 + "";
                        fieldsData[idx] = idx <= 5 ? this.getProp(inSummaryBOList.get(i), fieldName) : this.getProp(payInvoiceInfoVO, fieldName);
                    }
                    excel.addRow(sheetIdx, fieldsData, 16);
                }
                if (((InSummaryBO)inSummaryBOList.get(i)).getPayInvoiceInfoVOs().size() > 1) {
                    for (int k = 0; k <= 5; ++k) {
                        excel.mergeCell(0, start, k, start + ((InSummaryBO)inSummaryBOList.get(i)).getPayInvoiceInfoVOs().size() - 1, k);
                    }
                }
                start += ((InSummaryBO)inSummaryBOList.get(i)).getPayInvoiceInfoVOs().size();
                log.debug("EXCEL\u5bfc\u51fa\u6570\u636e:" + Arrays.toString(fieldsData));
            }
            for (int j = 0; j < this.ivDetailOutMap.length; ++j) {
                String cellName = this.ivDetailOutMap[j][1];
                fieldsData[0] = "\u5408\u8ba1";
                if (cellName.equals("H")) {
                    fieldsData[7] = busiExportInSummaryBillRspBO.getNotTaxAmtSum();
                }
                if (cellName.equals("I")) {
                    fieldsData[8] = "\u2014\u2014\u2014\u2014";
                }
                if (cellName.equals("J")) {
                    fieldsData[9] = busiExportInSummaryBillRspBO.getTaxAmtSum();
                }
                if (!cellName.equals("K")) continue;
                fieldsData[10] = busiExportInSummaryBillRspBO.getAmtSum();
            }
            excel.addRow(sheetIdx, fieldsData, 16);
            excel.mergeCell(0, start, 0, start, 6);
        }
        try {
            response.setContentType("application/x-download;charset=utf-8");
            String head = request.getHeader("User-Agent");
            String filename = null;
            filename = head.toLowerCase().indexOf("msie") >= 0 ? URLEncoder.encode(this.sheetNames[0], "utf-8") : new String(this.sheetNames[0].getBytes("utf-8"), "ISO-8859-1");
            response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".xls");
            excel.saveAsOutStream((OutputStream)response.getOutputStream());
            log.info("\u6210\u529f\u5bfc\u51faExcel\u6570\u636e\u4f9b\u4e0b\u8f7d");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u5bfc\u51faExcel\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        excel.close();
    }

    private Object getProp(Object bean, String name) {
        String v = null;
        try {
            v = BeanUtils.getProperty((Object)bean, (String)name);
            return v;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8bfb\u53d6Bean\u5c5e\u6027\u5230Excel\u6570\u636e\u5217\u5931\u8d25,name=" + name, (Throwable)e);
            return null;
        }
    }

    private void failedMsg(HttpServletResponse response, String msg) {
        response.setContentType("text/html;charset=utf-8");
        try {
            msg = String.format("<html><head><meta charset=\"utf-8\"><script language='javascript'>alert(\"%s\");window.history.back();</script></head><body><textarea>%s</textarea></body></html>", msg, msg);
            response.getWriter().print(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private QueryEntryTotalInfoReqBO initReqBO(HttpServletRequest request, HttpServletResponse response) {
        String pageNo;
        QueryEntryTotalInfoReqBO reqBo = new QueryEntryTotalInfoReqBO();
        String pageSize = this.blankString2null(request.getParameter("pageSize"));
        if (null != pageSize && !"".equals(pageSize)) {
            reqBo.setPageSize(Integer.valueOf(Integer.parseInt(pageSize)));
        }
        if (null != (pageNo = this.blankString2null(request.getParameter("pageNo"))) && !"".equals(pageNo)) {
            reqBo.setPageNo(Integer.valueOf(Integer.parseInt(pageNo)));
        }
        reqBo.setSource(this.blankString2null(request.getParameter("source")));
        reqBo.setBeginEntryDate(this.dateDispose(request.getParameter("beginEntryDate"), response));
        reqBo.setFinalEntryDate(this.dateDispose(request.getParameter("finalEntryDate"), response));
        reqBo.setPurchaseOrderCodeLike(this.blankString2null(request.getParameter("purchaseOrderCodeLike")));
        reqBo.setPurchaseOrderNameLike(this.blankString2null(request.getParameter("purchaseOrderNameLike")));
        reqBo.setApplyNo(this.blankString2null(request.getParameter("applyNo")));
        reqBo.setPurchaseId(this.longDispose(request.getParameter("purchaseId"), response));
        reqBo.setDocumentationId(this.longDispose(request.getParameter("documentationId"), response));
        reqBo.setCompanyId(this.longDispose(request.getParameter("companyId"), response));
        return reqBo;
    }

    private String blankString2null(String param) {
        if (!StringUtils.hasText((String)param)) {
            return null;
        }
        return param;
    }

    private Date dateDispose(String dateVal, HttpServletResponse response) {
        try {
            if (!StringUtils.hasText((String)dateVal)) {
                return null;
            }
            return new SimpleDateFormat("yyyy-MM-dd").parse(dateVal);
        }
        catch (Exception e) {
            this.failedMsg(response, "\u5b57\u7b26\u4e32" + dateVal + "\u8f6c\u65e5\u671f\u51fa\u9519");
            return null;
        }
    }

    private Long longDispose(String longVal, HttpServletResponse response) {
        try {
            if (!StringUtils.hasText((String)longVal)) {
                return null;
            }
            return Long.parseLong(longVal);
        }
        catch (Exception e) {
            this.failedMsg(response, "\u5b57\u7b26\u4e32" + longVal + "\u8f6cLong\u6570\u636e\u7c7b\u578b\u51fa\u9519");
            return null;
        }
    }
}

