/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.controller.rest.dataexport;

import com.tydic.pfsc.common.ExcelFile;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FscExportInvoiceTemplateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscExportInvoiceTemplateService.class);
    private String[] sheetNames = new String[]{"\u586b\u5199\u8bf4\u660e", "\u53d1\u7968\u4fe1\u606f"};
    private static final String MSIE = "msie";

    public void downloadData(HttpServletRequest request, HttpServletResponse response) {
        ExcelFile excel = new ExcelFile();
        this.defineExcelFormat(excel);
        try {
            response.setContentType("application/x-download;charset=utf-8");
            String head = request.getHeader("User-Agent");
            String filename = head.toLowerCase().contains(MSIE) ? URLEncoder.encode("\u53d1\u7968\u4fe1\u606f", "utf-8") : new String("\u53d1\u7968\u4fe1\u606f".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".xls");
            excel.saveAsOutStream((OutputStream)response.getOutputStream());
            LOGGER.info("\u6210\u529f\u5bfc\u51faExcel\u6570\u636e\u4f9b\u4e0b\u8f7d");
        }
        catch (IOException e) {
            LOGGER.debug("\u5bfc\u51faExcel\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        excel.close();
    }

    private void defineExcelFormat(ExcelFile excel) {
        int sheetIdx0 = 0;
        int sheetIdx = 1;
        excel.createSheet(this.sheetNames[sheetIdx0]);
        excel.createSheet(this.sheetNames[sheetIdx]);
        Object[] headerTitle0 = new String[]{"\u586b\u5199\u8bf4\u660e\uff1a"};
        Object[] headerTitle01 = new String[]{"1\u3001\u53ef\u4ee5\u586b\u5199\u591a\u4e2a\u5f00\u7968\u901a\u77e5\u5355\u7684\u53d1\u7968\u4fe1\u606f"};
        Object[] headerTitle02 = new String[]{"2\u3001\u4e00\u4e2a\u5f00\u7968\u901a\u77e5\u5355\u53ef\u4ee5\u586b\u5199\u591a\u884c\u53d1\u7968\u4fe1\u606f\uff0c\u6bcf\u5f20\u53d1\u7968\u5360\u4e00\u884c"};
        Object[] headerTitle03 = new String[]{"3\u3001\u5f00\u7968\u901a\u77e5\u5355\u7684\u5f00\u7968\u72b6\u6001\u5fc5\u987b\u662f\uff1a\u5df2\u63d0\u4ea4\u3001\u5df2\u5f00\u7968"};
        Object[] headerTitle04 = new String[]{"4\u3001\u53d1\u7968\u7c7b\u578b\u53ea\u80fd\u586b\u5199\uff1a\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u3001\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968"};
        Object[] headerTitle = new String[]{"\u5f00\u7968\u901a\u77e5\u5355\u53f7", "\u53d1\u7968\u7c7b\u578b", "\u53d1\u7968\u4ee3\u7801", "\u53d1\u7968\u53f7\u7801", "\u5f00\u7968\u65e5\u671f", "\u4ef7\u7a0e\u5408\u8ba1", "\u91d1\u989d(\u4e0d\u542b\u7a0e)", "\u7a0e  \u989d"};
        Object[] cellFormat0 = new String[headerTitle0.length];
        Object[] cellFormat01 = new String[headerTitle01.length];
        Object[] cellFormat02 = new String[headerTitle02.length];
        Object[] cellFormat03 = new String[headerTitle03.length];
        Object[] cellFormat04 = new String[headerTitle04.length];
        Object[] cellFormat = new String[headerTitle.length];
        excel.setArrayValueByNames(cellFormat0, ",,,\u5b8b\u4f53:10", new String[0]);
        excel.setArrayValueByNames(cellFormat01, ",,,\u5b8b\u4f53:10", new String[0]);
        excel.setArrayValueByNames(cellFormat02, ",,,\u5b8b\u4f53:10", new String[0]);
        excel.setArrayValueByNames(cellFormat03, ",,,\u5b8b\u4f53:10", new String[0]);
        excel.setArrayValueByNames(cellFormat04, ",,,\u5b8b\u4f53:10", new String[0]);
        excel.setCellsFormat(sheetIdx0, (String[])cellFormat0);
        excel.setCellsFormat(sheetIdx0, (String[])cellFormat01);
        excel.setCellsFormat(sheetIdx0, (String[])cellFormat02);
        excel.setCellsFormat(sheetIdx0, (String[])cellFormat03);
        excel.setCellsFormat(sheetIdx0, (String[])cellFormat04);
        excel.setArrayValueByNames(cellFormat, ",,,\u9ed1\u4f53:12", new String[0]);
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.addRow(sheetIdx0, headerTitle0, 14);
        excel.addRow(sheetIdx0, headerTitle01, 14);
        excel.addRow(sheetIdx0, headerTitle02, 14);
        excel.addRow(sheetIdx0, headerTitle03, 14);
        excel.addRow(sheetIdx0, headerTitle04, 14);
        excel.addRow(sheetIdx, headerTitle, 14);
        excel.setArrayValueByNames(cellFormat, "S,,", new String[]{"A", "B", "C", "D", "E", "F", "G", "H"});
        excel.setArrayValueByNames(cellFormat0, "S,,", new String[]{"A"});
        excel.setArrayValueByNames(cellFormat01, "S,,", new String[]{"A"});
        excel.setArrayValueByNames(cellFormat02, "S,,", new String[]{"A"});
        excel.setArrayValueByNames(cellFormat03, "S,,", new String[]{"A"});
        excel.setArrayValueByNames(cellFormat04, "S,,", new String[]{"A"});
        excel.setCellsFormat(sheetIdx0, (String[])cellFormat0);
        excel.setCellsFormat(sheetIdx0, (String[])cellFormat01);
        excel.setCellsFormat(sheetIdx0, (String[])cellFormat02);
        excel.setCellsFormat(sheetIdx0, (String[])cellFormat03);
        excel.setCellsFormat(sheetIdx0, (String[])cellFormat04);
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.setColumnsWidth(sheetIdx0, new Integer[]{53});
        excel.setColumnsWidth(sheetIdx, new Integer[]{20, 15, 15, 15, 15, 15, 15, 15});
    }
}

