/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.controller.rest;

import com.tydic.pfsc.api.busi.BusiProcessInvoiceDataInOutService;
import com.tydic.pfsc.api.busi.bo.BusiProcessInvoiceInOutReqBO;
import com.tydic.pfsc.api.busi.bo.BusiProcessInvoiceInOutRspBO;
import com.tydic.pfsc.api.busi.vo.BillNotificationInfoVO;
import com.tydic.pfsc.api.busi.vo.BusiProcessInvoiceInOutVO;
import com.tydic.pfsc.api.busi.vo.InvoiceDetailVO;
import com.tydic.pfsc.api.busi.vo.InvoiceInfoVO;
import com.tydic.pfsc.common.ExcelFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"download"})
public class BusiInvoiceNotificationController {
    private static final Logger logger = LoggerFactory.getLogger(BusiInvoiceNotificationController.class);
    private String[] sheetNames = new String[]{"\u586b\u5199\u8bf4\u660e", "\u5f00\u7968\u901a\u77e5\u5355\u4fe1\u606f", "\u5f00\u7968\u660e\u7ec6", "\u90ae\u5bc4\u4fe1\u606f"};
    private String[][] notifiInMap = new String[][]{{"name", "C", "S"}, {"bankAcctNo", "H", "S"}, {"bankAcNo", "H", "S"}, {"address", "E", "S"}};
    private String[][] ivDetailInMap = new String[][]{{"invoiceCode", "B", "S"}, {"invoiceNo", "C", "S"}, {"invoiceDate", "D", "T"}, {"priceUntax", "N", "D"}, {"untaxAmt", "P", "D"}, {"taxRate", "R", "D"}};
    private String[][] notifiOutMap = new String[][]{{"notificationNo", "A", "S"}, {"invoiceTypeDescr", "B", ""}, {"invoceName", "C", "S"}, {"taxNo", "D", "S"}, {"addr", "E", "S"}, {"phone", "F", "S"}, {"bankName", "G", "S"}, {"bankAccNo", "H", "S"}, {"amt", "I", "D"}};
    private String[][] ivDetailOutMap = new String[][]{{"notificationNo", "A", "S"}, {"invoiceCode", "B", "S"}, {"invoiceNo", "C", "S"}, {"invoiceDate", "D", "T"}, {"orderId", "E", "L"}, {"compName", "F", "S"}, {"identify", "G", "L"}, {"skuId", "H", "L"}, {"itemName", "I", "S"}, {"specModelFigureNo", "J", "S"}, {"itemUnit", "K", "S"}, {"quantity", "L", "D"}, {"priceIntax", "M", "D"}, {"priceUntax", "N", "D"}, {"amount", "O", "D"}, {"untaxAmt", "P", "D"}, {"taxAmt", "Q", "D"}, {"taxRate", "R", "D"}};
    @Autowired
    private BusiProcessInvoiceDataInOutService busiProcessInvoiceDataInOutService;

    @RequestMapping(value={"/busiInvoiceNotificationController"}, method={RequestMethod.GET})
    public void processDataGet(HttpServletRequest request, HttpServletResponse response) {
        this.processData(request, response, null);
    }

    @RequestMapping(value={"/busiInvoiceNotificationController"}, method={RequestMethod.POST})
    public void processData(HttpServletRequest request, HttpServletResponse response, MultipartFile file) {
        String operateType = request.getParameter("operate");
        String notificationNo = request.getParameter("notificationNo");
        String supNo = request.getParameter("supNo");
        String companyId = request.getParameter("companyId");
        String filename = "";
        if (file != null) {
            filename = file.getOriginalFilename();
        }
        logger.debug("\u53d1\u7968\u5bfc\u5165\u5bfc\u51fa\u5904\u7406,operate=" + operateType + ",notificationNo=" + notificationNo + ",supNo=" + supNo + ",companyId=" + companyId + ",filename=[" + filename + "]");
        BusiProcessInvoiceInOutReqBO reqBo = new BusiProcessInvoiceInOutReqBO();
        BusiProcessInvoiceInOutVO vo = new BusiProcessInvoiceInOutVO();
        reqBo.setData(vo);
        if (notificationNo == null || notificationNo.length() == 0) {
            this.failedMsg(response, "\u7f3a\u5c11\u53c2\u6570,\u8bf7\u6307\u5b9a\u901a\u77e5\u53f7(notificationNo)");
            return;
        }
        if ("download".equals(operateType)) {
            if (supNo == null || supNo.length() == 0) {
                this.failedMsg(response, "\u7f3a\u5c11\u53c2\u6570,\u8bf7\u6307\u5b9a\u4f9b\u5e94\u5546(supNo)");
                return;
            }
            if (companyId == null || companyId.length() == 0) {
                this.failedMsg(response, "\u7f3a\u5c11\u53c2\u6570,\u8bf7\u6307\u5b9a\u4e13\u4e1a\u516c\u53f8ID(companyId)");
                return;
            }
            reqBo.setCompanyId(Long.valueOf(companyId));
            reqBo.getData().setSupplierNo(Long.valueOf(supNo));
            this.downloadExcel(notificationNo, reqBo, request, response);
            return;
        }
        if ("upload".equals(operateType)) {
            if (supNo == null || supNo.length() == 0) {
                this.failedMsg(response, "\u7f3a\u5c11\u53c2\u6570,\u8bf7\u6307\u5b9a\u4f9b\u5e94\u5546(supNo)");
                return;
            }
            if (companyId == null || companyId.length() == 0) {
                this.failedMsg(response, "\u7f3a\u5c11\u53c2\u6570,\u8bf7\u6307\u5b9a\u4e13\u4e1a\u516c\u53f8ID(companyId)");
                return;
            }
            if (file == null) {
                this.failedMsg(response, "\u65e0\u6cd5\u5f97\u5230\u6587\u4ef6\u6570\u636e,\u8bf7\u5c1d\u8bd5\u7528POST\u65b9\u5f0f\u63d0\u4ea4\u8bf7\u6c42");
                return;
            }
            int idx = filename.toLowerCase().lastIndexOf(".xls");
            if (idx == -1 || filename.length() - idx != 4) {
                this.failedMsg(response, "Excel\u6587\u4ef6\u540d" + filename + "\u4e0d\u5408\u6cd5,\u7684\u6269\u5c55\u540d\u5fc5\u987b\u4e3a.xls");
                return;
            }
            reqBo.setCompanyId(Long.valueOf(companyId));
            reqBo.getData().setSupplierNo(Long.valueOf(supNo));
            InputStream is = null;
            try {
                is = file.getInputStream();
            }
            catch (IOException e) {
                this.failedMsg(response, "\u65e0\u6cd5\u5f97\u5230\u6587\u4ef6\u6570\u636e,\u8bf7\u5c1d\u8bd5\u7528POST\u65b9\u5f0f\u63d0\u4ea4\u8bf7\u6c42");
                return;
            }
            this.uploadExcel(notificationNo, is, filename, reqBo, request, response);
            return;
        }
        this.failedMsg(response, "\u8bf7\u6307\u5b9a\u64cd\u4f5c\u7c7b\u578b(operate)");
    }

    private void downloadExcel(String notificationNo, BusiProcessInvoiceInOutReqBO reqBo, HttpServletRequest request, HttpServletResponse response) {
        reqBo.getData().setProcessType(Integer.valueOf(1));
        reqBo.getData().setNotificationNo(notificationNo);
        BusiProcessInvoiceInOutRspBO resp = null;
        try {
            logger.debug("--\u8bfb\u53d6\u53d1\u7968\u6570\u636e\u5bfc\u51faExcel,reqBo=" + reqBo);
            resp = this.busiProcessInvoiceDataInOutService.processInvoiceInOut(reqBo);
            if (resp == null || !"0000".equals(resp.getRespCode())) {
                this.failedMsg(response, resp == null ? "\u83b7\u53d6\u5f00\u7968\u901a\u77e5\u5355\u6570\u636e\u5931\u8d25," : resp.getRespDesc());
                return;
            }
            logger.debug("Excel\u53d1\u7968\u901a\u77e5\u5355\u5bfc\u51fa,\u8bfb\u53d6\u901a\u77e5\u5355\u4fe1\u606f\u8fd4\u56de,resp=" + resp);
        }
        catch (Exception e) {
            logger.error("Excel\u53d1\u7968\u901a\u77e5\u5355\u5bfc\u51fa\u5931\u8d25,\u8bfb\u53d6\u5f00\u7968\u901a\u77e5\u5355\u6570\u636e\u5931\u8d25", (Throwable)e);
            this.failedMsg(response, "\u83b7\u53d6\u5f00\u7968\u901a\u77e5\u5355\u6570\u636e\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return;
        }
        ExcelFile excel = new ExcelFile();
        int sheetIdx = 0;
        excel.createSheet(this.sheetNames[sheetIdx]);
        Object[] commentTitle1 = new String[]{"\u3010\u5f00\u7968\u660e\u7ec6\u586b\u5199\u8bf4\u660e\u3011"};
        Object[] commentTitle2 = new String[]{"\u5546\u54c1\u4fe1\u606f\uff1a", "\u6d45\u9ec4\u8272\u6807\u9898\u5217\u4e3a\u5546\u54c1\u4fe1\u606f\uff0c\u6309\u8be5\u533a\u57df\u6570\u636e\u8fdb\u884c\u5f00\u7968\uff0c\u6b64\u533a\u57df\u6570\u636e\u5207\u52ff\u6539\u52a8"};
        Object[] commentTitle3 = new String[]{"\u586b\u5199\u533a\u57df\uff1a", "\u6df1\u9ec4\u8272\u6807\u9898\u5217\u4e3a\u56de\u586b\u53d1\u7968\u6570\u636e\u533a\u57df\uff0c\u53d1\u7968\u5f00\u5177\u540e\u6839\u636e\u5b9e\u9645\u7968\u9762\u6570\u636e\u8fdb\u884c\u586b\u5199\uff1b\u5982\u679c\u67d0\u4e9b\u5546\u54c1\u8fd8\u6ca1\u6709\u5f00\u7968\uff0c\u8be5\u884c\u53ef\u4ee5\u6682\u65f6\u4e0d\u586b\u5199\uff0c\u652f\u6301\u591a\u6b21\u586b\u5199\u5bfc\u5165"};
        Object[] commentTitle4 = new String[]{"\u586b\u5199\u683c\u5f0f\uff1a", "\u4fdd\u6301\u539f\u5bfc\u51fa\u5355\u5143\u683c\u683c\u5f0f\uff0c\u586b\u5199\u65f6\u5207\u52ff\u66f4\u6539\u5355\u5143\u683c\u683c\u5f0f"};
        Object[] commentTitle5 = new String[]{"*\u53d1\u7968\u4ee3\u7801", "\u5b9e\u9645\u5f00\u51fa\u53d1\u7968\u4ee3\u7801"};
        Object[] commentTitle6 = new String[]{"*\u53d1\u7968\u53f7\u7801", "\u5b9e\u9645\u5f00\u51fa\u53d1\u7968\u53f7\u7801"};
        Object[] commentTitle7 = new String[]{"*\u5f00\u7968\u65e5\u671f", "\u5b9e\u9645\u5f00\u7968\u65e5\u671f\uff0c\u683c\u5f0f\u4f8b\u5982\uff1a1900-01-01"};
        Object[] commentTitle8 = new String[]{"*\u5355\u4ef7(\u4e0d\u542b\u7a0e)", "\u5b9e\u9645\u4e0d\u542b\u7a0e\u5355\u4ef7"};
        Object[] commentTitle9 = new String[]{"*\u91d1\u989d(\u4e0d\u542b\u7a0e)", "\u5b9e\u9645\u4e0d\u542b\u7a0e\u91d1\u989d"};
        Object[] commentTitle10 = new String[]{"*\u7a0e  \u989d", "\u5b9e\u9645\u7a0e\u989d"};
        Object[] commentTitle11 = new String[]{"*\u7a0e \u7387", "\u5b9e\u9645\u7a0e\u7387"};
        Object[] cellFormat = new String[1];
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.setColumnsWidth(sheetIdx, new Integer[]{14});
        excel.addRow(sheetIdx, commentTitle1, 14);
        excel.addRow(sheetIdx, commentTitle2, 14);
        excel.addRow(sheetIdx, commentTitle3, 14);
        excel.addRow(sheetIdx, commentTitle4, 14);
        excel.addRow(sheetIdx, commentTitle5, 14);
        excel.addRow(sheetIdx, commentTitle6, 14);
        excel.addRow(sheetIdx, commentTitle7, 14);
        excel.addRow(sheetIdx, commentTitle8, 14);
        excel.addRow(sheetIdx, commentTitle9, 14);
        excel.addRow(sheetIdx, commentTitle10, 14);
        excel.addRow(sheetIdx, commentTitle11, 14);
        excel.createSheet(this.sheetNames[++sheetIdx]);
        Object[] headerTitle = new String[]{"\u901a\u77e5\u5355\u53f7", "\u53d1\u7968\u7c7b\u578b", "\u8d2d\u65b9\u540d\u79f0", "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", "\u5730\u5740", "\u7535\u8bdd", "\u5f00\u6237\u884c", "\u94f6\u884c\u8d26\u53f7", "\u4ef7\u7a0e\u5408\u8ba1"};
        cellFormat = new String[headerTitle.length];
        excel.setArrayValueByNames(cellFormat, ",," + HSSFColor.HSSFColorPredefined.YELLOW.getIndex() + ",\u9ed1\u4f53:12", new String[0]);
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.addRow(sheetIdx, headerTitle, 14);
        excel.setArrayValueByNames(cellFormat, ",," + HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), new String[0]);
        excel.setArrayValueByNames(cellFormat, "D:14,R," + HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), new String[]{"I"});
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        BillNotificationInfoVO bill = resp.getData().getNotification();
        Object[] fieldsData = new String[headerTitle.length];
        for (int i = 0; i < this.notifiOutMap.length; ++i) {
            String fieldName = this.notifiOutMap[i][0];
            String cellName = this.notifiOutMap[i][1];
            int idx = ExcelFile.cellNameToIndex((String)cellName);
            fieldsData[idx] = this.getProp(bill, fieldName);
        }
        logger.debug("\u5bfc\u51fa\u901a\u77e5\u5355\u4fe1\u606f=" + Arrays.toString(fieldsData));
        excel.addRow(sheetIdx, fieldsData, 14);
        excel.createSheet(this.sheetNames[++sheetIdx]);
        headerTitle = new String[]{"\u901a\u77e5\u5355\u53f7", "\u53d1\u7968\u4ee3\u7801", "\u53d1\u7968\u53f7\u7801", "\u5f00\u7968\u65e5\u671f", "\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7", "\u91c7\u8d2d\u5355\u4f4d\u540d\u79f0", "\u5546\u54c1\u884c\u53f7-\u5546\u54c1ID", "\u5546\u54c1\u7f16\u7801", "\u7269\u8d44\u540d\u79f0", "\u89c4\u683c\\\u578b\u53f7\\\u56fe\u53f7", "\u8ba1\u91cf\u5355\u4f4d", "\u6570 \u91cf", "\u5355\u4ef7(\u542b\u7a0e)", "\u5355\u4ef7(\u4e0d\u542b\u7a0e)", "\u4ef7\u7a0e\u5408\u8ba1", "\u91d1\u989d(\u4e0d\u542b\u7a0e)", "\u7a0e  \u989d", "\u7a0e \u7387"};
        cellFormat = new String[headerTitle.length];
        excel.setArrayValueByNames(cellFormat, ",C," + HSSFColor.HSSFColorPredefined.GOLD.getIndex() + ",\u9ed1\u4f53:12", new String[0]);
        excel.setArrayValueByNames(cellFormat, ",C," + HSSFColor.HSSFColorPredefined.YELLOW.getIndex() + ",\u9ed1\u4f53:12", new String[]{"A", "E", "F", "G", "H", "I", "J"});
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.addRow(sheetIdx, headerTitle, 14);
        excel.setMemo(sheetIdx, "D", 0, "\u65e5\u671f\u683c\u5f0f yyyy-MM-dd (\u5982:2017-11-01)");
        excel.setMemo(sheetIdx, "Q", 0, "\u7a0e\u7387\u586b\u5c0f\u6570,\u5982 0.17");
        excel.setArrayValueByNames(cellFormat, "D,R,", new String[0]);
        excel.setArrayValueByNames(cellFormat, "S,,", new String[]{"B", "C", "D", "H", "I", "J", "L", "M"});
        excel.setArrayValueByNames(cellFormat, "S,,", new String[]{"A", "E", "F", "G", "K"});
        excel.setArrayValueByNames(cellFormat, "D,R,", new String[]{"L", "M", "N", "O", "P"});
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.setColumnsWidth(sheetIdx, new Integer[]{21, 12, 10, 11, null, 20, null, 10, 18, null, null, 7, 12, 15, 14, 14, 12, 6});
        List invoices = resp.getData().getInvoices();
        if (invoices != null && invoices.size() > 0) {
            InvoiceInfoVO invoice = (InvoiceInfoVO)invoices.get(0);
            fieldsData = new String[headerTitle.length];
            List details = invoice.getInvoiceDetails();
            for (InvoiceDetailVO iv : details) {
                fieldsData[0] = notificationNo;
                for (int i = 1; i < this.ivDetailOutMap.length; ++i) {
                    String fieldName = this.ivDetailOutMap[i][0];
                    String cellName = this.ivDetailOutMap[i][1];
                    int idx = ExcelFile.cellNameToIndex((String)cellName);
                    fieldsData[idx] = "invoiceDate".equals(fieldName) && iv.getInvoiceDate() != null ? DateFormatUtils.format((Date)iv.getInvoiceDate(), (String)"yyyy-MM-dd") : this.getProp(iv, fieldName);
                }
                logger.debug("EXCEL\u5bfc\u51fa\u53d1\u7968\u660e\u7ec6\u6570\u636e:" + Arrays.toString(fieldsData));
                excel.addRow(sheetIdx, fieldsData, 14);
            }
        }
        excel.createSheet(this.sheetNames[++sheetIdx]);
        Object[] comment1 = new String[]{"\u90ae\u5bc4\u5730\u5740", bill.getAddrDesc()};
        Object[] comment2 = new String[]{"\u6536\u4ef6\u4eba", bill.getName()};
        Object[] comment3 = null;
        comment3 = "4".equals(bill.getSource()) ? new String[]{"\u7535\u8bdd", bill.getTel()} : new String[]{"\u7535\u8bdd", bill.getMobile()};
        Object[] cellFormat1 = new String[1];
        excel.setArrayValueByNames(cellFormat1, ",C," + HSSFColor.HSSFColorPredefined.YELLOW.getIndex() + ",\u9ed1\u4f53:12", new String[]{"A"});
        excel.setCellsFormat(sheetIdx, (String[])cellFormat1);
        excel.setColumnsWidth(sheetIdx, new Integer[]{14});
        excel.addRow(sheetIdx, comment1, 14);
        excel.addRow(sheetIdx, comment2, 14);
        excel.addRow(sheetIdx, comment3, 14);
        try {
            response.setHeader("Content-Disposition", "attachment;filename=N" + notificationNo + ".xls");
            response.setContentType("application/x-download");
            excel.saveAsOutStream((OutputStream)response.getOutputStream());
            logger.debug("\u6210\u529f\u5bfc\u51faExcel\u6570\u636e\u4f9b\u4e0b\u8f7d,\u901a\u77e5\u5355\u53f7=" + notificationNo);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("\u5bfc\u51faExcel\u6570\u636e\u5931\u8d25,\u901a\u77e5\u5355\u53f7=" + notificationNo, (Throwable)e);
        }
        excel.close();
    }

    private void uploadExcel(String notificationNo, InputStream is, String fileName, BusiProcessInvoiceInOutReqBO reqBo, HttpServletRequest request, HttpServletResponse response) {
        ExcelFile excel = new ExcelFile(is);
        if (!excel.isReady()) {
            this.failedMsg(response, "\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6" + fileName + "," + excel.getErrMsg());
            return;
        }
        if (excel.getSheetCount() == 4) {
            if (!"\u90ae\u5bc4\u4fe1\u606f".equals(excel.getSheetName(3)) && excel.getSheetCount() != 3) {
                this.failedMsg(response, "\u4e0a\u4f20\u7684Excel\u5e94\u67093\u9875");
                return;
            }
        } else if (excel.getSheetCount() != 3) {
            this.failedMsg(response, "\u4e0a\u4f20\u7684Excel\u5e94\u67093\u9875");
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (this.sheetNames[i].equals(excel.getSheetName(i))) continue;
            this.failedMsg(response, "\u7b2c" + (i + 1) + "\u4e2a\u6570\u636e\u9875\u7684\u540d\u79f0[" + excel.getSheetName(i) + "]\u4e0e\u9884\u671f\u4e0d\u7b26\u5408,\u8bf7\u4e0d\u8981\u4fee\u6539\u6a21\u677f\u6587\u4ef6\u7684\u9875\u540d\u79f0");
        }
        BillNotificationInfoVO bill = new BillNotificationInfoVO();
        reqBo.getData().setNotification(bill);
        InvoiceInfoVO invoice = new InvoiceInfoVO();
        StringBuilder errorCollection = new StringBuilder();
        List dataRows = excel.readRows(1, 0, -1);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 1; i < dataRows.size(); ++i) {
            String[] fields = (String[])dataRows.get(i);
            map.clear();
            StringBuilder errorMsg = this.arrayToMap(fields, this.notifiInMap, map);
            if (!this.isNullOrEmpty(errorMsg)) {
                errorCollection.append(errorMsg.toString());
                break;
            }
            errorMsg = this.arrayToMap(fields, this.notifiOutMap, map);
            if (!this.isNullOrEmpty(errorMsg)) {
                errorCollection.append(errorMsg.toString());
                break;
            }
            this.mapToBean(map, invoice);
            this.mapToBean(map, bill);
        }
        if (!this.isNullOrEmpty(errorCollection)) {
            this.failedMsg(response, errorCollection.toString());
            return;
        }
        logger.debug("Excel\u8f7d\u5165\u7684\u901a\u77e5\u5355\u4fe1\u606f=" + bill);
        logger.debug("Excel\u8f7d\u5165\u7684\u9500\u65b9\u53d1\u7968\u8d44\u6599=" + invoice);
        if (!notificationNo.equals(bill.getNotificationNo())) {
            this.failedMsg(response, "\u5bfc\u5165\u7684\u901a\u77e5\u5355\u53f7\u4e0d\u7b26\u5408,\u8bf7\u5bfc\u5165" + notificationNo + "\u7684\u53d1\u7968\u6570\u636e");
            return;
        }
        ArrayList<InvoiceInfoVO> invoices = new ArrayList<InvoiceInfoVO>();
        reqBo.getData().setInvoices(invoices);
        HashMap<String, InvoiceInfoVO> existInvoiceMap = new HashMap<String, InvoiceInfoVO>();
        try {
            dataRows = excel.readRows(2, 0, -1);
        }
        catch (Exception e) {
            logger.error("\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6" + fileName + ",\u53d1\u751f\u9519\u8bef\u7684\u4f4d\u7f6e" + excel.getLastCellLocation(), (Throwable)e);
            excel.close();
            this.failedMsg(response, "\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6,\u53d1\u751f\u9519\u8bef\u7684\u4f4d\u7f6e" + excel.getLastCellLocation() + e.getMessage());
            return;
        }
        InvoiceInfoVO iv = null;
        StringBuilder nullErrorMsg = new StringBuilder();
        for (int i = 1; i < dataRows.size(); ++i) {
            String[] fields = (String[])dataRows.get(i);
            if (fields[0].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (fields[1].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (fields[2].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (fields[3].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (!this.isNullOrEmpty(nullErrorMsg)) {
                errorCollection.append(nullErrorMsg.toString());
                break;
            }
            map.clear();
            StringBuilder errorMsg = this.arrayToMap(fields, this.ivDetailInMap, map);
            if (!this.isNullOrEmpty(errorMsg)) {
                errorCollection.append(errorMsg.toString());
                break;
            }
            this.mapToBean(map, invoice);
            String ivNo = invoice.getInvoiceCode() + "-" + invoice.getInvoiceNo();
            if (!existInvoiceMap.containsKey(ivNo)) {
                iv = new InvoiceInfoVO();
                invoices.add(iv);
                BeanUtils.copyProperties((Object)invoice, (Object)iv);
                existInvoiceMap.put(ivNo, iv);
                iv.setInvoiceDetails(new ArrayList());
            }
            if (!this.isNullOrEmpty(errorMsg = this.arrayToMap(fields, this.ivDetailOutMap, map))) {
                errorCollection.append(errorMsg.toString());
                break;
            }
            InvoiceDetailVO ivDetail = new InvoiceDetailVO();
            iv.getInvoiceDetails().add(ivDetail);
            this.mapToBean(map, ivDetail);
        }
        if (!this.isNullOrEmpty(errorCollection)) {
            this.failedMsg(response, errorCollection.toString());
            return;
        }
        excel.close();
        reqBo.getData().setProcessType(Integer.valueOf(2));
        reqBo.getData().setNotificationNo(bill.getNotificationNo());
        logger.debug("\u53d1\u7968\u901a\u77e5\u5355\u6570\u636e\u5bfc\u5165reqBo:" + reqBo);
        try {
            BusiProcessInvoiceInOutRspBO resp = this.busiProcessInvoiceDataInOutService.processInvoiceInOut(reqBo);
            if (resp == null || !"0000".equals(resp.getRespCode())) {
                this.failedMsg(response, resp == null ? "\u65e0\u6cd5\u83b7\u53d6\u8fd4\u56de\u6570\u636e" : resp.getRespDesc());
                return;
            }
            logger.debug("\u53d1\u7968\u901a\u77e5\u5355\u5bfc\u5165\u901a\u77e5\u5355\u4fe1\u606f\u8fd4\u56de,resp=" + resp);
            logger.debug("Excel \u6587\u4ef6" + fileName + "\u7684\u6570\u636e\u5bfc\u5165\u7cfb\u7edf\u5b8c\u6210");
            this.failedMsg(response, "\u53d1\u7968\u6570\u636e\u5df2\u6210\u529f\u5bfc\u5165\u7cfb\u7edf");
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528Excel\u53d1\u7968\u901a\u77e5\u5355\u6570\u636e\u5bfc\u5165\u63a5\u53e3\u5931\u8d25,file=" + fileName, (Throwable)e);
            this.failedMsg(response, "\u53d1\u7968\u6570\u636e\u5bfc\u5165\u63a5\u53e3\u8c03\u7528\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5.");
        }
    }

    private StringBuilder arrayToMap(String[] datasource, String[][] fieldDefine, Map<String, Object> targetMap) {
        StringBuilder errorMsg = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (int j = 0; j < fieldDefine.length; ++j) {
            String type = fieldDefine[j][2];
            if (type.length() == 0) continue;
            int idx = ExcelFile.cellNameToIndex((String)fieldDefine[j][1]);
            String fName = fieldDefine[j][0];
            if (type.equals("D") && datasource[idx] != null) {
                if (datasource[idx].length() == 0) {
                    datasource[idx] = "0";
                }
                targetMap.put(fName, new BigDecimal(datasource[idx]));
                continue;
            }
            if (type.equals("T")) {
                Date dt = null;
                try {
                    dt = sdf.parse(datasource[idx]);
                }
                catch (Exception e) {
                    errorMsg.append("\u65e5\u671f" + datasource[idx] + "\u683c\u5f0f\u6709\u8bef\u3002");
                    break;
                }
                if (dt == null) continue;
                targetMap.put(fName, dt);
                continue;
            }
            targetMap.put(fName, datasource[idx]);
        }
        if (null != errorMsg && errorMsg.length() <= 0) {
            errorMsg = null;
        }
        return errorMsg;
    }

    private void mapToBean(Map<String, Object> map, Object bean) {
        try {
            org.apache.commons.beanutils.BeanUtils.populate((Object)bean, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Object getProp(Object bean, String name) {
        String v = null;
        try {
            v = org.apache.commons.beanutils.BeanUtils.getProperty((Object)bean, (String)name);
            return v;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8bfb\u53d6Bean\u5c5e\u6027\u5230Excel\u6570\u636e\u5217\u5931\u8d25,name=" + name, (Throwable)e);
            return null;
        }
    }

    private void failedMsg(HttpServletResponse response, String msg) {
        response.setContentType("text/html;charset=utf-8");
        try {
            msg = String.format("<html><head><meta charset=\"utf-8\"><script language='javascript'>alert(\"%s\");window.history.back();</script></head><body><textarea>%s</textarea></body></html>", msg, msg);
            response.getWriter().print(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isNullOrEmpty(Object str) {
        return str == null || "".equals(str.toString());
    }
}

