/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.controller.rest.dataexport;

import com.tydic.pfsc.common.ExcelFile;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FscExportCheckSignTemplateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscExportCheckSignTemplateService.class);
    private static final String MSIE = "msie";
    private String[] sheetNames = new String[]{"\u5f00\u7968\u901a\u77e5\u5355\u6279\u91cf\u6838\u5bf9\u7b7e\u6536\u5bfc\u5165\u6a21\u677f"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadData(HttpServletRequest request, HttpServletResponse response) {
        ExcelFile excel = new ExcelFile(false);
        excel.createSheet(this.sheetNames[0]);
        int sheetIdx = 0;
        Object[] mainHeadTitles = new String[]{"\u7535\u5b50\u8d85\u5e02"};
        Object[] cellFormat = new String[mainHeadTitles.length];
        excel.setArrayValueByNames(cellFormat, "S,CV," + IndexedColors.YELLOW.index + ",\u9ed1\u4f53:18", new String[]{"A"});
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.addRow(sheetIdx, mainHeadTitles, 24);
        excel.mergeCell(sheetIdx, 0, "A", 0, "B");
        Object[] subHeadTitles = new String[]{this.sheetNames[0]};
        cellFormat = new String[subHeadTitles.length];
        excel.setArrayValueByNames(cellFormat, "S,CV," + IndexedColors.YELLOW.index + ",\u9ed1\u4f53:18", new String[]{"A"});
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.addRow(sheetIdx, subHeadTitles, 24);
        excel.mergeCell(sheetIdx, 1, "A", 1, "B");
        Object[] columnTitles = new String[]{"\u5e8f\u53f7", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\u7801"};
        cellFormat = new String[columnTitles.length];
        excel.setArrayValueByNames(cellFormat, "S,CV,,\u9ed1\u4f53:12", new String[]{"A", "B"});
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.setColumnWidth(sheetIdx, "A", 10);
        excel.setColumnWidth(sheetIdx, "B", 40);
        excel.addRow(sheetIdx, columnTitles, 16);
        try {
            response.setContentType("application/x-download;charset=utf-8");
            String head = request.getHeader("User-Agent");
            String filename = head.toLowerCase().contains(MSIE) ? URLEncoder.encode(this.sheetNames[sheetIdx], "utf-8") : new String(this.sheetNames[sheetIdx].getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".xls");
            excel.saveAsOutStream((OutputStream)response.getOutputStream());
            LOGGER.debug("\u6210\u529f\u5bfc\u51faExcel\u6570\u636e\u4f9b\u4e0b\u8f7d");
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51faExcel\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        finally {
            excel.close();
        }
    }
}

