/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.controller.rest.atour;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import com.tydic.pfsc.api.busi.bo.PayPurchaseOrderInfoBO;
import com.tydic.pfsc.api.busi.bo.QueryPayPurchaseOrderInfoReqBO;
import com.tydic.pfsc.api.busi.bo.QueryPayPurchaseOrderInfoRspBO;
import com.tydic.pfsc.api.busi.vo.PayItemInfoExtVO;
import com.tydic.pfsc.api.deal.QueryPayOrderInfoDetailService;
import com.tydic.pfsc.api.deal.QueryPayPurchaseOrderInfoListService;
import com.tydic.pfsc.api.deal.bo.PayOrderInfoDetailReqBO;
import com.tydic.pfsc.api.deal.bo.PayOrderInfoDetailRspBO;
import com.tydic.pfsc.common.PDFShowPageFooterEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/atour/estore/fsc"})
public class BusiExportDealServiceFeeController {
    private static final Logger log = LoggerFactory.getLogger(BusiExportDealServiceFeeController.class);
    @Autowired
    private QueryPayOrderInfoDetailService fscQueryPayOrderInfoDetailService;
    @Autowired
    private QueryPayPurchaseOrderInfoListService fscQueryPayPurchaseOrderInfoListService;

    @RequestMapping(value={"/deal/exportDealServiceFeeController"}, method={RequestMethod.GET})
    public void export(HttpServletResponse response, PayOrderInfoDetailReqBO reqBO) throws Exception {
        if (reqBO.getPayOrderId() == null) {
            this.failedMsg(response, "\u5e73\u53f0\u670d\u52a1\u8d39\u5355\u636eID[PayOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        PayOrderInfoDetailRspBO rspBO = null;
        try {
            rspBO = this.fscQueryPayOrderInfoDetailService.queryPayOrderInfoDetail(reqBO);
            if (rspBO == null) {
                this.failedMsg(response, "\u5e73\u53f0\u670d\u52a1\u8d39\u5bfc\u51fa\u5931\u8d25");
                return;
            }
        }
        catch (Exception e) {
            this.failedMsg(response, "\u67e5\u8be2\u65e0\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        QueryPayPurchaseOrderInfoReqBO fscQueryPayPurchaseOrderInfoReqBO = new QueryPayPurchaseOrderInfoReqBO();
        fscQueryPayPurchaseOrderInfoReqBO.setPayOrderId(reqBO.getPayOrderId());
        QueryPayPurchaseOrderInfoRspBO rspList = this.fscQueryPayPurchaseOrderInfoListService.queryPayPurchaseOrderInfoList(fscQueryPayPurchaseOrderInfoReqBO);
        List rows = rspList.getRows();
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            this.failedMsg(response, "\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519");
            return;
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = null;
        contentFont = new Font(baseFont, 10.0f, 0);
        int COLUMNS = 2;
        int COLUMNS2 = 8;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        response.setHeader("Content-Disposition", "attachment;filename=" + rspBO.getPayOrderCode() + ".pdf");
        response.setContentType("application/x-download");
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)response.getOutputStream());
            PDFShowPageFooterEvent event = new PDFShowPageFooterEvent(PageSize.A4.rotate(), titleFont, titleFont);
            writer.setPageEvent((PdfPageEvent)event);
        }
        catch (Exception e) {
            this.failedMsg(response, "\u628apdf\u5199\u5230\u8f93\u51fa\u6d41\u51fa\u9519\u3002");
            return;
        }
        document.open();
        PdfPTable titleTablex = new PdfPTable(1);
        PdfPCell titleCellx = new PdfPCell();
        titleCellx.setPhrase(new Phrase("\u5e73\u53f0\u670d\u52a1\u8d39\u8be6\u60c5", titleFont));
        titleCellx.setRowspan(1);
        titleCellx.setColspan(1);
        titleCellx.setBorder(0);
        titleCellx.setFixedHeight(20.0f);
        titleCellx.setHorizontalAlignment(1);
        titleCellx.setVerticalAlignment(6);
        titleTablex.addCell(titleCellx);
        titleCellx.setPhrase(null);
        titleTablex.addCell(titleCellx);
        try {
            document.add((Element)titleTablex);
        }
        catch (DocumentException e) {
            this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
            return;
        }
        PdfPTable table1 = new PdfPTable(2);
        PdfPCell cell1 = new PdfPCell();
        cell1.setFixedHeight(20.0f);
        cell1.setBorder(0);
        cell1.setColspan(1);
        cell1.setPhrase(new Phrase("\u4f9b\u5e94\u5546\uff1a", contentFont));
        cell1.setHorizontalAlignment(2);
        table1.addCell(cell1);
        cell1.setBorder(0);
        cell1.setColspan(1);
        cell1.setFixedHeight(20.0f);
        cell1.setPhrase(new Phrase(rspBO.getSupplierName(), contentFont));
        cell1.setHorizontalAlignment(0);
        table1.addCell(cell1);
        try {
            document.add((Element)table1);
        }
        catch (DocumentException e) {
            this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
            return;
        }
        PdfPTable table2 = new PdfPTable(2);
        PdfPCell cell2 = new PdfPCell();
        cell2.setBorder(0);
        cell2.setColspan(1);
        cell2.setFixedHeight(20.0f);
        cell2.setPhrase(new Phrase("\u5e73\u53f0\u670d\u52a1\u8d39\u5355\u636e\u7f16\u53f7\uff1a", contentFont));
        cell2.setHorizontalAlignment(2);
        table2.addCell(cell2);
        cell2.setBorder(0);
        cell2.setColspan(1);
        cell2.setFixedHeight(20.0f);
        cell2.setPhrase(new Phrase(rspBO.getPayOrderCode(), contentFont));
        cell2.setHorizontalAlignment(0);
        table2.addCell(cell2);
        try {
            document.add((Element)table2);
        }
        catch (DocumentException e) {
            this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
            return;
        }
        PdfPTable table3 = new PdfPTable(2);
        PdfPCell cell3 = new PdfPCell();
        cell3.setBorder(0);
        cell3.setColspan(1);
        cell3.setFixedHeight(20.0f);
        cell3.setPhrase(new Phrase("\u5e73\u53f0\u670d\u52a1\u8d39\u5355\u636e\u751f\u6210\u65f6\u95f4\uff1a", contentFont));
        cell3.setHorizontalAlignment(2);
        table3.addCell(cell3);
        String createTime = "-";
        try {
            if (null != rspBO.getCreateTime()) {
                createTime = sdf.format(rspBO.getCreateTime());
            }
        }
        catch (Exception e) {
            this.failedMsg(response, "\u65f6\u95f4\u8f6c\u6362\u51fa\u9519\u3002");
            return;
        }
        cell3.setBorder(0);
        cell3.setColspan(1);
        cell3.setFixedHeight(20.0f);
        cell3.setPhrase(new Phrase(createTime, contentFont));
        cell3.setHorizontalAlignment(0);
        table3.addCell(cell3);
        try {
            document.add((Element)table3);
        }
        catch (DocumentException e) {
            this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
            return;
        }
        PdfPTable table4 = new PdfPTable(2);
        PdfPCell cell4 = new PdfPCell();
        cell4.setBorder(0);
        cell4.setColspan(1);
        cell4.setFixedHeight(20.0f);
        cell4.setPhrase(new Phrase("\u5e73\u53f0\u670d\u52a1\u8d39\u5355\u636e\u72b6\u6001\uff1a", contentFont));
        cell4.setHorizontalAlignment(2);
        table4.addCell(cell4);
        cell4.setBorder(0);
        cell4.setColspan(1);
        cell4.setFixedHeight(20.0f);
        cell4.setPhrase(new Phrase(rspBO.getPayOrderStatusStr(), contentFont));
        cell4.setHorizontalAlignment(0);
        table4.addCell(cell4);
        try {
            document.add((Element)table4);
        }
        catch (DocumentException e) {
            this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
            return;
        }
        PdfPTable table5 = new PdfPTable(2);
        PdfPCell cell5 = new PdfPCell();
        cell5.setBorder(0);
        cell5.setColspan(1);
        cell5.setFixedHeight(20.0f);
        cell5.setPhrase(new Phrase("\u8ba2\u5355\u6570\u91cf\uff1a", contentFont));
        cell5.setHorizontalAlignment(2);
        table5.addCell(cell5);
        cell5.setBorder(0);
        cell5.setColspan(1);
        cell5.setFixedHeight(20.0f);
        cell5.setPhrase(new Phrase(rspBO.getOrderCount() == null ? "-" : rspBO.getOrderCount().toString(), contentFont));
        cell5.setHorizontalAlignment(0);
        table5.addCell(cell5);
        try {
            document.add((Element)table5);
        }
        catch (DocumentException e) {
            this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
            return;
        }
        PdfPTable table6 = new PdfPTable(2);
        PdfPCell cell6 = new PdfPCell();
        cell6.setBorder(0);
        cell6.setColspan(1);
        cell6.setFixedHeight(20.0f);
        cell6.setPhrase(new Phrase("\u5355\u636e\u91d1\u989d\uff1a", contentFont));
        cell6.setHorizontalAlignment(2);
        table6.addCell(cell6);
        cell6.setBorder(0);
        cell6.setColspan(1);
        cell6.setFixedHeight(20.0f);
        cell6.setPhrase(new Phrase(rspBO.getDocumentAmount() == null ? "-" : rspBO.getDocumentAmount().setScale(2, 4).toString(), contentFont));
        cell6.setHorizontalAlignment(0);
        table6.addCell(cell6);
        try {
            document.add((Element)table6);
        }
        catch (DocumentException e) {
            this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
            return;
        }
        PdfPTable table7 = new PdfPTable(2);
        PdfPCell cell7 = new PdfPCell();
        cell7.setBorder(0);
        cell7.setColspan(1);
        cell7.setFixedHeight(20.0f);
        cell7.setPhrase(new Phrase("\u51cf\u514d\u91d1\u989d\uff1a", contentFont));
        cell7.setHorizontalAlignment(2);
        table7.addCell(cell7);
        cell7.setBorder(0);
        cell7.setColspan(1);
        cell7.setFixedHeight(20.0f);
        cell7.setPhrase(new Phrase(rspBO.getActualAmount() == null ? "-" : rspBO.getActualAmount().setScale(2, 4).toString(), contentFont));
        cell7.setHorizontalAlignment(0);
        table7.addCell(cell7);
        try {
            document.add((Element)table7);
        }
        catch (DocumentException e) {
            this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
            return;
        }
        PdfPTable table8 = new PdfPTable(2);
        PdfPCell cell8 = new PdfPCell();
        cell8.setBorder(0);
        cell8.setColspan(1);
        cell8.setFixedHeight(20.0f);
        cell8.setPhrase(new Phrase("\u5b9e\u9645\u91d1\u989d\uff1a", contentFont));
        cell8.setHorizontalAlignment(2);
        table8.addCell(cell8);
        cell8.setBorder(0);
        cell8.setColspan(1);
        cell8.setFixedHeight(20.0f);
        cell8.setPhrase(new Phrase(rspBO.getDeductionAmount() == null ? "-" : rspBO.getDeductionAmount().setScale(2, 4).toString(), contentFont));
        cell8.setHorizontalAlignment(0);
        table8.addCell(cell8);
        try {
            document.add((Element)table8);
        }
        catch (DocumentException e) {
            this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
            return;
        }
        PdfPTable table9 = new PdfPTable(2);
        PdfPCell cell9 = new PdfPCell();
        cell9.setBorder(0);
        cell9.setColspan(1);
        cell9.setFixedHeight(20.0f);
        cell9.setPhrase(new Phrase("\u4f18\u60e0\u64cd\u4f5c\u4eba\uff1a", contentFont));
        cell9.setHorizontalAlignment(2);
        table9.addCell(cell9);
        cell9.setBorder(0);
        cell9.setColspan(1);
        cell9.setFixedHeight(20.0f);
        cell9.setPhrase(new Phrase(rspBO.getDeductionUserName(), contentFont));
        cell9.setHorizontalAlignment(0);
        table9.addCell(cell9);
        try {
            document.add((Element)table9);
        }
        catch (DocumentException e) {
            this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
            return;
        }
        PdfPTable table10 = new PdfPTable(2);
        PdfPCell cell10 = new PdfPCell();
        cell10.setBorder(0);
        cell10.setColspan(1);
        cell10.setFixedHeight(20.0f);
        cell10.setPhrase(new Phrase("\u4f18\u60e0\u64cd\u4f5c\u65f6\u95f4\uff1a", contentFont));
        cell10.setHorizontalAlignment(2);
        table10.addCell(cell10);
        String deductionTime = "-";
        try {
            if (null != rspBO.getCreateTime()) {
                deductionTime = sdf.format(rspBO.getDeductionTime());
            }
        }
        catch (Exception e) {
            this.failedMsg(response, "\u65f6\u95f4\u8f6c\u6362\u51fa\u9519\u3002");
            return;
        }
        cell10.setBorder(0);
        cell10.setColspan(1);
        cell10.setFixedHeight(20.0f);
        cell10.setPhrase(new Phrase(deductionTime, contentFont));
        cell10.setHorizontalAlignment(0);
        table10.addCell(cell10);
        try {
            document.add((Element)table10);
        }
        catch (DocumentException e) {
            this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
            return;
        }
        PdfPTable headTable = new PdfPTable(8);
        PdfPCell headCell = new PdfPCell(new Phrase("\u5e8f\u53f7", contentFont));
        headCell.setColspan(1);
        headCell.setHorizontalAlignment(1);
        headCell.setVerticalAlignment(5);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u8ba2\u5355\u7f16\u53f7", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u8ba2\u5355\u65e5\u671f", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u91c7\u8d2d\u5355\u4f4d ", contentFont));
        headCell.setColspan(2);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u8ba2\u5355\u91d1\u989d ", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u5e73\u53f0\u670d\u52a1\u8d39\u6bd4\u7387", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u8ba2\u5355\u6240\u9700\u7f34\u7eb3\u5e73\u53f0\u670d\u52a1\u8d39\u91d1\u989d", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        try {
            document.add((Element)headTable);
        }
        catch (DocumentException e) {
            this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
            return;
        }
        int count = 1;
        for (PayPurchaseOrderInfoBO row : rows) {
            PdfPTable detailTable = new PdfPTable(8);
            PdfPCell detailCell = new PdfPCell(new Phrase("" + count++, contentFont));
            detailCell.setFixedHeight(20.0f);
            detailCell.setColspan(1);
            detailCell.setHorizontalAlignment(1);
            detailCell.setVerticalAlignment(5);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(row.getPurchaseOrderCode(), contentFont));
            detailCell.setColspan(1);
            detailCell.setHorizontalAlignment(1);
            detailTable.addCell(detailCell);
            String orderDate = "-";
            try {
                if (null != row.getOrderDate()) {
                    orderDate = sdf.format(row.getOrderDate());
                }
            }
            catch (Exception e) {
                this.failedMsg(response, "\u65f6\u95f4\u8f6c\u6362\u51fa\u9519\u3002");
                return;
            }
            detailCell.setPhrase(new Phrase(orderDate, contentFont));
            detailCell.setColspan(1);
            detailCell.setHorizontalAlignment(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(row.getPurchaseName(), contentFont));
            detailCell.setColspan(2);
            detailCell.setHorizontalAlignment(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(row.getOrderAmt().toString(), contentFont));
            detailCell.setColspan(1);
            detailCell.setHorizontalAlignment(1);
            detailTable.addCell(detailCell);
            String orderDealServiceFeeRate = "";
            orderDealServiceFeeRate = null == row.getItemInfos().get(0) ? "-" : ((PayItemInfoExtVO)row.getItemInfos().get(0)).getCommDealServiceFeeRate().setScale(2, 4).toString() + "%";
            detailCell.setPhrase(new Phrase(orderDealServiceFeeRate, contentFont));
            detailCell.setColspan(1);
            detailCell.setHorizontalAlignment(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase("" + row.getOrderDealServiceFee(), contentFont));
            detailCell.setColspan(1);
            detailCell.setHorizontalAlignment(1);
            detailTable.addCell(detailCell);
            try {
                document.add((Element)detailTable);
            }
            catch (DocumentException e) {
                this.failedMsg(response, "pdf\u8ffd\u52a0table\u51fa\u9519\u3002");
                return;
            }
        }
        document.close();
    }

    private void failedMsg(HttpServletResponse response, String msg) {
        response.setContentType("text/html;charset=utf-8");
        try {
            msg = String.format("<html><head><meta charset=\"utf-8\"><script language='javascript'>alert(\"%s\");window.history.back();</script></head><body><textarea>%s</textarea></body></html>", msg, msg);
            response.getWriter().print(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

