/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.controller.rest;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pfsc.api.busi.BusiApplyPayService;
import com.tydic.pfsc.api.busi.BusiPayResultModifyService;
import com.tydic.pfsc.api.busi.QueryApplyPayInfoByIdService;
import com.tydic.pfsc.api.busi.QueryApplyPayInfoService;
import com.tydic.pfsc.api.busi.QueryPayableDetailByIdService;
import com.tydic.pfsc.api.busi.QueryPayableDetailService;
import com.tydic.pfsc.api.busi.bo.BusiApplyPayServiceReqBO;
import com.tydic.pfsc.api.busi.bo.BusiPayResultModifyReqBO;
import com.tydic.pfsc.api.busi.bo.QueryApplyPayInfoByIdReqBO;
import com.tydic.pfsc.api.busi.bo.QueryApplyPayInfoReqBO;
import com.tydic.pfsc.api.busi.bo.QueryPayableDetailByIdReqBO;
import com.tydic.pfsc.api.busi.bo.QueryPayableDetailReqBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fsc/payManager"})
public class FscPayManagerController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscPayManagerController.class);
    @Autowired
    private QueryApplyPayInfoService queryApplyPayInfoService;
    @Autowired
    private QueryApplyPayInfoByIdService queryApplyPayInfoByIdService;
    @Autowired
    private QueryPayableDetailService queryPayableDetailService;
    @Autowired
    private QueryPayableDetailByIdService queryPayableDetailByIdService;
    @Autowired
    private BusiApplyPayService busiApplyPayService;
    @Autowired
    private BusiPayResultModifyService busiPayResultModifyService;

    @PostMapping(value={"/queryPayRegisterList"})
    public Object queryPayRegisterList(@RequestBody QueryApplyPayInfoReqBO reqBo) {
        LOGGER.debug("\u4ed8\u6b3e\u767b\u8bb0\u5217\u8868\u67e5\u8be2\u5165\u53c2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBo));
        return this.queryApplyPayInfoService.queryListPage(reqBo);
    }

    @PostMapping(value={"/queryPayRegisterDetail"})
    public Object queryPayRegisterDetail(@RequestBody QueryApplyPayInfoByIdReqBO reqBo) {
        LOGGER.debug("\u4ed8\u6b3e\u7ed3\u679c\u5f55\u5165\u8be6\u60c5\u67e5\u8be2\u5165\u53c2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBo));
        return this.queryApplyPayInfoByIdService.queryById(reqBo);
    }

    @PostMapping(value={"/needPayListResult"})
    public Object needPayListResult(@RequestBody QueryPayableDetailReqBO reqBo) {
        LOGGER.debug("\u5e94\u4ed8\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u5165\u53c2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBo));
        return this.queryPayableDetailService.queryListPage(reqBo);
    }

    @PostMapping(value={"/queryNeedPayDetail"})
    public Object queryNeedPayDetail(@RequestBody QueryPayableDetailByIdReqBO reqBo) {
        LOGGER.debug("\u5e94\u4ed8\u8be6\u60c5\u67e5\u8be2\u5165\u53c2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBo));
        return this.queryPayableDetailByIdService.queryById(reqBo);
    }

    @PostMapping(value={"/submitPayRequest"})
    public Object submitPayRequest(@RequestBody BusiApplyPayServiceReqBO reqBo) {
        LOGGER.debug("\u4ed8\u6b3e\u7533\u8bf7\u63d0\u4ea4\u5165\u53c2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBo));
        return this.busiApplyPayService.applyPay(reqBo);
    }

    @PostMapping(value={"/submitInputResult"})
    public Object submitInputResult(@RequestBody BusiPayResultModifyReqBO reqBo) {
        LOGGER.debug("\u4ed8\u6b3e\u767b\u8bb0-\u5f55\u5165\u7ed3\u679c\u63d0\u4ea4\u5165\u53c2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBo));
        return this.busiPayResultModifyService.modifyResult(reqBo);
    }
}

