/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.controller.rest.dataexport;

import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FscExportReconcilitionInfoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscExportReconcilitionInfoService.class);

    public void downloadTemplate(HttpServletResponse response) {
        ArrayList<String> titles = new ArrayList<String>();
        titles.add("\u4f9b\u5e94\u5546");
        titles.add("\u5916\u90e8\u8ba2\u5355\u53f7");
        titles.add("\u7535\u5546\u53ef\u7ed3\u7b97\u91d1\u989d");
        try (HSSFWorkbook workBook = new HSSFWorkbook();){
            ServletOutputStream out = response.getOutputStream();
            String fileName = new String(("\u5bf9\u8d26\u6a21\u677f\u8868\u5bfc\u51fa" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())).getBytes(), "ISO-8859-1");
            response.setHeader("Content-disposition", "attachment; filename=" + fileName + ".xls");
            HSSFSheet sheet = workBook.createSheet("\u5bfc\u5165\u5bf9\u8d26\u8ba2\u5355\u6a21\u677f");
            HSSFRow row = sheet.createRow(0);
            sheet.setDefaultColumnWidth(20);
            HSSFCellStyle cellStyle = workBook.createCellStyle();
            cellStyle.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.index);
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setBorderRight(BorderStyle.THIN);
            HSSFCellStyle cellStyle2 = workBook.createCellStyle();
            HSSFDataFormat form = workBook.createDataFormat();
            cellStyle2.setDataFormat(form.getFormat("@"));
            HSSFFont font = workBook.createFont();
            font.setFontName("\u5b8b\u4f53");
            font.setFontHeightInPoints((short)11);
            font.setBold(true);
            cellStyle.setFont(font);
            for (int i = 0; i < titles.size(); ++i) {
                HSSFCell hssfCell = row.createCell(i);
                hssfCell.setCellValue((String)titles.get(i));
                hssfCell.setCellStyle(cellStyle);
            }
            workBook.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u5bf9\u8d26\u8ba2\u5355\u6a21\u677f\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }
}

