/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.controller.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FscFileUtils {
    private static Logger logger = LoggerFactory.getLogger(FscFileUtils.class);
    private static final String MSIE = "msie";

    public static String processFilename(HttpServletRequest request, String filename) {
        String newFilename = "1";
        String head = request.getHeader("User-Agent");
        if (head.toLowerCase().contains(MSIE)) {
            try {
                newFilename = URLEncoder.encode(filename, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("url\u7f16\u7801\u9519\u8bef\uff0c\u6587\u4ef6\u540d\uff1a" + filename, (Throwable)e);
            }
        } else {
            newFilename = new String(filename.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        }
        return newFilename;
    }

    public static InputStream outputStreamToInputStream(OutputStream out) {
        ByteArrayInputStream swapStream = null;
        try {
            if (null != out) {
                ByteArrayOutputStream baos = (ByteArrayOutputStream)out;
                swapStream = new ByteArrayInputStream(baos.toByteArray());
            }
        }
        catch (Exception e) {
            logger.error("\u6d41\u8f6c\u6362\u9519\u8bef:" + e.getMessage());
        }
        return swapStream;
    }
}

