/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.external.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfsc.external.api.BusiEMSExpressService;
import com.tydic.pfsc.external.api.bo.BusiEmsTraceBO;
import com.tydic.pfsc.external.api.bo.BusiEmsTraceDetailBO;
import com.tydic.pfsc.external.exception.PfscExternalBusinessException;
import com.tydic.pfsc.external.utils.http.HSHttpHelper;
import com.tydic.pfsc.external.utils.http.HSNHttpHeader;
import com.tydic.pfsc.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="busiEMSExpressService")
public class BusiEMSExpressServiceImpl
implements BusiEMSExpressService {
    private static final Logger logger = LoggerFactory.getLogger(BusiEMSExpressServiceImpl.class);
    @Autowired
    private Environment prop;

    @Override
    public BusiEmsTraceBO receiveTrace(String expressNo) {
        JSONObject rspJsonObject;
        HttpRetBean httpRetBean;
        StringBuffer sb = new StringBuffer();
        String reqStr = sb.append("{").append("\"com\":").append("\"ems\",").append("\"num\":").append("\"" + expressNo + "\",").append("\"from\":").append("\"\",").append("\"phone\":").append("\"\",").append("\"to\":").append("\"\",").append("\"resultv2\":").append("\"0\",").append("\"show\":").append("\"0\",").append("\"order\":").append("\"desc\"").append("}").toString();
        logger.info("\u67e5\u770b\u7269\u6d41\u8bf7\u6c42\u62a5\u6587\uff1a" + reqStr);
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_QUERY_DOPA_URL")), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
        }
        catch (Exception e) {
            logger.error("\u67e5\u770b\u7269\u6d41\u5931\u8d25", (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u67e5\u770b\u7269\u6d41\u5931\u8d25");
        }
        if (httpRetBean.getStatus() != 200) {
            logger.error("\u67e5\u770b\u7269\u6d41\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_EMS_ORDER_NUM_PARENT_URL") + "]");
            throw new RuntimeException("\u67e5\u770b\u7269\u6d41\u5931\u8d25");
        }
        logger.info("\u67e5\u770b\u7269\u6d41\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            logger.info("\u67e5\u770b\u7269\u6d41\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u67e5\u770b\u7269\u6d41\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        logger.debug("--\u63a5\u53e3\u8fd4\u56de\u7684\u62a5\u6587:" + returnString);
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            logger.error("\u67e5\u770b\u7269\u6d41\u5931\u8d25" + returnString, (Throwable)e);
            throw new PfscExternalBusinessException("18000", "\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        BusiEmsTraceBO busiEmsTraceBO = new BusiEmsTraceBO();
        JSONArray datas = (JSONArray)rspJsonObject.get((Object)"data");
        busiEmsTraceBO.setStatus(rspJsonObject.getInteger("state"));
        busiEmsTraceBO.setIscheck(rspJsonObject.getInteger("ischeck"));
        busiEmsTraceBO.setNum(expressNo);
        ArrayList<BusiEmsTraceDetailBO> busiEmsTraceDetailBOs = new ArrayList<BusiEmsTraceDetailBO>();
        if (datas != null) {
            for (Object obj : datas) {
                JSONObject jsonObject = (JSONObject)obj;
                BusiEmsTraceDetailBO busiEmsTraceDetailBO = new BusiEmsTraceDetailBO();
                busiEmsTraceDetailBO.setTime(jsonObject.getString("ftime"));
                busiEmsTraceDetailBO.setContext(jsonObject.getString("context"));
                busiEmsTraceDetailBOs.add(busiEmsTraceDetailBO);
            }
        }
        busiEmsTraceBO.setBusiEmsTraceDetailBOs(busiEmsTraceDetailBOs);
        return busiEmsTraceBO;
    }
}

