/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.external.nc.api.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfsc.external.nc.api.NcPaymentNoteBillUpService;
import com.tydic.pfsc.external.nc.api.bo.NcPaymentNoteBillUpReqBO;
import com.tydic.pfsc.external.nc.api.bo.NcPaymentNoteBillUpRspBO;
import com.tydic.pfsc.external.utils.http.HSHttpHelper;
import com.tydic.pfsc.external.utils.http.HSNHttpHeader;
import com.tydic.pfsc.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class NcPaymentNoteBillUpServiceImpl
implements NcPaymentNoteBillUpService {
    private static final Logger log = LoggerFactory.getLogger(NcPaymentNoteBillUpServiceImpl.class);
    @Autowired
    private Environment prop;

    @Override
    public NcPaymentNoteBillUpRspBO paymentNoteBillUp(NcPaymentNoteBillUpReqBO reqBO) {
        NcPaymentNoteBillUpRspBO extRspBO = new NcPaymentNoteBillUpRspBO();
        String reqEsbStr = this.initReqStr(reqBO);
        log.debug("--begin--");
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_PAYMENT_NOTE_BILL_UP_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            log.debug("\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_PAYMENT_NOTE_BILL_UP_URL") + "]" + reqEsbStr);
            if (httpRetBean.getStatus() == 200) {
                String returnString = httpRetBean.getStr();
                log.debug("\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u4e1a\u52a1\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
                return this.resolveRspMsg(returnString);
            }
            log.info("\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25httpRetBean.src=" + httpRetBean.getStr());
            extRspBO.setRespCode("8888");
            extRspBO.setRespDesc("\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u8c03\u7528\u5931\u8d25" + e);
            extRspBO.setRespCode("8888");
            extRspBO.setRespDesc("\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
            return extRspBO;
        }
        return extRspBO;
    }

    private String initReqStr(NcPaymentNoteBillUpReqBO reqBO) {
        log.debug("\u5f00\u59cb\u62fc\u63a5\u5165\u53c2\u62a5\u6587");
        StringBuffer sb = new StringBuffer();
        if (null != reqBO.getId()) {
            sb.append("{").append("\"id\":\"" + reqBO.getId()).append("\",");
            if (null != reqBO.getBillHead()) {
                sb.append("\"billhead\": ").append("{");
                if (null != reqBO.getBillHead().getDef20() && !"".equals(reqBO.getBillHead().getDef20())) {
                    sb.append("\"Def20\":\"" + reqBO.getBillHead().getDef20()).append("\",");
                }
                if (null != reqBO.getBillHead().getDef6() && !"".equals(reqBO.getBillHead().getDef6())) {
                    sb.append("\"Def6\":\"" + reqBO.getBillHead().getDef6()).append("\",");
                }
                if (null != reqBO.getBillHead().getBilldate() && !"".equals(reqBO.getBillHead().getBilldate())) {
                    sb.append("\"billdate\":\"" + reqBO.getBillHead().getBilldate()).append("\",");
                }
                if (null != reqBO.getBillHead().getBillmaker() && !"".equals(reqBO.getBillHead().getBillmaker())) {
                    sb.append("\"billmaker\":\"" + reqBO.getBillHead().getBillmaker()).append("\",");
                }
                sb.append("\"billstatus\":\"" + reqBO.getBillHead().getBillstatus()).append("\",");
                if (null != reqBO.getBillHead().getIsinit() && !"".equals(reqBO.getBillHead().getIsinit())) {
                    sb.append("\"isinit\":\"" + reqBO.getBillHead().getIsinit()).append("\",");
                }
                if (null != reqBO.getBillHead().getIsreded() && !"".equals(reqBO.getBillHead().getIsreded())) {
                    sb.append("\"isreded\":\"" + reqBO.getBillHead().getIsreded()).append("\",");
                }
                if (null != reqBO.getBillHead().getLocal_money()) {
                    sb.append("\"local_money\":\"" + reqBO.getBillHead().getLocal_money()).append("\",");
                }
                if (null != reqBO.getBillHead().getMoney()) {
                    sb.append("\"money\":\"" + reqBO.getBillHead().getMoney()).append("\",");
                }
                sb.append("\"objtype\":\"" + reqBO.getBillHead().getObjtype()).append("\",");
                if (null != reqBO.getBillHead().getPk_billtype() && !"".equals(reqBO.getBillHead().getPk_billtype())) {
                    sb.append("\"pk_billtype\":\"" + reqBO.getBillHead().getPk_billtype()).append("\",");
                }
                if (null != reqBO.getBillHead().getPk_currtype() && !"".equals(reqBO.getBillHead().getPk_currtype())) {
                    sb.append("\"pk_currtype\":\"" + reqBO.getBillHead().getPk_currtype()).append("\",");
                }
                if (null != reqBO.getBillHead().getPk_group() && !"".equals(reqBO.getBillHead().getPk_group())) {
                    sb.append("\"pk_group\":\"" + reqBO.getBillHead().getPk_group()).append("\",");
                }
                if (null != reqBO.getBillHead().getPk_org() && !"".equals(reqBO.getBillHead().getPk_org())) {
                    sb.append("\"pk_org\":\"" + reqBO.getBillHead().getPk_org()).append("\",");
                }
                if (null != reqBO.getBillHead().getPk_tradetype() && !"".equals(reqBO.getBillHead().getPk_tradetype())) {
                    sb.append("\"pk_tradetype\":\"" + reqBO.getBillHead().getPk_tradetype()).append("\",");
                }
                sb.append("\"src_syscode\":\"" + reqBO.getBillHead().getSrc_syscode()).append("\",");
                sb.append("\"syscode\":\"" + reqBO.getBillHead().getSyscode()).append("\",");
                if (null != reqBO.getBillHead().getPk_deptid() && !"".equals(reqBO.getBillHead().getPk_deptid())) {
                    sb.append("\"pk_deptid\":\"" + reqBO.getBillHead().getPk_deptid()).append("\",");
                }
                if (null != reqBO.getBillHead().getPayaccount() && !"".equals(reqBO.getBillHead().getPayaccount())) {
                    sb.append("\"payaccount\":\"" + reqBO.getBillHead().getPayaccount()).append("\",");
                }
                if (null != reqBO.getBillHead().getRecaccount() && !"".equals(reqBO.getBillHead().getRecaccount())) {
                    sb.append("\"recaccount\":\"" + reqBO.getBillHead().getRecaccount()).append("\",");
                }
                if (null != reqBO.getBillHead().getPk_balatype() && !"".equals(reqBO.getBillHead().getPk_balatype())) {
                    sb.append("\"pk_balatype\":\"" + reqBO.getBillHead().getPk_balatype()).append("\",");
                }
                if (null != reqBO.getBillHead().getDef10() && !"".equals(reqBO.getBillHead().getDef10())) {
                    sb.append("\"def10\":\"" + reqBO.getBillHead().getDef10()).append("\",");
                }
                sb.append("\"settleflag\":\"" + reqBO.getBillHead().getSettleflag()).append("\",");
                if (null != reqBO.getBillHead().getDef5() && !"".equals(reqBO.getBillHead().getDef5())) {
                    sb.append("\"Def5\":\"" + reqBO.getBillHead().getDef5()).append("\",");
                }
                if (null != reqBO.getBillHead().getDef7() && !"".equals(reqBO.getBillHead().getDef7())) {
                    sb.append("\"Def7\":\"" + reqBO.getBillHead().getDef7()).append("\",");
                }
                if (null != reqBO.getBillHead().getDef8() && !"".equals(reqBO.getBillHead().getDef8())) {
                    sb.append("\"Def8\":\"" + reqBO.getBillHead().getDef8()).append("\",");
                }
                if (null != reqBO.getItem() && reqBO.getItem().size() > 0) {
                    sb.append("\"bodys\": {\n              \"item\":");
                    sb.append(JSON.toJSONString(reqBO.getItem()));
                    sb.append("}");
                }
                sb.append("}");
            }
            sb.append("}");
        }
        log.debug("\u4ed8\u6b3e\u5355\u63a5\u53e3\u62fc\u63a5\u5165\u53c2\uff1a" + sb.toString());
        return sb.toString();
    }

    private NcPaymentNoteBillUpRspBO resolveRspMsg(String returnString) {
        JSONObject jsonPo;
        NcPaymentNoteBillUpRspBO extRspBO = new NcPaymentNoteBillUpRspBO();
        if (StringUtils.isEmpty((Object)returnString)) {
            extRspBO.setRespCode("8888");
            extRspBO.setRespDesc("\u83b7\u53d6\u4ed8\u6b3e\u5355\u8f7d\u63a5\u53e3\u4e1a\u52a1\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            return extRspBO;
        }
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"ufinterface");
        if (jsonObject != null && (jsonPo = (JSONObject)jsonObject.get((Object)"sendresult")) != null) {
            extRspBO.setRespCode((String)jsonPo.get((Object)"resultcode"));
            extRspBO.setResultdescription((String)jsonPo.get((Object)"resultdescription"));
            extRspBO.setContent((String)jsonPo.get((Object)"content"));
            extRspBO.setBillpk((String)jsonPo.get((Object)"billpk"));
            extRspBO.setFilename((String)jsonPo.get((Object)"filename"));
        }
        return extRspBO;
    }
}

