/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pfsc.external.api.PayCancelTradeService;
import com.tydic.pfsc.external.api.bo.PayCancelTradeReqBO;
import com.tydic.pfsc.external.api.bo.PayCancelTradeRspBO;
import com.tydic.pfsc.external.exception.PfscExternalBusinessException;
import com.tydic.pfsc.external.utils.JsonUtils;
import com.tydic.pfsc.external.utils.http.HSHttpHelper;
import com.tydic.pfsc.external.utils.http.HSNHttpHeader;
import com.tydic.pfsc.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PayCancelTradeServiceImpl
implements PayCancelTradeService {
    private static final Logger logger = LoggerFactory.getLogger(PayCancelTradeServiceImpl.class);
    @Autowired
    private Environment prop;

    @Override
    public PayCancelTradeRspBO payCancelTrade(PayCancelTradeReqBO reqBO) {
        JSONObject rspJsonObject;
        String reqStr = JsonUtils.objectBeanToJsonString(reqBO);
        logger.info(reqStr);
        HttpRetBean httpRetBean = null;
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("URL")), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
        }
        catch (Exception e) {
            logger.debug("\u8c03\u7528\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        if (httpRetBean.getStatus() != 200) {
            throw new RuntimeException("\u5546\u6237\u64a4\u9500\u4ea4\u6613 \u63a5\u53e3\u670d\u52a1--->\u8c03\u7528ESB\u63a5\u53e3\u7cfb\u7edf\u5931\u8d25");
        }
        logger.info("\u5546\u6237\u64a4\u9500\u4ea4\u6613 \u63a5\u53e3\u670d\u52a1--->\u8c03\u7528ESB\u63a5\u53e3\u7cfb\u7edf\u5931\u8d25\uff1a" + httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            throw new RuntimeException("\u5546\u6237\u64a4\u9500\u4ea4\u6613 \u63a5\u53e3\u670d\u52a1--->\u8c03\u7528ESB\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        logger.info("--\u63a5\u53e3\u8fd4\u56de\u7684\u62a5\u6587:" + returnString);
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            throw new PfscExternalBusinessException("18000", "\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        PayCancelTradeRspBO rspBO = new PayCancelTradeRspBO();
        rspBO.setRetCode(rspJsonObject.getString("rspcode"));
        rspBO.setRetMsg(rspJsonObject.getString("rspmsg"));
        return rspBO;
    }
}

