/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.external.atour.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pfsc.external.atour.api.BillInfoUploadExternalService;
import com.tydic.pfsc.external.atour.api.bo.BillInfoUploadExtReqBO;
import com.tydic.pfsc.external.atour.api.bo.BillInfoUploadExtRspBO;
import com.tydic.pfsc.external.utils.JsonUtils;
import com.tydic.pfsc.external.utils.http.HSHttpHelper;
import com.tydic.pfsc.external.utils.http.HSNHttpHeader;
import com.tydic.pfsc.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BillInfoUploadExternalServiceImpl
implements BillInfoUploadExternalService {
    private static final Logger log = LoggerFactory.getLogger(BillInfoUploadExternalServiceImpl.class);
    @Autowired
    private Environment prop;

    @Override
    public BillInfoUploadExtRspBO billInfoUpload(BillInfoUploadExtReqBO billInfoUploadExtReqBO) {
        BillInfoUploadExtRspBO extRspBO = new BillInfoUploadExtRspBO();
        String reqEsbStr = this.initReqStr(billInfoUploadExtReqBO);
        log.error("\u53d1\u7968\u5f00\u5177API\u63a5\u53e3\u4e1a\u52a1\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\uff1a" + reqEsbStr);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_BILL_INFO_UPLOAD_EXT_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u53d1\u7968\u5f00\u5177API\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_INVOICE_ISSUE_EXTERNAL_URL") + "]" + reqEsbStr);
                extRspBO.setRespCode("8888");
                extRspBO.setRespDesc("\u53d1\u7968\u5f00\u5177API\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
            } else {
                String returnString = httpRetBean.getStr();
                log.error("\u53d1\u7968\u5f00\u5177API\u63a5\u53e3\u4e1a\u52a1\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
                BillInfoUploadExtRspBO billDownloadExtRspBO = this.resolveRspMsg(returnString);
                if (billDownloadExtRspBO != null) {
                    extRspBO.setRespCode(billDownloadExtRspBO.getRespCode());
                    extRspBO.setRespDesc(billDownloadExtRspBO.getRespDesc());
                }
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u7968\u5f00\u5177API\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u8c03\u7528\u5931\u8d25", (Throwable)e);
            extRspBO.setRespCode("8888");
            extRspBO.setRespDesc("\u53d1\u7968\u5f00\u5177API\u63a5\u53e3\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
            return extRspBO;
        }
        return extRspBO;
    }

    private String initReqStr(BillInfoUploadExtReqBO reqBO) {
        String reqStr = JsonUtils.objectBeanToJsonString(reqBO);
        return reqStr;
    }

    private BillInfoUploadExtRspBO resolveRspMsg(String returnString) {
        BillInfoUploadExtRspBO extRspBO = new BillInfoUploadExtRspBO();
        if (StringUtils.isEmpty((Object)returnString)) {
            extRspBO.setRespCode("8888");
            extRspBO.setRespDesc("\u53d1\u7968\u5f00\u5177API\u63a5\u53e3\u4e1a\u52a1\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            return extRspBO;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        extRspBO.setRespCode(((Integer)jsonObject.get((Object)"code")).toString());
        extRspBO.setRespDesc((String)jsonObject.get((Object)"message"));
        return extRspBO;
    }
}

