/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.external.utils;

import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.JdException;
import com.jd.open.api.sdk.internal.parser.Parser;
import com.jd.open.api.sdk.internal.parser.ParserFactory;
import com.jd.open.api.sdk.internal.util.CodecUtil;
import com.jd.open.api.sdk.internal.util.HttpUtil;
import com.jd.open.api.sdk.internal.util.StringUtil;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.request.JdUploadRequest;
import com.jd.open.api.sdk.response.AbstractResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GuodianJdClient
implements JdClient {
    private static final Log logger = LogFactory.getLog(GuodianJdClient.class);
    public static final String CHARSET_UTF8 = "UTF-8";
    private static final String JSON_PARAM_KEY = "360buy_param_json";
    private static final String OTHER_PARAM_KEY = "other";
    private String serverUrl;
    private String accessToken;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private String appKey;
    private String fuzz;
    private String appSecret;
    private String sign;

    public GuodianJdClient(String serverUrl, String accessToken, String appKey, String appSecret) {
        this.serverUrl = serverUrl;
        this.accessToken = accessToken;
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public GuodianJdClient(String serverUrl, String accessToken, String appKey, String appSecret, String fuzz) {
        this.serverUrl = serverUrl;
        this.accessToken = accessToken;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.fuzz = fuzz;
    }

    public GuodianJdClient(String serverUrl, String accessToken, String appKey, String appSecret, int connectTimeout, int readTimeout) {
        this(serverUrl, accessToken, appKey, appSecret);
    }

    public <T extends AbstractResponse> T execute(JdRequest<T> request) throws JdException {
        HashMap<String, String> params = new HashMap<String, String>(16);
        String rsp = null;
        String url = null;
        try {
            url = this.buildUrl(request);
            String json = request.getAppJsonParams();
            params.putAll(request.getSysParams());
            params.put(JSON_PARAM_KEY, json);
            params.put("method", request.getApiMethod());
            params.put("access_token", this.accessToken);
            params.put("app_key", this.appKey);
            params.put("sign", this.sign);
            if (request.getOtherParams() != null) {
                params.put(OTHER_PARAM_KEY, request.getOtherParams());
            }
            rsp = request instanceof JdUploadRequest ? HttpUtil.doPost((String)url, params, (Map)((JdUploadRequest)request).getFileParams(), (int)this.connectTimeout, (int)this.readTimeout) : HttpUtil.doPost((String)url, params, (int)this.connectTimeout, (int)this.readTimeout);
            logger.debug((Object)("JD-EXPRESS RESP:" + rsp));
            T resp = this.parse(rsp, request.getResponseClass());
            if (resp != null) {
                resp.setUrl(url + "&" + JSON_PARAM_KEY + "=" + json);
            }
            return resp;
        }
        catch (Exception e) {
            logger.error((Object)("JD-EXPRESS\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\u3002url=" + url + ",params=" + params + ",RSP=" + rsp), (Throwable)e);
            throw new JdException("\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5");
        }
    }

    private <T extends AbstractResponse> String buildUrl(JdRequest<T> request) throws Exception {
        String sign;
        Map sysParams = request.getSysParams();
        TreeMap<String, String> pmap = new TreeMap<String, String>();
        pmap.putAll(sysParams);
        pmap.put(JSON_PARAM_KEY, request.getAppJsonParams());
        pmap.put("method", request.getApiMethod());
        pmap.put("access_token", this.accessToken);
        pmap.put("app_key", this.appKey);
        if (this.fuzz != null) {
            pmap.put("jos_result_fuzz", this.fuzz);
        }
        this.sign = sign = this.sign(pmap, this.appSecret);
        StringBuilder sb = new StringBuilder(this.serverUrl);
        return sb.toString();
    }

    private <T extends AbstractResponse> T parse(String rsp, Class<T> responseClass) throws JdException {
        Parser parser = ParserFactory.getJsonParser();
        return (T)parser.parse(rsp, responseClass);
    }

    private String sign(Map<String, String> pmap, String appSecret) throws Exception {
        StringBuilder sb = new StringBuilder(appSecret);
        for (Map.Entry<String, String> entry : pmap.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!StringUtil.areNotEmpty((String[])new String[]{name, value})) continue;
            sb.append(name).append(value);
        }
        sb.append(appSecret);
        String result = CodecUtil.md5((String)sb.toString());
        return result;
    }
}

