/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.external.zjpt.api.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pfsc.external.utils.http.HSHttpHelper;
import com.tydic.pfsc.external.utils.http.HSNHttpHeader;
import com.tydic.pfsc.external.utils.http.HttpRetBean;
import com.tydic.pfsc.external.zjpt.api.ZjptPayBillUpService;
import com.tydic.pfsc.external.zjpt.api.bo.ZjptPayBillUpReqBO;
import com.tydic.pfsc.external.zjpt.api.bo.ZjptPayBillUpRspBO;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ZjptPayBillUpServiceImpl
implements ZjptPayBillUpService {
    private static final Logger log = LoggerFactory.getLogger(ZjptPayBillUpServiceImpl.class);
    @Autowired
    private Environment prop;

    @Override
    public ZjptPayBillUpRspBO payBillUp(ZjptPayBillUpReqBO reqBO) {
        ZjptPayBillUpRspBO zjptPayBillUpRspBO = new ZjptPayBillUpRspBO();
        String reqEsbStr = this.initReqStr(reqBO);
        log.debug("--begin--");
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_ZJPT_PAY_BILL_UP_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            log.debug("\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u4e1a\u52a1\u5931\u8d25-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_PAYMENT_NOTE_BILL_UP_URL") + "]" + reqEsbStr);
            if (httpRetBean.getStatus() == 200) {
                String returnString = httpRetBean.getStr();
                log.debug("\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u4e1a\u52a1\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
                return this.resolveRspMsg(returnString);
            }
            log.info("\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u4e1a\u52a1\u5931\u8d25-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25httpRetBean.src=" + httpRetBean.getStr());
            zjptPayBillUpRspBO.setRespCode("8888");
            zjptPayBillUpRspBO.setRespDesc("\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u4e1a\u52a1\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u4e1a\u52a1\u8c03\u7528\u5931\u8d25" + e);
            zjptPayBillUpRspBO.setRespCode("8888");
            zjptPayBillUpRspBO.setRespDesc("\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u4e1a\u52a1\u5931\u8d25");
            return zjptPayBillUpRspBO;
        }
        return zjptPayBillUpRspBO;
    }

    private String initReqStr(ZjptPayBillUpReqBO reqBO) {
        log.debug("\u5f00\u59cb\u62fc\u63a5\u5165\u53c2\u62a5\u6587");
        StringBuffer sb = new StringBuffer();
        if (null != reqBO.getSerialNoErp()) {
            sb.append("{").append("\"serialNoErp\": \"" + reqBO.getSerialNoErp()).append("\",");
        }
        if (null != reqBO.getWishPayday()) {
            sb.append("\"wishPayday\": \"" + reqBO.getWishPayday()).append("\",");
        }
        if (null != reqBO.getCorpCode() && !"".equals(reqBO.getCorpCode())) {
            sb.append("\"corpCode\": \"" + reqBO.getCorpCode()).append("\",");
        }
        if (null != reqBO.getPayerAccNo() && !"".equals(reqBO.getPayerAccNo())) {
            sb.append("\"payerAccNo\": \"" + reqBO.getPayerAccNo()).append("\",");
        }
        if (null != reqBO.getAmt()) {
            sb.append("\"amt\": \"" + reqBO.getAmt()).append("\",");
        }
        if (null != reqBO.getCur() && !"".equals(reqBO.getCur())) {
            sb.append("\"cur\": \"" + reqBO.getCur()).append("\",");
        }
        if (null != reqBO.getPayeeAccNo() && !"".equals(reqBO.getPayeeAccNo())) {
            sb.append("\"payeeAccNo\": \"" + reqBO.getPayeeAccNo()).append("\",");
        }
        if (null != reqBO.getPayeeAccName() && !"".equals(reqBO.getPayeeAccName())) {
            sb.append("\"payeeAccName\": \"" + reqBO.getPayeeAccName()).append("\",");
        }
        if (null != reqBO.getPayeeCode() && !"".equals(reqBO.getPayeeCode())) {
            sb.append("\"payeeCode\": \"" + reqBO.getPayeeCode()).append("\",");
        }
        if (null != reqBO.getAbs() && !"".equals(reqBO.getAbs())) {
            sb.append("\"abs\": \"" + reqBO.getAbs()).append("\",");
        }
        if (null != reqBO.getPurpose() && !"".equals(reqBO.getPurpose())) {
            sb.append("\"purpose\": \"" + reqBO.getPurpose()).append("\",");
        }
        if (null != reqBO.getVoucherType() && !"".equals(reqBO.getVoucherType())) {
            sb.append("\"voucherType\": \"" + reqBO.getVoucherType()).append("\",");
        }
        if (null != reqBO.getIsforindividual() && !"".equals(reqBO.getIsforindividual())) {
            sb.append("\"isforindividual\": \"" + reqBO.getIsforindividual()).append("\",");
        }
        sb.append("}");
        log.debug("\u5e94\u6536\u5355\u62fc\u63a5\u5165\u53c2\uff1a" + sb.toString());
        return sb.toString();
    }

    private ZjptPayBillUpRspBO resolveRspMsg(String returnString) {
        JSONObject jsonPo;
        ZjptPayBillUpRspBO extRspBO = new ZjptPayBillUpRspBO();
        if (StringUtils.isEmpty((Object)returnString)) {
            extRspBO.setRespCode("8888");
            extRspBO.setRespDesc("\u83b7\u53d6\u4ed8\u6b3e\u5355\u8f7d\u63a5\u53e3\u4e1a\u52a1\u4fe1\u606f\u670d\u52a1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            return extRspBO;
        }
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"ufinterface");
        if (jsonObject != null && (jsonPo = (JSONObject)jsonObject.get((Object)"sendresult")) != null) {
            extRspBO.setRespCode((String)jsonPo.get((Object)"resultcode"));
            extRspBO.setSerialNoErp((String)jsonPo.get((Object)"serialNoErp"));
            extRspBO.setStatus((String)jsonPo.get((Object)"status"));
            extRspBO.setMessage((String)jsonPo.get((Object)"message"));
        }
        return extRspBO;
    }
}

