/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.domain.etms.TraceQueryJsf.TraceDTO;
import com.jd.open.api.sdk.domain.etms.TraceQueryJsf.TraceQueryResultDTO;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.request.etms.EtmsRangeCheckRequest;
import com.jd.open.api.sdk.request.etms.EtmsWaybillSendRequest;
import com.jd.open.api.sdk.request.etms.EtmsWaybillcodeGetRequest;
import com.jd.open.api.sdk.request.etms.LdopReceiveOrderInterceptRequest;
import com.jd.open.api.sdk.request.etms.LdopReceiveTraceGetRequest;
import com.jd.open.api.sdk.response.etms.EtmsRangeCheckResponse;
import com.jd.open.api.sdk.response.etms.EtmsWaybillSendResponse;
import com.jd.open.api.sdk.response.etms.EtmsWaybillcodeGetResponse;
import com.jd.open.api.sdk.response.etms.LdopReceiveOrderInterceptResponse;
import com.jd.open.api.sdk.response.etms.LdopReceiveTraceGetResponse;
import com.tydic.pfsc.external.api.BusiJdExpressService;
import com.tydic.pfsc.external.api.bo.JdexpressTokenVO;
import com.tydic.pfsc.external.exception.PfscExternalBusinessException;
import com.tydic.pfsc.external.utils.GuodianJdClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service(value="busiJdExpressService")
public class BusiJdExpressServiceImpl
implements BusiJdExpressService {
    private static final Logger logger = LoggerFactory.getLogger(BusiJdExpressServiceImpl.class);
    private String jdUrl = "https://api.jd.com/routerjson";
    @Autowired
    private Environment prop;
    private boolean propIsLoaded = false;

    @Override
    public List<TraceDTO> receiveTrace(String expressNo, JdexpressTokenVO token) {
        JdClient client = this.createClient(token);
        LdopReceiveTraceGetRequest request = new LdopReceiveTraceGetRequest();
        request.setCustomerCode(token.getCustCode());
        request.setWaybillCode(expressNo);
        List traceDTOList = null;
        LdopReceiveTraceGetResponse resp = null;
        try {
            resp = (LdopReceiveTraceGetResponse)client.execute((JdRequest)request);
            logger.info("\u8c03\u7528\u5feb\u9012\u7269\u6d41\u63a5\u53e3ReceiveTrace\u67e5\u8be2\u8fd4\u56de:code=" + resp.getCode() + ",msg=" + resp.getMsg());
            TraceQueryResultDTO result = resp.getQuerytraceResult();
            if (result == null) {
                logger.error("\u8c03\u7528\u5feb\u9012\u7269\u6d41\u63a5\u53e3ReceiveTrace\u8fd4\u56de\u7684DTO\u4e3aNULL,\u8fd0\u5355\u53f7=" + expressNo);
                throw new PfscExternalBusinessException("18002", "\u8c03\u7528\u7269\u6d41\u67e5\u8be2\u63a5\u53e3\u5931\u8d25,\u6ca1\u6709\u7ed3\u679c\u8fd4\u56de");
            }
            traceDTOList = result.getData();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4eac\u4e1c\u5feb\u9012\u67e5\u8be2\u7269\u6d41\u63a5\u53e3ReceiveTrace\u5931\u8d25,\u8fd0\u5355=" + expressNo + "," + e.getMessage(), (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528\u7269\u6d41\u67e5\u8be2\u63a5\u53e3\u5931\u8d25");
        }
        return traceDTOList;
    }

    @Override
    public String rangeCheck(String orderId, String recvAddr, JdexpressTokenVO token) {
        JdClient client = this.createClient(token);
        EtmsRangeCheckRequest request = new EtmsRangeCheckRequest();
        request.setGoodsType(Integer.valueOf(1));
        request.setCustomerCode(token.getCustCode());
        request.setWareHouseCode(token.getWarehouseCode());
        request.setOrderId(orderId);
        request.setReceiveAddress(recvAddr);
        EtmsRangeCheckResponse resp = null;
        try {
            resp = (EtmsRangeCheckResponse)client.execute((JdRequest)request);
            if (resp != null && "0".equals(resp.getCode())) {
                logger.info("\u8c03\u7528\u4eac\u914d\u63a5\u53e3\u6210\u529f,ordId=" + orderId + ",recvAddr=" + recvAddr + ",msg=" + resp.getMsg());
                JSONObject json = JSONObject.parseObject((String)resp.getMsg()).getJSONObject("jingdong_etms_range_check_responce");
                JSONObject resultJson = (JSONObject)json.get((Object)"resultInfo");
                return resultJson.getBigInteger("rcode") + "-" + resultJson.getString("rmessage");
            }
            if (resp == null) {
                logger.error("\u8c03\u7528\u4eac\u914d\u63a5\u53e3\u5931\u8d25,ordId=" + orderId + ",recvAddr=" + recvAddr);
            } else {
                logger.error("\u8c03\u7528\u4eac\u914d\u63a5\u53e3\u5931\u8d25,ordId=" + orderId + ",recvAddr=" + recvAddr + ",msg=" + resp.getMsg());
            }
            String msg = "\u8c03\u7528\u4eac\u914d\u63a5\u53e3\u5931\u8d25";
            if (resp != null) {
                msg = resp.getCode() + "-" + resp.getMsg();
            }
            return msg;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4eac\u914d\u9a8c\u8bc1\u63a5\u53e3RangeCheck\u5931\u8d25,ordId=" + orderId + "," + e.getMessage(), (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528\u4eac\u914d\u9a8c\u8bc1\u63a5\u53e3\u5931\u8d25" + e.getMessage());
        }
    }

    @Override
    public List<String> applyBillCode(int billCount, JdexpressTokenVO token) {
        if (billCount < 1 || billCount > 100) {
            throw new PfscExternalBusinessException("18002", "\u7533\u8bf7\u6570\u91cf\u5fc5\u987b\u57281~100\u4e4b\u95f4");
        }
        JdClient client = this.createClient(token);
        EtmsWaybillcodeGetRequest request = new EtmsWaybillcodeGetRequest();
        request.setCustomerCode(token.getCustCode());
        request.setPreNum("" + billCount);
        request.setOrderType(Integer.valueOf(0));
        EtmsWaybillcodeGetResponse resp = null;
        try {
            resp = (EtmsWaybillcodeGetResponse)client.execute((JdRequest)request);
            if (resp != null && "0".equals(resp.getCode()) && resp.getResultInfo() != null) {
                logger.info("\u7533\u8bf7\u5feb\u9012\u8fd0\u5355\u53f7\u6210\u529f,\u6570\u91cf=" + billCount + ",\u8fd0\u5355\u53f7=" + resp.getResultInfo().getDeliveryIdList());
                return resp.getResultInfo().getDeliveryIdList();
            }
            String msg = "\u672a\u8fd4\u56de\u6709\u6548\u7684\u6570\u636e";
            if (resp != null) {
                msg = resp.getMsg();
            }
            logger.error("\u8c03\u7528\u4eac\u4e1c\u7533\u8bf7\u5feb\u9012\u5355\u53f7\u63a5\u53e3WaybillcodeGet\u5931\u8d25,\u6570\u91cf=" + billCount + ",msg=" + msg);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528\u4eac\u4e1c\u7533\u8bf7\u5feb\u9012\u5355\u53f7\u63a5\u53e3\u5931\u8d25,\u63a5\u53e3\u672a\u8fd4\u56de\u6709\u6548\u6570\u636e");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8c03\u7528\u4eac\u4e1c\u7533\u8bf7\u5feb\u9012\u5355\u53f7\u63a5\u53e3WaybillcodeGet\u5931\u8d25,\u6570\u91cf=" + billCount + "," + e.getMessage(), (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528\u4eac\u4e1c\u7533\u8bf7\u5feb\u9012\u5355\u53f7\u63a5\u53e3\u5931\u8d25" + e.getMessage());
        }
    }

    @Override
    public void sendBill(String billNo, String orderId, String senderName, String senderAddr, String senderMobile, String recvName, String recvAddr, String recvMobile, String remark, JdexpressTokenVO token) {
        JdClient client = this.createClient(token);
        EtmsWaybillSendRequest request = new EtmsWaybillSendRequest();
        request.setCustomerCode(token.getCustCode());
        request.setWarehouseCode(token.getWarehouseCode());
        request.setSalePlat("0030001");
        request.setDeliveryId(billNo);
        request.setOrderId(orderId);
        request.setSenderName(senderName);
        request.setSenderAddress(senderAddr);
        request.setSenderMobile(senderMobile);
        request.setReceiveName(recvName);
        request.setReceiveAddress(recvAddr);
        request.setReceiveMobile(recvMobile);
        request.setRemark(remark);
        request.setPackageCount(Integer.valueOf(1));
        request.setWeight(Double.valueOf(1.0));
        request.setVloumn(Double.valueOf(1.0));
        request.setAging(Integer.valueOf(1));
        request.setGoodsType(Integer.valueOf(1));
        request.setOrderType(Integer.valueOf(0));
        EtmsWaybillSendResponse resp = null;
        try {
            resp = (EtmsWaybillSendResponse)client.execute((JdRequest)request);
            if (resp != null && "0".equals(resp.getCode())) {
                logger.info("\u63d0\u4ea4\u5feb\u9012\u8fd0\u5355\u6210\u529f,\u8fd0\u5355=" + billNo + ",ordId=" + orderId + ",\u6536\u4ef6=" + recvName + ",msg=" + resp.getMsg());
                return;
            }
            String msg = "\u672a\u8fd4\u56de\u6709\u6548\u6570\u636e";
            if (resp == null) {
                logger.error("\u63d0\u4ea4\u5feb\u9012\u8fd0\u5355\u5931\u8d25,\u8fd0\u5355=" + billNo + ",ordId=" + orderId + ",\u6536\u4ef6=" + recvName);
            } else {
                msg = resp.getMsg();
                logger.error("\u63d0\u4ea4\u5feb\u9012\u8fd0\u5355\u5931\u8d25,\u8fd0\u5355=" + billNo + ",ordId=" + orderId + ",\u6536\u4ef6=" + recvName + ",msg=" + resp.getMsg());
            }
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528\u63d0\u4ea4\u5feb\u9012\u8fd0\u5355\u63a5\u53e3WaybillSend\u5931\u8d25," + msg);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u63d0\u4ea4\u5feb\u9012\u8fd0\u5355\u63a5\u53e3WaybillSend\u5931\u8d25,\u5355\u53f7=" + billNo + "," + e.getMessage(), (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528\u63d0\u4ea4\u5feb\u9012\u8fd0\u5355\u63a5\u53e3WaybillSend\u5931\u8d25," + e.getMessage());
        }
    }

    private void loadProperty() {
        if (!this.propIsLoaded) {
            this.propIsLoaded = true;
            this.jdUrl = this.prop.getProperty("ESB_JD_REQUIRE_EXPRESS_ID_URL");
        }
    }

    private JdClient createClient(JdexpressTokenVO token) {
        this.loadProperty();
        return new GuodianJdClient(this.jdUrl, token.getToken(), token.getAppKey(), token.getAppSecret());
    }

    @Override
    public String getEsbUrl() {
        return this.jdUrl;
    }

    @Override
    public void setEsbUrl(String url) {
        this.jdUrl = url;
    }

    public static void main1(String[] args) {
        JdexpressTokenVO token = new JdexpressTokenVO();
        token.setAppKey("1746879AD78F69D3C6D4C4E88E9A85C7");
        token.setAppSecret("cd60cf848fae4aefa922db8bb7b8e9c1");
        token.setCustCode("010K127520");
        token.setWarehouseCode("888");
        token.setToken("6fc1157e-7ef5-4e4e-ba6c-14bc6fe3dd2c");
        String url = "http://47.94.137.59:8001/OSN/api/jdExpress/v1";
        GuodianJdClient client = new GuodianJdClient(url, token.getToken(), token.getAppKey(), token.getAppSecret());
        LdopReceiveTraceGetRequest request = new LdopReceiveTraceGetRequest();
        request.setCustomerCode(token.getCustCode());
        request.setWaybillCode("11111111111");
        LdopReceiveTraceGetResponse resp = null;
        try {
            resp = (LdopReceiveTraceGetResponse)client.execute((JdRequest)request);
            if (resp != null) {
                System.out.println(resp.getMsg());
            } else {
                System.out.println("\u8fd4\u56deRSP\u4e3aNULL");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main2(String[] args) {
        JdexpressTokenVO token = new JdexpressTokenVO();
        token.setAppKey("1746879AD78F69D3C6D4C4E88E9A85C7");
        token.setAppSecret("cd60cf848fae4aefa922db8bb7b8e9c1");
        token.setCustCode("010K127520");
        token.setWarehouseCode("888");
        token.setToken("6fc1157e-7ef5-4e4e-ba6c-14bc6fe3dd2c");
        String url = "http://47.94.137.59:8001/OSN/api/jdExpress/v1";
        GuodianJdClient client = new GuodianJdClient(url, token.getToken(), token.getAppKey(), token.getAppSecret());
        EtmsRangeCheckRequest request = new EtmsRangeCheckRequest();
        request.setGoodsType(Integer.valueOf(1));
        request.setCustomerCode(token.getCustCode());
        request.setWareHouseCode("888");
        request.setOrderId("100000001");
        request.setReceiveAddress("\u5317\u4eac\u5e02\u4e30\u53f0\u533a\u897f\u4e09\u73af\u4e2d\u8def88\u53f7");
        EtmsRangeCheckResponse resp = null;
        try {
            resp = (EtmsRangeCheckResponse)client.execute((JdRequest)request);
            System.out.println(resp.getMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main3(String[] args) {
        JdexpressTokenVO token = new JdexpressTokenVO();
        token.setAppKey("1746879AD78F69D3C6D4C4E88E9A85C7");
        token.setAppSecret("cd60cf848fae4aefa922db8bb7b8e9c1");
        token.setCustCode("010K127520");
        token.setWarehouseCode("888");
        token.setToken("6fc1157e-7ef5-4e4e-ba6c-14bc6fe3dd2c");
        String url = "http://47.94.137.59:8001/OSN/api/jdExpress/v1";
        GuodianJdClient client = new GuodianJdClient(url, token.getToken(), token.getAppKey(), token.getAppSecret());
        EtmsWaybillcodeGetRequest request = new EtmsWaybillcodeGetRequest();
        request.setCustomerCode(token.getCustCode());
        request.setPreNum("2");
        request.setOrderType(Integer.valueOf(0));
        EtmsWaybillcodeGetResponse resp = null;
        try {
            resp = (EtmsWaybillcodeGetResponse)client.execute((JdRequest)request);
            System.out.println(resp.getMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main4(String[] args) {
        JdexpressTokenVO token = new JdexpressTokenVO();
        token.setAppKey("1746879AD78F69D3C6D4C4E88E9A85C7");
        token.setAppSecret("cd60cf848fae4aefa922db8bb7b8e9c1");
        token.setCustCode("010K127520");
        token.setWarehouseCode("888");
        token.setToken("6fc1157e-7ef5-4e4e-ba6c-14bc6fe3dd2c");
        String url = "http://47.94.137.59:8001/OSN/api/jdExpress/v1";
        GuodianJdClient client = new GuodianJdClient(url, token.getToken(), token.getAppKey(), token.getAppSecret());
        EtmsWaybillSendRequest request = new EtmsWaybillSendRequest();
        request.setCustomerCode(token.getCustCode());
        request.setDeliveryId("V038579817301");
        request.setSalePlat("0030001");
        request.setWarehouseCode(token.getWarehouseCode());
        request.setOrderId("10005");
        request.setSenderName("\u8c22\u5148\u751f");
        request.setSenderAddress("\u5317\u4eac\u5e02\u4e30\u53f0\u533a\u897f\u4e09\u73af\u4e2d\u8def88\u53f7\u56fd\u7535\u62db\u5f85\u6240");
        request.setSenderMobile("010-5868 8444");
        request.setReceiveName("\u6d4b\u8bd5\u5355");
        request.setReceiveAddress("\u5317\u4eac\u5e02\u4e30\u53f0\u533a\u897f\u4e09\u73af\u4e2d\u8def88\u53f7");
        request.setReceiveMobile("010-5868 8444");
        request.setPackageCount(Integer.valueOf(1));
        request.setWeight(Double.valueOf(1.0));
        request.setVloumn(Double.valueOf(1.0));
        request.setAging(Integer.valueOf(1));
        request.setRemark("\u8fd9\u662f\u5907\u6ce8\u7684\u5185\u5bb9");
        request.setGoodsType(Integer.valueOf(1));
        request.setOrderType(Integer.valueOf(0));
        EtmsWaybillSendResponse resp = null;
        try {
            resp = (EtmsWaybillSendResponse)client.execute((JdRequest)request);
            System.out.println(resp.getMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main5(String[] args) {
        JdexpressTokenVO token = new JdexpressTokenVO();
        token.setAppKey("1746879AD78F69D3C6D4C4E88E9A85C7");
        token.setAppSecret("cd60cf848fae4aefa922db8bb7b8e9c1");
        token.setCustCode("010K127520");
        token.setWarehouseCode("888");
        token.setToken("6fc1157e-7ef5-4e4e-ba6c-14bc6fe3dd2c");
        String url = "http://47.94.137.59:8001/OSN/api/jdExpress/v1";
        GuodianJdClient client = new GuodianJdClient(url, token.getToken(), token.getAppKey(), token.getAppSecret());
        LdopReceiveOrderInterceptRequest request = new LdopReceiveOrderInterceptRequest();
        request.setVendorCode(token.getCustCode());
        request.setDeliveryId("V038579817301");
        request.setInterceptReason("\u64a4\u9500");
        LdopReceiveOrderInterceptResponse resp = null;
        try {
            resp = (LdopReceiveOrderInterceptResponse)client.execute((JdRequest)request);
            System.out.println(resp.getMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

