/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.external.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tydic.pfsc.external.exception.PfscExternalBusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    public static ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);

    public static <T> T jsonStringToJavaBean(String content, Class<T> valueType) {
        if (valueType == null) {
            return null;
        }
        if (content == null) {
            return null;
        }
        try {
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
            objectMapper.configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true);
            objectMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
            objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            return (T)objectMapper.readValue(content, valueType);
        }
        catch (Exception e) {
            log.error("\u5c06\u5b57\u7b26\u4e32\u8f6cJava\u5bf9\u8c61\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u7c7b\u578b\uff01", (Throwable)e);
            throw new PfscExternalBusinessException("C994", "\u5c06\u5b57\u7b26\u4e32\u8f6cJava\u5bf9\u8c61\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u7c7b\u578b", e);
        }
    }

    public static <T> T jsonStringToJavaBean(String jsonStr, TypeReference<T> valueTypeRef) {
        try {
            return (T)objectMapper.readValue(jsonStr, valueTypeRef);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T jsonStringToJavaBean(String jsonStr, JavaType javatype) {
        try {
            return (T)objectMapper.readValue(jsonStr, javatype);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String objectBeanToJsonString(Object object) {
        String taskContent = null;
        try {
            taskContent = object == null ? "" : objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error("\u5c06\u5bf9\u8c61\u751f\u6210json\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8be5\u5bf9\u8c61\uff01", (Throwable)e);
            throw new PfscExternalBusinessException("C991", "\u5bf9\u8c61\u751f\u6210json\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8be5\u5bf9\u8c61\uff01", e);
        }
        return taskContent;
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return objectMapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }
}

