/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.invoice.busi.impl;

import com.tydic.pfsc.constant.PfscConstants;
import com.tydic.pfsc.exception.PfscBusinessException;
import com.tydic.pfsc.po.OrderInfoPO;
import com.tydic.pfsc.service.invoice.atom.PfscElecApplyAtomService;
import com.tydic.pfsc.service.invoice.atom.PfscQrySaleOrderAtomService;
import com.tydic.pfsc.service.invoice.atom.bo.PfscElecApplyAtomReqBO;
import com.tydic.pfsc.service.invoice.atom.bo.PfscElecApplyAtomRspBO;
import com.tydic.pfsc.service.invoice.busi.PfscElecInvoiceApplySingleBusiService;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyBusiReqBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyBusiRspBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscQrySaleOrderInfoBusiReqBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscQrySaleOrderInfoBusiRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfscElecInvoiceApplySingleBusiServiceImpl
implements PfscElecInvoiceApplySingleBusiService {
    private static final Logger logger = LoggerFactory.getLogger(PfscElecInvoiceApplySingleBusiServiceImpl.class);
    @Autowired
    private PfscQrySaleOrderAtomService pfscQrySaleOrderAtomService;
    @Autowired
    private PfscElecApplyAtomService pfscElecApplyAtomService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PfscElecInvoiceApplyBusiRspBO commitElecInvoiceApply(PfscElecInvoiceApplyBusiReqBO reqBo) {
        PfscElecInvoiceApplyBusiRspBO rspBo = new PfscElecInvoiceApplyBusiRspBO();
        PfscQrySaleOrderInfoBusiReqBO saleOrderInfoBusiReqBo = new PfscQrySaleOrderInfoBusiReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)((Object)saleOrderInfoBusiReqBo));
        PfscQrySaleOrderInfoBusiRspBO saleOrderInfoBusiRspBo = this.pfscQrySaleOrderAtomService.qrySaleOrderInfo(saleOrderInfoBusiReqBo);
        if (!"0000".equals(saleOrderInfoBusiRspBo.getRespCode())) {
            throw new PfscBusinessException("8888", "\u8c03\u7528\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        OrderInfoPO orderInfoPo = saleOrderInfoBusiRspBo.getSaleOrderInfo();
        if (orderInfoPo == null) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u8be5\u8ba2\u5355\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f\uff0c\u65e0\u9700\u5f00\u7968\uff0c\u8bf7\u6838\u5b9e");
            rspBo.setOrderStatus(PfscConstants.OrderStatus.REFUNDALL);
            return rspBo;
        }
        if (PfscConstants.BillApplyInfo.BillStatus.INVOICING.equals(orderInfoPo.getOrderStatus())) {
            throw new PfscBusinessException("8888", "\u8be5\u8ba2\u5355\u5df2\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\uff0c\u4e0d\u80fd\u91cd\u590d\u7533\u8bf7");
        }
        if (PfscConstants.BillApplyInfo.BillStatus.INVOICED.equals(orderInfoPo.getOrderStatus())) {
            throw new PfscBusinessException("8888", "\u8be5\u8ba2\u5355\u5df2\u5f00\u7968\uff0c\u4e0d\u80fd\u91cd\u590d\u7533\u8bf7");
        }
        if (PfscConstants.BillApplyInfo.BillStatus.REFUNDING.equals(orderInfoPo.getOrderStatus())) {
            throw new PfscBusinessException("8888", "\u8be5\u8ba2\u5355\u5df2\u63d0\u4ea4\u9000\u7968\u7533\u8bf7\uff0c\u4e0d\u80fd\u7533\u8bf7\u5f00\u7968");
        }
        PfscElecApplyAtomReqBO pfscElecApplyAtomReqBO = new PfscElecApplyAtomReqBO();
        pfscElecApplyAtomReqBO.setOrderId(reqBo.getOrderId());
        pfscElecApplyAtomReqBO.setOrderInfoPo(orderInfoPo);
        pfscElecApplyAtomReqBO.setOrgIdIn(orderInfoPo.getSupplierId());
        pfscElecApplyAtomReqBO.setShopIdIn(orderInfoPo.getSupplierShopId());
        PfscElecApplyAtomRspBO pfscElecApplyAtomRspBO = this.pfscElecApplyAtomService.dealApply(pfscElecApplyAtomReqBO);
        if (!"0000".equals(pfscElecApplyAtomRspBO.getRespCode())) {
            rspBo.setRespCode(pfscElecApplyAtomRspBO.getRespCode());
            rspBo.setRespDesc(pfscElecApplyAtomRspBO.getRespDesc());
            return rspBo;
        }
        rspBo.setSaleItemInfoList(pfscElecApplyAtomRspBO.getSaleItemInfoList());
        rspBo.setApplyNo(pfscElecApplyAtomRspBO.getApplyNo());
        rspBo.setOrderStatus(pfscElecApplyAtomRspBO.getOrderStatus());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u7535\u5b50\u53d1\u7968\u7533\u8bf7\u63d0\u4ea4\u5b8c\u6210");
        return rspBo;
    }
}

