/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.invoice.busi.impl;

import com.tydic.pfsc.dao.ApplyQueryIndexMapper;
import com.tydic.pfsc.dao.OrderInfoMapper;
import com.tydic.pfsc.dao.OrderItemInfoMapper;
import com.tydic.pfsc.exception.PfscBusinessException;
import com.tydic.pfsc.po.ApplyQueryIndexPO;
import com.tydic.pfsc.po.OrderInfoPO;
import com.tydic.pfsc.po.OrderItemInfoPO;
import com.tydic.pfsc.service.invoice.busi.PfscSaveIndexAndAppliedBusiService;
import com.tydic.pfsc.service.invoice.busi.bo.PfscSaveIndexAndAppliedBusiReqBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscSaveIndexAndAppliedBusiRspBO;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfscSaveIndexAndAppliedBusiServiceImpl
implements PfscSaveIndexAndAppliedBusiService {
    @Autowired
    private ApplyQueryIndexMapper applyQueryIndexMapper;
    @Autowired
    private OrderItemInfoMapper orderItemInfoMapper;
    @Autowired
    private OrderInfoMapper orderInfoMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PfscSaveIndexAndAppliedBusiRspBO saveIndexAndApplied(PfscSaveIndexAndAppliedBusiReqBO reqBo) {
        PfscSaveIndexAndAppliedBusiRspBO rspBo = new PfscSaveIndexAndAppliedBusiRspBO();
        if ("all".equals(reqBo.getType())) {
            this.saveApplyQueryIndex(reqBo);
            if (CollectionUtils.isNotEmpty(reqBo.getSaleItemInfoList())) {
                this.updateAppliedData(reqBo);
            }
        }
        this.updateOrderInfo(reqBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u4fdd\u5b58\u7d22\u5f15\u6210\u529f");
        return rspBo;
    }

    private void saveApplyQueryIndex(PfscSaveIndexAndAppliedBusiReqBO reqBo) {
        ApplyQueryIndexPO indexPo = new ApplyQueryIndexPO();
        indexPo.setOrderId(reqBo.getOrderId());
        indexPo.setApplyNo(reqBo.getApplyNo());
        int result = this.applyQueryIndexMapper.insert(indexPo);
        if (result < 1) {
            throw new PfscBusinessException("18004", "\u4fdd\u5b58\u7d22\u5f15\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void updateAppliedData(PfscSaveIndexAndAppliedBusiReqBO reqBo) {
        List<OrderItemInfoPO> orderItemInfoPoList = reqBo.getSaleItemInfoList();
        for (OrderItemInfoPO itemPo : orderItemInfoPoList) {
            BigDecimal redEnvelopeFee = itemPo.getRedEnvelopeFee() == null ? BigDecimal.ZERO : itemPo.getRedEnvelopeFee();
            BigDecimal reduceFee = itemPo.getReduceFee() == null ? BigDecimal.ZERO : itemPo.getReduceFee();
            BigDecimal refundFee = itemPo.getRefundFee() == null ? BigDecimal.ZERO : itemPo.getRefundFee();
            BigDecimal totalFee = redEnvelopeFee.add(reduceFee).add(refundFee);
            BigDecimal unitPrice = itemPo.getSaleUnitPrice();
            BigDecimal quantity = itemPo.getQuantity();
            BigDecimal returnQuantity = itemPo.getReturnQuantity() == null ? BigDecimal.ZERO : itemPo.getReturnQuantity();
            BigDecimal quantityApplied = quantity.subtract(returnQuantity);
            BigDecimal totalAmt = unitPrice.multiply(quantityApplied);
            BigDecimal amountApplied = totalAmt.subtract(totalFee);
            OrderItemInfoPO reqPo = new OrderItemInfoPO();
            reqPo.setSeq(itemPo.getSeq());
            reqPo.setAmountApplied(amountApplied);
            reqPo.setQuantityApplied(quantityApplied);
            int updateResult = this.orderItemInfoMapper.updateByIdCondition(reqPo);
            if (updateResult >= 1) continue;
            throw new PfscBusinessException("18006", "\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u8868\u5df2\u63d0\u4ea4\u6570\u91cf\u548c\u91d1\u989d\u5931\u8d25");
        }
    }

    private void updateOrderInfo(PfscSaveIndexAndAppliedBusiReqBO reqBo) {
        OrderInfoPO orderInfoPO = new OrderInfoPO();
        orderInfoPO.setOrderId(reqBo.getOrderId());
        orderInfoPO.setApplyNo(reqBo.getApplyNo());
        orderInfoPO.setOrderStatus(reqBo.getOrderStatus());
        int updateResult = this.orderInfoMapper.updateStatusAndApplyNo(orderInfoPO);
        if (updateResult < 1) {
            throw new PfscBusinessException("18006", "\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u8868\u72b6\u6001\u548c\u7533\u8bf7\u5355\u53f7\u5931\u8d25");
        }
    }
}

