/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.invoice.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.pfsc.exception.PfscBusinessException;
import com.tydic.pfsc.invoice.PfscElecInvoiceApplyByReqAbilityService;
import com.tydic.pfsc.invoice.bo.PfscElecInvoiceApplyByReqAbilityReqBO;
import com.tydic.pfsc.invoice.bo.PfscElecInvoiceApplyByReqAbilityRspBO;
import com.tydic.pfsc.invoice.bo.common.PfscSaleItemInfoBO;
import com.tydic.pfsc.service.invoice.comb.PfscElecInvoiceApplyByReqCombService;
import java.math.BigDecimal;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="PFSC_GROUP_DEV", serviceInterface=PfscElecInvoiceApplyByReqAbilityService.class)
public class PfscElecInvoiceApplyByReqAbilityServiceImpl
implements PfscElecInvoiceApplyByReqAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PfscElecInvoiceApplyByReqAbilityServiceImpl.class);
    private final PfscElecInvoiceApplyByReqCombService pfscElecInvoiceApplyByReqCombService;

    @Autowired
    public PfscElecInvoiceApplyByReqAbilityServiceImpl(PfscElecInvoiceApplyByReqCombService pfscElecInvoiceApplyByReqCombService) {
        this.pfscElecInvoiceApplyByReqCombService = pfscElecInvoiceApplyByReqCombService;
    }

    public PfscElecInvoiceApplyByReqAbilityRspBO commitElecInvoiceApply(PfscElecInvoiceApplyByReqAbilityReqBO reqBo) {
        log.debug("\u5f00\u7968\u7533\u8bf7(byReq)\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        this.validateParams(reqBo);
        return this.pfscElecInvoiceApplyByReqCombService.commitElecInvoiceApply(reqBo);
    }

    private void validateParams(PfscElecInvoiceApplyByReqAbilityReqBO reqBo) {
        String redBlue;
        String string = redBlue = reqBo.getRedBlue() == null ? "blue" : reqBo.getRedBlue();
        if (null == reqBo) {
            throw new PfscBusinessException("18000", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrgIdIn()) {
            throw new PfscBusinessException("18001", "\u673a\u6784\uff08\u5546\u6237\uff09ID\u3010orgIdIn\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getShopIdIn()) {
            throw new PfscBusinessException("18001", "\u5e97\u94faID\u3010shopIdIn\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new PfscBusinessException("18001", "\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAmount()) {
            throw new PfscBusinessException("18001", "\u91d1\u989d\uff08\u542b\u7a0e\uff09\u3010amount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("red".equals(redBlue)) {
            if (reqBo.getAmount().compareTo(BigDecimal.ZERO) >= 0) {
                throw new PfscBusinessException("18002", "\u5f00\u7ea2\u7968\u65f6\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e0");
            }
        } else if ("blue".equals(redBlue)) {
            if (reqBo.getAmount().compareTo(BigDecimal.ZERO) <= 0) {
                throw new PfscBusinessException("18002", "\u5f00\u84dd\u7968\u65f6\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
        } else {
            throw new PfscBusinessException("18002", "\u5f00\u7968\u7c7b\u578b\u5fc5\u987b\u662f\u7ea2\u7968'red'\u6216\u8005\u84dd\u7968'blue'\uff0c\u4e0d\u4f20\u5219\u9ed8\u8ba4\u662f'blue'");
        }
        this.validateBusiInvoiceInfo(reqBo);
        this.validateSaleItemInfo(reqBo);
        this.validateOrderInvoiceInfo(reqBo);
    }

    private void validateBusiInvoiceInfo(PfscElecInvoiceApplyByReqAbilityReqBO reqBo) {
        if (null == reqBo.getBusiInvoiceInfoBo()) {
            throw new PfscBusinessException("18001", "\u5546\u6237\u5f00\u7968\u4fe1\u606fBO\u3010busiInvoiceInfoBo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getBusiInvoiceInfoBo().getPayeeName()) {
            throw new PfscBusinessException("18001", "\u5f00\u7968\u65b9\u540d\u79f0\u3010payeeName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getBusiInvoiceInfoBo().getPayeeRegisterNo()) {
            throw new PfscBusinessException("18001", "\u5f00\u7968\u65b9\u7a0e\u52a1\u767b\u8bb0\u8bc1\u53f7\u3010payeeRegisterNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getBusiInvoiceInfoBo().getPayeeAddress()) {
            throw new PfscBusinessException("18001", "\u5f00\u7968\u65b9\u5730\u5740\u3010payeeAddress\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getBusiInvoiceInfoBo().getPayeePhone()) {
            throw new PfscBusinessException("18001", "\u5f00\u7968\u65b9\u7535\u8bdd\u3010payeePhone\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getBusiInvoiceInfoBo().getPayeeOperator()) {
            throw new PfscBusinessException("18001", "\u5f00\u7968\u4eba\u3010payeeOperator\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateSaleItemInfo(PfscElecInvoiceApplyByReqAbilityReqBO reqBo) {
        String redBlue;
        String string = redBlue = reqBo.getRedBlue() == null ? "blue" : reqBo.getRedBlue();
        if (CollectionUtils.isEmpty((Collection)reqBo.getSaleItemInfoList())) {
            throw new PfscBusinessException("18001", "\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u3010saleItemInfoList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (PfscSaleItemInfoBO bo : reqBo.getSaleItemInfoList()) {
            if (null == bo.getItemNo()) {
                throw new PfscBusinessException("18001", "\u5546\u54c1\u7f16\u53f7\u3010itemNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == bo.getSkuName()) {
                throw new PfscBusinessException("18001", "\u5546\u54c1\u540d\u79f0\u3010skuName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == bo.getSaleUnitPrice()) {
                throw new PfscBusinessException("18001", "\u5355\u4ef7\u3010saleUnitPrice\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == bo.getQuantity()) {
                throw new PfscBusinessException("18001", "\u6570\u91cf\u3010quantity\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if ("red".equals(redBlue) && bo.getQuantity().compareTo(BigDecimal.ZERO) >= 0) {
                throw new PfscBusinessException("18002", "\u5f00\u7ea2\u7968\u65f6\u6570\u91cf\u5fc5\u987b\u662f\u8d1f\u6570");
            }
            if ("blue".equals(redBlue) && bo.getQuantity().compareTo(BigDecimal.ZERO) <= 0) {
                throw new PfscBusinessException("18002", "\u5f00\u84dd\u7968\u65f6\u6570\u91cf\u5fc5\u987b\u662f\u6b63\u6570");
            }
            if (null != bo.getUnitName()) continue;
            throw new PfscBusinessException("18001", "\u5355\u4f4d\u3010unitName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateOrderInvoiceInfo(PfscElecInvoiceApplyByReqAbilityReqBO reqBo) {
        if (null == reqBo.getOrderInvoiceInfoBo()) {
            throw new PfscBusinessException("18001", "\u8ba2\u5355\u5f00\u7968\u4fe1\u606fBO\u3010orderInvoiceInfoBo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderInvoiceInfoBo().getInvoiceNameType()) {
            throw new PfscBusinessException("18001", "\u53d1\u7968\u62ac\u5934\u7c7b\u578b\u3010invoiceNameType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderInvoiceInfoBo().getInvoiceName()) {
            throw new PfscBusinessException("18001", "\u53d1\u7968\u62ac\u5934\u3010invoiceName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderInvoiceInfoBo().getReceiveInvoiceEmail()) {
            throw new PfscBusinessException("18001", "\u63a5\u6536\u53d1\u7968\u90ae\u7bb1\u3010receiveInvoicePhone\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderInvoiceInfoBo().getReceiveInvoicePhone()) {
            throw new PfscBusinessException("18001", "\u63a5\u6536\u53d1\u7968\u624b\u673a\u3010receiveInvoicePhone\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

