/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.invoice.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.pfsc.constant.PfscConstants;
import com.tydic.pfsc.exception.PfscBusinessException;
import com.tydic.pfsc.external.api.einvoice.IfcReqCreateEinvoiceIntfService;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceItemBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcReqCreateEinvoiceReqBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcReqCreateEinvoiceRspBO;
import com.tydic.pfsc.po.ApplyInfoPO;
import com.tydic.pfsc.po.ApplyItemInfoPO;
import com.tydic.pfsc.po.ApplyReceiveInfoPO;
import com.tydic.pfsc.po.BusiInvoiceInfoPO;
import com.tydic.pfsc.po.OrderInfoPO;
import com.tydic.pfsc.po.OrderInvoiceInfoPO;
import com.tydic.pfsc.po.OrderItemInfoPO;
import com.tydic.pfsc.service.invoice.atom.PfscElecApplyAtomService;
import com.tydic.pfsc.service.invoice.atom.PfscElecInvoiceApplySaveAtomService;
import com.tydic.pfsc.service.invoice.atom.bo.PfscElecApplyAtomReqBO;
import com.tydic.pfsc.service.invoice.atom.bo.PfscElecApplyAtomRspBO;
import com.tydic.pfsc.service.invoice.atom.bo.PfscElecInvoiceApplyAtomReqBO;
import com.tydic.pfsc.service.invoice.atom.bo.PfscElecInvoiceApplyAtomRspBO;
import com.tydic.pfsc.service.invoice.busi.PfscElecInvoiceApplyParamBusiService;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyParamBusiReqBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyParamBusiRspBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyTmpBO;
import com.tydic.pfsc.service.invoice.common.bo.PfscBillApplyInfoBO;
import com.tydic.pfsc.service.invoice.common.bo.PfscBillApplyItemInfoBO;
import com.tydic.pfsc.service.invoice.common.bo.PfscBillApplyReceiveInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PfscElecApplyAtomServiceImpl
implements PfscElecApplyAtomService {
    private static final Logger logger = LoggerFactory.getLogger(PfscElecApplyAtomServiceImpl.class);
    @Autowired
    private IfcReqCreateEinvoiceIntfService ifcReqCreateEinvoiceIntfService;
    @Autowired
    private PfscElecInvoiceApplySaveAtomService pfscElecInvoiceApplySaveAtomService;
    @Autowired
    private PfscElecInvoiceApplyParamBusiService pfscElecInvoiceApplyParamBusiService;

    @Override
    public PfscElecApplyAtomRspBO dealApply(PfscElecApplyAtomReqBO reqBo) {
        PfscElecApplyAtomRspBO rspBO = new PfscElecApplyAtomRspBO();
        PfscElecInvoiceApplyParamBusiReqBO paramBusiReqBo = new PfscElecInvoiceApplyParamBusiReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)((Object)paramBusiReqBo));
        PfscElecInvoiceApplyParamBusiRspBO paramBusiRspBo = this.pfscElecInvoiceApplyParamBusiService.applyCommonParam(paramBusiReqBo);
        if (!"0000".equals(paramBusiRspBo.getRespCode())) {
            throw new PfscBusinessException("8888", "\u8c03\u7528\u7535\u5b50\u53d1\u7968\u7533\u8bf7\u63d0\u4ea4\u5171\u7528\u5165\u53c2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + paramBusiRspBo.getRespDesc());
        }
        PfscElecInvoiceApplyTmpBO pfscElecInvoiceApplyTmpBO = this.recordBillApplyItemInfo(paramBusiRspBo);
        ApplyInfoPO applyInfoPo = this.recordBillApplyInfo(reqBo, paramBusiRspBo, reqBo.getOrderInfoPo(), pfscElecInvoiceApplyTmpBO);
        ApplyReceiveInfoPO applyReceiveInfoPo = this.recordBillApplyReceiveInfo(paramBusiRspBo);
        IfcReqCreateEinvoiceReqBO einvoiceReqBo = this.buildReqParams(paramBusiRspBo, pfscElecInvoiceApplyTmpBO);
        if (logger.isDebugEnabled()) {
            logger.debug("\u963f\u91cc\u5f00\u7968\u7533\u8bf7\u5165\u53c2\uff1a" + JSON.toJSONString((Object)einvoiceReqBo));
        }
        IfcReqCreateEinvoiceRspBO einvoiceRspBo = this.ifcReqCreateEinvoiceIntfService.requestToCreateEinvoice(einvoiceReqBo);
        if (logger.isDebugEnabled()) {
            logger.debug("\u963f\u91cc\u5f00\u7968\u7533\u8bf7\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)einvoiceRspBo));
        }
        PfscElecInvoiceApplyAtomReqBO applyAtomReqBo = new PfscElecInvoiceApplyAtomReqBO();
        PfscBillApplyInfoBO pfscBillApplyInfoBo = new PfscBillApplyInfoBO();
        PfscBillApplyReceiveInfoBO pfscBillApplyReceiveInfoBo = new PfscBillApplyReceiveInfoBO();
        ArrayList<PfscBillApplyItemInfoBO> pfscBillApplyItemInfoList = new ArrayList<PfscBillApplyItemInfoBO>();
        BeanUtils.copyProperties((Object)applyInfoPo, (Object)pfscBillApplyInfoBo);
        BeanUtils.copyProperties((Object)applyReceiveInfoPo, (Object)pfscBillApplyReceiveInfoBo);
        for (ApplyItemInfoPO applyItemInfoPo : pfscElecInvoiceApplyTmpBO.getBillApplyItemInfoList()) {
            PfscBillApplyItemInfoBO pfscBillApplyItemInfoBo = new PfscBillApplyItemInfoBO();
            BeanUtils.copyProperties((Object)applyItemInfoPo, (Object)pfscBillApplyItemInfoBo);
            pfscBillApplyItemInfoList.add(pfscBillApplyItemInfoBo);
        }
        if (null == einvoiceRspBo.getIsSuccess() || !einvoiceRspBo.getIsSuccess().booleanValue()) {
            pfscBillApplyInfoBo.setBillStatus(PfscConstants.BillApplyInfo.BillStatus.UNSUBMITTED);
            pfscBillApplyInfoBo.setRemark(einvoiceRspBo.getSubMsg());
            rspBO.setFailDesc(einvoiceRspBo.getSubMsg());
        }
        applyAtomReqBo.setPfscBillApplyInfo(pfscBillApplyInfoBo);
        applyAtomReqBo.setPfscBillApplyReceiveInfo(pfscBillApplyReceiveInfoBo);
        applyAtomReqBo.setBillApplyItemList(pfscBillApplyItemInfoList);
        PfscElecInvoiceApplyAtomRspBO applyAtomRspBo = this.pfscElecInvoiceApplySaveAtomService.saveApplyInfo(applyAtomReqBo);
        if (!"0000".equals(applyAtomRspBo.getRespCode())) {
            throw new PfscBusinessException("8888", "\u4fdd\u5b58\u7533\u8bf7\u4fe1\u606f\u5931\u8d25");
        }
        rspBO.setSaleItemInfoList(paramBusiRspBo.getSaleItemInfoList());
        rspBO.setApplyNo(paramBusiRspBo.getDzfpNo());
        rspBO.setOrderStatus(pfscBillApplyInfoBo.getBillStatus());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7535\u5b50\u53d1\u7968\u7533\u8bf7\u6210\u529f");
        return rspBO;
    }

    private IfcReqCreateEinvoiceReqBO buildReqParams(PfscElecInvoiceApplyParamBusiRspBO paramBusiRspBo, PfscElecInvoiceApplyTmpBO tmpBO) {
        OrderInvoiceInfoPO orderInvoiceInfoPo = paramBusiRspBo.getOrderInvoiceInfo();
        BusiInvoiceInfoPO busiInvoiceInfoPo = paramBusiRspBo.getBusiInvoiceInfo();
        IfcReqCreateEinvoiceReqBO einvoiceReqBo = new IfcReqCreateEinvoiceReqBO();
        einvoiceReqBo.setBusinessType(Long.valueOf(orderInvoiceInfoPo.getInvoiceNameType().longValue()));
        einvoiceReqBo.setPlatformTid(paramBusiRspBo.getDzfpNo().toString());
        einvoiceReqBo.setPlatformCode("OTHER");
        einvoiceReqBo.setOutShopName("\u534e\u6cca\u79d1\u6280-\u5f00\u7968");
        einvoiceReqBo.setInvoiceType("blue");
        einvoiceReqBo.setPayerName(orderInvoiceInfoPo.getInvoiceName());
        einvoiceReqBo.setPayerEmail(orderInvoiceInfoPo.getReceiveInvoiceEmail());
        if ("1".equals(einvoiceReqBo.getBusinessType())) {
            einvoiceReqBo.setPayerRegisterNo(orderInvoiceInfoPo.getTaxNo());
        }
        einvoiceReqBo.setSerialNo(paramBusiRspBo.getSerialNo());
        einvoiceReqBo.setPayeeAddress(busiInvoiceInfoPo.getPayeeAddress());
        einvoiceReqBo.setPayeeName(busiInvoiceInfoPo.getPayeeName());
        einvoiceReqBo.setPayeeRegisterNo(busiInvoiceInfoPo.getPayeeRegisterNo());
        List<IfcEinvoiceItemBO> invoiceItems = this.buildIfcEinvoiceItems(tmpBO);
        einvoiceReqBo.setSumTax(String.valueOf(tmpBO.getSumTax()));
        einvoiceReqBo.setSumPrice(String.valueOf(tmpBO.getSumPrice()));
        einvoiceReqBo.setInvoiceAmount(String.valueOf(tmpBO.getInvoiceAmount()));
        einvoiceReqBo.setInvoiceItems(invoiceItems);
        return einvoiceReqBo;
    }

    private PfscElecInvoiceApplyTmpBO recordBillApplyItemInfo(PfscElecInvoiceApplyParamBusiRspBO paramBusiRspBo) {
        PfscElecInvoiceApplyTmpBO tmpBO = new PfscElecInvoiceApplyTmpBO();
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        BigDecimal sumPrice = BigDecimal.ZERO;
        BigDecimal sumTax = BigDecimal.ZERO;
        ArrayList<ApplyItemInfoPO> billApplyItemInfoList = new ArrayList<ApplyItemInfoPO>();
        List<OrderItemInfoPO> saleItemInfoList = paramBusiRspBo.getSaleItemInfoList();
        for (OrderItemInfoPO orderItemInfoPo : saleItemInfoList) {
            ApplyItemInfoPO normalItemPo = new ApplyItemInfoPO();
            BeanUtils.copyProperties((Object)orderItemInfoPo, (Object)normalItemPo);
            BigDecimal taxRate = orderItemInfoPo.getTaxRate();
            normalItemPo.setApplyNo(paramBusiRspBo.getDzfpNo());
            normalItemPo.setSerialNo(paramBusiRspBo.getSerialNo());
            normalItemPo.setItemName(orderItemInfoPo.getSkuName());
            normalItemPo.setStatus(PfscConstants.StatusType.VALID);
            normalItemPo.setUnit(orderItemInfoPo.getUnitName());
            BigDecimal normalAmount = orderItemInfoPo.getTotalAmt();
            BigDecimal normalUntaxAmt = normalAmount.divide(taxRate.add(BigDecimal.ONE), 6, 6);
            BigDecimal normalTaxAmt = normalUntaxAmt.multiply(taxRate).setScale(6, 6);
            BigDecimal normalPrice = normalUntaxAmt.divide(normalItemPo.getQuantity(), 6, 6);
            normalItemPo.setAmount(normalAmount);
            normalItemPo.setUntaxAmt(normalUntaxAmt.setScale(2, 6));
            normalItemPo.setTaxAmt(normalTaxAmt.setScale(2, 6));
            normalItemPo.setPrice(normalPrice.setScale(2, 6));
            BigDecimal redEnvelopeFee = orderItemInfoPo.getRedEnvelopeFee();
            BigDecimal reduceFee = orderItemInfoPo.getReduceFee();
            BigDecimal actFee = orderItemInfoPo.getActFee();
            if (redEnvelopeFee.compareTo(BigDecimal.ZERO) > 0 || reduceFee.compareTo(BigDecimal.ZERO) > 0 || actFee.compareTo(BigDecimal.ZERO) > 0) {
                ApplyItemInfoPO discountItemPo = new ApplyItemInfoPO();
                ApplyItemInfoPO discountedItemPo = new ApplyItemInfoPO();
                BeanUtils.copyProperties((Object)normalItemPo, (Object)discountedItemPo);
                discountItemPo.setRowType(PfscConstants.RowType.DISCOUNT_LINE);
                discountedItemPo.setRowType(PfscConstants.RowType.DISCOUNTED_LINE);
                BigDecimal discountAmount = redEnvelopeFee.add(reduceFee).add(actFee).negate();
                BigDecimal discountUntaxAmt = discountAmount.divide(BigDecimal.ONE.add(taxRate), 6, 6);
                BigDecimal discountTaxAmt = discountUntaxAmt.multiply(taxRate).setScale(6, 6);
                discountItemPo.setAmount(discountAmount);
                discountItemPo.setUntaxAmt(discountUntaxAmt.setScale(2, 6));
                discountItemPo.setTaxAmt(discountTaxAmt.setScale(2, 6));
                discountItemPo.setItemName(normalItemPo.getItemName());
                discountItemPo.setItemNo(normalItemPo.getItemNo());
                discountItemPo.setTaxRate(normalItemPo.getTaxRate());
                discountItemPo.setSeq(normalItemPo.getSeq());
                discountItemPo.setApplyNo(normalItemPo.getApplyNo());
                discountItemPo.setStatus(normalItemPo.getStatus());
                discountItemPo.setSerialNo(normalItemPo.getSerialNo());
                billApplyItemInfoList.add(discountedItemPo);
                billApplyItemInfoList.add(discountItemPo);
                sumPrice = sumPrice.add(discountItemPo.getUntaxAmt()).add(discountedItemPo.getUntaxAmt());
                sumTax = sumTax.add(discountItemPo.getTaxAmt()).add(discountedItemPo.getTaxAmt());
                invoiceAmount = invoiceAmount.add(discountItemPo.getAmount()).add(discountedItemPo.getAmount());
                continue;
            }
            normalItemPo.setRowType(PfscConstants.RowType.NORMAL_LINE);
            billApplyItemInfoList.add(normalItemPo);
            sumPrice = sumPrice.add(normalItemPo.getUntaxAmt());
            sumTax = sumTax.add(normalItemPo.getTaxAmt());
            invoiceAmount = invoiceAmount.add(normalItemPo.getAmount());
        }
        tmpBO.setInvoiceAmount(invoiceAmount);
        tmpBO.setSumPrice(sumPrice);
        tmpBO.setSumTax(sumTax);
        tmpBO.setBillApplyItemInfoList(billApplyItemInfoList);
        return tmpBO;
    }

    private List<IfcEinvoiceItemBO> buildIfcEinvoiceItems(PfscElecInvoiceApplyTmpBO tmpBO) {
        ArrayList<IfcEinvoiceItemBO> invoiceItems = new ArrayList<IfcEinvoiceItemBO>();
        for (ApplyItemInfoPO itemInfoPo : tmpBO.getBillApplyItemInfoList()) {
            IfcEinvoiceItemBO ifcEinvoiceItemBo = new IfcEinvoiceItemBO();
            ifcEinvoiceItemBo.setItemName(itemInfoPo.getItemName());
            ifcEinvoiceItemBo.setItemNo(String.valueOf(itemInfoPo.getItemNo()));
            ifcEinvoiceItemBo.setTaxRate(String.valueOf(itemInfoPo.getTaxRate()));
            ifcEinvoiceItemBo.setAmount(String.valueOf(itemInfoPo.getAmount()));
            ifcEinvoiceItemBo.setSumPrice(String.valueOf(itemInfoPo.getUntaxAmt()));
            ifcEinvoiceItemBo.setTax(String.valueOf(itemInfoPo.getTaxAmt()));
            if (itemInfoPo.getPrice() != null) {
                ifcEinvoiceItemBo.setPrice(String.valueOf(itemInfoPo.getPrice()));
            }
            if (itemInfoPo.getQuantity() != null) {
                ifcEinvoiceItemBo.setQuantity(String.valueOf(itemInfoPo.getQuantity()));
            }
            ifcEinvoiceItemBo.setUnit(itemInfoPo.getUnit());
            ifcEinvoiceItemBo.setRowType(String.valueOf(itemInfoPo.getRowType()));
            invoiceItems.add(ifcEinvoiceItemBo);
        }
        return invoiceItems;
    }

    private ApplyReceiveInfoPO recordBillApplyReceiveInfo(PfscElecInvoiceApplyParamBusiRspBO paramBusiRspBo) {
        OrderInvoiceInfoPO orderInvoiceInfoPo = paramBusiRspBo.getOrderInvoiceInfo();
        ApplyReceiveInfoPO applyReceiveInfoPo = new ApplyReceiveInfoPO();
        applyReceiveInfoPo.setApplyNo(paramBusiRspBo.getDzfpNo());
        applyReceiveInfoPo.setAddrDesc(orderInvoiceInfoPo.getAddr());
        applyReceiveInfoPo.setMobile(orderInvoiceInfoPo.getPhone());
        applyReceiveInfoPo.setReceiveInvoicePhone(orderInvoiceInfoPo.getReceiveInvoicePhone());
        applyReceiveInfoPo.setReceiveInvoiceEmail(orderInvoiceInfoPo.getReceiveInvoiceEmail());
        return applyReceiveInfoPo;
    }

    private ApplyInfoPO recordBillApplyInfo(PfscElecApplyAtomReqBO reqBo, PfscElecInvoiceApplyParamBusiRspBO paramBusiRspBo, OrderInfoPO orderInfoPo, PfscElecInvoiceApplyTmpBO temBo) {
        OrderInvoiceInfoPO orderInvoiceInfoPo = paramBusiRspBo.getOrderInvoiceInfo();
        BusiInvoiceInfoPO busiInvoiceInfoPo = paramBusiRspBo.getBusiInvoiceInfo();
        ApplyInfoPO applyInfoPo = new ApplyInfoPO();
        applyInfoPo.setApplyNo(paramBusiRspBo.getDzfpNo());
        applyInfoPo.setApplyCode(paramBusiRspBo.getApplyCode());
        applyInfoPo.setSupplierId(reqBo.getOrgIdIn());
        applyInfoPo.setSupplierShopId(reqBo.getShopIdIn());
        applyInfoPo.setRedBlue("blue");
        applyInfoPo.setApplyDate(new Date());
        applyInfoPo.setBillStatus(PfscConstants.BillApplyInfo.BillStatus.INVOICING);
        applyInfoPo.setApplyType(PfscConstants.BillApplyInfo.ApplyType.BY_ORDER);
        applyInfoPo.setInvoiceType(orderInvoiceInfoPo.getInvoiceNameType());
        applyInfoPo.setTaxNo(orderInvoiceInfoPo.getTaxNo());
        applyInfoPo.setAddr(orderInvoiceInfoPo.getAddr());
        applyInfoPo.setPhone(orderInvoiceInfoPo.getPhone());
        applyInfoPo.setBankName(orderInvoiceInfoPo.getBankName());
        applyInfoPo.setBankAcctNo(orderInvoiceInfoPo.getBankAcctNo());
        applyInfoPo.setInvoceName(orderInvoiceInfoPo.getInvoiceName());
        applyInfoPo.setInvoceNameType(orderInvoiceInfoPo.getInvoiceNameType());
        applyInfoPo.setPurchaseNo(orderInfoPo.getPurchaseNo());
        applyInfoPo.setPurchaseProjectId(orderInfoPo.getPurchaseProjectId());
        applyInfoPo.setOperUnitNo(orderInfoPo.getOperUnitNo());
        applyInfoPo.setOperUnitName(orderInfoPo.getOperUnitName());
        applyInfoPo.setBranchCompany(orderInfoPo.getBranchCompany());
        applyInfoPo.setRemark(orderInfoPo.getRemark());
        applyInfoPo.setUserId(orderInfoPo.getPurchaserId());
        applyInfoPo.setSource(orderInfoPo.getSource());
        applyInfoPo.setSerialNo(paramBusiRspBo.getSerialNo());
        applyInfoPo.setAmt(temBo.getInvoiceAmount());
        applyInfoPo.setUntaxAmt(temBo.getSumPrice());
        applyInfoPo.setTaxAmt(temBo.getSumTax());
        applyInfoPo.setTaxRate(String.valueOf(PfscConstants.TAX_RATE));
        applyInfoPo.setPayeeName(busiInvoiceInfoPo.getPayeeName());
        applyInfoPo.setPayeeRegisterNo(busiInvoiceInfoPo.getPayeeRegisterNo());
        applyInfoPo.setPayeeAddress(busiInvoiceInfoPo.getPayeeAddress());
        applyInfoPo.setPayeePhone(busiInvoiceInfoPo.getPayeePhone());
        applyInfoPo.setPayeeOperator(busiInvoiceInfoPo.getPayeeOperator());
        return applyInfoPo;
    }
}

