/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.invoice.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.pfsc.constant.PfscConstants;
import com.tydic.pfsc.dao.ApplyReceiveInfoMapper;
import com.tydic.pfsc.dao.InvoiceInfoMapper;
import com.tydic.pfsc.exception.PfscBusinessException;
import com.tydic.pfsc.external.api.einvoice.IfcEinvoiceCallHttpSendMessageService;
import com.tydic.pfsc.external.api.einvoice.IfcEinvoiceSendMailIntfService;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceCallHttpSendMessageReqBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceCallHttpSendMessageRspBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceSendMailReqBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceSendMailRspBO;
import com.tydic.pfsc.po.ApplyReceiveInfoPO;
import com.tydic.pfsc.po.InvoiceInfoPO;
import com.tydic.pfsc.service.invoice.atom.PfscElecInvoiceNotifyAtomService;
import com.tydic.pfsc.service.invoice.atom.bo.PfscElecInvoiceNotifyAtomReqBO;
import com.tydic.pfsc.service.invoice.atom.bo.PfscElecInvoiceNotifyAtomRspBO;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PfscElecInvoiceNotifyAtomServiceImpl
implements PfscElecInvoiceNotifyAtomService {
    private static final Logger logger = LoggerFactory.getLogger(PfscElecInvoiceNotifyAtomServiceImpl.class);
    private final InvoiceInfoMapper invoiceInfoMapper;
    private final ApplyReceiveInfoMapper applyReceiveInfoMapper;
    private final IfcEinvoiceCallHttpSendMessageService ifcEinvoiceCallHttpSendMessageService;
    private final IfcEinvoiceSendMailIntfService ifcEinvoiceSendMailIntfService;

    @Autowired
    public PfscElecInvoiceNotifyAtomServiceImpl(InvoiceInfoMapper invoiceInfoMapper, ApplyReceiveInfoMapper applyReceiveInfoMapper, IfcEinvoiceCallHttpSendMessageService ifcEinvoiceCallHttpSendMessageService, IfcEinvoiceSendMailIntfService ifcEinvoiceSendMailIntfService) {
        this.invoiceInfoMapper = invoiceInfoMapper;
        this.applyReceiveInfoMapper = applyReceiveInfoMapper;
        this.ifcEinvoiceCallHttpSendMessageService = ifcEinvoiceCallHttpSendMessageService;
        this.ifcEinvoiceSendMailIntfService = ifcEinvoiceSendMailIntfService;
    }

    @Override
    public PfscElecInvoiceNotifyAtomRspBO dealInvoiceNotify(PfscElecInvoiceNotifyAtomReqBO reqBo) {
        PfscElecInvoiceNotifyAtomRspBO rspBo = new PfscElecInvoiceNotifyAtomRspBO();
        Integer notified = PfscConstants.NotifyStatus.NOTIFIED;
        String content = "\u6e29\u99a8\u63d0\u793a\uff1a\u6839\u636e\u56fd\u5bb6\u8981\u6c42\u5b9e\u884c\u7535\u5b50\u53d1\u7968\uff0c\u60a8\u672c\u6b21\u529e\u7406\u7684\u4e1a\u52a1\u8ba2\u5355\u53f7\u4e3a" + reqBo.getOrderId() + "\uff0c\u672c\u6b21\u751f\u6210\u7684\u7535\u5b50\u53d1\u7968\u4ee3\u7801\u4e3a" + reqBo.getInvoiceCode() + "\uff0c\u53d1\u7968\u53f7\u7801\u4e3a" + reqBo.getInvoiceNo() + "\uff0c\u5f00\u7968\u65e5\u671f\u4e3a" + reqBo.getInvoiceDate() + "\uff0c\u5f00\u7968\u91d1\u989d\u4e3a" + reqBo.getAmt() + "\uff0c\u6821\u9a8c\u7801\u4e3a" + reqBo.getAntiFakeCode() + "\u3002\u60a8\u53ef\u767b\u5f55APP\u8fdb\u884c\u67e5\u9a8c\u3002\u611f\u8c22\u60a8\u7684\u4f7f\u7528\u3002";
        String filePath = reqBo.getFilePath();
        boolean sendFlag = false;
        ApplyReceiveInfoPO applyReceiveInfoPo = this.qryBillApplyReceiveInfo(reqBo.getApplyNo());
        if (null != applyReceiveInfoPo.getReceiveInvoicePhone()) {
            IfcEinvoiceCallHttpSendMessageReqBO messageReqBo = new IfcEinvoiceCallHttpSendMessageReqBO();
            messageReqBo.setContent(content);
            messageReqBo.setMobile(applyReceiveInfoPo.getReceiveInvoicePhone());
            IfcEinvoiceCallHttpSendMessageRspBO messageRspBo = this.ifcEinvoiceCallHttpSendMessageService.callHttpSendMessage(messageReqBo);
            if (logger.isDebugEnabled()) {
                logger.debug("\u53d1\u9001\u77ed\u4fe1\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)messageRspBo));
            }
            if ("0000".equals(messageRspBo.getRespCode())) {
                sendFlag = true;
            }
        }
        if (null != applyReceiveInfoPo.getReceiveInvoiceEmail()) {
            IfcEinvoiceSendMailReqBO mailReqBo = new IfcEinvoiceSendMailReqBO();
            mailReqBo.setToUser(applyReceiveInfoPo.getReceiveInvoiceEmail());
            mailReqBo.setText(content);
            ArrayList<String> filePaths = new ArrayList<String>();
            filePaths.add(filePath);
            mailReqBo.setFilePaths(filePaths);
            IfcEinvoiceSendMailRspBO mailRspBo = this.ifcEinvoiceSendMailIntfService.sendMail(mailReqBo);
            if (logger.isDebugEnabled()) {
                logger.debug("\u53d1\u9001\u90ae\u4ef6\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)mailRspBo));
            }
            if ("0000".equals(mailRspBo.getRespCode())) {
                sendFlag = true;
            }
        }
        if (sendFlag) {
            InvoiceInfoPO statePo = new InvoiceInfoPO();
            statePo.setNotifyStatus(notified);
            statePo.setApplyNo(reqBo.getApplyNo());
            statePo.setSerialNo(reqBo.getSerialNo());
            int result = this.invoiceInfoMapper.updateState(statePo);
            if (result < 1) {
                throw new PfscBusinessException("18006", "\u66f4\u6539\u53d1\u7968\u4fe1\u606f\u8868\u4e3a\u5df2\u901a\u77e5\u5931\u8d25");
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u7535\u5b50\u53d1\u7968\u901a\u77e5\u6210\u529f");
        return rspBo;
    }

    private ApplyReceiveInfoPO qryBillApplyReceiveInfo(Long applyNo) {
        ApplyReceiveInfoPO qryPo = new ApplyReceiveInfoPO();
        qryPo.setApplyNo(applyNo);
        ApplyReceiveInfoPO resultPo = this.applyReceiveInfoMapper.getModelBy(qryPo);
        if (null == resultPo) {
            throw new PfscBusinessException("18003", "\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u6536\u7968\u4fe1\u606f\u8868\u7ed3\u679c\u4e3a\u7a7a");
        }
        return resultPo;
    }
}

