/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.invoice.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfsc.exception.PfscBusinessException;
import com.tydic.pfsc.invoice.PfscPushOrderInfoAbilityService;
import com.tydic.pfsc.invoice.bo.PfscPushOrderInfoAbilityReqBO;
import com.tydic.pfsc.invoice.bo.PfscPushOrderInfoAbilityRspBO;
import com.tydic.pfsc.invoice.bo.common.PfscPushOrderInfoBO;
import com.tydic.pfsc.invoice.bo.common.PfscPushOrderInfoItemBO;
import com.tydic.pfsc.service.invoice.comb.PfscPushOrderInfoCombService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="PFSC_GROUP_DEV", serviceInterface=PfscPushOrderInfoAbilityService.class)
public class PfscPushOrderInfoAbilityServiceImpl
implements PfscPushOrderInfoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PfscPushOrderInfoAbilityServiceImpl.class);
    @Autowired
    private PfscPushOrderInfoCombService pfscPushOrderInfoCombService;

    public PfscPushOrderInfoAbilityRspBO dealPushOrderInfo(PfscPushOrderInfoAbilityReqBO reqBo) {
        this.validParam(reqBo);
        return this.pfscPushOrderInfoCombService.dealApplyInvoice(reqBo);
    }

    private void validParam(PfscPushOrderInfoAbilityReqBO reqBo) {
        if (reqBo == null) {
            throw new PfscBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PfscPushOrderInfoBO orderInfoBo = reqBo.getOrderInfo();
        if (orderInfoBo == null) {
            throw new PfscBusinessException("18001", "\u5165\u53c2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u3010orderInfo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderInfoBo.getOrderId() == null) {
            throw new PfscBusinessException("18001", "\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderInfoBo.getSupplierId() == null) {
            throw new PfscBusinessException("18001", "\u5165\u53c2\u5546\u6237ID\u3010supplierId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderInfoBo.getOrderAmt() == null) {
            throw new PfscBusinessException("18001", "\u5165\u53c2\u9500\u552e\u8ba2\u5355\u91d1\u989d\u3010orderAmt\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderInfoBo.getInvoiceFlag() == null) {
            throw new PfscBusinessException("18001", "\u5165\u53c2\u662f\u5426\u5f00\u7968\u6807\u8bc6\u3010invoiceFlag\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List itemList = reqBo.getItemList();
        if (itemList.size() > 0) {
            for (PfscPushOrderInfoItemBO itemBo : itemList) {
                if (itemBo.getItemNo() == null) {
                    throw new PfscBusinessException("18001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u5546\u54c1\u7f16\u53f7\u3010itemNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (itemBo.getSkuId() == null) {
                    throw new PfscBusinessException("18001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u5546\u54c1ID\u3010skuId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (itemBo.getSkuName() == null) {
                    throw new PfscBusinessException("18001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u5546\u54c1\u540d\u79f0\u3010skuName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (itemBo.getSaleUnitPrice() == null) {
                    throw new PfscBusinessException("18001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u9500\u552e\u5355\u4ef7\u3010saleUnitPrice\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (itemBo.getQuantity() != null) continue;
                throw new PfscBusinessException("18001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u5546\u54c1\u6570\u91cf\u3010quantity\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

