/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.invoice.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfsc.dao.BusiInvoiceInfoMapper;
import com.tydic.pfsc.dao.OrderInvoiceInfoMapper;
import com.tydic.pfsc.dao.OrderItemInfoMapper;
import com.tydic.pfsc.exception.PfscBusinessException;
import com.tydic.pfsc.external.api.einvoice.IfcEinvoiceSerialnoGenerateIntfService;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceSerialnoGenerateReqBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceSerialnoGenerateRspBO;
import com.tydic.pfsc.po.BusiInvoiceInfoPO;
import com.tydic.pfsc.po.OrderInvoiceInfoPO;
import com.tydic.pfsc.po.OrderItemInfoPO;
import com.tydic.pfsc.service.invoice.busi.PfscElecInvoiceApplyParamBusiService;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyParamBusiReqBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyParamBusiRspBO;
import java.util.Calendar;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PfscElecInvoiceApplyParamBusiServiceImpl
implements PfscElecInvoiceApplyParamBusiService {
    private final BusiInvoiceInfoMapper busiInvoiceInfoMapper;
    private final OrderItemInfoMapper orderItemInfoMapper;
    private final OrderInvoiceInfoMapper orderInvoiceInfoMapper;
    private final IfcEinvoiceSerialnoGenerateIntfService ifcEinvoiceSerialnoGenerateIntfService;

    @Autowired
    public PfscElecInvoiceApplyParamBusiServiceImpl(BusiInvoiceInfoMapper busiInvoiceInfoMapper, OrderItemInfoMapper orderItemInfoMapper, OrderInvoiceInfoMapper orderInvoiceInfoMapper, IfcEinvoiceSerialnoGenerateIntfService ifcEinvoiceSerialnoGenerateIntfService) {
        this.busiInvoiceInfoMapper = busiInvoiceInfoMapper;
        this.orderItemInfoMapper = orderItemInfoMapper;
        this.orderInvoiceInfoMapper = orderInvoiceInfoMapper;
        this.ifcEinvoiceSerialnoGenerateIntfService = ifcEinvoiceSerialnoGenerateIntfService;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PfscElecInvoiceApplyParamBusiRspBO applyCommonParam(PfscElecInvoiceApplyParamBusiReqBO reqBo) {
        PfscElecInvoiceApplyParamBusiRspBO rspBo = new PfscElecInvoiceApplyParamBusiRspBO();
        Long dzfpNo = Sequence.getInstance().nextId();
        String timeStamp = this.getTimeStamp();
        int randomNo = (int)((Math.random() * 9.0 + 1.0) * 10000.0);
        String applyCode = "DZFP" + timeStamp + randomNo;
        IfcEinvoiceSerialnoGenerateReqBO generateReqBo = new IfcEinvoiceSerialnoGenerateReqBO();
        IfcEinvoiceSerialnoGenerateRspBO generateRspBo = this.ifcEinvoiceSerialnoGenerateIntfService.generateEinvoiceSerialno(generateReqBo);
        if (null == generateRspBo.getSerialNo()) {
            throw new PfscBusinessException("18009", "\u83b7\u53d6\u7edf\u4e00\u5f00\u7968\u6d41\u6c34\u53f7\u5931\u8d25\uff1a" + generateRspBo.getSubMsg());
        }
        BusiInvoiceInfoPO busiInvoiceInfoPo = this.qryBusiInvoiceInfo(reqBo);
        rspBo.setBusiInvoiceInfo(busiInvoiceInfoPo);
        List<OrderItemInfoPO> orderItemInfoPoList = this.qrySaleItemInfo(reqBo);
        OrderInvoiceInfoPO orderInvoiceInfoPo = this.qryOrderInvoiceInfo(reqBo);
        rspBo.setSaleItemInfoList(orderItemInfoPoList);
        rspBo.setOrderInvoiceInfo(orderInvoiceInfoPo);
        rspBo.setDzfpNo(dzfpNo);
        rspBo.setApplyCode(applyCode);
        rspBo.setSerialNo(generateRspBo.getSerialNo());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u83b7\u53d6\u7535\u5b50\u53d1\u7968\u7533\u8bf7\u63d0\u4ea4\u5171\u7528\u5165\u53c2\u6210\u529f");
        return rspBo;
    }

    private BusiInvoiceInfoPO qryBusiInvoiceInfo(PfscElecInvoiceApplyParamBusiReqBO reqBo) {
        BusiInvoiceInfoPO busiInvoiceInfoPo = new BusiInvoiceInfoPO();
        busiInvoiceInfoPo.setAdmOrgId(reqBo.getOrgIdIn());
        busiInvoiceInfoPo.setShopId(reqBo.getShopIdIn());
        BusiInvoiceInfoPO busiInvoiceInfoResult = this.busiInvoiceInfoMapper.getModelBy(busiInvoiceInfoPo);
        if (null == busiInvoiceInfoResult) {
            throw new PfscBusinessException("18003", "\u67e5\u8be2\u5546\u6237\u5f00\u7968\u4fe1\u606f\u8868\u7ed3\u679c\u4e3a\u7a7a");
        }
        return busiInvoiceInfoResult;
    }

    private List<OrderItemInfoPO> qrySaleItemInfo(PfscElecInvoiceApplyParamBusiReqBO reqBo) {
        OrderItemInfoPO po = new OrderItemInfoPO();
        po.setOrderId(reqBo.getOrderId());
        List<OrderItemInfoPO> orderItemInfoPoList = this.orderItemInfoMapper.getList(po);
        if (CollectionUtils.isEmpty(orderItemInfoPoList)) {
            throw new PfscBusinessException("18003", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u8868\u7ed3\u679c\u4e3a\u7a7a");
        }
        return orderItemInfoPoList;
    }

    private OrderInvoiceInfoPO qryOrderInvoiceInfo(PfscElecInvoiceApplyParamBusiReqBO reqBo) {
        OrderInvoiceInfoPO orderInvoiceInfoPo = new OrderInvoiceInfoPO();
        orderInvoiceInfoPo.setOrderId(reqBo.getOrderId());
        OrderInvoiceInfoPO orderInvoiceInfoResult = this.orderInvoiceInfoMapper.getModelBy(orderInvoiceInfoPo);
        if (null == orderInvoiceInfoResult) {
            throw new PfscBusinessException("18003", "\u67e5\u8be2\u8ba2\u5355\u5f00\u7968\u4fe1\u606f\u8868\u7ed3\u679c\u4e3a\u7a7a");
        }
        return orderInvoiceInfoResult;
    }

    private String getTimeStamp() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int millisecond = calendar.get(14);
        return String.format("%04d%02d%02d%02d%02d%02d%03d", year, month, day, hour, minute, second, millisecond);
    }
}

