/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.invoice.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfsc.constant.PfscConstants;
import com.tydic.pfsc.dao.OrderInfoHisMapper;
import com.tydic.pfsc.dao.OrderInfoMapper;
import com.tydic.pfsc.dao.OrderInvoiceHisMapper;
import com.tydic.pfsc.dao.OrderInvoiceInfoMapper;
import com.tydic.pfsc.dao.OrderItemHisMapper;
import com.tydic.pfsc.dao.OrderItemInfoMapper;
import com.tydic.pfsc.invoice.bo.PfscPushOrderInfoAbilityReqBO;
import com.tydic.pfsc.invoice.bo.common.PfscPushInvoiceInfoBO;
import com.tydic.pfsc.invoice.bo.common.PfscPushOrderInfoBO;
import com.tydic.pfsc.invoice.bo.common.PfscPushOrderInfoItemBO;
import com.tydic.pfsc.po.OrderInfoHisPO;
import com.tydic.pfsc.po.OrderInfoPO;
import com.tydic.pfsc.po.OrderInvoiceHisPO;
import com.tydic.pfsc.po.OrderInvoiceInfoPO;
import com.tydic.pfsc.po.OrderItemHisPO;
import com.tydic.pfsc.po.OrderItemInfoPO;
import com.tydic.pfsc.service.invoice.busi.PfscPushOrderInfoBusiService;
import com.tydic.pfsc.service.invoice.busi.bo.PfscPushOrderInfoRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfscPushOrderInfoBusiServiceImpl
implements PfscPushOrderInfoBusiService {
    private static final Logger logger = LoggerFactory.getLogger(PfscPushOrderInfoBusiServiceImpl.class);
    @Autowired
    private OrderInfoMapper orderInfoMapper;
    @Autowired
    private OrderItemInfoMapper orderItemInfoMapper;
    @Autowired
    private OrderInvoiceInfoMapper orderInvoiceInfoMapper;
    @Autowired
    private OrderInfoHisMapper orderInfoHisMapper;
    @Autowired
    private OrderItemHisMapper orderItemHisMapper;
    @Autowired
    private OrderInvoiceHisMapper orderInvoiceHisMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PfscPushOrderInfoRspBO dealPushOrderInfo(PfscPushOrderInfoAbilityReqBO reqBo) {
        PfscPushOrderInfoRspBO pfscPushOrderInfoRspBo = new PfscPushOrderInfoRspBO();
        if (logger.isDebugEnabled()) {
            logger.debug("\u63a5\u6536\u8ba2\u5355\u4e2d\u5fc3\u63a8\u9001\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBo);
        }
        PfscPushOrderInfoBO orderInfoBo = reqBo.getOrderInfo();
        OrderInfoPO qryParam = new OrderInfoPO();
        qryParam.setOrderId(orderInfoBo.getOrderId());
        qryParam.setSupplierShopId(orderInfoBo.getSupplierShopId());
        qryParam.setSupplierId(orderInfoBo.getSupplierId());
        OrderInfoPO qryResult = this.orderInfoMapper.getModelBy(qryParam);
        if (qryResult != null) {
            pfscPushOrderInfoRspBo.setApplyNo(qryResult.getApplyNo());
            pfscPushOrderInfoRspBo.setOrderStatus(qryResult.getOrderStatus());
            Long batchNo = Sequence.getInstance().nextId();
            OrderInfoHisPO orderInfoHisPO = new OrderInfoHisPO();
            BeanUtils.copyProperties((Object)qryResult, (Object)orderInfoHisPO);
            orderInfoHisPO.setBatchNo(batchNo);
            this.orderInfoHisMapper.insert(orderInfoHisPO);
            this.orderInfoMapper.deleteBy(qryParam);
            OrderItemInfoPO orderItemInfoPO = new OrderItemInfoPO();
            orderItemInfoPO.setOrderId(orderInfoBo.getOrderId());
            List<OrderItemInfoPO> orderItemInfoPOS = this.orderItemInfoMapper.getList(orderItemInfoPO);
            ArrayList<OrderItemHisPO> orderItemHisPOS = new ArrayList<OrderItemHisPO>();
            if (orderItemInfoPOS != null && orderItemInfoPOS.size() > 0) {
                for (OrderItemInfoPO po : orderItemInfoPOS) {
                    OrderItemHisPO orderItemHisPO = new OrderItemHisPO();
                    BeanUtils.copyProperties((Object)po, (Object)orderItemHisPO);
                    orderItemHisPO.setBatchNo(batchNo);
                    orderItemHisPOS.add(orderItemHisPO);
                }
                this.orderItemHisMapper.insertBatch(orderItemHisPOS);
            }
            OrderItemInfoPO delPo = new OrderItemInfoPO();
            delPo.setOrderId(orderInfoBo.getOrderId());
            this.orderItemInfoMapper.deleteBy(delPo);
            OrderInvoiceInfoPO ordInvPo = new OrderInvoiceInfoPO();
            ordInvPo.setOrderId(orderInfoBo.getOrderId());
            OrderInvoiceInfoPO ordInvoiceResult = this.orderInvoiceInfoMapper.getModelBy(ordInvPo);
            if (ordInvoiceResult != null) {
                OrderInvoiceHisPO orderInvoiceHisPO = new OrderInvoiceHisPO();
                BeanUtils.copyProperties((Object)ordInvoiceResult, (Object)orderInvoiceHisPO);
                orderInvoiceHisPO.setBatchNo(batchNo);
                this.orderInvoiceHisMapper.insert(orderInvoiceHisPO);
            }
            this.orderInvoiceInfoMapper.deleteBy(ordInvPo);
        }
        OrderInfoPO orderInfoPo = this.assemblingSaleParam(reqBo.getOrderInfo());
        this.orderInfoMapper.insert(orderInfoPo);
        List<OrderItemInfoPO> itemInfoPoList = this.assemblingSaleItemParam(reqBo);
        this.orderItemInfoMapper.insertBatch(itemInfoPoList);
        PfscPushInvoiceInfoBO invoiceInfoBo = reqBo.getInvoiceInfo();
        if (invoiceInfoBo != null) {
            OrderInvoiceInfoPO orderInvoiceInfoPo = this.assemblingSaleInvoiceParam(reqBo);
            this.orderInvoiceInfoMapper.insert(orderInvoiceInfoPo);
        }
        pfscPushOrderInfoRspBo.setRespCode("0000");
        pfscPushOrderInfoRspBo.setRespDesc("\u8ba2\u5355\u63a8\u9001\u6210\u529f");
        return pfscPushOrderInfoRspBo;
    }

    private OrderInfoPO assemblingSaleParam(PfscPushOrderInfoBO reqBo) {
        OrderInfoPO orderInfoPo = new OrderInfoPO();
        orderInfoPo.setOrderId(reqBo.getOrderId());
        orderInfoPo.setSupplierId(reqBo.getSupplierId());
        orderInfoPo.setSupplierShopId(reqBo.getSupplierShopId());
        if (reqBo.getRecvDate() != null) {
            orderInfoPo.setRecvDate(DateUtils.strToDateLong((String)reqBo.getRecvDate()));
        }
        if (reqBo.getOrderDate() != null) {
            orderInfoPo.setOrderDate(DateUtils.strToDateLong((String)reqBo.getOrderDate()));
        }
        orderInfoPo.setOrderAmt(reqBo.getOrderAmt());
        orderInfoPo.setTotalAmt(reqBo.getTotalAmt());
        orderInfoPo.setDisAmt(reqBo.getDisAmt());
        orderInfoPo.setPurchaserId(reqBo.getUserId());
        orderInfoPo.setPurchaseName(reqBo.getUserName());
        orderInfoPo.setSource(reqBo.getSource());
        orderInfoPo.setPlatformCode("OTHER");
        orderInfoPo.setOrderStatus(PfscConstants.OrderStatus.UNCOMMITED);
        orderInfoPo.setInvoiceFlag(PfscConstants.InvoiceFlag.ELECTRONIC);
        return orderInfoPo;
    }

    private List<OrderItemInfoPO> assemblingSaleItemParam(PfscPushOrderInfoAbilityReqBO reqBo) {
        ArrayList<OrderItemInfoPO> itemInfoPoList = new ArrayList<OrderItemInfoPO>();
        List itemBoList = reqBo.getItemList();
        for (PfscPushOrderInfoItemBO itemBo : itemBoList) {
            OrderItemInfoPO orderItemInfoPo = new OrderItemInfoPO();
            orderItemInfoPo.setOrderId(reqBo.getOrderInfo().getOrderId());
            orderItemInfoPo.setOrdItemId(itemBo.getOrdItemId());
            orderItemInfoPo.setSkuId(itemBo.getSkuId());
            orderItemInfoPo.setSkuName(itemBo.getSkuName());
            orderItemInfoPo.setSpec(itemBo.getSpec());
            orderItemInfoPo.setModel(itemBo.getModel());
            orderItemInfoPo.setFigureNo(itemBo.getFigureNo());
            BigDecimal unitPrice = itemBo.getSaleUnitPrice();
            orderItemInfoPo.setSaleUnitPrice(unitPrice);
            orderItemInfoPo.setQuantity(itemBo.getQuantity());
            orderItemInfoPo.setUnitName(itemBo.getUnitName());
            orderItemInfoPo.setTaxRate(PfscConstants.TAX_RATE);
            orderItemInfoPo.setExtOrderId(itemBo.getExtOrderId());
            orderItemInfoPo.setExtSubOrderId(itemBo.getExtSubOrderId());
            orderItemInfoPo.setRedEnvelopeFee(itemBo.getRedEnvelopeFee());
            orderItemInfoPo.setReduceFee(itemBo.getReduceFee());
            orderItemInfoPo.setActFee(itemBo.getActFee());
            orderItemInfoPo.setTotalAmt(itemBo.getTotalAmt());
            BigDecimal realFee = itemBo.getTotalAmt().subtract(itemBo.getRedEnvelopeFee()).subtract(itemBo.getReduceFee());
            BigDecimal taxAmt = realFee.multiply(orderItemInfoPo.getTaxRate()).setScale(6, 6);
            BigDecimal untaxAmt = realFee.subtract(taxAmt);
            orderItemInfoPo.setTaxAmt(taxAmt.setScale(2, 6));
            orderItemInfoPo.setUntaxAmt(untaxAmt);
            orderItemInfoPo.setAmount(realFee);
            orderItemInfoPo.setItemNo(itemBo.getItemNo());
            orderItemInfoPo.setSeq(Sequence.getInstance().nextId());
            orderItemInfoPo.setItemStatus(0);
            orderItemInfoPo.setQuantityApplied(BigDecimal.ZERO);
            orderItemInfoPo.setAmountApplied(BigDecimal.ZERO);
            orderItemInfoPo.setReturnQuantity(BigDecimal.ZERO);
            orderItemInfoPo.setRefundFee(BigDecimal.ZERO);
            if (itemBo.getReturnQuantity() != null) {
                orderItemInfoPo.setReturnQuantity(itemBo.getReturnQuantity());
            }
            if (itemBo.getRefundFee() != null) {
                orderItemInfoPo.setRefundFee(itemBo.getRefundFee());
            }
            itemInfoPoList.add(orderItemInfoPo);
        }
        return itemInfoPoList;
    }

    private OrderInvoiceInfoPO assemblingSaleInvoiceParam(PfscPushOrderInfoAbilityReqBO reqBo) {
        PfscPushInvoiceInfoBO invoiceInfoBo = reqBo.getInvoiceInfo();
        OrderInvoiceInfoPO orderInvoiceInfoPo = new OrderInvoiceInfoPO();
        BeanUtils.copyProperties((Object)invoiceInfoBo, (Object)orderInvoiceInfoPo);
        orderInvoiceInfoPo.setSeq(Sequence.getInstance().nextId());
        orderInvoiceInfoPo.setOrderId(reqBo.getOrderInfo().getOrderId());
        return orderInvoiceInfoPo;
    }
}

