/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.invoice.busi.impl;

import com.tydic.pfsc.constant.PfscConstants;
import com.tydic.pfsc.dao.FscApplyInfoMapper;
import com.tydic.pfsc.dao.FscApplyItemInfoMapper;
import com.tydic.pfsc.dao.FscApplyQueryIndexMapper;
import com.tydic.pfsc.dao.FscApplyReceiveInfoMapper;
import com.tydic.pfsc.dao.FscInvoiceInfoMapper;
import com.tydic.pfsc.dao.FscOrderItemInfoMapper;
import com.tydic.pfsc.exception.PfscBusinessException;
import com.tydic.pfsc.external.api.einvoice.IfcReqCreateEinvoiceIntfService;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceItemBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcReqCreateEinvoiceReqBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcReqCreateEinvoiceRspBO;
import com.tydic.pfsc.invoice.bo.PfscOrderReturnInvoiceAbilityReqBO;
import com.tydic.pfsc.invoice.bo.PfscOrderReturnInvoiceAbilityRspBO;
import com.tydic.pfsc.invoice.bo.common.PfscPushOrderInfoItemBO;
import com.tydic.pfsc.po.FscApplyInfoPO;
import com.tydic.pfsc.po.FscApplyItemInfoPO;
import com.tydic.pfsc.po.FscApplyQueryIndexPO;
import com.tydic.pfsc.po.FscInvoiceInfoPO;
import com.tydic.pfsc.po.FscOrderItemInfoPO;
import com.tydic.pfsc.service.invoice.atom.PfscElecInvoiceApplySaveAtomService;
import com.tydic.pfsc.service.invoice.atom.bo.PfscElecInvoiceApplyAtomReqBO;
import com.tydic.pfsc.service.invoice.atom.bo.PfscElecInvoiceApplyAtomRspBO;
import com.tydic.pfsc.service.invoice.busi.PfscElecInvoiceApplyParamBusiService;
import com.tydic.pfsc.service.invoice.busi.PfscOrderReturnInvoiceBusiService;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyParamBusiReqBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyParamBusiRspBO;
import com.tydic.pfsc.service.invoice.common.bo.PfscBillApplyInfoBO;
import com.tydic.pfsc.service.invoice.common.bo.PfscBillApplyItemInfoBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PfscOrderReturnInvoiceBusiServiceImpl
implements PfscOrderReturnInvoiceBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PfscOrderReturnInvoiceBusiServiceImpl.class);
    @Autowired
    private FscOrderItemInfoMapper orderItemInfoMapper;
    @Autowired
    private FscApplyQueryIndexMapper applyQueryIndexMapper;
    @Autowired
    private FscApplyInfoMapper applyInfoMapper;
    @Autowired
    private FscApplyItemInfoMapper applyItemInfoMapper;
    @Autowired
    private FscApplyReceiveInfoMapper applyReceiveInfoMapper;
    @Autowired
    private FscInvoiceInfoMapper invoiceInfoMapper;
    @Autowired
    private PfscElecInvoiceApplyParamBusiService pfscElecInvoiceApplyParamBusiService;
    @Autowired
    private IfcReqCreateEinvoiceIntfService ifcReqCreateEinvoiceIntfService;
    @Autowired
    private PfscElecInvoiceApplySaveAtomService pfscElecInvoiceApplySaveAtomService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PfscOrderReturnInvoiceAbilityRspBO dealOrderReturnInvoice(PfscOrderReturnInvoiceAbilityReqBO reqBo) {
        PfscOrderReturnInvoiceAbilityRspBO rspBo = new PfscOrderReturnInvoiceAbilityRspBO();
        List returnItemList = reqBo.getReturnItemList();
        for (PfscPushOrderInfoItemBO itemBo : returnItemList) {
            FscOrderItemInfoPO orderItemInfoPo = new FscOrderItemInfoPO();
            orderItemInfoPo.setOrderId(reqBo.getOrderId());
            orderItemInfoPo.setOrdItemId(itemBo.getOrdItemId());
            orderItemInfoPo = this.orderItemInfoMapper.getModelBy(orderItemInfoPo);
            if (orderItemInfoPo == null) {
                throw new PfscBusinessException("18003", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u8868\u65e0\u8bb0\u5f55");
            }
            FscOrderItemInfoPO itemInfoPo = new FscOrderItemInfoPO();
            itemInfoPo.setOrderId(reqBo.getOrderId());
            itemInfoPo.setOrdItemId(itemBo.getOrdItemId());
            itemInfoPo.setReturnQuantity(itemBo.getReturnQuantity());
            itemInfoPo.setRefundFee(itemBo.getRefundFee());
            itemInfoPo.setSeq(orderItemInfoPo.getSeq());
            this.orderItemInfoMapper.updateReturnQuantity(itemInfoPo);
        }
        FscApplyQueryIndexPO applyQueryIndexPo = new FscApplyQueryIndexPO();
        applyQueryIndexPo.setOrderId(reqBo.getOrderId());
        applyQueryIndexPo = this.applyQueryIndexMapper.getApplyNo(applyQueryIndexPo);
        if (applyQueryIndexPo == null) {
            throw new PfscBusinessException("18003", "\u67e5\u8be2\u8be5\u8ba2\u5355\u5df2\u5f00\u84dd\u7968\u65e0\u8bb0\u5f55");
        }
        FscInvoiceInfoPO invoiceInfoPo = new FscInvoiceInfoPO();
        invoiceInfoPo.setApplyNo(applyQueryIndexPo.getApplyNo());
        invoiceInfoPo.setInvoiceKind(PfscConstants.OrderInvoiceInfo.InvoiceType.ELECTRONIC);
        invoiceInfoPo = this.invoiceInfoMapper.getModelBy(invoiceInfoPo);
        if (invoiceInfoPo == null) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u8ba2\u5355\u9000\u8d27\u4fe1\u606f\u540c\u6b65\u6210\u529f!");
            return rspBo;
        }
        PfscElecInvoiceApplyParamBusiReqBO paramBusiReqBo = new PfscElecInvoiceApplyParamBusiReqBO();
        paramBusiReqBo.setOrderId(reqBo.getOrderId());
        PfscElecInvoiceApplyParamBusiRspBO paramBusiRspBo = this.pfscElecInvoiceApplyParamBusiService.applyCommonParam(paramBusiReqBo);
        PfscElecInvoiceApplyAtomReqBO elecAtomReqBo = this.assemblingApplyParam(invoiceInfoPo, paramBusiRspBo);
        IfcReqCreateEinvoiceReqBO einvoiceReqBo = this.assemblingIfcInvoiceCreateParam(elecAtomReqBo);
        IfcReqCreateEinvoiceRspBO einvoiceRspBo = this.ifcReqCreateEinvoiceIntfService.requestToCreateEinvoice(einvoiceReqBo);
        if (null == einvoiceRspBo.getIsSuccess() || !einvoiceRspBo.getIsSuccess().booleanValue()) {
            throw new PfscBusinessException("18009", "\u8c03\u7528\u963f\u91cc\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5931\u8d25:" + einvoiceRspBo.getSubMsg());
        }
        PfscElecInvoiceApplyAtomRspBO atomRspBo = this.pfscElecInvoiceApplySaveAtomService.saveApplyInfo(elecAtomReqBo);
        if (!"0000".equals(atomRspBo.getRespCode())) {
            throw new PfscBusinessException("18009", "\u8c03\u7528\u53d1\u7968\u7533\u8bf7\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a" + atomRspBo.getRespDesc());
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u8ba2\u5355\u9000\u8d27\u53d1\u7968\u670d\u52a1\u7ea2\u7968\u7533\u8bf7\u6210\u529f");
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setApplyNo(atomRspBo.getApplyNo());
        return rspBo;
    }

    private PfscElecInvoiceApplyAtomReqBO assemblingApplyParam(FscInvoiceInfoPO invoiceInfoPo, PfscElecInvoiceApplyParamBusiRspBO paramBusiRspBo) {
        PfscElecInvoiceApplyAtomReqBO atomReqBo = new PfscElecInvoiceApplyAtomReqBO();
        FscApplyInfoPO applyInfoPo = new FscApplyInfoPO();
        applyInfoPo.setApplyNo(invoiceInfoPo.getApplyNo());
        applyInfoPo.setRedBlue("blue");
        applyInfoPo.setBillStatus(PfscConstants.BillApplyInfo.BillStatus.INVOICED);
        applyInfoPo = this.applyInfoMapper.getModelBy(applyInfoPo);
        if (applyInfoPo == null) {
            throw new PfscBusinessException("18003", "\u67e5\u8be2\u539f\u53d1\u7968\u5f00\u7968\u7533\u8bf7\u8868\u65e0\u6570\u636e");
        }
        PfscBillApplyInfoBO pfscBillApplyInfoBo = new PfscBillApplyInfoBO();
        BeanUtils.copyProperties((Object)applyInfoPo, (Object)pfscBillApplyInfoBo);
        pfscBillApplyInfoBo.setApplyCode(paramBusiRspBo.getApplyCode());
        pfscBillApplyInfoBo.setSerialNo(paramBusiRspBo.getSerialNo());
        pfscBillApplyInfoBo.setAmt(applyInfoPo.getAmt().negate());
        pfscBillApplyInfoBo.setTaxAmt(applyInfoPo.getTaxAmt().negate());
        pfscBillApplyInfoBo.setUntaxAmt(applyInfoPo.getUntaxAmt().negate());
        pfscBillApplyInfoBo.setApplyDate(new Date());
        pfscBillApplyInfoBo.setRedBlue("red");
        pfscBillApplyInfoBo.setNormalInvoiceCode(invoiceInfoPo.getInvoiceCode());
        pfscBillApplyInfoBo.setNormalInvoiceNo(invoiceInfoPo.getInvoiceNo());
        pfscBillApplyInfoBo.setBillStatus(PfscConstants.BillApplyInfo.BillStatus.INVOICING);
        ArrayList<PfscBillApplyItemInfoBO> pfscBillApplyItemInfoBoList = new ArrayList<PfscBillApplyItemInfoBO>();
        FscApplyItemInfoPO applyItemInfoPo = new FscApplyItemInfoPO();
        applyItemInfoPo.setApplyNo(invoiceInfoPo.getApplyNo());
        applyItemInfoPo.setSerialNo(applyInfoPo.getSerialNo());
        List<FscApplyItemInfoPO> oldApplyItemPos = this.applyItemInfoMapper.getList(applyItemInfoPo);
        if (!CollectionUtils.isEmpty(oldApplyItemPos)) {
            for (FscApplyItemInfoPO applyItemPo : oldApplyItemPos) {
                PfscBillApplyItemInfoBO newApplyItemBo = new PfscBillApplyItemInfoBO();
                newApplyItemBo.setSeq(applyItemPo.getSeq());
                newApplyItemBo.setApplyNo(applyInfoPo.getApplyNo());
                newApplyItemBo.setItemNo(applyItemPo.getItemNo());
                newApplyItemBo.setItemName(applyItemPo.getItemName());
                newApplyItemBo.setRowType(PfscConstants.RowType.NORMAL_LINE);
                newApplyItemBo.setTaxRate(PfscConstants.TAX_RATE);
                newApplyItemBo.setQuantity(applyItemPo.getQuantity().negate());
                newApplyItemBo.setStatus(PfscConstants.StatusType.VALID);
                newApplyItemBo.setUnit(applyItemPo.getUnit());
                newApplyItemBo.setPrice(applyItemPo.getPrice());
                newApplyItemBo.setUntaxAmt(applyItemPo.getUntaxAmt().negate());
                newApplyItemBo.setTaxAmt(applyItemPo.getTaxAmt().negate());
                newApplyItemBo.setAmount(applyItemPo.getAmount().negate());
                newApplyItemBo.setApplyNo(invoiceInfoPo.getApplyNo());
                newApplyItemBo.setSerialNo(paramBusiRspBo.getSerialNo());
                pfscBillApplyItemInfoBoList.add(newApplyItemBo);
            }
        }
        atomReqBo.setPfscBillApplyInfo(pfscBillApplyInfoBo);
        atomReqBo.setBillApplyItemList(pfscBillApplyItemInfoBoList);
        return atomReqBo;
    }

    private boolean checkIfAllReturn(Long orderId) {
        boolean flag = false;
        FscOrderItemInfoPO qryParam = new FscOrderItemInfoPO();
        qryParam.setOrderId(String.valueOf(orderId));
        List<FscOrderItemInfoPO> itemInfoPoList = this.orderItemInfoMapper.getList(qryParam);
        if (!CollectionUtils.isEmpty(itemInfoPoList)) {
            for (FscOrderItemInfoPO orderItemInfoPo : itemInfoPoList) {
                if (orderItemInfoPo.getReturnQuantity().compareTo(orderItemInfoPo.getQuantity()) >= 0) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    private IfcReqCreateEinvoiceReqBO assemblingIfcInvoiceCreateParam(PfscElecInvoiceApplyAtomReqBO reqBo) {
        IfcReqCreateEinvoiceReqBO ifcReqCreateEinvoiceReqBo = new IfcReqCreateEinvoiceReqBO();
        PfscBillApplyInfoBO pfscBillApplyInfoBo = reqBo.getPfscBillApplyInfo();
        ifcReqCreateEinvoiceReqBo.setBusinessType(Long.valueOf(pfscBillApplyInfoBo.getInvoceNameType().intValue()));
        ifcReqCreateEinvoiceReqBo.setPlatformCode("OTHER");
        ifcReqCreateEinvoiceReqBo.setPlatformTid(String.valueOf(pfscBillApplyInfoBo.getApplyNo()));
        ifcReqCreateEinvoiceReqBo.setSerialNo(pfscBillApplyInfoBo.getSerialNo());
        ifcReqCreateEinvoiceReqBo.setPayeeAddress(pfscBillApplyInfoBo.getPayeeAddress());
        ifcReqCreateEinvoiceReqBo.setPayeeName(pfscBillApplyInfoBo.getPayeeName());
        ifcReqCreateEinvoiceReqBo.setPayerRegisterNo(pfscBillApplyInfoBo.getTaxNo());
        ifcReqCreateEinvoiceReqBo.setInvoiceAmount(pfscBillApplyInfoBo.getAmt() + "");
        ifcReqCreateEinvoiceReqBo.setInvoiceType("red");
        ifcReqCreateEinvoiceReqBo.setNormalInvoiceCode(pfscBillApplyInfoBo.getNormalInvoiceCode());
        ifcReqCreateEinvoiceReqBo.setNormalInvoiceNo(pfscBillApplyInfoBo.getNormalInvoiceNo());
        ifcReqCreateEinvoiceReqBo.setPayeeRegisterNo(pfscBillApplyInfoBo.getPayeeRegisterNo());
        ifcReqCreateEinvoiceReqBo.setPayerName(pfscBillApplyInfoBo.getInvoceName());
        ifcReqCreateEinvoiceReqBo.setSumTax(pfscBillApplyInfoBo.getTaxAmt() + "");
        ifcReqCreateEinvoiceReqBo.setSumPrice(pfscBillApplyInfoBo.getUntaxAmt() + "");
        ifcReqCreateEinvoiceReqBo.setInvoiceKind(Long.valueOf(0L));
        ifcReqCreateEinvoiceReqBo.setOutShopName("\u534e\u6cca\u79d1\u6280-\u5f00\u7968");
        List<PfscBillApplyItemInfoBO> itemInfoBoList = reqBo.getBillApplyItemList();
        ArrayList<IfcEinvoiceItemBO> ifcEinvoiceItemBoList = new ArrayList<IfcEinvoiceItemBO>();
        for (PfscBillApplyItemInfoBO pfscBillApplyItemInfoBo : itemInfoBoList) {
            IfcEinvoiceItemBO ifcEinvoiceItemBo = new IfcEinvoiceItemBO();
            ifcEinvoiceItemBo.setItemNo(pfscBillApplyItemInfoBo.getItemNo() + "");
            ifcEinvoiceItemBo.setItemName(pfscBillApplyItemInfoBo.getItemName());
            ifcEinvoiceItemBo.setRowType(String.valueOf(pfscBillApplyItemInfoBo.getRowType()));
            ifcEinvoiceItemBo.setPrice(String.valueOf(pfscBillApplyItemInfoBo.getPrice()));
            ifcEinvoiceItemBo.setQuantity(String.valueOf(pfscBillApplyItemInfoBo.getQuantity()));
            ifcEinvoiceItemBo.setSpecification(pfscBillApplyItemInfoBo.getSpec());
            ifcEinvoiceItemBo.setSumPrice(String.valueOf(pfscBillApplyItemInfoBo.getUntaxAmt()));
            ifcEinvoiceItemBo.setTax(String.valueOf(pfscBillApplyItemInfoBo.getTaxAmt()));
            ifcEinvoiceItemBo.setTaxRate(String.valueOf(pfscBillApplyItemInfoBo.getTaxRate()));
            ifcEinvoiceItemBo.setUnit(pfscBillApplyItemInfoBo.getUnit());
            ifcEinvoiceItemBo.setAmount(String.valueOf(pfscBillApplyItemInfoBo.getAmount()));
            ifcEinvoiceItemBoList.add(ifcEinvoiceItemBo);
        }
        ifcReqCreateEinvoiceReqBo.setInvoiceItems(ifcEinvoiceItemBoList);
        return ifcReqCreateEinvoiceReqBo;
    }
}

