/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.invoice.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.pfsc.constant.PfscConstants;
import com.tydic.pfsc.dao.FscApplyInfoMapper;
import com.tydic.pfsc.dao.FscApplyQueryIndexMapper;
import com.tydic.pfsc.dao.FscInvoiceDetailMapper;
import com.tydic.pfsc.dao.FscInvoiceInfoMapper;
import com.tydic.pfsc.dao.FscOrderInfoMapper;
import com.tydic.pfsc.dao.FscOrderItemInfoMapper;
import com.tydic.pfsc.exception.PfscBusinessException;
import com.tydic.pfsc.external.api.einvoice.IfcOrderLmPushInvoiceResultService;
import com.tydic.pfsc.external.api.einvoice.IfcReqCreateRedEinvoiceIntfService;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceItemBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceResultBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcOrderLmPushInvoiceResultReqBO;
import com.tydic.pfsc.po.FscApplyInfoPO;
import com.tydic.pfsc.po.FscApplyQueryIndexPO;
import com.tydic.pfsc.po.FscInvoiceDetailPO;
import com.tydic.pfsc.po.FscInvoiceInfoPO;
import com.tydic.pfsc.po.FscOrderInfoPO;
import com.tydic.pfsc.po.FscOrderItemInfoPO;
import com.tydic.pfsc.service.invoice.busi.PfscQryInvoiceResultBusiService;
import com.tydic.pfsc.service.invoice.busi.bo.PfscQryInvoiceResultBusiReqBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscQryInvoiceResultBusiRspBO;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfscQryInvoiceResultBusiServiceImpl
implements PfscQryInvoiceResultBusiService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "invoice";
    @Value(value="${oss.accessUrl}")
    private String baseUrl;
    @Autowired
    private FscApplyInfoMapper applyInfoMapper;
    @Autowired
    private FscOrderInfoMapper orderInfoMapper;
    @Autowired
    private FscOrderItemInfoMapper orderItemInfoMapper;
    @Autowired
    private FscApplyQueryIndexMapper applyQueryIndexMapper;
    @Autowired
    private FscInvoiceInfoMapper invoiceInfoMapper;
    @Autowired
    private FscInvoiceDetailMapper invoiceDetailMapper;
    @Autowired
    private IfcReqCreateRedEinvoiceIntfService ifcReqCreateRedEinvoiceIntfService;
    @Autowired
    private IfcOrderLmPushInvoiceResultService ifcOrderLmPushInvoiceResultService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PfscQryInvoiceResultBusiRspBO saveElecInvoiceResult(PfscQryInvoiceResultBusiReqBO reqBo) {
        PfscQryInvoiceResultBusiRspBO rspBo = new PfscQryInvoiceResultBusiRspBO();
        IfcEinvoiceResultBO resultBo = reqBo.getIfcEinvoiceResult();
        FscApplyInfoPO applyInfoPo = new FscApplyInfoPO();
        applyInfoPo.setApplyNo(Long.parseLong(resultBo.getPlatformTid()));
        applyInfoPo.setSerialNo(reqBo.getSerialNo());
        FscApplyQueryIndexPO indexPo = this.qryApplyQueryIndex(applyInfoPo.getApplyNo());
        FscOrderInfoPO fscOrderInfoPO = new FscOrderInfoPO();
        fscOrderInfoPO.setOrderId(indexPo.getOrderId());
        FscOrderInfoPO orderInfoPo = this.orderInfoMapper.getModelBy(fscOrderInfoPO);
        List<String> orderIds = Arrays.asList(orderInfoPo.getOrderIds());
        IfcOrderLmPushInvoiceResultReqBO orderLmPushInvoiceResultReqBO = new IfcOrderLmPushInvoiceResultReqBO();
        orderLmPushInvoiceResultReqBO.setOrderId(indexPo.getOrderId());
        if ("create_failed".equals(resultBo.getStatus())) {
            applyInfoPo.setBillStatus(PfscConstants.BillApplyInfo.BillStatus.FAILED);
            applyInfoPo.setFailDesc(resultBo.getBizErrorMsg());
            orderLmPushInvoiceResultReqBO.setSuccess(Boolean.valueOf(false));
            orderLmPushInvoiceResultReqBO.setFailMsg(resultBo.getBizErrorMsg());
        } else if ("create_success".equals(resultBo.getStatus())) {
            orderLmPushInvoiceResultReqBO.setSuccess(Boolean.valueOf(true));
            ArrayList<FscInvoiceDetailPO> invoiceDetailList = new ArrayList<FscInvoiceDetailPO>();
            if (resultBo.getInvoiceItems() != null && resultBo.getInvoiceItems().size() > 0) {
                for (IfcEinvoiceItemBO itemBo : resultBo.getInvoiceItems()) {
                    FscInvoiceDetailPO detailPo = new FscInvoiceDetailPO();
                    detailPo.setSeq(Sequence.getInstance().nextId());
                    detailPo.setApplyNo(Long.valueOf(resultBo.getPlatformTid()));
                    detailPo.setInvoiceNo(resultBo.getInvoiceNo());
                    detailPo.setItemNo(itemBo.getItemNo());
                    detailPo.setItemName(itemBo.getItemName());
                    detailPo.setRowType(Integer.valueOf(itemBo.getRowType()));
                    detailPo.setUnitName(itemBo.getUnit());
                    detailPo.setUntaxAmt(new BigDecimal(itemBo.getSumPrice()));
                    detailPo.setTaxAmt(new BigDecimal(itemBo.getTax()));
                    detailPo.setSpecModel(itemBo.getSpecification());
                    detailPo.setTaxRate(new BigDecimal(itemBo.getTaxRate()));
                    detailPo.setAmount(new BigDecimal(itemBo.getAmount()));
                    if (null != itemBo.getPrice()) {
                        detailPo.setSaleUnitPrice(new BigDecimal(itemBo.getPrice()));
                    }
                    if (null != itemBo.getQuantity()) {
                        detailPo.setQuantity(new BigDecimal(itemBo.getQuantity()));
                    }
                    invoiceDetailList.add(detailPo);
                }
            }
            FscInvoiceInfoPO invoiceInfoPo = new FscInvoiceInfoPO();
            BeanUtils.copyProperties((Object)resultBo, (Object)invoiceInfoPo);
            invoiceInfoPo.setStatus("1");
            invoiceInfoPo.setApplyNo(Long.valueOf(resultBo.getPlatformTid()));
            invoiceInfoPo.setSerialNo(resultBo.getSerialNo());
            invoiceInfoPo.setInvoiceKind(resultBo.getInvoiceKind().intValue());
            String invoiceTime = resultBo.getInvoiceDate() + " " + resultBo.getInvoiceTime();
            invoiceInfoPo.setInvoiceTime(DateUtils.strToDateLong((String)invoiceTime));
            BigDecimal taxRate = PfscConstants.TAX_RATE;
            BigDecimal amt = new BigDecimal(resultBo.getInvoiceAmount());
            BigDecimal untaxAmt = amt.divide(taxRate.add(BigDecimal.ONE), 2, 4);
            BigDecimal taxAmt = amt.subtract(untaxAmt);
            invoiceInfoPo.setAmt(amt);
            invoiceInfoPo.setUntaxAmt(untaxAmt);
            invoiceInfoPo.setTaxAmt(taxAmt);
            invoiceInfoPo.setRedFlag(PfscConstants.RedFlag.IS_NOT_RED);
            if ("red".equals(resultBo.getInvoiceType())) {
                FscApplyInfoPO oldBlueReq = new FscApplyInfoPO();
                oldBlueReq.setApplyNo(indexPo.getApplyNo());
                oldBlueReq.setRedBlue("blue");
                oldBlueReq.setBillStatus(PfscConstants.BillApplyInfo.BillStatus.INVOICED);
                oldBlueReq = this.applyInfoMapper.getModelBy(oldBlueReq);
                if (oldBlueReq == null) {
                    throw new PfscBusinessException("18006", "\u67e5\u8be2\u7533\u8bf7\u5355\u53f7[" + indexPo.getApplyNo() + "]\u7684\u84dd\u7968\u65e0\u8bb0\u5f55");
                }
                invoiceInfoPo.setNormalInvoiceCode(resultBo.getNormalInvoiceCode());
                invoiceInfoPo.setNormalInvoiceNo(resultBo.getNormalInvoiceNo());
                FscApplyInfoPO setApplyInfoPo = new FscApplyInfoPO();
                setApplyInfoPo.setBillStatus(PfscConstants.BillApplyInfo.BillStatus.REFUNDED);
                FscApplyInfoPO whereApplyInfoPo = new FscApplyInfoPO();
                whereApplyInfoPo.setApplyNo(indexPo.getApplyNo());
                whereApplyInfoPo.setSerialNo(oldBlueReq.getSerialNo());
                this.applyInfoMapper.updateBy(setApplyInfoPo, whereApplyInfoPo);
                FscInvoiceInfoPO updateInvoiceReq = new FscInvoiceInfoPO();
                updateInvoiceReq.setApplyNo(indexPo.getApplyNo());
                updateInvoiceReq.setSerialNo(oldBlueReq.getSerialNo());
                updateInvoiceReq.setStatus("2");
                updateInvoiceReq.setRedFlag(PfscConstants.RedFlag.IS_RED);
                this.invoiceInfoMapper.updateBillStatus(updateInvoiceReq);
            }
            invoiceInfoPo.setNotifyStatus(PfscConstants.NotifyStatus.ACQUIRED);
            String ossUrl = this.uploadInvoiceFileOss(resultBo.getFilePath(), invoiceInfoPo.getApplyNo() + "_" + invoiceInfoPo.getSerialNo());
            invoiceInfoPo.setFileOssPath(ossUrl);
            orderLmPushInvoiceResultReqBO.setUrl(ossUrl);
            applyInfoPo.setBillStatus(PfscConstants.BillApplyInfo.BillStatus.INVOICED);
            this.invoiceInfoMapper.insert(invoiceInfoPo);
            if (invoiceDetailList.size() > 0) {
                this.invoiceDetailMapper.insertBatch(invoiceDetailList);
            }
        }
        FscApplyInfoPO setApplyInfoPo = new FscApplyInfoPO();
        setApplyInfoPo.setBillStatus(applyInfoPo.getBillStatus());
        setApplyInfoPo.setFailDesc(applyInfoPo.getFailDesc());
        FscApplyInfoPO whereApplyInfoPo = new FscApplyInfoPO();
        whereApplyInfoPo.setApplyNo(applyInfoPo.getApplyNo());
        whereApplyInfoPo.setSerialNo(applyInfoPo.getSerialNo());
        int result = this.applyInfoMapper.updateBy(setApplyInfoPo, whereApplyInfoPo);
        if (result < 1) {
            throw new PfscBusinessException("18006", "\u4fee\u6539\u5f00\u7968\u7533\u8bf7\u8868\u7684\u5f00\u7968\u72b6\u6001[billStatus]\u5931\u8d25");
        }
        rspBo.setOrderId(indexPo.getOrderId());
        rspBo.setApplyNo(applyInfoPo.getApplyNo());
        if ("red".equals(resultBo.getInvoiceType())) {
            rspBo.setOrderStatus(PfscConstants.BillApplyInfo.BillStatus.REFUNDED);
        } else {
            rspBo.setOrderStatus(applyInfoPo.getBillStatus());
        }
        this.ifcOrderLmPushInvoiceResultService.pushInvoiceResultToOrder(orderLmPushInvoiceResultReqBO);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u7535\u5b50\u53d1\u7968\u7ed3\u679c\u83b7\u53d6\u6210\u529f");
        return rspBo;
    }

    private boolean qrySaleItemInfo(Long orderId) {
        FscOrderItemInfoPO orderItemInfoPo = new FscOrderItemInfoPO();
        orderItemInfoPo.setOrderId(String.valueOf(orderId));
        List<FscOrderItemInfoPO> orderItemInfoPoList = this.orderItemInfoMapper.getList(orderItemInfoPo);
        if (CollectionUtils.isEmpty(orderItemInfoPoList)) {
            throw new PfscBusinessException("18003", "\u67e5\u8be2\u8ba2\u5355" + orderId + "\u7684\u660e\u7ec6\u7ed3\u679c\u4e3a\u7a7a");
        }
        for (FscOrderItemInfoPO po : orderItemInfoPoList) {
            if (null == po.getReturnQuantity()) {
                return false;
            }
            if (po.getReturnQuantity().compareTo(po.getQuantity()) >= 0) continue;
            return false;
        }
        return true;
    }

    private FscApplyQueryIndexPO qryApplyQueryIndex(Long applyNo) {
        FscApplyQueryIndexPO reqBo = new FscApplyQueryIndexPO();
        reqBo.setApplyNo(applyNo);
        FscApplyQueryIndexPO rspBo = this.applyQueryIndexMapper.getModelBy(reqBo);
        if (null == rspBo) {
            throw new PfscBusinessException("18003", "\u67e5\u8be2\u7d22\u5f15\u8868\u7ed3\u679c\u4e3a\u7a7a");
        }
        return rspBo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadInvoiceFileOss(String filePath, String fileName) {
        String ossUrl = "";
        fileName = fileName + ".pdf";
        URL url = null;
        InputStream inputStream = null;
        try {
            url = new URL(filePath);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            inputStream = connection.getInputStream();
            ossUrl = this.baseUrl + "/" + this.fileClient.uploadFileByInputStream(PATH, fileName, inputStream);
            this.logger.info("ossUrl=" + ossUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ossUrl;
    }
}

