/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.invoice.comb.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.pfsc.constant.PfscConstants;
import com.tydic.pfsc.dao.FscApplyInfoMapper;
import com.tydic.pfsc.dao.FscApplyReceiveInfoMapper;
import com.tydic.pfsc.exception.PfscBusinessException;
import com.tydic.pfsc.external.api.einvoice.IfcGetEinvoiceCreateResultIntfService;
import com.tydic.pfsc.external.api.einvoice.IfcReqCreateEinvoiceIntfService;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceResultBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcGetEinvoiceCreateResultReqBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcGetEinvoiceCreateResultRspBO;
import com.tydic.pfsc.invoice.bo.PfscQryInvoiceResultAbilityReqBO;
import com.tydic.pfsc.invoice.bo.PfscQryInvoiceResultAbilityRspBO;
import com.tydic.pfsc.po.FscApplyInfoPO;
import com.tydic.pfsc.po.FscApplyReceiveInfoPO;
import com.tydic.pfsc.service.invoice.busi.PfscElecInvoiceApplyBusiService;
import com.tydic.pfsc.service.invoice.busi.PfscElecInvoiceApplyParamBusiService;
import com.tydic.pfsc.service.invoice.busi.PfscElecSaveInvoiceApplyBusiService;
import com.tydic.pfsc.service.invoice.busi.PfscQryInvoiceResultBusiService;
import com.tydic.pfsc.service.invoice.busi.PfscSaveIndexAndAppliedBusiService;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyBusiReqBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyBusiRspBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscQryInvoiceResultBusiReqBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscQryInvoiceResultBusiRspBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscSaveIndexAndAppliedBusiReqBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscSaveIndexAndAppliedBusiRspBO;
import com.tydic.pfsc.service.invoice.comb.PfscQryInvoiceResultCombService;
import com.tydic.pfsc.service.invoice.common.bo.PfscBillApplyReceiveInfoBO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PfscQryInvoiceResultCombServiceImpl
implements PfscQryInvoiceResultCombService {
    private static final Logger logger = LoggerFactory.getLogger(PfscQryInvoiceResultCombServiceImpl.class);
    private final IfcGetEinvoiceCreateResultIntfService ifcGetEinvoiceCreateResultIntfService;
    private final IfcReqCreateEinvoiceIntfService ifcReqCreateEinvoiceIntfService;
    private final FscApplyInfoMapper applyInfoMapper;
    private final FscApplyReceiveInfoMapper applyReceiveInfoMapper;
    private final PfscQryInvoiceResultBusiService pfscQryInvoiceResultBusiService;
    private final PfscSaveIndexAndAppliedBusiService pfscSaveIndexAndAppliedBusiService;
    private final PfscElecInvoiceApplyParamBusiService pfscElecInvoiceApplyParamBusiService;
    private final PfscElecSaveInvoiceApplyBusiService pfscElecSaveInvoiceApplyBusiService;
    @Autowired
    private PfscElecInvoiceApplyBusiService pfscElecInvoiceApplyBusiService;

    @Autowired
    public PfscQryInvoiceResultCombServiceImpl(IfcGetEinvoiceCreateResultIntfService ifcGetEinvoiceCreateResultIntfService, IfcReqCreateEinvoiceIntfService ifcReqCreateEinvoiceIntfService, FscApplyInfoMapper applyInfoMapper, FscApplyReceiveInfoMapper applyReceiveInfoMapper, PfscQryInvoiceResultBusiService pfscQryInvoiceResultBusiService, PfscSaveIndexAndAppliedBusiService pfscSaveIndexAndAppliedBusiService, PfscElecInvoiceApplyParamBusiService pfscElecInvoiceApplyParamBusiService, PfscElecSaveInvoiceApplyBusiService pfscElecSaveInvoiceApplyBusiService) {
        this.ifcGetEinvoiceCreateResultIntfService = ifcGetEinvoiceCreateResultIntfService;
        this.ifcReqCreateEinvoiceIntfService = ifcReqCreateEinvoiceIntfService;
        this.applyInfoMapper = applyInfoMapper;
        this.applyReceiveInfoMapper = applyReceiveInfoMapper;
        this.pfscQryInvoiceResultBusiService = pfscQryInvoiceResultBusiService;
        this.pfscSaveIndexAndAppliedBusiService = pfscSaveIndexAndAppliedBusiService;
        this.pfscElecInvoiceApplyParamBusiService = pfscElecInvoiceApplyParamBusiService;
        this.pfscElecSaveInvoiceApplyBusiService = pfscElecSaveInvoiceApplyBusiService;
    }

    @Override
    public PfscQryInvoiceResultAbilityRspBO queryElecInvoiceResult(PfscQryInvoiceResultAbilityReqBO reqBo) {
        PfscQryInvoiceResultAbilityRspBO rspBo = new PfscQryInvoiceResultAbilityRspBO();
        IfcGetEinvoiceCreateResultReqBO resultReqBo = new IfcGetEinvoiceCreateResultReqBO();
        resultReqBo.setSerialNo(reqBo.getSerialNo());
        resultReqBo.setPayeeRegisterNo(reqBo.getPayeeRegisterNo());
        resultReqBo.setPlatformCode(reqBo.getPlatformCode());
        resultReqBo.setOutShopName("\u534e\u6cca\u79d1\u6280-\u5f00\u7968");
        IfcGetEinvoiceCreateResultRspBO resultRspBo = this.ifcGetEinvoiceCreateResultIntfService.getEinvoiceCreateResult(resultReqBo);
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d1\u7968\u7ed3\u679cresultRspBO\uff1a" + JSON.toJSONString((Object)resultRspBo));
        }
        for (IfcEinvoiceResultBO resultBo : resultRspBo.getInvoiceResultList()) {
            PfscQryInvoiceResultBusiReqBO resultBusiReqBo = new PfscQryInvoiceResultBusiReqBO();
            resultBusiReqBo.setIfcEinvoiceResult(resultBo);
            resultBusiReqBo.setSerialNo(reqBo.getSerialNo());
            PfscQryInvoiceResultBusiRspBO resultBusiRspBo = this.pfscQryInvoiceResultBusiService.saveElecInvoiceResult(resultBusiReqBo);
            if (!"0000".equals(resultBusiRspBo.getRespCode())) {
                throw new PfscBusinessException("8888", "\u8c03\u7528\u7535\u5b50\u53d1\u7968\u7ed3\u679c\u83b7\u53d6\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
            }
            PfscSaveIndexAndAppliedBusiReqBO reqBO = new PfscSaveIndexAndAppliedBusiReqBO();
            if (PfscConstants.RedFlag.IS_RED.equals(resultBusiRspBo.getRedFlag())) {
                reqBO.setApplyNo(null);
            } else {
                reqBO.setApplyNo(resultBusiRspBo.getApplyNo());
            }
            reqBO.setOrderId(resultBusiRspBo.getOrderId());
            reqBO.setOrderStatus(resultBusiRspBo.getOrderStatus());
            PfscSaveIndexAndAppliedBusiRspBO rspBO = this.pfscSaveIndexAndAppliedBusiService.saveIndexAndApplied(reqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                rspBo.setRespCode(rspBO.getRespCode());
                rspBo.setRespDesc(rspBO.getRespDesc());
                return rspBo;
            }
            if (!"red".equals(resultBo.getInvoiceType())) continue;
            PfscElecInvoiceApplyBusiReqBO pfscElecInvoiceApplyBusiReqBO = new PfscElecInvoiceApplyBusiReqBO();
            pfscElecInvoiceApplyBusiReqBO.setOrderId(resultBusiRspBo.getOrderId());
            pfscElecInvoiceApplyBusiReqBO.setOrderStatus(resultBusiRspBo.getOrderStatus());
            pfscElecInvoiceApplyBusiReqBO.setApplyNo(resultBusiRspBo.getApplyNo());
            PfscElecInvoiceApplyBusiRspBO pfscElecInvoiceApplyBusiRspBO = this.pfscElecInvoiceApplyBusiService.commitElecInvoiceApply(pfscElecInvoiceApplyBusiReqBO);
            if (!"0000".equals(pfscElecInvoiceApplyBusiRspBO.getRespCode())) {
                rspBo.setRespCode(pfscElecInvoiceApplyBusiRspBO.getRespCode());
                rspBo.setRespDesc(pfscElecInvoiceApplyBusiRspBO.getRespDesc());
                return rspBo;
            }
            PfscSaveIndexAndAppliedBusiReqBO saveIndexAndAppliedBusiReqBo = new PfscSaveIndexAndAppliedBusiReqBO();
            saveIndexAndAppliedBusiReqBo.setType("all");
            saveIndexAndAppliedBusiReqBo.setOrderId(resultBusiRspBo.getOrderId());
            saveIndexAndAppliedBusiReqBo.setOrderStatus(pfscElecInvoiceApplyBusiRspBO.getOrderStatus());
            saveIndexAndAppliedBusiReqBo.setApplyNo(pfscElecInvoiceApplyBusiRspBO.getApplyNo());
            saveIndexAndAppliedBusiReqBo.setSaleItemInfoList(pfscElecInvoiceApplyBusiRspBO.getSaleItemInfoList());
            PfscSaveIndexAndAppliedBusiRspBO saveIndexAndAppliedBusiRspBo = this.pfscSaveIndexAndAppliedBusiService.saveIndexAndApplied(saveIndexAndAppliedBusiReqBo);
            if ("0000".equals(saveIndexAndAppliedBusiRspBo.getRespCode())) continue;
            throw new PfscBusinessException("18004", "\u4fdd\u5b58\u7d22\u5f15\u548c\u5df2\u63d0\u4ea4\u6570\u636e\u5931\u8d25");
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u7535\u5b50\u53d1\u7968\u7ed3\u679c\u83b7\u53d6\u6210\u529f");
        return rspBo;
    }

    private List<FscApplyInfoPO> qryBillApplyInfo(PfscQryInvoiceResultAbilityReqBO reqBo) {
        FscApplyInfoPO applyInfoPo = new FscApplyInfoPO();
        applyInfoPo.setSupplierId(null == reqBo.getOrgIdIn() ? reqBo.getSupplierId() : String.valueOf(reqBo.getOrgIdIn()));
        applyInfoPo.setSupplierShopId(null == reqBo.getShopIdIn() ? reqBo.getSupplierShopId() : String.valueOf(reqBo.getShopIdIn()));
        applyInfoPo.setBillStatus(PfscConstants.BillApplyInfo.BillStatus.INVOICING);
        if (reqBo.getCurrentFragment() != null) {
            applyInfoPo.setCurrentFragment(Integer.valueOf(reqBo.getCurrentFragment()));
        }
        applyInfoPo.setTotalFragment(Integer.valueOf(reqBo.getTotalFragment()));
        List<FscApplyInfoPO> applyInfoPoList = this.applyInfoMapper.getList(applyInfoPo);
        return applyInfoPoList;
    }

    private FscApplyInfoPO qryBillApplyInfo(Long applyNo, String serialNo) {
        FscApplyInfoPO applyInfoPo = new FscApplyInfoPO();
        applyInfoPo.setSerialNo(serialNo);
        applyInfoPo.setApplyNo(applyNo);
        FscApplyInfoPO applyInfoPoResult = this.applyInfoMapper.getModelBy(applyInfoPo);
        if (null == applyInfoPoResult) {
            throw new PfscBusinessException("18003", "\u6839\u636e\u539fapplyNo\u548cserialNo\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u8868\u7ed3\u679c\u4e3a\u7a7a");
        }
        return applyInfoPoResult;
    }

    private PfscBillApplyReceiveInfoBO qryBillApplyReceiveInfo(Long applyNo) {
        FscApplyReceiveInfoPO applyReceiveInfoPo = new FscApplyReceiveInfoPO();
        applyReceiveInfoPo.setApplyNo(applyNo);
        FscApplyReceiveInfoPO po = this.applyReceiveInfoMapper.getModelBy(applyReceiveInfoPo);
        if (null == po) {
            throw new PfscBusinessException("18003", "\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u6536\u7968\u4fe1\u606f\u8868\u7ed3\u679c\u4e3a\u7a7a");
        }
        PfscBillApplyReceiveInfoBO bo = new PfscBillApplyReceiveInfoBO();
        BeanUtils.copyProperties((Object)po, (Object)bo);
        return bo;
    }
}

