/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.invoice.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfsc.api.invoice.ability.bo.PfscPushOrderInfoAbilityReqBO;
import com.tydic.pfsc.api.invoice.bo.PfscPushInvoiceInfoBO;
import com.tydic.pfsc.api.invoice.bo.PfscPushOrderInfoBO;
import com.tydic.pfsc.api.invoice.bo.PfscPushOrderInfoItemBO;
import com.tydic.pfsc.constant.PfscConstants;
import com.tydic.pfsc.dao.FscOrderInfoHisMapper;
import com.tydic.pfsc.dao.FscOrderInfoMapper;
import com.tydic.pfsc.dao.FscOrderInvoiceHisMapper;
import com.tydic.pfsc.dao.FscOrderInvoiceInfoMapper;
import com.tydic.pfsc.dao.FscOrderItemHisMapper;
import com.tydic.pfsc.dao.FscOrderItemInfoMapper;
import com.tydic.pfsc.dao.FscOrderRelOriginMapper;
import com.tydic.pfsc.po.FscOrderInfoHisPO;
import com.tydic.pfsc.po.FscOrderInfoPO;
import com.tydic.pfsc.po.FscOrderInvoiceHisPO;
import com.tydic.pfsc.po.FscOrderInvoiceInfoPO;
import com.tydic.pfsc.po.FscOrderItemHisPO;
import com.tydic.pfsc.po.FscOrderItemInfoPO;
import com.tydic.pfsc.po.FscOrderRelOriginPO;
import com.tydic.pfsc.service.invoice.busi.PfscPushOrderInfoBusiService;
import com.tydic.pfsc.service.invoice.busi.bo.PfscPushOrderInfoRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PfscPushOrderInfoBusiServiceImpl
implements PfscPushOrderInfoBusiService {
    private static final Logger logger = LoggerFactory.getLogger(PfscPushOrderInfoBusiServiceImpl.class);
    @Autowired
    private FscOrderInfoMapper orderInfoMapper;
    @Autowired
    private FscOrderItemInfoMapper orderItemInfoMapper;
    @Autowired
    private FscOrderInvoiceInfoMapper orderInvoiceInfoMapper;
    @Autowired
    private FscOrderInfoHisMapper orderInfoHisMapper;
    @Autowired
    private FscOrderItemHisMapper orderItemHisMapper;
    @Autowired
    private FscOrderInvoiceHisMapper orderInvoiceHisMapper;
    @Autowired
    private FscOrderRelOriginMapper fscOrderRelOriginMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PfscPushOrderInfoRspBO dealPushOrderInfo(PfscPushOrderInfoAbilityReqBO reqBo) {
        PfscPushOrderInfoRspBO pfscPushOrderInfoRspBo = new PfscPushOrderInfoRspBO();
        if (logger.isDebugEnabled()) {
            logger.debug("\u63a5\u6536\u8ba2\u5355\u4e2d\u5fc3\u63a8\u9001\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBo);
        }
        PfscPushOrderInfoBO orderInfoBo = reqBo.getOrderInfo();
        FscOrderInfoPO qryParam = new FscOrderInfoPO();
        qryParam.setOrderId(orderInfoBo.getOrderId());
        qryParam.setSupplierShopId(orderInfoBo.getSupplierShopId());
        qryParam.setSupplierId(orderInfoBo.getSupplierId());
        FscOrderInfoPO qryResult = this.orderInfoMapper.getModelBy(qryParam);
        if (qryResult != null) {
            pfscPushOrderInfoRspBo.setApplyNo(qryResult.getApplyNo());
            pfscPushOrderInfoRspBo.setOrderStatus(qryResult.getOrderStatus());
            Long batchNo = Sequence.getInstance().nextId();
            FscOrderInfoHisPO orderInfoHisPO = new FscOrderInfoHisPO();
            BeanUtils.copyProperties((Object)qryResult, (Object)orderInfoHisPO);
            orderInfoHisPO.setBatchNo(batchNo);
            this.orderInfoHisMapper.insert(orderInfoHisPO);
            this.orderInfoMapper.deleteBy(qryParam);
            FscOrderItemInfoPO orderItemInfoPO = new FscOrderItemInfoPO();
            orderItemInfoPO.setOrderId(orderInfoBo.getOrderId());
            List<FscOrderItemInfoPO> orderItemInfoPOS = this.orderItemInfoMapper.getList(orderItemInfoPO);
            ArrayList<FscOrderItemHisPO> orderItemHisPOS = new ArrayList<FscOrderItemHisPO>();
            if (orderItemInfoPOS != null && orderItemInfoPOS.size() > 0) {
                for (FscOrderItemInfoPO po : orderItemInfoPOS) {
                    FscOrderItemHisPO orderItemHisPO = new FscOrderItemHisPO();
                    BeanUtils.copyProperties((Object)po, (Object)orderItemHisPO);
                    orderItemHisPO.setBatchNo(batchNo);
                    orderItemHisPOS.add(orderItemHisPO);
                }
                this.orderItemHisMapper.insertBatch(orderItemHisPOS);
            }
            FscOrderItemInfoPO delPo = new FscOrderItemInfoPO();
            delPo.setOrderId(orderInfoBo.getOrderId());
            this.orderItemInfoMapper.deleteBy(delPo);
            FscOrderInvoiceInfoPO ordInvPo = new FscOrderInvoiceInfoPO();
            ordInvPo.setOrderId(orderInfoBo.getOrderId());
            FscOrderInvoiceInfoPO ordInvoiceResult = this.orderInvoiceInfoMapper.getModelBy(ordInvPo);
            if (ordInvoiceResult != null) {
                FscOrderInvoiceHisPO orderInvoiceHisPO = new FscOrderInvoiceHisPO();
                BeanUtils.copyProperties((Object)ordInvoiceResult, (Object)orderInvoiceHisPO);
                orderInvoiceHisPO.setBatchNo(batchNo);
                this.orderInvoiceHisMapper.insert(orderInvoiceHisPO);
            }
            this.orderInvoiceInfoMapper.deleteBy(ordInvPo);
        }
        FscOrderInfoPO orderInfoPo = this.assemblingSaleParam(reqBo);
        this.orderInfoMapper.insert(orderInfoPo);
        List<FscOrderItemInfoPO> itemInfoPoList = this.assemblingSaleItemParam(reqBo);
        this.orderItemInfoMapper.insertBatch(itemInfoPoList);
        this.updateOrderRelOrigin(reqBo.getOriginOrderInfo(), reqBo.getOrderInfo().getOrderId(), reqBo.getOrderType());
        PfscPushInvoiceInfoBO invoiceInfoBo = reqBo.getInvoiceInfo();
        if (invoiceInfoBo != null) {
            FscOrderInvoiceInfoPO orderInvoiceInfoPo = this.assemblingSaleInvoiceParam(reqBo);
            this.orderInvoiceInfoMapper.insert(orderInvoiceInfoPo);
        }
        pfscPushOrderInfoRspBo.setRespCode("0000");
        pfscPushOrderInfoRspBo.setRespDesc("\u8ba2\u5355\u63a8\u9001\u6210\u529f");
        return pfscPushOrderInfoRspBo;
    }

    private void updateOrderRelOrigin(List<String> originOrderInfoList, String orderId, Integer orderType) {
        FscOrderRelOriginPO fscOrderRelOriginPo = new FscOrderRelOriginPO();
        fscOrderRelOriginPo.setOrderId(orderId);
        int check = this.fscOrderRelOriginMapper.getCheckBy(fscOrderRelOriginPo);
        if (check > 0) {
            FscOrderRelOriginPO deleteRelPo = new FscOrderRelOriginPO();
            deleteRelPo.setOrderId(orderId);
            this.fscOrderRelOriginMapper.deleteBy(deleteRelPo);
        }
        if (!PfscConstants.OrderType.WELFARE.equals(orderType) && !CollectionUtils.isEmpty(originOrderInfoList)) {
            ArrayList<FscOrderRelOriginPO> orderRelOriginList = new ArrayList<FscOrderRelOriginPO>();
            for (String originOrderInfo : originOrderInfoList) {
                FscOrderRelOriginPO orderRelOriginPo = new FscOrderRelOriginPO();
                orderRelOriginPo.setOrderId(orderId);
                orderRelOriginPo.setOriginOrderJson(originOrderInfo);
                orderRelOriginList.add(orderRelOriginPo);
            }
            this.fscOrderRelOriginMapper.insertBatch(orderRelOriginList);
        }
    }

    private FscOrderInfoPO assemblingSaleParam(PfscPushOrderInfoAbilityReqBO reqBo) {
        PfscPushOrderInfoBO orderInfo = reqBo.getOrderInfo();
        FscOrderInfoPO orderInfoPo = new FscOrderInfoPO();
        orderInfoPo.setOrderId(orderInfo.getOrderId());
        orderInfoPo.setSupplierId(orderInfo.getSupplierId());
        orderInfoPo.setSupplierShopId(orderInfo.getSupplierShopId());
        if (orderInfo.getRecvDate() != null) {
            orderInfoPo.setRecvDate(DateUtils.strToDateLong((String)orderInfo.getRecvDate()));
        }
        if (orderInfo.getOrderDate() != null) {
            orderInfoPo.setOrderDate(DateUtils.strToDateLong((String)orderInfo.getOrderDate()));
        }
        orderInfoPo.setOrderAmt(orderInfo.getOrderAmt());
        orderInfoPo.setTotalAmt(orderInfo.getTotalAmt());
        orderInfoPo.setDisAmt(orderInfo.getDisAmt());
        orderInfoPo.setPurchaserId(orderInfo.getPurchaserId());
        orderInfoPo.setPurchaseName(orderInfo.getPurchaseName());
        orderInfoPo.setSource(orderInfo.getSource());
        orderInfoPo.setPlatformCode("OTHER");
        orderInfoPo.setOrderStatus(PfscConstants.OrderStatus.UNCOMMITED);
        orderInfoPo.setInvoiceFlag(reqBo.getOrderInfo().getInvoiceFlag());
        orderInfoPo.setOrderType(reqBo.getOrderType());
        return orderInfoPo;
    }

    private List<FscOrderItemInfoPO> assemblingSaleItemParam(PfscPushOrderInfoAbilityReqBO reqBo) {
        ArrayList<FscOrderItemInfoPO> itemInfoPoList = new ArrayList<FscOrderItemInfoPO>();
        List itemBoList = reqBo.getItemList();
        for (PfscPushOrderInfoItemBO itemBo : itemBoList) {
            FscOrderItemInfoPO orderItemInfoPo = new FscOrderItemInfoPO();
            orderItemInfoPo.setOrderId(reqBo.getOrderInfo().getOrderId());
            orderItemInfoPo.setOrdItemId(itemBo.getOrdItemId());
            orderItemInfoPo.setSkuId(itemBo.getSkuId());
            orderItemInfoPo.setSkuName(itemBo.getSkuName());
            orderItemInfoPo.setSpec(itemBo.getSpec());
            orderItemInfoPo.setModel(itemBo.getModel());
            orderItemInfoPo.setFigureNo(itemBo.getFigureNo());
            BigDecimal unitPrice = itemBo.getSaleUnitPrice();
            orderItemInfoPo.setSaleUnitPrice(unitPrice);
            orderItemInfoPo.setQuantity(itemBo.getQuantity());
            orderItemInfoPo.setUnitName(itemBo.getUnitName());
            orderItemInfoPo.setTaxRate(null == itemBo.getTaxRate() ? PfscConstants.TAX_RATE : itemBo.getTaxRate());
            orderItemInfoPo.setExtOrderId(itemBo.getExtOrderId());
            orderItemInfoPo.setExtSubOrderId(itemBo.getExtSubOrderId());
            orderItemInfoPo.setRedEnvelopeFee(itemBo.getRedEnvelopeFee());
            orderItemInfoPo.setReduceFee(itemBo.getReduceFee());
            orderItemInfoPo.setActFee(itemBo.getActFee());
            orderItemInfoPo.setTotalAmt(itemBo.getTotalAmt());
            BigDecimal realFee = itemBo.getTotalAmt().subtract(itemBo.getRedEnvelopeFee()).subtract(itemBo.getReduceFee());
            BigDecimal untaxAmt = realFee.divide(BigDecimal.ONE.add(orderItemInfoPo.getTaxRate()), 6, 6);
            BigDecimal taxAmt = untaxAmt.multiply(orderItemInfoPo.getTaxRate());
            orderItemInfoPo.setTaxAmt(taxAmt.setScale(2, 6));
            orderItemInfoPo.setUntaxAmt(untaxAmt.setScale(2, 6));
            orderItemInfoPo.setAmount(realFee);
            orderItemInfoPo.setItemNo(itemBo.getItemNo());
            orderItemInfoPo.setSeq(Sequence.getInstance().nextId());
            orderItemInfoPo.setItemStatus(0);
            orderItemInfoPo.setQuantityApplied(BigDecimal.ZERO);
            orderItemInfoPo.setAmountApplied(BigDecimal.ZERO);
            orderItemInfoPo.setReturnQuantity(BigDecimal.ZERO);
            orderItemInfoPo.setRefundFee(BigDecimal.ZERO);
            if (itemBo.getReturnQuantity() != null) {
                orderItemInfoPo.setReturnQuantity(itemBo.getReturnQuantity());
            }
            if (itemBo.getRefundFee() != null) {
                orderItemInfoPo.setRefundFee(itemBo.getRefundFee());
            }
            itemInfoPoList.add(orderItemInfoPo);
        }
        return itemInfoPoList;
    }

    private FscOrderInvoiceInfoPO assemblingSaleInvoiceParam(PfscPushOrderInfoAbilityReqBO reqBo) {
        PfscPushInvoiceInfoBO invoiceInfoBo = reqBo.getInvoiceInfo();
        FscOrderInvoiceInfoPO orderInvoiceInfoPo = new FscOrderInvoiceInfoPO();
        BeanUtils.copyProperties((Object)invoiceInfoBo, (Object)orderInvoiceInfoPo);
        orderInvoiceInfoPo.setSeq(Sequence.getInstance().nextId());
        orderInvoiceInfoPo.setOrderId(reqBo.getOrderInfo().getOrderId());
        return orderInvoiceInfoPo;
    }
}

