/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.invoice.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfsc.api.invoice.ability.PfscPushOrderInfoAbilityService;
import com.tydic.pfsc.api.invoice.ability.bo.PfscPushOrderInfoAbilityReqBO;
import com.tydic.pfsc.api.invoice.ability.bo.PfscPushOrderInfoAbilityRspBO;
import com.tydic.pfsc.api.invoice.bo.PfscPushOrderInfoBO;
import com.tydic.pfsc.api.invoice.bo.PfscPushOrderInfoItemBO;
import com.tydic.pfsc.constant.PfscConstants;
import com.tydic.pfsc.exception.PfscBusinessException;
import com.tydic.pfsc.service.invoice.comb.PfscPushOrderInfoCombService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="PFSC_GROUP_DEV", serviceInterface=PfscPushOrderInfoAbilityService.class)
public class PfscPushOrderInfoAbilityServiceImpl
implements PfscPushOrderInfoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PfscPushOrderInfoAbilityServiceImpl.class);
    @Autowired
    private PfscPushOrderInfoCombService pfscPushOrderInfoCombService;

    public PfscPushOrderInfoAbilityRspBO dealPushOrderInfo(PfscPushOrderInfoAbilityReqBO reqBo) {
        this.validParam(reqBo);
        return this.pfscPushOrderInfoCombService.dealApplyInvoice(reqBo);
    }

    private void validParam(PfscPushOrderInfoAbilityReqBO reqBo) {
        PfscPushOrderInfoBO orderInfoBo;
        if (reqBo == null) {
            throw new PfscBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderType()) {
            reqBo.setOrderType(PfscConstants.OrderType.GENERAL_ORDER);
        }
        if ((orderInfoBo = reqBo.getOrderInfo()) == null) {
            throw new PfscBusinessException("18001", "\u5165\u53c2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u3010orderInfo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (PfscConstants.OrderType.WELFARE.equals(reqBo.getOrderType()) || PfscConstants.OrderType.MIXED_ORDER.equals(reqBo.getOrderType())) {
            orderInfoBo.setOrderId(String.valueOf(Sequence.getInstance().nextId()));
        }
        if (orderInfoBo.getOrderId() == null) {
            throw new PfscBusinessException("18001", "\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderInfoBo.getSupplierId() == null) {
            throw new PfscBusinessException("18001", "\u5165\u53c2\u5546\u6237ID\u3010supplierId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderInfoBo.getSupplierShopId() == null) {
            orderInfoBo.setSupplierShopId(orderInfoBo.getSupplierId());
        }
        if (orderInfoBo.getOrderAmt() == null) {
            throw new PfscBusinessException("18001", "\u5165\u53c2\u9500\u552e\u8ba2\u5355\u91d1\u989d\u3010orderAmt\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderInfoBo.getInvoiceFlag() == null) {
            throw new PfscBusinessException("18001", "\u5165\u53c2\u662f\u5426\u5f00\u7968\u6807\u8bc6\u3010invoiceFlag\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List itemList = reqBo.getItemList();
        if (CollectionUtils.isEmpty((Collection)itemList)) {
            throw new PfscBusinessException("18000", "\u5165\u53c2\u9500\u552e\u5546\u54c1\u4fe1\u606f\u3010itemList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int count = 0;
        for (PfscPushOrderInfoItemBO itemBo : itemList) {
            boolean ifGenOrdItemId;
            boolean bl = ifGenOrdItemId = (PfscConstants.OrderType.WELFARE.equals(reqBo.getOrderType()) || PfscConstants.OrderType.MIXED_ORDER.equals(reqBo.getOrderType())) && null == itemBo.getOrdItemId();
            if (ifGenOrdItemId) {
                itemBo.setOrdItemId(String.valueOf(Sequence.getInstance().nextId()));
                if (null == itemBo.getSkuId()) {
                    itemBo.setSkuId("0");
                }
            }
            if (itemBo.getOrdItemId() == null) {
                throw new PfscBusinessException("18001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6ID\u3010ordItemId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (itemBo.getItemNo() == null) {
                throw new PfscBusinessException("18001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u5546\u54c1\u7f16\u53f7\u3010itemNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (itemBo.getSkuId() == null) {
                throw new PfscBusinessException("18001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u5546\u54c1ID\u3010skuId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (itemBo.getSkuName() == null) {
                throw new PfscBusinessException("18001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u5546\u54c1\u540d\u79f0\u3010skuName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (itemBo.getSaleUnitPrice() == null) {
                throw new PfscBusinessException("18001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u9500\u552e\u5355\u4ef7\u3010saleUnitPrice\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (itemBo.getQuantity() == null) {
                throw new PfscBusinessException("18001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u5546\u54c1\u6570\u91cf\u3010quantity\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)itemBo.getUnitName())) {
                itemBo.setUnitName("\u4ef6");
            }
            ++count;
            BigDecimal discount = BigDecimal.ZERO;
            if (null != itemBo.getRedEnvelopeFee()) {
                discount = discount.add(itemBo.getRedEnvelopeFee());
            }
            if (null != itemBo.getReduceFee()) {
                discount = discount.add(itemBo.getReduceFee());
            }
            if (null != itemBo.getActFee()) {
                discount = discount.add(itemBo.getActFee());
            }
            if (BigDecimal.ZERO.compareTo(discount) < 0) {
                ++count;
            }
            if (count <= 100) continue;
            throw new PfscBusinessException("18002", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u53ca\u4f18\u60e0\u5355\u6b21\u6700\u591a\u652f\u6301100\u6761");
        }
    }
}

