/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.invoice.busi.impl;

import com.tydic.pfsc.constant.PfscConstants;
import com.tydic.pfsc.dao.FscApplyInfoMapper;
import com.tydic.pfsc.dao.FscApplyItemInfoMapper;
import com.tydic.pfsc.dao.FscInvoiceInfoMapper;
import com.tydic.pfsc.exception.PfscBusinessException;
import com.tydic.pfsc.external.api.einvoice.IfcReqCreateEinvoiceIntfService;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceItemBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcReqCreateEinvoiceReqBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcReqCreateEinvoiceRspBO;
import com.tydic.pfsc.po.FscApplyInfoPO;
import com.tydic.pfsc.po.FscApplyItemInfoPO;
import com.tydic.pfsc.po.FscInvoiceInfoPO;
import com.tydic.pfsc.po.FscOrderInfoPO;
import com.tydic.pfsc.service.invoice.atom.PfscElecApplyAtomService;
import com.tydic.pfsc.service.invoice.atom.PfscElecInvoiceApplySaveAtomService;
import com.tydic.pfsc.service.invoice.atom.PfscQrySaleOrderAtomService;
import com.tydic.pfsc.service.invoice.atom.bo.PfscElecApplyAtomReqBO;
import com.tydic.pfsc.service.invoice.atom.bo.PfscElecApplyAtomRspBO;
import com.tydic.pfsc.service.invoice.atom.bo.PfscElecInvoiceApplyAtomReqBO;
import com.tydic.pfsc.service.invoice.atom.bo.PfscElecInvoiceApplyAtomRspBO;
import com.tydic.pfsc.service.invoice.busi.PfscElecInvoiceApplyBusiService;
import com.tydic.pfsc.service.invoice.busi.PfscElecInvoiceApplyParamBusiService;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyBusiReqBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyBusiRspBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyParamBusiReqBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyParamBusiRspBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscQrySaleOrderInfoBusiReqBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscQrySaleOrderInfoBusiRspBO;
import com.tydic.pfsc.service.invoice.common.bo.PfscBillApplyInfoBO;
import com.tydic.pfsc.service.invoice.common.bo.PfscBillApplyItemInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PfscElecInvoiceApplyBusiServiceImpl
implements PfscElecInvoiceApplyBusiService {
    private static final Logger logger = LoggerFactory.getLogger(PfscElecInvoiceApplyBusiServiceImpl.class);
    @Autowired
    private PfscQrySaleOrderAtomService pfscQrySaleOrderAtomService;
    @Autowired
    private IfcReqCreateEinvoiceIntfService ifcReqCreateEinvoiceIntfService;
    @Autowired
    private PfscElecInvoiceApplySaveAtomService pfscElecInvoiceApplySaveAtomService;
    @Autowired
    private PfscElecApplyAtomService pfscElecApplyAtomService;
    @Autowired
    private PfscElecInvoiceApplyParamBusiService pfscElecInvoiceApplyParamBusiService;
    @Autowired
    private FscInvoiceInfoMapper invoiceInfoMapper;
    @Autowired
    private FscApplyInfoMapper applyInfoMapper;
    @Autowired
    private FscApplyItemInfoMapper applyItemInfoMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PfscElecInvoiceApplyBusiRspBO commitElecInvoiceApply(PfscElecInvoiceApplyBusiReqBO reqBo) {
        PfscElecInvoiceApplyBusiRspBO rspBo = new PfscElecInvoiceApplyBusiRspBO();
        PfscQrySaleOrderInfoBusiReqBO saleOrderInfoBusiReqBo = new PfscQrySaleOrderInfoBusiReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)((Object)saleOrderInfoBusiReqBo));
        PfscQrySaleOrderInfoBusiRspBO saleOrderInfoBusiRspBo = this.pfscQrySaleOrderAtomService.qrySaleOrderInfo(saleOrderInfoBusiReqBo);
        if (!"0000".equals(saleOrderInfoBusiRspBo.getRespCode())) {
            throw new PfscBusinessException("8888", "\u8c03\u7528\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        FscOrderInfoPO orderInfoPO = saleOrderInfoBusiRspBo.getSaleOrderInfo();
        if (orderInfoPO == null) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u8be5\u8ba2\u5355\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f\uff0c\u65e0\u9700\u5f00\u7968\uff0c\u8bf7\u6838\u5b9e");
            rspBo.setOrderStatus(PfscConstants.OrderStatus.REFUNDALL);
            return rspBo;
        }
        if (PfscConstants.BillApplyInfo.BillStatus.INVOICING.equals(reqBo.getOrderStatus())) {
            throw new PfscBusinessException("8888", "\u8be5\u8ba2\u5355\u5df2\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\uff0c\u4e0d\u80fd\u91cd\u590d\u7533\u8bf7");
        }
        if (PfscConstants.BillApplyInfo.BillStatus.REFUNDING.equals(reqBo.getOrderStatus())) {
            throw new PfscBusinessException("8888", "\u8be5\u8ba2\u5355\u5df2\u63d0\u4ea4\u9000\u7968\u7533\u8bf7\uff0c\u4e0d\u80fd\u7533\u8bf7\u5f00\u7968");
        }
        if ("0".equals(reqBo.getBkFlag()) && (PfscConstants.BillApplyInfo.BillStatus.INVOICED.equals(reqBo.getOrderStatus()) || PfscConstants.BillApplyInfo.BillStatus.INVOICING.equals(reqBo.getOrderStatus()))) {
            throw new PfscBusinessException("8888", "\u8be5\u8ba2\u5355\u5f00\u7968\u72b6\u6001\uff0c\u4e0d\u7b26\u5408\u8865\u5f00\u53d1\u7968");
        }
        if (PfscConstants.BillApplyInfo.BillStatus.INVOICED.equals(reqBo.getOrderStatus())) {
            FscInvoiceInfoPO invoiceInfoPo = new FscInvoiceInfoPO();
            invoiceInfoPo.setApplyNo(reqBo.getApplyNo());
            invoiceInfoPo.setInvoiceKind(PfscConstants.OrderInvoiceInfo.InvoiceType.ELECTRONIC);
            invoiceInfoPo = this.invoiceInfoMapper.getModelBy(invoiceInfoPo);
            if (invoiceInfoPo == null) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u8ba2\u5355\u672a\u67e5\u8be2\u5230\u7535\u5b50\u53d1\u7968\uff0c\u8bf7\u6838\u5b9e\u662f\u5426\u5f00\u7968!");
                return rspBo;
            }
            PfscElecInvoiceApplyParamBusiReqBO paramBusiReqBo = new PfscElecInvoiceApplyParamBusiReqBO();
            paramBusiReqBo.setOrderId(reqBo.getOrderId());
            PfscElecInvoiceApplyParamBusiRspBO paramBusiRspBo = this.pfscElecInvoiceApplyParamBusiService.applyCommonParam(paramBusiReqBo);
            PfscElecInvoiceApplyAtomReqBO elecAtomReqBo = this.assemblingApplyParam(invoiceInfoPo, paramBusiRspBo);
            IfcReqCreateEinvoiceReqBO einvoiceReqBo = this.assemblingIfcInvoiceCreateParam(elecAtomReqBo);
            IfcReqCreateEinvoiceRspBO einvoiceRspBo = this.ifcReqCreateEinvoiceIntfService.requestToCreateEinvoice(einvoiceReqBo);
            if (null == einvoiceRspBo.getIsSuccess() || !einvoiceRspBo.getIsSuccess().booleanValue()) {
                throw new PfscBusinessException("18009", "\u8c03\u7528\u963f\u91cc\u5f00\u7968\u7533\u8bf7\u63a5\u53e3\u5931\u8d25:" + einvoiceRspBo.getSubMsg());
            }
            PfscElecInvoiceApplyAtomRspBO atomRspBo = this.pfscElecInvoiceApplySaveAtomService.saveApplyInfo(elecAtomReqBo);
            if (!"0000".equals(atomRspBo.getRespCode())) {
                throw new PfscBusinessException("18009", "\u8c03\u7528\u53d1\u7968\u7533\u8bf7\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a" + atomRspBo.getRespDesc());
            }
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u8ba2\u5355\u7ea2\u7968\u7533\u8bf7\u6210\u529f");
            rspBo.setOrderId(reqBo.getOrderId());
            rspBo.setApplyNo(atomRspBo.getApplyNo());
        } else {
            PfscElecApplyAtomReqBO pfscElecApplyAtomReqBO = new PfscElecApplyAtomReqBO();
            pfscElecApplyAtomReqBO.setOrderId(reqBo.getOrderId());
            pfscElecApplyAtomReqBO.setOrderInfoPo(orderInfoPO);
            pfscElecApplyAtomReqBO.setSupplierId(reqBo.getSupplierId());
            pfscElecApplyAtomReqBO.setSupplierShopId(reqBo.getSupplierShopId());
            pfscElecApplyAtomReqBO.setUserId(reqBo.getUserId());
            pfscElecApplyAtomReqBO.setUserName(reqBo.getUserName());
            pfscElecApplyAtomReqBO.setUserDeptId(reqBo.getUserDeptId());
            pfscElecApplyAtomReqBO.setUserDeptName(reqBo.getUserDeptName());
            pfscElecApplyAtomReqBO.setInvoiceMemo(reqBo.getInvoiceMemo());
            PfscElecApplyAtomRspBO pfscElecApplyAtomRspBO = this.pfscElecApplyAtomService.dealApply(pfscElecApplyAtomReqBO);
            if (!"0000".equals(pfscElecApplyAtomRspBO.getRespCode())) {
                rspBo.setRespCode(pfscElecApplyAtomRspBO.getRespCode());
                rspBo.setRespDesc(pfscElecApplyAtomRspBO.getRespDesc());
                return rspBo;
            }
            rspBo.setSaleItemInfoList(pfscElecApplyAtomRspBO.getSaleItemInfoList());
            rspBo.setApplyNo(pfscElecApplyAtomRspBO.getApplyNo());
            rspBo.setOrderStatus(pfscElecApplyAtomRspBO.getOrderStatus());
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u7535\u5b50\u53d1\u7968\u7533\u8bf7\u63d0\u4ea4\u5b8c\u6210");
        }
        return rspBo;
    }

    private PfscElecInvoiceApplyAtomReqBO assemblingApplyParam(FscInvoiceInfoPO invoiceInfoPo, PfscElecInvoiceApplyParamBusiRspBO paramBusiRspBo) {
        PfscElecInvoiceApplyAtomReqBO atomReqBo = new PfscElecInvoiceApplyAtomReqBO();
        FscApplyInfoPO applyInfoPo = new FscApplyInfoPO();
        applyInfoPo.setApplyNo(invoiceInfoPo.getApplyNo());
        applyInfoPo.setRedBlue("blue");
        applyInfoPo.setBillStatus(PfscConstants.BillApplyInfo.BillStatus.INVOICED);
        applyInfoPo = this.applyInfoMapper.getModelBy(applyInfoPo);
        if (applyInfoPo == null) {
            throw new PfscBusinessException("18003", "\u67e5\u8be2\u539f\u53d1\u7968\u5f00\u7968\u7533\u8bf7\u8868\u65e0\u6570\u636e");
        }
        PfscBillApplyInfoBO pfscBillApplyInfoBo = new PfscBillApplyInfoBO();
        BeanUtils.copyProperties((Object)applyInfoPo, (Object)pfscBillApplyInfoBo);
        pfscBillApplyInfoBo.setApplyCode(paramBusiRspBo.getApplyCode());
        pfscBillApplyInfoBo.setSerialNo(paramBusiRspBo.getSerialNo());
        pfscBillApplyInfoBo.setAmt(applyInfoPo.getAmt().negate());
        pfscBillApplyInfoBo.setTaxAmt(applyInfoPo.getTaxAmt().negate());
        pfscBillApplyInfoBo.setUntaxAmt(applyInfoPo.getUntaxAmt().negate());
        pfscBillApplyInfoBo.setApplyDate(new Date());
        pfscBillApplyInfoBo.setRedBlue("red");
        pfscBillApplyInfoBo.setNormalInvoiceCode(invoiceInfoPo.getInvoiceCode());
        pfscBillApplyInfoBo.setNormalInvoiceNo(invoiceInfoPo.getInvoiceNo());
        pfscBillApplyInfoBo.setBillStatus(PfscConstants.BillApplyInfo.BillStatus.INVOICING);
        ArrayList<PfscBillApplyItemInfoBO> pfscBillApplyItemInfoBoList = new ArrayList<PfscBillApplyItemInfoBO>();
        FscApplyItemInfoPO applyItemInfoPo = new FscApplyItemInfoPO();
        applyItemInfoPo.setApplyNo(invoiceInfoPo.getApplyNo());
        applyItemInfoPo.setSerialNo(applyInfoPo.getSerialNo());
        List<FscApplyItemInfoPO> oldApplyItemPos = this.applyItemInfoMapper.getList(applyItemInfoPo);
        if (!CollectionUtils.isEmpty(oldApplyItemPos)) {
            HashMap<Long, ArrayList<FscApplyItemInfoPO>> applyItemsMap = new HashMap<Long, ArrayList<FscApplyItemInfoPO>>();
            for (FscApplyItemInfoPO applyItemPo : oldApplyItemPos) {
                ArrayList<FscApplyItemInfoPO> tmpList = (ArrayList<FscApplyItemInfoPO>)applyItemsMap.get(applyItemPo.getSeq());
                if (tmpList == null) {
                    tmpList = new ArrayList<FscApplyItemInfoPO>();
                    tmpList.add(applyItemPo);
                    applyItemsMap.put(applyItemPo.getSeq(), tmpList);
                    continue;
                }
                tmpList.add(applyItemPo);
            }
            for (Long seq : applyItemsMap.keySet()) {
                List itemInfoPOS = (List)applyItemsMap.get(seq);
                BigDecimal taxAmt = BigDecimal.ZERO;
                BigDecimal untaxAmt = BigDecimal.ZERO;
                BigDecimal amt = BigDecimal.ZERO;
                PfscBillApplyItemInfoBO normalItemBo = new PfscBillApplyItemInfoBO();
                for (FscApplyItemInfoPO itemInfoPO : itemInfoPOS) {
                    if (PfscConstants.RowType.NORMAL_LINE.equals(itemInfoPO.getRowType()) || PfscConstants.RowType.DISCOUNTED_LINE.equals(itemInfoPO.getRowType())) {
                        normalItemBo.setSeq(itemInfoPO.getSeq());
                        normalItemBo.setApplyNo(itemInfoPO.getApplyNo());
                        normalItemBo.setItemNo(itemInfoPO.getItemNo());
                        normalItemBo.setItemName(itemInfoPO.getItemName());
                        normalItemBo.setRowType(PfscConstants.RowType.NORMAL_LINE);
                        normalItemBo.setTaxRate(PfscConstants.TAX_RATE);
                        normalItemBo.setQuantity(itemInfoPO.getQuantity().negate());
                        normalItemBo.setUnit(itemInfoPO.getUnit());
                        normalItemBo.setApplyNo(invoiceInfoPo.getApplyNo());
                        normalItemBo.setSerialNo(paramBusiRspBo.getSerialNo());
                        normalItemBo.setStatus(PfscConstants.StatusType.VALID);
                    }
                    taxAmt = taxAmt.add(itemInfoPO.getTaxAmt());
                    untaxAmt = untaxAmt.add(itemInfoPO.getUntaxAmt());
                    amt = amt.add(itemInfoPO.getAmount());
                }
                normalItemBo.setPrice(untaxAmt.divide(normalItemBo.getQuantity().negate()));
                normalItemBo.setUntaxAmt(untaxAmt.negate());
                normalItemBo.setTaxAmt(taxAmt.negate());
                normalItemBo.setAmount(amt.negate());
                pfscBillApplyItemInfoBoList.add(normalItemBo);
            }
        }
        atomReqBo.setPfscBillApplyInfo(pfscBillApplyInfoBo);
        atomReqBo.setBillApplyItemList(pfscBillApplyItemInfoBoList);
        return atomReqBo;
    }

    private IfcReqCreateEinvoiceReqBO assemblingIfcInvoiceCreateParam(PfscElecInvoiceApplyAtomReqBO reqBo) {
        IfcReqCreateEinvoiceReqBO ifcReqCreateEinvoiceReqBo = new IfcReqCreateEinvoiceReqBO();
        PfscBillApplyInfoBO pfscBillApplyInfoBo = reqBo.getPfscBillApplyInfo();
        ifcReqCreateEinvoiceReqBo.setBusinessType(Long.valueOf(pfscBillApplyInfoBo.getInvoceNameType().intValue()));
        ifcReqCreateEinvoiceReqBo.setPlatformCode("OTHER");
        ifcReqCreateEinvoiceReqBo.setPlatformTid(String.valueOf(pfscBillApplyInfoBo.getApplyNo()));
        ifcReqCreateEinvoiceReqBo.setSerialNo(pfscBillApplyInfoBo.getSerialNo());
        ifcReqCreateEinvoiceReqBo.setPayeeAddress(pfscBillApplyInfoBo.getPayeeAddress());
        ifcReqCreateEinvoiceReqBo.setPayeeName(pfscBillApplyInfoBo.getPayeeName());
        ifcReqCreateEinvoiceReqBo.setPayerRegisterNo(pfscBillApplyInfoBo.getTaxNo());
        ifcReqCreateEinvoiceReqBo.setInvoiceAmount(pfscBillApplyInfoBo.getAmt() + "");
        ifcReqCreateEinvoiceReqBo.setInvoiceType("red");
        ifcReqCreateEinvoiceReqBo.setNormalInvoiceCode(pfscBillApplyInfoBo.getNormalInvoiceCode());
        ifcReqCreateEinvoiceReqBo.setNormalInvoiceNo(pfscBillApplyInfoBo.getNormalInvoiceNo());
        ifcReqCreateEinvoiceReqBo.setPayeeRegisterNo(pfscBillApplyInfoBo.getPayeeRegisterNo());
        ifcReqCreateEinvoiceReqBo.setPayerName(pfscBillApplyInfoBo.getInvoceName());
        ifcReqCreateEinvoiceReqBo.setSumTax(pfscBillApplyInfoBo.getTaxAmt() + "");
        ifcReqCreateEinvoiceReqBo.setSumPrice(pfscBillApplyInfoBo.getUntaxAmt() + "");
        ifcReqCreateEinvoiceReqBo.setInvoiceKind(Long.valueOf(0L));
        ifcReqCreateEinvoiceReqBo.setOutShopName("\u534e\u6cca\u79d1\u6280-\u5f00\u7968");
        ifcReqCreateEinvoiceReqBo.setInvoiceMemo(reqBo.getPfscBillApplyInfo().getInvoiceMemo());
        List<PfscBillApplyItemInfoBO> itemInfoBoList = reqBo.getBillApplyItemList();
        ArrayList<IfcEinvoiceItemBO> ifcEinvoiceItemBoList = new ArrayList<IfcEinvoiceItemBO>();
        for (PfscBillApplyItemInfoBO pfscBillApplyItemInfoBo : itemInfoBoList) {
            IfcEinvoiceItemBO ifcEinvoiceItemBo = new IfcEinvoiceItemBO();
            ifcEinvoiceItemBo.setItemNo(pfscBillApplyItemInfoBo.getItemNo() + "");
            ifcEinvoiceItemBo.setItemName(pfscBillApplyItemInfoBo.getItemName().length() > 45 ? pfscBillApplyItemInfoBo.getItemName().substring(0, 45) : pfscBillApplyItemInfoBo.getItemName());
            ifcEinvoiceItemBo.setRowType(String.valueOf(pfscBillApplyItemInfoBo.getRowType()));
            ifcEinvoiceItemBo.setPrice(String.valueOf(pfscBillApplyItemInfoBo.getPrice()));
            ifcEinvoiceItemBo.setQuantity(String.valueOf(pfscBillApplyItemInfoBo.getQuantity()));
            ifcEinvoiceItemBo.setSpecification(pfscBillApplyItemInfoBo.getSpec());
            ifcEinvoiceItemBo.setSumPrice(String.valueOf(pfscBillApplyItemInfoBo.getUntaxAmt()));
            ifcEinvoiceItemBo.setTax(String.valueOf(pfscBillApplyItemInfoBo.getTaxAmt()));
            ifcEinvoiceItemBo.setTaxRate(String.valueOf(pfscBillApplyItemInfoBo.getTaxRate()));
            ifcEinvoiceItemBo.setUnit(pfscBillApplyItemInfoBo.getUnit());
            ifcEinvoiceItemBo.setAmount(String.valueOf(pfscBillApplyItemInfoBo.getAmount()));
            ifcEinvoiceItemBoList.add(ifcEinvoiceItemBo);
        }
        ifcReqCreateEinvoiceReqBo.setInvoiceItems(ifcEinvoiceItemBoList);
        return ifcReqCreateEinvoiceReqBo;
    }
}

