/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.invoice.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfsc.api.invoice.ability.bo.PfscElecInvoiceApplyByReqAbilityReqBO;
import com.tydic.pfsc.api.invoice.ability.bo.PfscElecInvoiceApplyByReqAbilityRspBO;
import com.tydic.pfsc.api.invoice.bo.PfscBusiInvoiceInfoBO;
import com.tydic.pfsc.api.invoice.bo.PfscOrderInvoiceInfoBO;
import com.tydic.pfsc.api.invoice.bo.PfscSaleItemInfoBO;
import com.tydic.pfsc.constant.PfscConstants;
import com.tydic.pfsc.exception.PfscBusinessException;
import com.tydic.pfsc.external.api.einvoice.IfcReqCreateEinvoiceIntfService;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceItemBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcReqCreateEinvoiceReqBO;
import com.tydic.pfsc.po.FscApplyInfoPO;
import com.tydic.pfsc.po.FscApplyItemInfoPO;
import com.tydic.pfsc.po.FscApplyReceiveInfoPO;
import com.tydic.pfsc.service.invoice.atom.PfscElecInvoiceApplySaveAtomService;
import com.tydic.pfsc.service.invoice.atom.bo.PfscElecInvoiceApplyAtomReqBO;
import com.tydic.pfsc.service.invoice.atom.bo.PfscElecInvoiceApplyAtomRspBO;
import com.tydic.pfsc.service.invoice.busi.PfscElecInvoiceApplyByReqBusiService;
import com.tydic.pfsc.service.invoice.busi.PfscElecInvoiceApplyParamBusiService;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyParamBusiReqBO;
import com.tydic.pfsc.service.invoice.busi.bo.PfscElecInvoiceApplyParamBusiRspBO;
import com.tydic.pfsc.service.invoice.common.bo.PfscBillApplyInfoBO;
import com.tydic.pfsc.service.invoice.common.bo.PfscBillApplyItemInfoBO;
import com.tydic.pfsc.service.invoice.common.bo.PfscBillApplyReceiveInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfscElecInvoiceApplyByReqBusiServiceImpl
implements PfscElecInvoiceApplyByReqBusiService {
    private static final Logger log = LoggerFactory.getLogger(PfscElecInvoiceApplyByReqBusiServiceImpl.class);
    @Autowired
    private IfcReqCreateEinvoiceIntfService ifcReqCreateEinvoiceIntfService;
    @Autowired
    private PfscElecInvoiceApplySaveAtomService pfscElecInvoiceApplyAtomService;
    @Autowired
    private PfscElecInvoiceApplyParamBusiService pfscElecInvoiceApplyParamBusiService;
    private List<FscApplyItemInfoPO> billApplyItemInfoList = new ArrayList<FscApplyItemInfoPO>();
    private BigDecimal invoiceAmount = BigDecimal.ZERO;
    private BigDecimal sumPrice = BigDecimal.ZERO;
    private BigDecimal sumTax = BigDecimal.ZERO;
    private BigDecimal taxRate = BigDecimal.ZERO;
    private String redBlue;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PfscElecInvoiceApplyByReqAbilityRspBO commitElecInvoiceApply(PfscElecInvoiceApplyByReqAbilityReqBO reqBo) {
        PfscElecInvoiceApplyByReqAbilityRspBO rspBo = new PfscElecInvoiceApplyByReqAbilityRspBO();
        this.redBlue = reqBo.getRedBlue() == null ? "blue" : reqBo.getRedBlue();
        PfscElecInvoiceApplyParamBusiReqBO paramBusiReqBo = new PfscElecInvoiceApplyParamBusiReqBO();
        PfscElecInvoiceApplyParamBusiRspBO paramBusiRspBo = this.pfscElecInvoiceApplyParamBusiService.applyCommonParam(paramBusiReqBo);
        if (!paramBusiRspBo.getRespCode().equals("0000")) {
            throw new PfscBusinessException("8888", "\u8c03\u7528\u7535\u5b50\u53d1\u7968\u7533\u8bf7\u63d0\u4ea4\u5171\u7528\u5165\u53c2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        this.recordBillApplyItemInfo(reqBo, paramBusiRspBo);
        FscApplyInfoPO applyInfoPo = this.recordBillApplyInfo(reqBo, paramBusiRspBo);
        FscApplyReceiveInfoPO applyReceiveInfoPo = this.recordBillApplyReceiveInfo(reqBo, paramBusiRspBo);
        if (this.invoiceAmount.compareTo(reqBo.getAmount()) != 0) {
            throw new PfscBusinessException("8888", "\u660e\u7ec6\u542b\u7a0e\u91d1\u989d\u4e4b\u548c\u4e0e\u5165\u53c2\u542b\u7a0e\u91d1\u989d\u4e0d\u76f8\u7b49");
        }
        IfcReqCreateEinvoiceReqBO einvoiceReqBo = this.prepareEinvoiceReqParams(reqBo, paramBusiRspBo);
        log.debug("\u5f00\u7968\u7533\u8bf7\u5165\u53c2\uff1a" + JSON.toJSONString((Object)einvoiceReqBo));
        PfscElecInvoiceApplyAtomReqBO applyAtomReqBo = new PfscElecInvoiceApplyAtomReqBO();
        ArrayList<PfscBillApplyItemInfoBO> pfscBillApplyItemInfoList = new ArrayList<PfscBillApplyItemInfoBO>();
        PfscBillApplyReceiveInfoBO pfscBillApplyReceiveInfoBo = new PfscBillApplyReceiveInfoBO();
        PfscBillApplyInfoBO pfscBillApplyInfoBo = new PfscBillApplyInfoBO();
        for (FscApplyItemInfoPO applyItemInfoPo : this.billApplyItemInfoList) {
            PfscBillApplyItemInfoBO pfscBillApplyItemInfoBo = new PfscBillApplyItemInfoBO();
            BeanUtils.copyProperties((Object)applyItemInfoPo, (Object)pfscBillApplyItemInfoBo);
            pfscBillApplyItemInfoList.add(pfscBillApplyItemInfoBo);
        }
        BeanUtils.copyProperties((Object)applyInfoPo, (Object)pfscBillApplyInfoBo);
        BeanUtils.copyProperties((Object)applyReceiveInfoPo, (Object)pfscBillApplyReceiveInfoBo);
        applyAtomReqBo.setBillApplyItemList(pfscBillApplyItemInfoList);
        applyAtomReqBo.setPfscBillApplyInfo(pfscBillApplyInfoBo);
        applyAtomReqBo.setPfscBillApplyReceiveInfo(pfscBillApplyReceiveInfoBo);
        PfscElecInvoiceApplyAtomRspBO applyAtomRspBo = this.pfscElecInvoiceApplyAtomService.saveApplyInfo(applyAtomReqBo);
        if (!"0000".equals(applyAtomRspBo.getRespCode())) {
            throw new PfscBusinessException("8888", "\u4fdd\u5b58\u7533\u8bf7\u4fe1\u606f\u5931\u8d25");
        }
        rspBo.setApplyNo(paramBusiRspBo.getDzfpNo());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u7535\u5b50\u53d1\u7968\u7533\u8bf7\u63d0\u4ea4\u6210\u529f");
        return rspBo;
    }

    private void recordBillApplyItemInfo(PfscElecInvoiceApplyByReqAbilityReqBO reqBo, PfscElecInvoiceApplyParamBusiRspBO paramBusiRspBo) {
        List saleItemInfoList = reqBo.getSaleItemInfoList();
        for (PfscSaleItemInfoBO saleItemInfoBo : saleItemInfoList) {
            BigDecimal reduceFee;
            FscApplyItemInfoPO normalItemPo = new FscApplyItemInfoPO();
            BeanUtils.copyProperties((Object)saleItemInfoBo, (Object)normalItemPo);
            normalItemPo.setSeq(Sequence.getInstance().nextId());
            String spec = saleItemInfoBo.getSpec() == null ? "" : saleItemInfoBo.getSpec();
            String model = saleItemInfoBo.getModel() == null ? "" : saleItemInfoBo.getModel();
            normalItemPo.setSpec(spec + model);
            this.taxRate = saleItemInfoBo.getTaxRate() == null ? PfscConstants.TAX_RATE : saleItemInfoBo.getTaxRate();
            normalItemPo.setTaxRate(this.taxRate);
            normalItemPo.setSerialNo(paramBusiRspBo.getSerialNo());
            normalItemPo.setApplyNo(paramBusiRspBo.getDzfpNo());
            normalItemPo.setStatus(PfscConstants.StatusType.VALID);
            normalItemPo.setItemName(saleItemInfoBo.getSkuName());
            normalItemPo.setUnit(saleItemInfoBo.getUnitName());
            BigDecimal normalAmount = saleItemInfoBo.getSaleUnitPrice().multiply(saleItemInfoBo.getQuantity());
            BigDecimal normalUntaxAmt = normalAmount.divide(BigDecimal.ONE.add(this.taxRate), 2, 4);
            BigDecimal normalTaxAmt = normalAmount.subtract(normalUntaxAmt);
            BigDecimal normalPrice = normalUntaxAmt.divide(normalItemPo.getQuantity(), 2, 4);
            normalItemPo.setPrice(normalPrice);
            normalItemPo.setAmount(normalAmount);
            normalItemPo.setUntaxAmt(normalUntaxAmt);
            normalItemPo.setTaxAmt(normalTaxAmt);
            BigDecimal bigDecimal = reduceFee = saleItemInfoBo.getReduceFee() == null ? BigDecimal.ZERO : saleItemInfoBo.getReduceFee();
            if ("blue".equals(this.redBlue) && reduceFee.compareTo(BigDecimal.ZERO) > 0) {
                FscApplyItemInfoPO discountItemPo = new FscApplyItemInfoPO();
                FscApplyItemInfoPO discountedItemPo = new FscApplyItemInfoPO();
                BeanUtils.copyProperties((Object)normalItemPo, (Object)discountItemPo);
                BeanUtils.copyProperties((Object)normalItemPo, (Object)discountedItemPo);
                discountedItemPo.setRowType(PfscConstants.RowType.DISCOUNTED_LINE);
                this.billApplyItemInfoList.add(discountedItemPo);
                discountItemPo.setRowType(PfscConstants.RowType.DISCOUNT_LINE);
                BigDecimal discountAmount = reduceFee.negate();
                BigDecimal discountUntaxAmt = discountAmount.divide(this.taxRate.add(BigDecimal.ONE), 2, 4);
                BigDecimal discountTaxAmt = discountAmount.subtract(discountUntaxAmt);
                discountItemPo.setTaxAmt(discountTaxAmt);
                discountItemPo.setAmount(discountAmount);
                discountItemPo.setUntaxAmt(discountUntaxAmt);
                discountItemPo.setPrice(null);
                discountItemPo.setQuantity(null);
                discountItemPo.setUnit(null);
                this.billApplyItemInfoList.add(discountItemPo);
                this.invoiceAmount = this.invoiceAmount.add(discountedItemPo.getAmount().add(discountItemPo.getAmount()));
                this.sumPrice = this.sumPrice.add(discountItemPo.getUntaxAmt()).add(discountedItemPo.getUntaxAmt());
                this.sumTax = this.sumTax.add(discountItemPo.getTaxAmt()).add(discountedItemPo.getTaxAmt());
                continue;
            }
            this.invoiceAmount = this.invoiceAmount.add(normalItemPo.getAmount());
            this.sumPrice = this.sumPrice.add(normalItemPo.getUntaxAmt());
            this.sumTax = this.sumTax.add(normalItemPo.getTaxAmt());
            normalItemPo.setRowType(PfscConstants.RowType.NORMAL_LINE);
            this.billApplyItemInfoList.add(normalItemPo);
        }
    }

    private FscApplyInfoPO recordBillApplyInfo(PfscElecInvoiceApplyByReqAbilityReqBO reqBo, PfscElecInvoiceApplyParamBusiRspBO paramBusiRspBo) {
        PfscOrderInvoiceInfoBO orderInvoiceInfoBo = reqBo.getOrderInvoiceInfoBo();
        PfscBusiInvoiceInfoBO busiInvoiceInfoBo = reqBo.getBusiInvoiceInfoBo();
        FscApplyInfoPO applyInfoPo = new FscApplyInfoPO();
        applyInfoPo.setApplyType(PfscConstants.BillApplyInfo.ApplyType.BY_ORDER);
        applyInfoPo.setSource(PfscConstants.BillApplyInfo.SOURCE);
        applyInfoPo.setTaxRate(String.valueOf(this.taxRate));
        applyInfoPo.setApplyNo(paramBusiRspBo.getDzfpNo());
        applyInfoPo.setApplyCode(paramBusiRspBo.getApplyCode());
        applyInfoPo.setSerialNo(paramBusiRspBo.getSerialNo());
        applyInfoPo.setSupplierShopId(null == reqBo.getShopIdIn() ? reqBo.getSupplierShopId() : String.valueOf(reqBo.getShopIdIn()));
        applyInfoPo.setSupplierId(null == reqBo.getOrgIdIn() ? reqBo.getSupplierId() : String.valueOf(reqBo.getOrgIdIn()));
        applyInfoPo.setRedBlue(this.redBlue);
        applyInfoPo.setBillStatus(PfscConstants.BillApplyInfo.BillStatus.INVOICING);
        applyInfoPo.setApplyDate(new Date());
        applyInfoPo.setTaxNo(orderInvoiceInfoBo.getTaxNo());
        applyInfoPo.setInvoiceType(PfscConstants.OrderInvoiceInfo.InvoiceType.ELECTRONIC);
        if (null != orderInvoiceInfoBo.getInvoiceType()) {
            applyInfoPo.setInvoiceType(orderInvoiceInfoBo.getInvoiceType());
        }
        applyInfoPo.setPhone(orderInvoiceInfoBo.getPhone());
        applyInfoPo.setAddr(orderInvoiceInfoBo.getAddr());
        applyInfoPo.setBankAcctNo(orderInvoiceInfoBo.getBankAcctNo());
        applyInfoPo.setBankName(orderInvoiceInfoBo.getBankName());
        applyInfoPo.setInvoceNameType(orderInvoiceInfoBo.getInvoiceNameType());
        applyInfoPo.setInvoceName(orderInvoiceInfoBo.getInvoiceName());
        applyInfoPo.setUserId(String.valueOf(reqBo.getUserIdIn()));
        applyInfoPo.setRemark(reqBo.getRemark());
        applyInfoPo.setTaxAmt(this.sumTax);
        applyInfoPo.setUntaxAmt(this.sumPrice);
        applyInfoPo.setAmt(this.invoiceAmount);
        applyInfoPo.setPayeePhone(busiInvoiceInfoBo.getPayeePhone());
        applyInfoPo.setPayeeName(busiInvoiceInfoBo.getPayeeName());
        applyInfoPo.setPayeeRegisterNo(busiInvoiceInfoBo.getPayeeRegisterNo());
        applyInfoPo.setPayeeAddress(busiInvoiceInfoBo.getPayeeAddress());
        applyInfoPo.setPayeeOperator(busiInvoiceInfoBo.getPayeeOperator());
        return applyInfoPo;
    }

    private FscApplyReceiveInfoPO recordBillApplyReceiveInfo(PfscElecInvoiceApplyByReqAbilityReqBO reqBo, PfscElecInvoiceApplyParamBusiRspBO paramBusiRspBo) {
        PfscOrderInvoiceInfoBO orderInvoiceInfoBo = reqBo.getOrderInvoiceInfoBo();
        String addr = orderInvoiceInfoBo.getAddr() == null ? "" : orderInvoiceInfoBo.getAddr();
        FscApplyReceiveInfoPO applyReceiveInfoPo = new FscApplyReceiveInfoPO();
        applyReceiveInfoPo.setRemark(reqBo.getRemark());
        applyReceiveInfoPo.setAddrDesc(addr);
        applyReceiveInfoPo.setApplyNo(paramBusiRspBo.getDzfpNo());
        applyReceiveInfoPo.setName(reqBo.getUsername());
        applyReceiveInfoPo.setMobile(orderInvoiceInfoBo.getPhone());
        applyReceiveInfoPo.setReceiveInvoiceEmail(orderInvoiceInfoBo.getReceiveInvoiceEmail());
        applyReceiveInfoPo.setReceiveInvoicePhone(orderInvoiceInfoBo.getReceiveInvoicePhone());
        applyReceiveInfoPo.setProvince("");
        applyReceiveInfoPo.setCity("");
        applyReceiveInfoPo.setName("");
        applyReceiveInfoPo.setCounty("");
        applyReceiveInfoPo.setProvId(0L);
        applyReceiveInfoPo.setCityId(0L);
        applyReceiveInfoPo.setCountyId(0L);
        return applyReceiveInfoPo;
    }

    private IfcReqCreateEinvoiceReqBO prepareEinvoiceReqParams(PfscElecInvoiceApplyByReqAbilityReqBO reqBo, PfscElecInvoiceApplyParamBusiRspBO paramBusiRspBo) {
        PfscOrderInvoiceInfoBO orderInvoiceInfoBo = reqBo.getOrderInvoiceInfoBo();
        PfscBusiInvoiceInfoBO busiInvoiceInfoBo = reqBo.getBusiInvoiceInfoBo();
        IfcReqCreateEinvoiceReqBO einvoiceReqBo = new IfcReqCreateEinvoiceReqBO();
        einvoiceReqBo.setPlatformCode("OTHER");
        einvoiceReqBo.setPlatformTid(paramBusiRspBo.getDzfpNo().toString());
        einvoiceReqBo.setSerialNo(paramBusiRspBo.getSerialNo());
        einvoiceReqBo.setInvoiceType(this.redBlue);
        einvoiceReqBo.setPayerName(orderInvoiceInfoBo.getInvoiceName());
        einvoiceReqBo.setPayeeAddress(busiInvoiceInfoBo.getPayeeAddress());
        einvoiceReqBo.setPayeeName(busiInvoiceInfoBo.getPayeeName());
        einvoiceReqBo.setPayeeRegisterNo(busiInvoiceInfoBo.getPayeeRegisterNo());
        List<IfcEinvoiceItemBO> invoiceItems = this.prepareEinvoiceItems();
        einvoiceReqBo.setInvoiceItems(invoiceItems);
        einvoiceReqBo.setInvoiceAmount(String.valueOf(this.invoiceAmount));
        einvoiceReqBo.setSumPrice(String.valueOf(this.sumPrice));
        einvoiceReqBo.setSumTax(String.valueOf(this.sumTax));
        return einvoiceReqBo;
    }

    private List<IfcEinvoiceItemBO> prepareEinvoiceItems() {
        ArrayList<IfcEinvoiceItemBO> invoiceItems = new ArrayList<IfcEinvoiceItemBO>();
        for (FscApplyItemInfoPO itemInfoPo : this.billApplyItemInfoList) {
            IfcEinvoiceItemBO ifcEinvoiceItemBo = new IfcEinvoiceItemBO();
            ifcEinvoiceItemBo.setItemNo(String.valueOf(itemInfoPo.getItemNo()));
            ifcEinvoiceItemBo.setItemName(itemInfoPo.getItemName());
            ifcEinvoiceItemBo.setTaxRate(String.valueOf(itemInfoPo.getTaxRate()));
            ifcEinvoiceItemBo.setPrice(String.valueOf(itemInfoPo.getPrice()));
            ifcEinvoiceItemBo.setUnit(itemInfoPo.getUnit());
            ifcEinvoiceItemBo.setQuantity(String.valueOf(itemInfoPo.getQuantity()));
            ifcEinvoiceItemBo.setRowType(String.valueOf(itemInfoPo.getRowType()));
            ifcEinvoiceItemBo.setAmount(String.valueOf(itemInfoPo.getAmount()));
            ifcEinvoiceItemBo.setSumPrice(String.valueOf(itemInfoPo.getUntaxAmt()));
            ifcEinvoiceItemBo.setTax(String.valueOf(itemInfoPo.getTaxAmt()));
            invoiceItems.add(ifcEinvoiceItemBo);
        }
        return invoiceItems;
    }
}

