/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.external.service.einvoice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfsc.external.api.einvoice.IfcEinvoiceCallHttpSendMessageService;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceCallHttpSendMessageReqBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceCallHttpSendMessageRspBO;
import com.tydic.pfsc.external.common.exception.IfcBusinessException;
import com.tydic.pfsc.external.common.utils.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="ifcEinvoiceCallHttpSendMessageService")
public class IfcEinvoiceCallHttpSendMessageServiceImpl
implements IfcEinvoiceCallHttpSendMessageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcEinvoiceCallHttpSendMessageServiceImpl.class);
    @Value(value="${NOTIFY_SEND_MESSAGE_URL}")
    private String NOTIFY_SEND_MESSAGE_URL;

    @Override
    public IfcEinvoiceCallHttpSendMessageRspBO callHttpSendMessage(IfcEinvoiceCallHttpSendMessageReqBO reqBO) {
        this.validateArg(reqBO);
        String reqJson = JSON.toJSONString((Object)reqBO);
        if (!StringUtils.hasText((String)reqJson)) {
            throw new IfcBusinessException("8888", "reqBO\u8f6c\u6362json\u4e3a\u7a7a");
        }
        String rspJson = HttpUtil.doPost(this.NOTIFY_SEND_MESSAGE_URL, reqJson);
        if (!StringUtils.hasText((String)rspJson)) {
            throw new IfcBusinessException("8888", "\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u77ed\u4fe1\u63a5\u53e3\u8fd4\u56de\u7a7a");
        }
        JSONObject rspJsonObj = JSONObject.parseObject((String)rspJson);
        if (null == rspJsonObj) {
            throw new IfcBusinessException("8888", "\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u77ed\u4fe1\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u8f6c\u6362JSON\u4e3a\u7a7a");
        }
        IfcEinvoiceCallHttpSendMessageRspBO rspBO = new IfcEinvoiceCallHttpSendMessageRspBO();
        if ("0".equals(rspJsonObj.get((Object)"code"))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc((String)rspJsonObj.get((Object)"message"));
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc((String)rspJsonObj.get((Object)"message"));
        }
        return rspBO;
    }

    private void validateArg(IfcEinvoiceCallHttpSendMessageReqBO reqBO) {
        if (null == reqBO) {
            throw new IfcBusinessException("7777", "\u5165\u53c2\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getMobile())) {
            throw new IfcBusinessException("7777", "\u5165\u53c2[mobile]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getContent())) {
            throw new IfcBusinessException("7777", "\u5165\u53c2[content]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

