/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.external.common.utils.top;

import com.tydic.pfsc.external.common.utils.common.CommonUtils;
import com.tydic.pfsc.external.common.utils.http.HttpUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;

public class TaoBaoHttpUtil {
    private static final String CHARSET_UTF8 = "utf-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String callApi(URL url, Map<String, String> params) throws IOException {
        String rsp;
        String query = TaoBaoHttpUtil.buildQuery(params);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(StandardCharsets.UTF_8);
        }
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            conn = HttpUtils.getConnection(url);
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestProperty("Host", url.getHost());
            conn.setRequestProperty("Accept", "text/xml,text/javascript");
            conn.setRequestProperty("User-Agent", "top-sdk-java");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            out = conn.getOutputStream();
            out.write(content);
            rsp = HttpUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static String buildQuery(Map<String, String> params) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!CommonUtils.isNotEmpty(name) || !CommonUtils.isNotEmpty(value)) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, CHARSET_UTF8));
        }
        return query.toString();
    }
}

