/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.external.service.impl;

import com.tydic.pfsc.external.api.IfcEinvoiceSendMailIntfService;
import com.tydic.pfsc.external.api.bo.IfcEinvoiceSendMailReqBO;
import com.tydic.pfsc.external.api.bo.IfcEinvoiceSendMailRspBO;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="ifcEinvoiceSendMailIntfService")
public class IfcEinvoiceSendMailIntfServiceImpl
implements IfcEinvoiceSendMailIntfService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcEinvoiceSendMailIntfServiceImpl.class);
    private static final String GBK = "GBK";
    private static final String GB2312 = "GB2312";
    @Value(value="${mailHost}")
    private String host;
    @Value(value="${sendUser}")
    private String sendUser;
    @Value(value="${sendPassword}")
    private String sendPassWord;
    @Value(value="${mailTitle}")
    private String mailTitle;

    @Override
    public IfcEinvoiceSendMailRspBO sendMail(IfcEinvoiceSendMailReqBO reqBo) {
        IfcEinvoiceSendMailRspBO rspBo = new IfcEinvoiceSendMailRspBO();
        String validateArgStr = this.validateArg(reqBo);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBo.setRespCode("7777");
            rspBo.setRespDesc(validateArgStr);
            return rspBo;
        }
        if (!StringUtils.hasText((String)reqBo.getSubject())) {
            String iso88591 = new String(this.mailTitle.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.ISO_8859_1);
            String gbk = new String(this.mailTitle.getBytes(Charset.forName(GBK)), Charset.forName(GBK));
            String gb2312 = new String(this.mailTitle.getBytes(Charset.forName(GB2312)), Charset.forName(GB2312));
            if (iso88591.equals(this.mailTitle)) {
                this.mailTitle = new String(this.mailTitle.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
            } else if (gbk.equals(this.mailTitle)) {
                this.mailTitle = new String(this.mailTitle.getBytes(Charset.forName(GBK)), StandardCharsets.UTF_8);
            } else if (gb2312.equals(this.mailTitle)) {
                this.mailTitle = new String(this.mailTitle.getBytes(Charset.forName(GB2312)), StandardCharsets.UTF_8);
            }
        }
        try {
            Properties props = new Properties();
            props.setProperty("mail.debug", "true");
            props.setProperty("mail.smtp.auth", "true");
            props.setProperty("mail.host", this.host);
            props.setProperty("mail.transport.protocol", "smtp");
            Session session = Session.getInstance((Properties)props);
            MimeMessage msg = new MimeMessage(session);
            msg.setSubject(this.mailTitle, "UTF-8");
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)("<meta http-equiv=Content-Type content=text/html; charset=UTF-8>" + reqBo.getText()), "text/html;charset=UTF-8");
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            if (!CollectionUtils.isEmpty(reqBo.getFilePaths())) {
                for (String filePath : reqBo.getFilePaths()) {
                    if (!StringUtils.hasText((String)filePath)) continue;
                    messageBodyPart = new MimeBodyPart();
                    FileDataSource source = new FileDataSource(filePath);
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    messageBodyPart.setFileName(MimeUtility.encodeText((String)filePath, (String)"UTF-8", null));
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
            }
            msg.setContent((Multipart)multipart);
            msg.setSentDate(reqBo.getSendTime());
            msg.setFrom((Address)new InternetAddress(this.sendUser));
            msg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(reqBo.getToUser()));
            msg.saveChanges();
            Transport transport = session.getTransport("smtp");
            transport.connect(this.host, this.sendUser, this.sendPassWord);
            transport.sendMessage((Message)msg, msg.getRecipients(Message.RecipientType.TO));
            transport.close();
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u53d1\u9001\u90ae\u4ef6\u5f02\u5e38:{}", (Object)e.getMessage());
            }
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u53d1\u9001\u90ae\u4ef6\u5f02\u5e38");
            return rspBo;
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
        return rspBo;
    }

    private String validateArg(IfcEinvoiceSendMailReqBO reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBo.getToUser())) {
            return "\u5165\u53c2\u6536\u4ef6\u4eba\u90ae\u7bb1[toUser]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBo.getText())) {
            return "\u5165\u53c2\u90ae\u4ef6\u6b63\u6587[text]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getSendTime()) {
            reqBo.setSendTime(new Date());
        }
        if (StringUtils.hasText((String)reqBo.getSubject())) {
            this.mailTitle = reqBo.getSubject();
        }
        return null;
    }
}

