/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.mock.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.vo.Statis;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.mock.FscMockGetInvoiceService;
import com.tydic.pfscext.mock.bo.FscMockGetInvoiceBO;
import java.util.Date;
import java.util.Random;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=FscMockGetInvoiceService.class)
public class FscMockGetInvoiceServiceImpl
implements FscMockGetInvoiceService {
    @Autowired
    BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    PayItemInfoMapper payItemInfoMapper;

    public FscMockGetInvoiceBO getInvoiceData(String markId) {
        FscMockGetInvoiceBO getInvoiceBO = new FscMockGetInvoiceBO();
        if (!StringUtils.hasText((String)markId)) {
            throw new PfscExtBusinessException("0001", "\u901a\u77e5\u5355\u53f7markId\u5fc5\u987b\u8f93\u5165");
        }
        BillNotificationInfo bill = this.billNotificationInfoMapper.selectByPrimaryKey(markId);
        if (bill == null) {
            throw new PfscExtBusinessException("0001", "\u901a\u77e5\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        Statis ordStatis = this.payItemInfoMapper.orderStatis(markId);
        getInvoiceBO.setInvoiceNo(String.valueOf(new Random().nextDouble()).substring(2, 10));
        getInvoiceBO.setInvoiceId(String.valueOf(new Random().nextDouble()).substring(2, 10));
        getInvoiceBO.setInvoiceCode(String.valueOf(new Random().nextDouble()).substring(2, 12));
        getInvoiceBO.setInvoiceDate(DateUtils.dateToStrLong((Date)new Date()));
        getInvoiceBO.setInvoiceAmount(String.valueOf(ordStatis.getTotAmt()));
        getInvoiceBO.setInvoiceNakedAmount(String.valueOf(ordStatis.getTotUntaxAmt()));
        getInvoiceBO.setInvoiceTaxAmount(String.valueOf(ordStatis.getTotTaxAmt()));
        getInvoiceBO.setTitle(bill.getInvoceName());
        getInvoiceBO.setEnterpriseTaxpayer(bill.getTaxNo());
        getInvoiceBO.setAddress(bill.getAddr());
        getInvoiceBO.setTel(bill.getPhone());
        getInvoiceBO.setBank(bill.getBankName());
        getInvoiceBO.setAccount(bill.getBankAccNo());
        getInvoiceBO.setInvoiceType(String.valueOf(bill.getInvoceType()));
        return getInvoiceBO;
    }
}

