/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiAcctCheckingListService;
import com.tydic.pfscext.api.busi.bo.BusiAccountCheckingReqBO;
import com.tydic.pfscext.api.busi.bo.BusiAccountCheckingRspBO;
import com.tydic.pfscext.api.busi.bo.BusiAcctCheckingListRspBO;
import com.tydic.pfscext.dao.AcctCheckingResultMapper;
import com.tydic.pfscext.dao.bo.AcctCheckingResultExt;
import com.tydic.pfscext.dao.po.AcctCheckingResult;
import com.tydic.pfscext.dao.po.MainAcctInfo;
import com.tydic.pfscext.dao.po.Pagination;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.MainAccountService;
import com.tydic.pfscext.service.atom.SubAccountService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=BusiAcctCheckingListService.class)
public class BusiAcctCheckingListServiceImpl
implements BusiAcctCheckingListService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAcctCheckingListServiceImpl.class);
    @Autowired
    private AcctCheckingResultMapper mapper;
    @Autowired(required=false)
    private MainAccountService mainAccountService;
    @Autowired
    private SubAccountService subAccountService;

    public BusiAcctCheckingListRspBO listResult(BusiAccountCheckingReqBO busiAccountCheckingReqBO) {
        logger.info("\u67e5\u8be2\u5bf9\u8d26\u7ed3\u679creqBO=" + busiAccountCheckingReqBO);
        Pagination pageInfo = new Pagination();
        pageInfo.setPage(busiAccountCheckingReqBO.getPageNo());
        pageInfo.setPageSize(busiAccountCheckingReqBO.getPageSize());
        Integer dataType = busiAccountCheckingReqBO.getDataType();
        String actType = busiAccountCheckingReqBO.getActType();
        Date acDate = busiAccountCheckingReqBO.getAcDate();
        Date endAcDate = busiAccountCheckingReqBO.getEndAcDate();
        if (dataType == null) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u6570\u636e\u7c7b\u578b(dataType),1=\u7d22\u5f15,2=\u660e\u7ec6");
        }
        if (dataType == 2) {
            if (acDate == null) {
                throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u660e\u7ec6\u9700\u8981\u63d0\u4f9b\u5bf9\u8d26\u65e5\u671f(acDate)");
            }
            endAcDate = acDate;
        }
        AcctCheckingResultExt record = new AcctCheckingResultExt();
        record.setResultType(busiAccountCheckingReqBO.getDataType());
        record.setCheckDate(acDate);
        record.setEndCheckDate(endAcDate);
        if ("1".equals(actType)) {
            record.setDataCount(0L);
        }
        int tot = this.mapper.selectForCount(record);
        logger.info("\u67e5\u8be2\u5bf9\u8d26\u7ed3\u679c\u8bb0\u5f55\u6570:" + tot);
        pageInfo.setTotalCount(tot);
        int rowIndex = pageInfo.getRowIndex();
        record.setPageSize(pageInfo.getPageSize());
        record.setRowIndex(rowIndex);
        List<AcctCheckingResult> rows = this.mapper.queryPage(record);
        BusiAcctCheckingListRspBO resp = new BusiAcctCheckingListRspBO();
        HashMap<String, MainAcctInfo> history = new HashMap<String, MainAcctInfo>();
        ArrayList<BusiAccountCheckingRspBO> outData = new ArrayList<BusiAccountCheckingRspBO>();
        for (AcctCheckingResult result : rows) {
            String subAcctNo;
            String[] inf;
            BusiAccountCheckingRspBO rspBo = new BusiAccountCheckingRspBO();
            outData.add(rspBo);
            BeanUtils.copyProperties((Object)result, (Object)rspBo);
            rspBo.setDrcr(result.getDrCr());
            rspBo.setPostDate(result.getCheckDate());
            rspBo.setResultText(result.getRemark());
            if (dataType != 2) continue;
            String mainAcctNo = result.getMainAcctNo();
            MainAcctInfo main = (MainAcctInfo)((Object)history.get(mainAcctNo));
            if (main == null && (main = this.getMainAcct(mainAcctNo)) != null) {
                history.put(mainAcctNo, main);
            }
            rspBo.setMainAcctNo(mainAcctNo);
            if (main != null) {
                rspBo.setMainAcctName(main.getMainAcctName());
                rspBo.setMainOrgNo("" + main.getOrgId());
                rspBo.setSource(main.getSource());
                OrderSource src = OrderSource.getInstance((String)main.getSource());
                rspBo.setSourceDescr(src.getDescr());
            }
            if ((inf = (subAcctNo = result.getSubAcctNo()).split("/")).length <= 1) continue;
            rspBo.setPayAcctNo(inf[0]);
            rspBo.setPayAcctName(this.subAccountService.getAcctName(rspBo.getPayAcctNo()));
            rspBo.setRecvAcctNo(inf[1]);
            rspBo.setRecvAcctName(this.subAccountService.getAcctName(rspBo.getRecvAcctNo()));
        }
        resp.setTotal(pageInfo.getPageCount());
        resp.setRecordsTotal(pageInfo.getTotalCount());
        resp.setRows(outData);
        resp.setPageNo(pageInfo.getPage());
        return resp;
    }

    private MainAcctInfo getMainAcct(String mainAcctNo) {
        MainAcctInfo param = new MainAcctInfo();
        param.setMainAcctNo(mainAcctNo);
        List<MainAcctInfo> ls = this.mainAccountService.listAccount(param);
        if (ls.size() == 0) {
            return null;
        }
        return ls.get(0);
    }
}

