/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiAddBillApplyInfoByItemsService;
import com.tydic.pfscext.api.busi.bo.BusiAddBillApplyInfoByItemsDetailReqBO;
import com.tydic.pfscext.api.busi.bo.BusiAddBillApplyInfoByItemsReqBO;
import com.tydic.pfscext.api.busi.bo.BusiAddBillApplyInfoByItemsRspBO;
import com.tydic.pfscext.api.busi.vo.InvoiceHeaderVO;
import com.tydic.pfscext.api.busi.vo.InvoiceMailAddrInfoVO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleItemApplyInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.SaleItemApplyInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.ApplyType;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.InvoiceClasses;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.SaleItemApplyInfoStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import com.tydic.pfscext.service.atom.EnumsService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=BusiAddBillApplyInfoByItemsService.class)
public class BusiAddBillApplyInfoByItemsServiceImpl
implements BusiAddBillApplyInfoByItemsService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddBillApplyInfoByItemsServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private SaleItemApplyInfoMapper saleItemApplyInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;

    public BusiAddBillApplyInfoByItemsRspBO add(BusiAddBillApplyInfoByItemsReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u62c6\u5206\u5f00\u7968\u7533\u8bf7\u5355\u65b0\u589e\u670d\u52a1:" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceHeaderVO invoiceInfo = reqBO.getInvoiceInfo();
        InvoiceMailAddrInfoVO mailAddrInfo = reqBO.getMailAddrInfo();
        List detailInfoList = reqBO.getDetailInfoList();
        if (invoiceInfo == null) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (!StringUtils.hasText((String)invoiceInfo.getInvoiceTitle())) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u4fe1\u606f\u4e2d\u7684\u53d1\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mailAddrInfo == null || !StringUtils.hasText((String)mailAddrInfo.getName())) {
            throw new PfscExtBusinessException("18000", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (CollectionUtils.isEmpty((Collection)detailInfoList)) {
            throw new PfscExtBusinessException("18000", "\u8bf7\u9009\u62e9\u5546\u54c1\u660e\u7ec6");
        }
        ArrayList<Long> seqList = new ArrayList<Long>();
        HashMap<Long, BigDecimal> dataMap = new HashMap<Long, BigDecimal>(2);
        for (BusiAddBillApplyInfoByItemsDetailReqBO detail : detailInfoList) {
            if (detail.getSeq() == null || detail.getSeq() <= 0L) {
                throw new PfscExtBusinessException("18000", "\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (detail.getQuantityApply() == null || detail.getQuantityApply().compareTo(BigDecimal.ZERO) <= 0) {
                throw new PfscExtBusinessException("18000", "\u5f85\u5f00\u7968\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            }
            SaleItemInfo saleInfo = this.saleItemInfoMapper.getModelByPrimaryKey(detail.getSeq());
            if (saleInfo == null) {
                throw new PfscExtBusinessException("18000", "\u5546\u54c1\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e");
            }
            BigDecimal remain = saleInfo.getQuantity().subtract(saleInfo.getQuantityApplied());
            if (detail.getQuantityApply().compareTo(remain) > 0) {
                throw new PfscExtBusinessException("18000", "\u586b\u5199\u7684\u5f00\u7968\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u53ef\u63d0\u5f00\u7968\u7533\u8bf7\u6570\u91cf");
            }
            seqList.add(detail.getSeq());
            dataMap.put(detail.getSeq(), detail.getQuantityApply());
        }
        String empApplyIsolateOrderSwitch = this.enumsService.queryEmApplyIsolateOrderSwitch();
        SaleItemInfoVO queryItemVO = new SaleItemInfoVO();
        queryItemVO.setSeqList(seqList);
        queryItemVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
        List<SaleItemInfoVO> itemInfosList = this.saleItemInfoMapper.querySaleJoinOrderItemList(queryItemVO);
        if (CollectionUtils.isEmpty(itemInfosList)) {
            throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u8bf7\u9009\u62e9\u672a\u63d0\u4ea4\u7684\u5546\u54c1\u8ba2\u5355\u660e\u7ec6");
        }
        List<List<SaleItemInfoVO>> saleItemInfosList = this.splitByBase(itemInfosList);
        saleItemInfosList = this.splitBySupplierNo(saleItemInfosList);
        if ("1".equals(empApplyIsolateOrderSwitch)) {
            saleItemInfosList = this.splitByOrder(saleItemInfosList);
        }
        if (InvoiceType.SPECIAL.getCode().equals(invoiceInfo.getInvoiceType())) {
            saleItemInfosList = this.splitByInvoiceType(saleItemInfosList);
        }
        saleItemInfosList = this.splitBySettleRate(saleItemInfosList);
        saleItemInfosList = this.splitBySettleTaxRate(saleItemInfosList);
        logger.info("########################\u751f\u6210\u5f00\u7968\u7533\u8bf7\u5355==========start");
        StringBuilder sb = new StringBuilder();
        HashSet<Long> inspectionIds = new HashSet<Long>();
        for (List<SaleItemInfoVO> dataList : saleItemInfosList) {
            if (dataList.isEmpty()) continue;
            String applyNo = this.billSNService.getSnAsString(BillType.INVOICE_APPLICATION);
            BillApplyInfo billApplyInfo = new BillApplyInfo();
            billApplyInfo.setInvoiceType(String.valueOf(invoiceInfo.getInvoiceType() == 0 ? InvoiceType.SPECIAL.getCode() : InvoiceType.NORMAL.getCode()));
            if (String.valueOf(InvoiceType.SPECIAL.getCode()).equals(billApplyInfo.getInvoiceType()) && dataList.get(0).getTaxRate().compareTo(BigDecimal.ZERO) == 0) {
                billApplyInfo.setInvoiceType(String.valueOf(InvoiceType.NORMAL.getCode()));
            }
            billApplyInfo.setInvoceName(invoiceInfo.getInvoiceTitle());
            billApplyInfo.setTaxNo(invoiceInfo.getTaxpayerId());
            billApplyInfo.setAddr(invoiceInfo.getAddress());
            billApplyInfo.setPhone(invoiceInfo.getPhone());
            billApplyInfo.setBankName(invoiceInfo.getBank());
            billApplyInfo.setBankAcctNo(invoiceInfo.getAccount());
            billApplyInfo.setName(mailAddrInfo.getName());
            billApplyInfo.setProvince(mailAddrInfo.getProvince());
            billApplyInfo.setCity(mailAddrInfo.getCity());
            billApplyInfo.setCounty(mailAddrInfo.getCounty());
            billApplyInfo.setTown("0".equals(mailAddrInfo.getTown()) ? null : mailAddrInfo.getTown());
            billApplyInfo.setProvId(mailAddrInfo.getProvId());
            billApplyInfo.setCityId(mailAddrInfo.getCityId());
            billApplyInfo.setCountyId(mailAddrInfo.getCountyId());
            billApplyInfo.setTownId(mailAddrInfo.getTownId());
            billApplyInfo.setAddrDesc(mailAddrInfo.getAddrDesc());
            billApplyInfo.setMobile(mailAddrInfo.getTel());
            billApplyInfo.setTel(mailAddrInfo.getSpecialPlane());
            billApplyInfo.setPostCode(mailAddrInfo.getPostCode());
            billApplyInfo.setApplyNo(applyNo);
            billApplyInfo.setApplyDate(new Date());
            billApplyInfo.setBillStatus(BillStatus.NO_APPLY.getCode());
            billApplyInfo.setUserId(reqBO.getUserId());
            billApplyInfo.setSource(OrderSource.ELECTRIC_MARKET.getCode());
            billApplyInfo.setApplyType(ApplyType.APPLY_TYPE_ITEM.getCode());
            billApplyInfo.setPurchaseNo(dataList.get(0).getPurchaseNo());
            billApplyInfo.setPurchaseName(dataList.get(0).getPurchaseName());
            billApplyInfo.setPurchaseProjectId(dataList.get(0).getPurchaseProjectId());
            billApplyInfo.setOperUnitNo(dataList.get(0).getOperUnitNo());
            billApplyInfo.setOperUnitName(dataList.get(0).getOperUnitName());
            billApplyInfo.setSupplierNo(dataList.get(0).getSupplierNo());
            billApplyInfo.setSupplierName(dataList.get(0).getSupplierName());
            billApplyInfo.setInvoiceClasses(InvoiceClasses.PAPER_INVOICE.getCode());
            BigDecimal applyAmtTotal = BigDecimal.ZERO;
            for (SaleItemInfoVO saleInfoVO : dataList) {
                inspectionIds.add(saleInfoVO.getInspectionId());
                SaleItemApplyInfo applyInfo = new SaleItemApplyInfo();
                applyInfo.setApplyNo(applyNo);
                applyInfo.setInspectionId(saleInfoVO.getInspectionId());
                applyInfo.setSeq(saleInfoVO.getSeq());
                applyInfo.setStatus(SaleItemApplyInfoStatus.VALID.getCode());
                applyInfo.setItemNo(saleInfoVO.getItemNo());
                BigDecimal quantityToApply = (BigDecimal)dataMap.get(saleInfoVO.getSeq());
                BigDecimal amountToApply = saleInfoVO.getAmount().multiply(quantityToApply).divide(saleInfoVO.getQuantity(), 2, 4);
                BigDecimal amountRemain = saleInfoVO.getAmount().subtract(saleInfoVO.getAmountApplied());
                BigDecimal quantityRemain = saleInfoVO.getQuantity().subtract(saleInfoVO.getQuantityApplied());
                if (amountRemain.compareTo(amountToApply) <= 0) {
                    amountToApply = amountRemain;
                }
                if (quantityToApply.compareTo(quantityRemain) == 0) {
                    amountToApply = amountRemain;
                }
                applyInfo.setAmount(amountToApply);
                applyInfo.setQuantity(quantityToApply);
                this.saleItemApplyInfoMapper.insertSelective(applyInfo);
                applyAmtTotal = applyAmtTotal.add(amountToApply);
                SaleItemInfo updateItemInfo = new SaleItemInfo();
                updateItemInfo.setSeq(saleInfoVO.getSeq());
                if (amountToApply.compareTo(amountRemain) == 0) {
                    updateItemInfo.setItemStatus(OrderStatus.APPLIED.getCode());
                }
                updateItemInfo.setQuantityApplied(quantityToApply.add(saleInfoVO.getQuantityApplied()));
                updateItemInfo.setAmountApplied(amountToApply.add(saleInfoVO.getAmountApplied()));
                this.saleItemInfoMapper.updateByPrimaryKeySelective(updateItemInfo);
            }
            billApplyInfo.setAmt(applyAmtTotal);
            this.billApplyInfoMapper.insertSelective(billApplyInfo);
            sb.append(applyNo).append(",");
        }
        SaleOrderInfoVO updateOrderVO = new SaleOrderInfoVO();
        updateOrderVO.setOrderStatus(OrderStatus.APPLIED.getCode());
        updateOrderVO.setInspectionIdList(new ArrayList<Long>(inspectionIds));
        updateOrderVO.setItemStatusNotIn(Arrays.asList(OrderStatus.APPLIED.getCode(), OrderStatus.SEND_BILL.getCode(), OrderStatus.INVALID.getCode()));
        this.saleOrderInfoMapper.updateOrderByCondition(updateOrderVO);
        logger.info("########################\u751f\u6210\u5f00\u7968\u7533\u8bf7\u5355==========end");
        BusiAddBillApplyInfoByItemsRspBO rspBO = new BusiAddBillApplyInfoByItemsRspBO();
        if (StringUtils.isEmpty((Object)sb.toString())) {
            throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u751f\u6210\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25");
        }
        String msg = sb.deleteCharAt(sb.length() - 1).toString();
        rspBO.setMsg("\u6210\u529f\uff0c\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e3a\uff1a" + msg);
        return rspBO;
    }

    private List<List<SaleItemInfoVO>> splitByBase(List<SaleItemInfoVO> itemInfoList) {
        LinkedList<List<SaleItemInfoVO>> itemsInfoList = new LinkedList<List<SaleItemInfoVO>>();
        itemsInfoList.add(itemInfoList);
        return itemsInfoList;
    }

    private List<List<SaleItemInfoVO>> splitBySupplierNo(List<List<SaleItemInfoVO>> itemInfoList) {
        LinkedList<List<SaleItemInfoVO>> itemsInfoList = new LinkedList<List<SaleItemInfoVO>>();
        for (List<SaleItemInfoVO> saleItemInfoVOS : itemInfoList) {
            HashMap tmpMap = new HashMap(16);
            for (SaleItemInfoVO saleItemInfoVO : saleItemInfoVOS) {
                if (tmpMap.containsKey(saleItemInfoVO.getSupplierNo())) {
                    ((List)tmpMap.get(saleItemInfoVO.getSupplierNo())).add(saleItemInfoVO);
                    continue;
                }
                LinkedList<SaleItemInfoVO> saleList = new LinkedList<SaleItemInfoVO>();
                saleList.add(saleItemInfoVO);
                tmpMap.put(saleItemInfoVO.getSupplierNo(), saleList);
            }
            for (Map.Entry entry : tmpMap.entrySet()) {
                itemsInfoList.add((List<SaleItemInfoVO>)entry.getValue());
            }
        }
        return itemsInfoList;
    }

    private List<List<SaleItemInfoVO>> splitByOrder(List<List<SaleItemInfoVO>> itemInfoList) {
        LinkedList<List<SaleItemInfoVO>> itemsInfoList = new LinkedList<List<SaleItemInfoVO>>();
        for (List<SaleItemInfoVO> saleItemInfoVOS : itemInfoList) {
            HashMap tmpMap = new HashMap(16);
            for (SaleItemInfoVO saleItemInfoVO : saleItemInfoVOS) {
                if (tmpMap.containsKey(saleItemInfoVO.getOrderId())) {
                    ((List)tmpMap.get(saleItemInfoVO.getOrderId())).add(saleItemInfoVO);
                    continue;
                }
                LinkedList<SaleItemInfoVO> saleList = new LinkedList<SaleItemInfoVO>();
                saleList.add(saleItemInfoVO);
                tmpMap.put(saleItemInfoVO.getOrderId(), saleList);
            }
            for (Map.Entry entry : tmpMap.entrySet()) {
                itemsInfoList.add((List<SaleItemInfoVO>)entry.getValue());
            }
        }
        return itemsInfoList;
    }

    private List<List<SaleItemInfoVO>> splitByInvoiceType(List<List<SaleItemInfoVO>> itemInfoList) {
        LinkedList<List<SaleItemInfoVO>> itemsInfoList = new LinkedList<List<SaleItemInfoVO>>();
        for (List<SaleItemInfoVO> itemList : itemInfoList) {
            LinkedList<SaleItemInfoVO> specialList = new LinkedList<SaleItemInfoVO>();
            LinkedList<SaleItemInfoVO> normalList = new LinkedList<SaleItemInfoVO>();
            for (SaleItemInfoVO saleInfoVO : itemList) {
                if (saleInfoVO.getTaxRate().compareTo(BigDecimal.ZERO) > 0) {
                    specialList.add(saleInfoVO);
                    continue;
                }
                normalList.add(saleInfoVO);
            }
            if (!specialList.isEmpty()) {
                itemsInfoList.add(specialList);
            }
            if (normalList.isEmpty()) continue;
            itemsInfoList.add(normalList);
        }
        return itemsInfoList;
    }

    private List<List<SaleItemInfoVO>> splitByPurchaseUnit(List<List<SaleItemInfoVO>> itemInfoList) {
        LinkedList<List<SaleItemInfoVO>> itemsInfoList = new LinkedList<List<SaleItemInfoVO>>();
        LinkedList<SaleItemInfoVO> saleList = null;
        for (List<SaleItemInfoVO> saleItemInfoVOS : itemInfoList) {
            HashMap tmpMap = new HashMap(16);
            for (SaleItemInfoVO saleItemInfoVO : saleItemInfoVOS) {
                if (tmpMap.containsKey(saleItemInfoVO.getPurchaseProjectId())) {
                    ((List)tmpMap.get(saleItemInfoVO.getPurchaseProjectId())).add(saleItemInfoVO);
                    continue;
                }
                saleList = new LinkedList<SaleItemInfoVO>();
                saleList.add(saleItemInfoVO);
                tmpMap.put(saleItemInfoVO.getPurchaseProjectId(), saleList);
            }
            for (Map.Entry entry : tmpMap.entrySet()) {
                itemsInfoList.add((List<SaleItemInfoVO>)entry.getValue());
            }
        }
        return itemsInfoList;
    }

    private List<List<SaleItemInfoVO>> splitBySettleRate(List<List<SaleItemInfoVO>> itemInfoList) {
        LinkedList<List<SaleItemInfoVO>> itemsInfoList = new LinkedList<List<SaleItemInfoVO>>();
        for (List<SaleItemInfoVO> saleItemInfoVOS : itemInfoList) {
            HashMap settleRateMap = new HashMap(16);
            for (SaleItemInfoVO saleItemInfoVO : saleItemInfoVOS) {
                if (null != saleItemInfoVO.getSettleRate()) {
                    if (settleRateMap.get(0L) != null) {
                        ((List)settleRateMap.get(0L)).add(saleItemInfoVO);
                        continue;
                    }
                    LinkedList<SaleItemInfoVO> saleList = new LinkedList<SaleItemInfoVO>();
                    saleList.add(saleItemInfoVO);
                    settleRateMap.put(0L, saleList);
                    continue;
                }
                if (settleRateMap.get(1L) != null) {
                    ((List)settleRateMap.get(1L)).add(saleItemInfoVO);
                    continue;
                }
                LinkedList<SaleItemInfoVO> saleListNull = new LinkedList<SaleItemInfoVO>();
                saleListNull.add(saleItemInfoVO);
                settleRateMap.put(1L, saleListNull);
            }
            for (Map.Entry entry : settleRateMap.entrySet()) {
                itemsInfoList.add((List<SaleItemInfoVO>)entry.getValue());
            }
        }
        return itemsInfoList;
    }

    private List<List<SaleItemInfoVO>> splitBySettleTaxRate(List<List<SaleItemInfoVO>> itemInfoList) {
        LinkedList<List<SaleItemInfoVO>> itemsInfoList = new LinkedList<List<SaleItemInfoVO>>();
        for (List<SaleItemInfoVO> saleItemInfoVOS : itemInfoList) {
            HashMap settleRateMap = new HashMap(16);
            for (SaleItemInfoVO saleItemInfoVO : saleItemInfoVOS) {
                if (settleRateMap.containsKey(saleItemInfoVO.getTaxRate())) {
                    ((List)settleRateMap.get(saleItemInfoVO.getTaxRate())).add(saleItemInfoVO);
                    continue;
                }
                LinkedList<SaleItemInfoVO> saleList = new LinkedList<SaleItemInfoVO>();
                saleList.add(saleItemInfoVO);
                settleRateMap.put(saleItemInfoVO.getTaxRate(), saleList);
            }
            for (Map.Entry entry : settleRateMap.entrySet()) {
                itemsInfoList.add((List<SaleItemInfoVO>)entry.getValue());
            }
        }
        return itemsInfoList;
    }
}

