/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiQueryEntryDetailsService;
import com.tydic.pfscext.api.busi.bo.BusiQueryEntryDetailsServiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryEntryDetailsServiceRspBO;
import com.tydic.pfscext.api.busi.bo.EntryInfoBO;
import com.tydic.pfscext.api.busi.bo.PurchaseOrderDetailInfoRspBO;
import com.tydic.pfscext.dao.EntryInfoMapper;
import com.tydic.pfscext.dao.EntryTotalInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.EntryInfoPO;
import com.tydic.pfscext.dao.po.EntryTotalInfoPO;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.EntryInfoVO;
import com.tydic.pfscext.dao.vo.EntryTotalInfoVO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.UserInfoService;
import com.tydic.pfscext.service.busi.impl.QueryEntryInfoServiceImpl;
import com.tydic.pfscext.utils.AntiSqlInjectionManage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=BusiQueryEntryDetailsService.class)
public class BusiQueryEntryDetailsServiceImpl
implements BusiQueryEntryDetailsService {
    private static final Logger logger = LoggerFactory.getLogger(QueryEntryInfoServiceImpl.class);
    @Autowired
    private EntryInfoMapper entryInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private EntryTotalInfoMapper entryTotalInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    public BusiQueryEntryDetailsServiceRspBO<EntryInfoBO> queryEntryDetails(BusiQueryEntryDetailsServiceReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u6c47\u603b\u5355\u8be6\u60c5\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (reqBO.getApplyNo() == null || !StringUtils.hasText((String)reqBO.getApplyNo())) {
            throw new PfscExtBusinessException("18000", "\u6c47\u603b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderBy = null;
        if (!StringUtils.isEmpty((Object)reqBO.getSortName()) && !StringUtils.isEmpty((Object)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        }
        BusiQueryEntryDetailsServiceRspBO rspPageBO = new BusiQueryEntryDetailsServiceRspBO();
        EntryTotalInfoVO entryTotalInfoVO = new EntryTotalInfoVO();
        entryTotalInfoVO.setApplyNo(reqBO.getApplyNo());
        EntryTotalInfoPO entryTotalInfoPO = this.entryTotalInfoMapper.getModelById(entryTotalInfoVO);
        if (null == entryTotalInfoPO) {
            throw new PfscExtBusinessException("18000", "\u6839\u636e\u6c47\u603b\u5355\u53f7\uff1a" + reqBO.getApplyNo() + "\u67e5\u8be2\u6c47\u603b\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        BeanUtils.copyProperties((Object)entryTotalInfoPO, (Object)rspPageBO);
        String documentationName = this.userInfoService.queryUserNameByUserId(entryTotalInfoPO.getDocumentationId());
        rspPageBO.setDocumentationName(documentationName);
        String companyName = this.organizationInfoService.queryOrgName(rspPageBO.getCompanyId());
        rspPageBO.setCompanyName(companyName);
        EntryInfoVO entryInfoVO = new EntryInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)entryInfoVO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<EntryInfoPO> entryInfoPOs = this.entryInfoMapper.getListPage(entryInfoVO, (Page<Map<String, Object>>)page, orderBy);
        if (null == entryInfoPOs || entryInfoPOs.isEmpty()) {
            logger.error("\u627e\u4e0d\u5230\u6c47\u603b\u5355\u53f7\u5bf9\u5e94\u7684\u6c47\u603b\u5355\u8be6\u60c5\u8bb0\u5f55\uff0c\u6c47\u603b\u5355\u53f7\u4e3a\uff1a" + reqBO.getApplyNo());
            return rspPageBO;
        }
        ArrayList<EntryInfoBO> entryInfoBOs = new ArrayList<EntryInfoBO>();
        for (EntryInfoPO entryInfo : entryInfoPOs) {
            EntryInfoBO entryInfoBO = new EntryInfoBO();
            BeanUtils.copyProperties((Object)entryInfo, (Object)entryInfoBO);
            String purchaseName = this.organizationInfoService.querySupplierName(entryInfoBO.getPurchaseId());
            entryInfoBO.setPurchaseName(purchaseName);
            LinkedList<PurchaseOrderDetailInfoRspBO> purchaseOrderDetailList = new LinkedList<PurchaseOrderDetailInfoRspBO>();
            LinkedList<String> purchaseOrderNameList = new LinkedList<String>();
            if (!"0".equals(this.enumsService.queryShowOrderCodeSwitch()) || !OrderSource.ELECTRIC_MARKET.getCode().equals(entryInfo.getSource())) {
                if (OrderSource.ELECTRIC_MARKET.getCode().equals(entryInfo.getSource())) {
                    List<PayPurchaseOrderInfo> orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(entryInfo.getNotificationNo());
                    PurchaseOrderDetailInfoRspBO detailRspBO = null;
                    for (PayPurchaseOrderInfo singleOrder : orders) {
                        detailRspBO = new PurchaseOrderDetailInfoRspBO();
                        detailRspBO.setPurchaseOrderCode(singleOrder.getPurchaseOrderCode());
                        detailRspBO.setInspectionId(singleOrder.getInspectionId());
                        purchaseOrderDetailList.add(detailRspBO);
                        purchaseOrderNameList.add(singleOrder.getPurchaseOrderName());
                    }
                } else {
                    PayPurchaseOrderInfoVO purchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
                    purchaseOrderInfoVO.setNotificationNo(entryInfo.getNotificationNo());
                    List<PayPurchaseOrderInfo> purchaseOrderInfos = this.payPurchaseOrderInfoMapper.getListByItemNotifNo(purchaseOrderInfoVO);
                    PurchaseOrderDetailInfoRspBO detailRspBO = null;
                    for (PayPurchaseOrderInfo purchaseOrder : purchaseOrderInfos) {
                        detailRspBO = new PurchaseOrderDetailInfoRspBO();
                        detailRspBO.setPurchaseOrderCode(purchaseOrder.getPurchaseOrderCode());
                        detailRspBO.setInspectionId(purchaseOrder.getInspectionId());
                        purchaseOrderDetailList.add(detailRspBO);
                        purchaseOrderNameList.add(purchaseOrder.getPurchaseOrderName());
                    }
                }
            }
            entryInfoBO.setPurchaseOrderCodeList(purchaseOrderDetailList);
            entryInfoBO.setPurchaseOrderNameList(purchaseOrderNameList);
            entryInfoBOs.add(entryInfoBO);
        }
        rspPageBO.setRows(entryInfoBOs);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }
}

