/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.QueryPayPurchaseOrderInfoDlzqService;
import com.tydic.pfscext.api.busi.bo.PayPurchaseOrderInfoBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoDlzqReqBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoDlzqRspBO;
import com.tydic.pfscext.api.busi.vo.PayItemInfoExtVO;
import com.tydic.pfscext.base.PfscExtReqPageBaseBO;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.OrderStatus2;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.utils.BusinessUtils;
import com.tydic.pfscext.utils.FscStringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=QueryPayPurchaseOrderInfoDlzqService.class)
public class QueryPayPurchaseOrderInfoDlzqServiceImpl
implements QueryPayPurchaseOrderInfoDlzqService {
    private static final Logger logger = LoggerFactory.getLogger(QueryPayPurchaseOrderInfoDlzqServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public QueryPayPurchaseOrderInfoDlzqRspBO queryListPage(QueryPayPurchaseOrderInfoDlzqReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f85\u5f00\u7968\u91c7\u8d2d\u8ba2\u5355\u670d\u52a1\uff08\u7535\u529b\u4e13\u533a\u7b49\uff09\u5165\u53c2\uff1a" + reqBO.toString());
        }
        Long companyId = reqBO.getCompanyId();
        Long operUnitNo = reqBO.getOperUnitNo();
        if (null == companyId) {
            throw new PfscExtBusinessException("0001", "\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSource()) {
            throw new PfscExtBusinessException("0001", "\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        operUnitNo = BusinessUtils.judgeOperUnitNo(operUnitNo, companyId, false);
        QueryPayPurchaseOrderInfoDlzqRspBO rspBO = new QueryPayPurchaseOrderInfoDlzqRspBO();
        PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)payPurchaseOrderInfoVO);
        String orderBy = null;
        ArrayList<String> sourceList = new ArrayList<String>();
        if (OrderSource.CONSULT_PRICE.getCode().equals(String.valueOf(reqBO.getSource()))) {
            sourceList.add(OrderSource.CONSULT_PRICE.getCode());
            sourceList.add(OrderSource.CONSULT_PRICE_FRAME.getCode());
        } else {
            sourceList.add(String.valueOf(reqBO.getSource()));
        }
        payPurchaseOrderInfoVO.setSource(null);
        payPurchaseOrderInfoVO.setSourceList(sourceList);
        payPurchaseOrderInfoVO.setOperUnitNo(operUnitNo);
        if (reqBO.getPurchaseOrderCode() != null) {
            payPurchaseOrderInfoVO.setPurchaseOrderCode(reqBO.getPurchaseOrderCode());
        }
        if (reqBO.getSupplierNo() != null) {
            payPurchaseOrderInfoVO.setSupplierNo(reqBO.getSupplierNo());
        }
        payPurchaseOrderInfoVO.setRecvDateStart(reqBO.getRecvDateStart());
        payPurchaseOrderInfoVO.setRecvDateEnd(reqBO.getRecvDateEnd());
        payPurchaseOrderInfoVO.setMinOrderAmt(reqBO.getMinOrderAmt());
        payPurchaseOrderInfoVO.setMaxOrderAmt(reqBO.getMaxOrderAmt());
        if (reqBO.getPurchaseNo() != null) {
            payPurchaseOrderInfoVO.setPurchaseNo(reqBO.getPurchaseNo());
        }
        String tableName = "d_pay_purchase_order_info";
        orderBy = FscStringUtils.obtainOrderBy((PfscExtReqPageBaseBO)reqBO, tableName, null);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        LinkedList<PayPurchaseOrderInfoBO> boList = new LinkedList<PayPurchaseOrderInfoBO>();
        Date startDate = reqBO.getOrderDateStart();
        Date endDate = reqBO.getOrderDateEnd();
        List<PayPurchaseOrderInfo> payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getListPage(payPurchaseOrderInfoVO, startDate, endDate, (Page<Map<String, Object>>)page, orderBy);
        for (PayPurchaseOrderInfo singlePO : payPurchaseOrderInfoPOs) {
            PayPurchaseOrderInfoBO singleBO = new PayPurchaseOrderInfoBO();
            BeanUtils.copyProperties((Object)singlePO, (Object)singleBO);
            singleBO.setParentOrderId(String.valueOf(singlePO.getParentOrderId()));
            singleBO.setOrderId(String.valueOf(singlePO.getOrderId()));
            singleBO.setInspectionId(String.valueOf(singlePO.getInspectionId()));
            LinkedList<PayItemInfoExtVO> itemVOList = new LinkedList<PayItemInfoExtVO>();
            List<PayItemInfo> itemList = this.payItemInfoMapper.selectByOrderAndInspector(singlePO.getOrderId(), singlePO.getInspectionId());
            for (PayItemInfo singleItem : itemList) {
                PayItemInfoExtVO sinleItemVO = new PayItemInfoExtVO();
                BeanUtils.copyProperties((Object)singleItem, (Object)sinleItemVO);
                sinleItemVO.setSeq(String.valueOf(singleItem.getSeq()));
                StringBuilder specModelFigureNo = new StringBuilder();
                if (StringUtils.hasText((String)singleItem.getSpec())) {
                    specModelFigureNo.append(singleItem.getSpec()).append("\\");
                }
                if (StringUtils.hasText((String)singleItem.getModel())) {
                    specModelFigureNo.append(singleItem.getModel()).append("\\");
                }
                if (StringUtils.hasText((String)singleItem.getFigureNo())) {
                    specModelFigureNo.append(singleItem.getFigureNo()).append("\\");
                }
                if (specModelFigureNo.length() >= 1) {
                    sinleItemVO.setSpecModelFigureNo(specModelFigureNo.toString().substring(0, specModelFigureNo.length() - 1));
                }
                itemVOList.add(sinleItemVO);
            }
            singleBO.setItemInfos(itemVOList);
            OrderStatus orderStatusEnum = OrderStatus.getInstance(singleBO.getOrderStatus());
            singleBO.setOrderStatusStr(this.enumsService.getDescr(orderStatusEnum));
            singleBO.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)singleBO.getSource())));
            singleBO.setProfessionalDepartDescr(this.organizationInfoService.queryOrgName(singleBO.getProfessionalDepartId()));
            singleBO.setServiceDepartDescr(this.organizationInfoService.queryServiceDepartName(singleBO.getServiceDepartId()));
            OrderStatus2 orderStatus2Enum = OrderStatus2.getInstance(singlePO.getOrderStatus2());
            singleBO.setOrderStatus2Descr(this.enumsService.getDescr(orderStatus2Enum));
            singleBO.setBranchCompanyName(this.organizationInfoService.queryOrgName(singlePO.getBranchCompany()));
            boList.add(singleBO);
        }
        rspBO.setRows(boList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

