/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.RegisterReturnQryListBusiService;
import com.tydic.pfscext.api.busi.bo.RegisterReturnInfoBO;
import com.tydic.pfscext.api.busi.bo.RegisterReturnQryListBusiReqBO;
import com.tydic.pfscext.base.PfscExtReqPageBaseBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.ConfTabStateMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.RegisterReturnMapper;
import com.tydic.pfscext.dao.po.ConfTabStatePO;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.RegisterReturnPO;
import com.tydic.pfscext.enums.ReturnType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.utils.FscStringUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=RegisterReturnQryListBusiService.class)
public class RegisterReturnQryListBusiServiceImpl
implements RegisterReturnQryListBusiService {
    private static final Logger log = LoggerFactory.getLogger(RegisterReturnQryListBusiServiceImpl.class);
    @Autowired
    private ConfTabStateMapper confTabStateMapper;
    @Autowired
    private RegisterReturnMapper registerReturnMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;

    public PfscExtRspPageBaseBO<RegisterReturnInfoBO> qryInvoiceReturnList(RegisterReturnQryListBusiReqBO reqBO) {
        String[] statusArray;
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u9000\u7968\u767b\u8bb0\u5217\u8868\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getTabId()) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u9000\u7968\u767b\u8bb0\u5217\u8868\u4e1a\u52a1\u670d\u52a1-\u6807\u7b7eId[tabId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PfscExtRspPageBaseBO rspPageBaseBO = new PfscExtRspPageBaseBO();
        ArrayList<String> statusList = new ArrayList<String>();
        ConfTabStatePO confTabStatePO = this.confTabStateMapper.selectByTabId(reqBO.getTabId());
        if (confTabStatePO == null) {
            throw new PfscExtBusinessException("18001", "\u67e5\u8be2tabId\u5bf9\u5e94\u7684\u72b6\u6001\u5217\u8868\u65e0\u8bb0\u5f55");
        }
        String statusCodes = confTabStatePO.getStatusCode();
        for (String status : statusArray = statusCodes.split(",")) {
            statusList.add(status);
        }
        String defaultOrderBy = " CREATE_DATE desc,NOTIFICATION_NO desc ";
        String tableName = "d_register_return";
        String orderBy = FscStringUtils.obtainOrderBy((PfscExtReqPageBaseBO)reqBO, tableName, defaultOrderBy);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        LinkedList<RegisterReturnInfoBO> result = new LinkedList<RegisterReturnInfoBO>();
        List<RegisterReturnPO> resultList = this.registerReturnMapper.getListPage(reqBO, (Page<Map<String, Object>>)page, orderBy);
        if (resultList != null && resultList.size() > 0) {
            for (RegisterReturnPO registerReturnPO : resultList) {
                RegisterReturnInfoBO registerReturnInfoBO = new RegisterReturnInfoBO();
                BeanUtils.copyProperties((Object)registerReturnPO, (Object)registerReturnInfoBO);
                registerReturnInfoBO.setInvoiceNo(registerReturnPO.getInvoiceNo1());
                registerReturnInfoBO.setInvoiceCode(registerReturnPO.getInvoiceCode1());
                List<PayInvoiceInfo> payInvoiceInfo = this.payInvoiceInfoMapper.selectByInvoiceNo(registerReturnPO.getInvoiceNo1());
                if (payInvoiceInfo != null && payInvoiceInfo.size() > 0) {
                    registerReturnInfoBO.setInvoiceAmt(payInvoiceInfo.get(0).getAmt());
                }
                registerReturnInfoBO.setReturnTypeStr(this.enumsService.getDescr(ReturnType.getInstance(registerReturnPO.getReturnType())));
                String supplierName = this.organizationInfoService.querySupplierName(registerReturnPO.getSupplierNo());
                registerReturnInfoBO.setSupplierName(supplierName);
                result.add(registerReturnInfoBO);
            }
        }
        rspPageBaseBO.setRows(result);
        rspPageBaseBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBaseBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBaseBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBaseBO;
    }
}

