/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.RegisterReturnSaveRedInvoiceBusiService;
import com.tydic.pfscext.api.busi.bo.PayInvoiceInfoBO;
import com.tydic.pfscext.api.busi.bo.RegisterReturnSaveRedInvoiceBusiReqBO;
import com.tydic.pfscext.api.busi.bo.RegisterReturnSaveRedInvoiceBusiRspBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.RegisterReturnDetailMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.RegisterReturnDetailPO;
import com.tydic.pfscext.dao.vo.BillNotificationInfoVO;
import com.tydic.pfscext.dao.vo.Statis;
import com.tydic.pfscext.enums.BusinessType;
import com.tydic.pfscext.enums.InvoiceMailStatus;
import com.tydic.pfscext.enums.InvoiceStatus;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.AccountantEngineService;
import com.tydic.pfscext.service.atom.CreateReturnEntryInfoService;
import com.tydic.pfscext.service.atom.SourceMappingService;
import com.tydic.pfscext.service.atom.bo.AccountantEngineReqBO;
import com.tydic.pfscext.service.atom.bo.CreateReturnEntryInfoReqBO;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=RegisterReturnSaveRedInvoiceBusiService.class)
public class RegisterReturnSaveRedInvoiceBusiServiceImpl
implements RegisterReturnSaveRedInvoiceBusiService {
    private static final Logger log = LoggerFactory.getLogger(RegisterReturnSaveRedInvoiceBusiServiceImpl.class);
    @Autowired
    private RegisterReturnDetailMapper registerReturnDetailMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private CreateReturnEntryInfoService createReturnEntryInfoService;
    @Autowired
    private AccountantEngineService accountantEngineService;
    @Autowired
    private SourceMappingService sourceMappingService;

    public RegisterReturnSaveRedInvoiceBusiRspBO saveRedInvoice(RegisterReturnSaveRedInvoiceBusiReqBO reqBO) {
        RegisterReturnSaveRedInvoiceBusiRspBO rspBO = new RegisterReturnSaveRedInvoiceBusiRspBO();
        this.validParam(reqBO);
        RegisterReturnDetailPO registerReturnDetailPO = new RegisterReturnDetailPO();
        registerReturnDetailPO.setBillNo(reqBO.getBillNo());
        registerReturnDetailPO.setInvoiceNo1(reqBO.getInvoiceNo());
        RegisterReturnDetailPO resultPo = this.registerReturnDetailMapper.select(registerReturnDetailPO);
        if (resultPo == null) {
            throw new PfscExtBusinessException("18001", "\u672a\u67e5\u8be2\u5230\u539f\u53d1\u7968[" + reqBO.getInvoiceNo() + "]\u9000\u7968\u767b\u8bb0\u660e\u7ec6\u8bb0\u5f55");
        }
        PayInvoiceInfoBO payInvoiceInfoBO = reqBO.getRedInvoiceInfo();
        PayInvoiceInfo payInvoiceInfo = new PayInvoiceInfo();
        BeanUtils.copyProperties((Object)payInvoiceInfoBO, (Object)payInvoiceInfo);
        payInvoiceInfo.setNotificationNo(resultPo.getNotifyNo2());
        payInvoiceInfo.setCreateDate(new Date());
        payInvoiceInfo.setInvoiceStatus(InvoiceStatus.HAS_MAKE.getCode());
        payInvoiceInfo.setMailStatus(InvoiceMailStatus.NOT_SENT.getCode());
        payInvoiceInfo.setNotTaxAmt(payInvoiceInfoBO.getNotTaxAmt().negate());
        payInvoiceInfo.setTaxAmt(payInvoiceInfoBO.getTaxAmt().negate());
        payInvoiceInfo.setAmt(payInvoiceInfoBO.getAmt().negate());
        this.payInvoiceInfoMapper.insert(payInvoiceInfo);
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(resultPo.getNotifyNo2());
        if (billNotificationInfo == null) {
            throw new PfscExtBusinessException("18001", "\u672a\u67e5\u8be2\u5230\u539f\u5f00\u7968\u901a\u77e5\u5355\u8bb0\u5f55");
        }
        BillNotificationInfoVO oldBillNotificationInfo = new BillNotificationInfoVO();
        oldBillNotificationInfo.setNotificationNo(resultPo.getNotifyNo1());
        oldBillNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.RETURN_BACK.getCode());
        this.billNotificationInfoMapper.update(oldBillNotificationInfo);
        BillNotificationInfoVO redBillNotificationInfo = new BillNotificationInfoVO();
        redBillNotificationInfo.setNotificationNo(resultPo.getNotifyNo2());
        redBillNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.HAS_MAKE.getCode());
        this.billNotificationInfoMapper.update(redBillNotificationInfo);
        log.debug("\u51c6\u5907\u4ea7\u751f\u7ea2\u7968\u8d1f\u6570\u5165\u5e93\u5355\u53f7,\u901a\u77e5\u5355\u53f7=" + resultPo.getNotifyNo2());
        CreateReturnEntryInfoReqBO createReturnEntryInfoReqBO = new CreateReturnEntryInfoReqBO();
        createReturnEntryInfoReqBO.setEntryType(2);
        createReturnEntryInfoReqBO.setInvoiceNo(resultPo.getInvoiceNo1());
        createReturnEntryInfoReqBO.setOldNotificationNo(resultPo.getNotifyNo1());
        createReturnEntryInfoReqBO.setRedNotificationNo(resultPo.getNotifyNo2());
        createReturnEntryInfoReqBO.setWriteoffAmt(BigDecimal.ZERO);
        createReturnEntryInfoReqBO.setUserId(reqBO.getUserId());
        String entryNo = this.createReturnEntryInfoService.createEntryInfo(createReturnEntryInfoReqBO);
        Statis ivStatis = this.payInvoiceInfoMapper.invoiceStatis(resultPo.getNotifyNo2());
        log.debug("\u51c6\u5907\u8fdb\u884c\u5165\u5e93\u8bb0\u8d26,\u5165\u5e93\u5355\u53f7=" + entryNo + ",\u5e94\u4ed8\u91d1\u989d=" + ivStatis.getTotAmt() + ",\u5e94\u7a0e\u91d1\u989d=" + ivStatis.getTotTaxAmt());
        AccountantEngineReqBO accBo = new AccountantEngineReqBO();
        accBo.setBusinessType(BusinessType.STOCK_IN.getCode());
        String targetSource = this.sourceMappingService.queryAccountingTargetSource(billNotificationInfo.getSource());
        accBo.setSource(targetSource);
        accBo.setOperUnit(reqBO.getOrgId());
        accBo.setServiceNo(entryNo);
        accBo.setRemark("\u9000\u7968\u7ea2\u7968\u7b7e\u6536\u5165\u5e93\u8bb0\u8d26");
        accBo.setAmounts(Arrays.asList(ivStatis.getTotUntaxAmt(), ivStatis.getTotTaxAmt()));
        this.accountantEngineService.executeAccountantEngine(accBo);
        log.debug("\u5f00\u7968\u901a\u77e5\u5355\u6d89\u53ca\u7684\u53d1\u7968\u7b7e\u6536\u5b8c\u6bd5,\u901a\u77e5\u5355\u53f7=" + resultPo.getNotifyNo2());
        return rspBO;
    }

    private void validParam(RegisterReturnSaveRedInvoiceBusiReqBO reqBO) {
        if (reqBO == null) {
            if (null == reqBO) {
                throw new PfscExtBusinessException("0001", "\u9000\u7968\u767b\u8bb0\u7ea2\u7968\u5f55\u5165\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getBillNo()) {
                throw new PfscExtBusinessException("0001", "\u9000\u7968\u767b\u8bb0\u7ea2\u7968\u5f55\u5165\u4e1a\u52a1\u670d\u52a1-\u9000\u7968\u767b\u8bb0\u5355\u53f7[billNo]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getRedInvoiceInfo()) {
                throw new PfscExtBusinessException("0001", "\u9000\u7968\u767b\u8bb0\u7ea2\u7968\u5f55\u5165\u4e1a\u52a1\u670d\u52a1-\u7ea2\u7968\u53d1\u7968\u4fe1\u606f[redInvoiceInfo]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

