/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.comb.impl;

import com.tydic.pfscext.api.busi.BusiInvoiceVerifyService;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceVerifyReqBO;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceVerifyRspBO;
import com.tydic.pfscext.api.comb.FscBatchInvoiceVerifyCombService;
import com.tydic.pfscext.api.comb.bo.FscBatchInvoiceVerifyCombReqBO;
import com.tydic.pfscext.api.comb.bo.FscBatchInvoiceVerifyCombRspBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=FscBatchInvoiceVerifyCombService.class)
public class FscBatchInvoiceVerifyCombServiceImpl
implements FscBatchInvoiceVerifyCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscBatchInvoiceVerifyCombServiceImpl.class);
    private BusiInvoiceVerifyService busiInvoiceVerifyService;
    private BillNotificationInfoMapper billNotificationInfoMapper;

    @Autowired
    public FscBatchInvoiceVerifyCombServiceImpl(BusiInvoiceVerifyService busiInvoiceVerifyService, BillNotificationInfoMapper billNotificationInfoMapper) {
        this.busiInvoiceVerifyService = busiInvoiceVerifyService;
        this.billNotificationInfoMapper = billNotificationInfoMapper;
    }

    public FscBatchInvoiceVerifyCombRspBO invoiceVerify(FscBatchInvoiceVerifyCombReqBO reqBO) {
        FscBatchInvoiceVerifyCombRspBO rspBO = new FscBatchInvoiceVerifyCombRspBO();
        String validateStr = this.validateArg(reqBO);
        if (StringUtils.hasText((String)validateStr)) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc(validateStr);
            return rspBO;
        }
        List notificationNos = reqBO.getNotificationNos();
        try {
            int totalNum = this.billNotificationInfoMapper.checkExist(notificationNos);
            if (totalNum != notificationNos.size()) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u90e8\u5206\u5f00\u7968\u901a\u77e5\u5355\u4e0d\u5b58\u5728!");
                return rspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u6570\u636e\u5e93\u8868billNotificationInfoMapper\u53d1\u751f\u5f02\u5e38\uff1a" + e.toString());
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u6570\u636e\u5e93\u5f02\u5e38!");
            return rspBO;
        }
        int total = notificationNos.size();
        int failed = 0;
        for (String notificationNo : notificationNos) {
            BusiInvoiceVerifyReqBO invoiceVerifyReqBO = new BusiInvoiceVerifyReqBO();
            invoiceVerifyReqBO.setSignMode(reqBO.getSignMode());
            invoiceVerifyReqBO.setNotificationNo(notificationNo);
            invoiceVerifyReqBO.setCompanyId(reqBO.getCompanyId());
            invoiceVerifyReqBO.setUserId(reqBO.getUserId());
            BusiInvoiceVerifyRspBO verifyRspBO = this.busiInvoiceVerifyService.invoiceVerify(invoiceVerifyReqBO);
            if ("0000".equals(verifyRspBO.getRespCode())) continue;
            ++failed;
        }
        int successed = total - failed;
        rspBO.setResultInfo("\u6279\u91cf\u6838\u5bf9\u7b7e\u6536\u5b8c\u6210,\u603b\u8ba1" + total + "\u6761,\u5176\u4e2d\u6210\u529f" + successed + "\u6761,\u5931\u8d25" + failed + "\u6761\uff0c\u8bf7\u786e\u8ba4\u7ed3\u679c");
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6279\u91cf\u6838\u5bf9\u7b7e\u6536\u5f00\u7968\u901a\u77e5\u5355\u5b8c\u6210");
        return rspBO;
    }

    private String validateArg(FscBatchInvoiceVerifyCombReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getNotificationNos())) {
            return "\u5f00\u7968\u901a\u77e5\u5355\u53f7\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBO.getSignMode()) {
            return "\u7b7e\u6536\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (1 != reqBO.getSignMode()) {
            return "\u7b7e\u6536\u6807\u5fd7\u6709\u8bef";
        }
        return null;
    }
}

