/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.comb.impl;

import com.tydic.pfscext.api.busi.FscWfFinishTaskBusiService;
import com.tydic.pfscext.api.busi.bo.FscWfFinishTaskBusiReqBO;
import com.tydic.pfscext.api.busi.bo.FscWfFinishTaskBusiRspBO;
import com.tydic.pfscext.api.comb.FscWfEndWithoutSynchFinanceCombService;
import com.tydic.pfscext.api.comb.FscWfFinishTaskBatchCombService;
import com.tydic.pfscext.api.comb.bo.FscWfEndWithoutSynchFinanceCombReqBO;
import com.tydic.pfscext.api.comb.bo.FscWfFinishTaskBatchCombReqBO;
import com.tydic.pfscext.api.comb.bo.FscWfFinishTaskBatchCombRspBO;
import com.tydic.pfscext.dao.WorkFlowDataMapper;
import com.tydic.pfscext.dao.po.WorkFlowDataInfo;
import com.tydic.pfscext.enums.WFStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=FscWfFinishTaskBatchCombService.class)
public class FscWfFinishTaskBatchCombServiceImpl
implements FscWfFinishTaskBatchCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscWfFinishTaskBatchCombServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final String AUDIT_SUCCESS = "1";
    private WorkFlowDataMapper workFlowDataMapper;
    private FscWfFinishTaskBusiService fscWfFinishTaskBusiService;
    private FscWfEndWithoutSynchFinanceCombService fscWfEndWithoutSynchFinanceCombService;

    @Autowired
    public FscWfFinishTaskBatchCombServiceImpl(WorkFlowDataMapper workFlowDataMapper, FscWfFinishTaskBusiService fscWfFinishTaskBusiService, FscWfEndWithoutSynchFinanceCombService fscWfEndWithoutSynchFinanceCombService) {
        this.workFlowDataMapper = workFlowDataMapper;
        this.fscWfFinishTaskBusiService = fscWfFinishTaskBusiService;
        this.fscWfEndWithoutSynchFinanceCombService = fscWfEndWithoutSynchFinanceCombService;
    }

    public FscWfFinishTaskBatchCombRspBO dealFinishTaskBatch(FscWfFinishTaskBatchCombReqBO reqBO) {
        LOGGER.info("\u6279\u91cf\u5ba1\u6279\u63d0\u4ea4\u5904\u7406\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        FscWfFinishTaskBatchCombRspBO rspBO = new FscWfFinishTaskBatchCombRspBO();
        String validateArgStr = this.validateArg(reqBO);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc(validateArgStr);
            return rspBO;
        }
        try {
            this.checkTypeAndStatus(reqBO.getProcInstIdList());
        }
        catch (PfscExtBusinessException e) {
            rspBO.setRespCode(e.getMsgCode());
            rspBO.setRespDesc(e.getMsgInfo());
            return rspBO;
        }
        int faultCount = 0;
        for (String procInstId : reqBO.getProcInstIdList()) {
            boolean apprResult = this.dealObjectAudit(procInstId, reqBO);
            if (!apprResult) continue;
            ++faultCount;
        }
        int total = reqBO.getProcInstIdList().size();
        int successCount = total - faultCount;
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5ba1\u6279\u5904\u7406\u5b8c\u6210\uff0c\u603b\u8ba1\u63d0\u4ea4" + total + "\u6761\uff0c\u5176\u4e2d\u5904\u7406\u6210\u529f" + successCount + "\u6761\uff0c\u5931\u8d25" + faultCount + "\u6761\uff0c\u5931\u8d25\u7684\u5ba1\u6279\u5355\u636e\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u63d0\u4ea4");
        return rspBO;
    }

    private boolean dealObjectAudit(String procInstId, FscWfFinishTaskBatchCombReqBO reqBO) {
        FscWfFinishTaskBusiReqBO wfFinishTaskBusiReqBO = new FscWfFinishTaskBusiReqBO();
        wfFinishTaskBusiReqBO.setProcInstId(procInstId);
        wfFinishTaskBusiReqBO.setComment(reqBO.getComment());
        wfFinishTaskBusiReqBO.setSeqFlowId(reqBO.getSeqFlowId());
        wfFinishTaskBusiReqBO.setUserId(reqBO.getUserId());
        FscWfFinishTaskBusiRspBO wfFinishTaskBusiRspBO = this.fscWfFinishTaskBusiService.dealFinishTask(wfFinishTaskBusiReqBO);
        if (!"0000".equals(wfFinishTaskBusiRspBO.getRespCode()) || null == wfFinishTaskBusiRspBO.getWfFinish()) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u5ba1\u6279\u63d0\u4ea4\u5904\u7406\u670d\u52a1\u5931\u8d25\uff0cprocInstId=[" + procInstId + "]" + wfFinishTaskBusiRspBO.getRespDesc());
            }
            return true;
        }
        if (AUDIT_SUCCESS.equals(reqBO.getSeqFlowId()) && null != wfFinishTaskBusiRspBO.getWfFinish() && wfFinishTaskBusiRspBO.getWfFinish().booleanValue()) {
            FscWfEndWithoutSynchFinanceCombReqBO wfEndWithoutSynchFinanceCombReqBO = new FscWfEndWithoutSynchFinanceCombReqBO();
            wfEndWithoutSynchFinanceCombReqBO.setProcInstId(procInstId);
            this.fscWfEndWithoutSynchFinanceCombService.dealWfEndWithoutSynchFinance(wfEndWithoutSynchFinanceCombReqBO);
        }
        return false;
    }

    private void checkTypeAndStatus(List<String> procInstIdList) {
        List<WorkFlowDataInfo> workFlowDataList;
        ArrayList<String> statusList = new ArrayList<String>();
        ArrayList<String> billTypeList = new ArrayList<String>();
        try {
            workFlowDataList = this.workFlowDataMapper.selectByProcInstId(procInstIdList);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u6570\u636e\u5e93\u8868workFlowDataMapper\u53d1\u751f\u5f02\u5e38\uff1a" + e.toString());
            throw new PfscExtBusinessException("18996", "\u6570\u636e\u5e93\u5f02\u5e38");
        }
        if (!CollectionUtils.isEmpty(workFlowDataList)) {
            for (WorkFlowDataInfo workFlowDataInfo : workFlowDataList) {
                statusList.add(workFlowDataInfo.getStatus());
                billTypeList.add(workFlowDataInfo.getBillType());
            }
        }
        if (CollectionUtils.isEmpty(billTypeList)) {
            throw new PfscExtBusinessException("18996", "\u672a\u67e5\u8be2\u5230\u5355\u636e\u7c7b\u578b");
        }
        String billTypeOne = (String)billTypeList.get(0);
        for (String billType : billTypeList) {
            if (billTypeOne.equals(billType)) continue;
            throw new PfscExtBusinessException("18996", "\u5fc5\u987b\u4e3a\u540c\u4e00\u7c7b\u578b\u7684\u5355\u636e\u624d\u53ef\u8fdb\u884c\u6279\u91cf\u5ba1\u6279\u5904\u7406");
        }
        if (CollectionUtils.isEmpty(statusList)) {
            throw new PfscExtBusinessException("18996", "\u672a\u67e5\u8be2\u5230\u5ba1\u6279\u72b6\u6001");
        }
        for (String string : statusList) {
            if (WFStatus.IN_THE_AUDIT.getCode().equals(string)) continue;
            throw new PfscExtBusinessException("18996", "\u5ba1\u6279\u72b6\u6001\u5fc5\u987b\u90fd\u4e3a\u5ba1\u6279\u4e2d");
        }
    }

    private String validateArg(FscWfFinishTaskBatchCombReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getSeqFlowId())) {
            return "\u5ba1\u6279\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getProcInstIdList())) {
            return "\u6d41\u7a0b\u5b9e\u4f8bID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

