/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.zm.impl;

import com.tydic.pfscext.api.zm.ExportReconcilitionDetailsService;
import com.tydic.pfscext.api.zm.bo.ExtReconcilitionDetailsRspBO;
import com.tydic.pfscext.api.zm.bo.ReconcilitionDetails;
import com.tydic.pfscext.api.zm.bo.ReconcilitionDetailsReqBO;
import com.tydic.pfscext.dao.CheckBillInfoMapper;
import com.tydic.pfscext.dao.ReconcilitionHisMapper;
import com.tydic.pfscext.dao.po.ReconcilitionDetailsReqPO;
import com.tydic.pfscext.dao.po.ReconcilitionDetailsRspPO;
import com.tydic.pfscext.dao.po.ReconcilitionZmPO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.DictionaryAtomService;
import com.tydic.pfscext.service.atom.bo.DictionaryAtomReqBo;
import com.tydic.pfscext.service.atom.bo.DictionaryAtomRspBo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=ExportReconcilitionDetailsService.class)
public class ExportReconcilitionDetailsServiceImpl
implements ExportReconcilitionDetailsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportReconcilitionDetailsServiceImpl.class);
    private CheckBillInfoMapper checkBillInfoMapper;
    private ReconcilitionHisMapper reconcilitionHisMapper;
    private DictionaryAtomService dicDictionaryService;

    @Autowired
    public ExportReconcilitionDetailsServiceImpl(CheckBillInfoMapper checkBillInfoMapper, ReconcilitionHisMapper reconcilitionHisMapper, DictionaryAtomService dicDictionaryService) {
        this.checkBillInfoMapper = checkBillInfoMapper;
        this.reconcilitionHisMapper = reconcilitionHisMapper;
        this.dicDictionaryService = dicDictionaryService;
    }

    public ExtReconcilitionDetailsRspBO extReconcilitionDetails(ReconcilitionDetailsReqBO reconcilitionDetailsReqBO) {
        ExtReconcilitionDetailsRspBO rspBO = new ExtReconcilitionDetailsRspBO();
        if (reconcilitionDetailsReqBO.getReconciliationCode() == null) {
            throw new PfscExtBusinessException("18000", "\u5bf9\u8d26\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList reconcilitionDetails = new ArrayList();
        List<Object> noacceptanceDetails = new ArrayList();
        List<Object> reconciliationY = new ArrayList();
        List<Object> reconciliationN = new ArrayList();
        ReconcilitionDetailsRspPO rspPO = new ReconcilitionDetailsRspPO();
        ArrayList rspPOList = new ArrayList();
        ReconcilitionZmPO reconcilitionZmPO = this.checkBillInfoMapper.selectByCode(reconcilitionDetailsReqBO.getReconciliationCode());
        rspBO.setUserName(reconcilitionZmPO.getUserName());
        rspBO.setSupName(reconcilitionZmPO.getSupName());
        rspBO.setReconciliationCode(reconcilitionZmPO.getReconcilitionCode());
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dd = format.format(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US).parse(reconcilitionZmPO.getReconcilitionDate().toString()));
            LOGGER.error("\u65f6\u95f4\u683c\u5f0f\uff1a" + dd);
            System.out.println("\u65f6\u95f4\u683c\u5f0f\uff1a" + dd);
            rspBO.setReconcilitionDate(dd);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ReconcilitionDetailsReqPO noacceptancereqPO = new ReconcilitionDetailsReqPO();
        noacceptancereqPO.setOrderStatus2("6");
        noacceptancereqPO.setReconciliationCode(reconcilitionDetailsReqBO.getReconciliationCode());
        noacceptanceDetails = this.selectDetails(noacceptancereqPO);
        ReconcilitionDetailsReqPO reconciliationYreqPO = new ReconcilitionDetailsReqPO();
        reconciliationYreqPO.setReconciliationStatus("1");
        reconciliationYreqPO.setReconciliationCode(reconcilitionDetailsReqBO.getReconciliationCode());
        reconciliationY = this.selectDetails(reconciliationYreqPO);
        ReconcilitionDetailsReqPO reconciliationNreqPO = new ReconcilitionDetailsReqPO();
        reconciliationNreqPO.setReconciliationStatus("2");
        reconciliationNreqPO.setReconciliationCode(reconcilitionDetailsReqBO.getReconciliationCode());
        reconciliationN = this.selectDetails(reconciliationNreqPO);
        rspBO.setNoacceptanceDetails(noacceptanceDetails);
        rspBO.setReconciliationY(reconciliationY);
        rspBO.setReconciliationN(reconciliationN);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5bf9\u8d26\u5355\u8be6\u60c5\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    private List<ReconcilitionDetails> selectDetails(ReconcilitionDetailsReqPO reqPO) {
        ArrayList<ReconcilitionDetails> reconcilitionDetails = new ArrayList<ReconcilitionDetails>();
        List<ReconcilitionDetailsRspPO> rspPOList = this.checkBillInfoMapper.queryReconcilitionDetails(reqPO);
        if (rspPOList != null && rspPOList.size() > 0) {
            for (ReconcilitionDetailsRspPO reconcilitionDetailsRspPO : rspPOList) {
                String dd;
                SimpleDateFormat format;
                ReconcilitionDetails detailsBO = new ReconcilitionDetails();
                detailsBO.setBillConfirmStr(reconcilitionDetailsRspPO.getBillConfirm());
                if ("01".equals(reconcilitionDetailsRspPO.getBillConfirm())) {
                    detailsBO.setBillConfirm("\u672a\u786e\u8ba4");
                }
                if ("02".equals(reconcilitionDetailsRspPO.getBillConfirm())) {
                    detailsBO.setBillConfirm("\u5df2\u786e\u8ba4");
                }
                if ("1".equals(reconcilitionDetailsRspPO.getErpOrder())) {
                    detailsBO.setErpOrder("\u662f");
                } else {
                    detailsBO.setErpOrder("\u5426");
                }
                detailsBO.setErpOrderNo(reconcilitionDetailsRspPO.getErpOrderNo());
                detailsBO.setExtOrderId(reconcilitionDetailsRspPO.getExtOrderId());
                detailsBO.setOrderAmt(reconcilitionDetailsRspPO.getOrderAmt());
                try {
                    format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    dd = format.format(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US).parse(reconcilitionDetailsRspPO.getOrderDate().toString()));
                    LOGGER.error("\u65f6\u95f4\u683c\u5f0f\uff1a" + dd);
                    System.out.println("\u65f6\u95f4\u683c\u5f0f\uff1a" + dd);
                    detailsBO.setOrderDate(dd);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (reconcilitionDetailsRspPO.getOrderStatus() != null) {
                    detailsBO.setOrderStatusStr(reconcilitionDetailsRspPO.getOrderStatus());
                    detailsBO.setOrderStatus(this.getSaleOrderStatusMap().get(reconcilitionDetailsRspPO.getOrderStatus()));
                }
                detailsBO.setPurchaseOrderCode(reconcilitionDetailsRspPO.getPurchaseOrderCode());
                detailsBO.setPurchaseProjectId(reconcilitionDetailsRspPO.getPurchaseProjectId().toString());
                if (reconcilitionDetailsRspPO.getReconciliationStatus() != null) {
                    detailsBO.setReconciliationStatusStr(reconcilitionDetailsRspPO.getReconciliationStatus());
                    detailsBO.setReconciliationStatus(this.getReconcilStatusMap().get(reconcilitionDetailsRspPO.getReconciliationStatus()));
                }
                try {
                    format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    dd = format.format(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US).parse(reconcilitionDetailsRspPO.getRecvDate().toString()));
                    LOGGER.error("\u65f6\u95f4\u683c\u5f0f\uff1a" + dd);
                    System.out.println("\u65f6\u95f4\u683c\u5f0f\uff1a" + dd);
                    detailsBO.setRecvDate(dd);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                detailsBO.setStockOrgId(reconcilitionDetailsRspPO.getStockOrgId());
                detailsBO.setUseDepartmentId(reconcilitionDetailsRspPO.getUseDepartmentId());
                detailsBO.setUseDepartmentName(reconcilitionDetailsRspPO.getUseDepartmentName());
                if (reconcilitionDetailsRspPO.getExtOrderId() != null) {
                    String outMat = this.reconcilitionHisMapper.selectOutAmtByExtOrderId(reconcilitionDetailsRspPO.getExtOrderId(), reqPO.getReconciliationCode());
                    detailsBO.setSupplierAmt(new BigDecimal(outMat));
                }
                reconcilitionDetails.add(detailsBO);
            }
        }
        return reconcilitionDetails;
    }

    private Map<String, String> getReconcilStatusMap() {
        Map<String, String> map = new HashMap<String, String>(2);
        DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
        dictionaryAtomReqBo.setpCode("RECONCIL_STATUS");
        DictionaryAtomRspBo dictionaryAtomRspBo = this.dicDictionaryService.qryDic(dictionaryAtomReqBo);
        if (null != dictionaryAtomRspBo) {
            map = dictionaryAtomRspBo.getData();
        }
        return map;
    }

    private Map<String, String> getSaleOrderStatusMap() {
        Map<String, String> map = new HashMap<String, String>(2);
        DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
        dictionaryAtomReqBo.setpCode("D_SALE_ORDER_INFO_ORDER_STATUS");
        DictionaryAtomRspBo dictionaryAtomRspBo = this.dicDictionaryService.qryDic(dictionaryAtomReqBo);
        if (null != dictionaryAtomRspBo) {
            map = dictionaryAtomRspBo.getData();
        }
        return map;
    }
}

