/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.zm.impl;

import com.tydic.order.third.intf.constant.BusinessException;
import com.tydic.pfscext.api.zm.QryNotificationAmtService;
import com.tydic.pfscext.api.zm.bo.QryNotificationAmtReqBO;
import com.tydic.pfscext.api.zm.bo.QryNotificationAmtRspBO;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import java.math.BigDecimal;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="FSC_GROUP_DEV", interfaceClass=QryNotificationAmtService.class)
public class QryNotificationAmtServiceImpl
implements QryNotificationAmtService {
    private static final Logger logger = LoggerFactory.getLogger(QryNotificationAmtServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    public QryNotificationAmtRspBO makeNotify(QryNotificationAmtReqBO reqBO) throws Exception {
        logger.info("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        QryNotificationAmtRspBO rspBO = new QryNotificationAmtRspBO();
        if (null == reqBO.getOrderCodeList() && null == reqBO.getReconciliationCode()) {
            throw new BusinessException("18001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u8ba2\u5355\u7f16\u53f7[orderCodeList]\u548c\u5bf9\u8d26\u5355\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        List<PayPurchaseOrderInfo> payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getNewListExt(reqBO);
        if (payPurchaseOrderInfoPOs.isEmpty()) {
            throw new BusinessException("18004", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2\u5bf9\u5e94\u5f85\u5f00\u7968\u7ed3\u679c\u67e5\u8be2\u4e3a\u7a7a");
        }
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfoPOs) {
            totalAmt = totalAmt.add(payPurchaseOrderInfo.getOrderAmt());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRecordsTotal(payPurchaseOrderInfoPOs.size());
        rspBO.setTotalAmt(totalAmt);
        return rspBO;
    }
}

